/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.util;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import oracle.rat.tfa.singletons.IgnoreFilesList;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class RegexFilter
extends AbstractFileFilter
implements Serializable {
    private final Pattern[] patterns;

    public RegexFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public RegexFilter(String[] stringArray, IOCase iOCase) {
        if (stringArray == null) {
            throw new IllegalArgumentException("The pattern array must not be null");
        }
        this.patterns = new Pattern[stringArray.length];
        int n = 0;
        if (iOCase != null && !iOCase.isCaseSensitive()) {
            n = 2;
        }
        int n2 = 0;
        for (String string : stringArray) {
            this.patterns[n2++] = Pattern.compile(string, n);
        }
    }

    public RegexFilter(List<String> list) {
        this(list, null);
    }

    public RegexFilter(List<String> list, IOCase iOCase) {
        if (list == null) {
            throw new IllegalArgumentException("The patterns list must not be null");
        }
        this.patterns = new Pattern[list.size()];
        int n = 0;
        if (iOCase != null && !iOCase.isCaseSensitive()) {
            n = 2;
        }
        int n2 = 0;
        for (String string : list) {
            this.patterns[n2++] = Pattern.compile(string, n);
        }
    }

    public boolean accept(File file, String string) {
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean accept(File file) {
        String string = file.getAbsolutePath();
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        RegexFilter regexFilter = new RegexFilter(IgnoreFilesList.getInstance().getPatterns());
    }
}

