/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.RandomAccessFile;
import java.util.Date;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.singletons.MatchDates;
import oracle.rat.tfa.type.DateFormatType;
import oracle.rat.tfa.util.DateSearchResult;
import oracle.rat.tfa.util.Output;

public class RandomFileReader {
    private RandomAccessFile file;
    private FileEntity entity;

    public RandomFileReader(FileEntity fileEntity) {
        this.entity = fileEntity;
    }

    public long getNextHigherTimestampOffset(Date date, long l) throws IOException {
        this.file = new RandomAccessFile(this.entity.getFileName(), "r");
        long l2 = this.file.length();
        long l3 = l;
        this.file.seek(l3);
        Timestamp timestamp = this.getFirstTimestampInRange(l3, l2);
        if (timestamp.getDate() == null) {
            return 0L;
        }
        while (timestamp.getDate() != null && date.compareTo(timestamp.getDate()) >= 0) {
            timestamp = this.getFirstTimestampInRange(this.file.getFilePointer(), l2);
        }
        this.file.close();
        if (timestamp.getDate() != null) {
            Output.printTrace("Next higher timestamp : " + timestamp.getDate(), 3);
            return timestamp.getOffset();
        }
        return 0L;
    }

    public long binarySearch(Date date) throws IOException {
        Output.printTrace("Doing binary search for " + date, 3);
        this.file = new RandomAccessFile(this.entity.getFileName(), "r");
        long l = 0L;
        long l2 = this.file.length();
        long l3 = 0L;
        long l4 = -1L;
        while (l <= l2) {
            l3 = (l + l2) / 2L;
            Timestamp timestamp = this.getFirstTimestampInRange(l3, l2);
            Date date2 = timestamp.getDate();
            if (date2 == null) {
                this.file.close();
                return l4;
            }
            l4 = timestamp.getOffset();
            Output.printTrace("dateFound ---->>> " + date2 + " " + l4, 3);
            if (date2.before(date)) {
                l = l3;
                continue;
            }
            if (date2.after(date)) {
                l2 = l3;
                continue;
            }
            this.file.close();
            return l4;
        }
        this.file.close();
        return l4;
    }

    public Timestamp getFirstTimestampInRange(long l, long l2) throws IOException {
        Timestamp timestamp = new Timestamp();
        long l3 = -1L;
        this.file.seek(l);
        MatchDates matchDates = MatchDates.getInstance();
        DateSearchResult dateSearchResult = null;
        DateFormatType dateFormatType = null;
        Date date = null;
        String string = null;
        while ((string = this.file.readLine()) != null && this.file.getFilePointer() <= l2 && date == null) {
            l3 = this.file.getFilePointer();
            if (dateFormatType != null) {
                dateSearchResult = matchDates.searchReuseFormat(string, dateFormatType);
            } else {
                dateSearchResult = matchDates.searchForDate(string, this.entity);
                if (dateSearchResult != null) {
                    dateFormatType = dateSearchResult.getDft();
                }
            }
            if ((date = dateSearchResult != null ? dateSearchResult.getDateFound() : null) == null) continue;
            timestamp.setDate(date);
            timestamp.setOffset(l3);
        }
        return timestamp;
    }

    public long binarySearch(long l) throws IOException {
        Output.printTrace("Doing binary search for " + this.entity.getFileName() + " at line : " + l, 3);
        this.file = new RandomAccessFile(this.entity.getFileName(), "r");
        long l2 = 0L;
        long l3 = this.file.length();
        long l4 = 0L;
        long l5 = -1L;
        while (l2 <= l3) {
            l4 = (l2 + l3) / 2L;
            LineOffset lineOffset = this.getFirstLineInRange(l4, l3);
            long l6 = lineOffset.getLine();
            if (l6 <= 0L) {
                this.file.close();
                return l5;
            }
            l5 = lineOffset.getOffset();
            Output.printTrace("line ---->>> " + l6 + " " + l5, 3);
            if (l6 < l) {
                l2 = l4;
                continue;
            }
            if (l6 > l) {
                l3 = l4;
                continue;
            }
            this.file.close();
            return l5;
        }
        this.file.close();
        return l5;
    }

    public LineOffset getFirstLineInRange(long l, long l2) throws IOException {
        LineOffset lineOffset = new LineOffset();
        long l3 = -1L;
        this.file.seek(l);
        long l4 = -1L;
        String string = null;
        while ((string = this.file.readLine()) != null && this.file.getFilePointer() <= l2 && l4 == -1L) {
            l3 = this.file.getFilePointer();
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(new File(this.entity.getFileName())));
            lineNumberReader.skip(l3);
            l4 = lineNumberReader.getLineNumber();
            lineNumberReader.close();
            Output.printTrace("getFirstLineInRange: " + l + ":" + l2, 3);
            Output.printTrace("getFirstLineInRange: " + l4, 3);
            if (l4 == -1L) continue;
            lineOffset.setLine(l4);
            lineOffset.setOffset(l3);
        }
        return lineOffset;
    }

    public void closeFile() {
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(File.separator + "home" + File.separator + "sowsingh" + File.separator + "Desktop" + File.separator + "traces" + File.separator + "cssd" + File.separator + "ocssd.l05", "r");
            randomAccessFile.seek(26450721L);
            System.out.println(randomAccessFile.readLine());
            randomAccessFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class LineOffset {
        private long line;
        private long offset;

        private LineOffset() {
        }

        public void LineOffset() {
        }

        public void setLine(long l) {
            this.line = l;
        }

        public long getLine() {
            return this.line;
        }

        public void setOffset(long l) {
            this.offset = l;
        }

        public long getOffset() {
            return this.offset;
        }
    }

    private class Timestamp {
        private Date date;
        private long offset;

        private Timestamp() {
        }

        public void Timestamp() {
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public Date getDate() {
            return this.date;
        }

        public void setOffset(long l) {
            this.offset = l;
        }

        public long getOffset() {
            return this.offset;
        }
    }
}

