/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Date;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.PrefixFileFilter;

public class PurgeTFALogs
extends Thread {
    private int logAge = 15;
    private Date lastRun = null;

    public void setLogAge(int n) {
        this.logAge = n;
    }

    public int getLogAge() {
        return this.logAge;
    }

    public void setLastRun(Date date) {
        this.lastRun = date;
    }

    public Date getLastRun() {
        return this.lastRun;
    }

    @Override
    public void run() {
        this.setName("PurgeTFALog");
        Output.printTrace("Thread PurgeTFALog Started...", 3);
        this.lastRun = new Date();
        try {
            File file = new File(Properties.logDir);
            if (file.exists()) {
                File file2;
                int n;
                PrefixFileFilter prefixFileFilter = new PrefixFileFilter("tfa.", IOCase.SENSITIVE);
                File[] fileArray = file.listFiles((FilenameFilter)prefixFileFilter);
                if (Global.getMaxLogCount() > 0 && fileArray.length > Global.getMaxLogCount()) {
                    Arrays.sort(fileArray, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
                    int n2 = fileArray.length - Global.getMaxLogCount();
                    for (n = 0; n < n2; ++n) {
                        Output.print("Removing TFA Trace Log " + fileArray[n].getName() + ", Last Modified on " + new Date(fileArray[n].lastModified()));
                        if (fileArray[n].delete()) continue;
                        Output.print("Unable to remove TFA Trace Log " + fileArray[n].getName());
                    }
                }
                if (Global.getMaxLogSize() > 0L && Properties.sysLogFile != null && (file2 = new File(Properties.sysLogFile)).length() > Global.getMaxLogSize()) {
                    Properties.setSysLogFile("syserrorout." + Properties.getCurrentDate());
                }
                prefixFileFilter = new PrefixFileFilter("syserrorout.", IOCase.SENSITIVE);
                File[] fileArray2 = file.listFiles((FilenameFilter)prefixFileFilter);
                if (Global.getMaxLogCount() > 0 && fileArray2.length > Global.getMaxLogCount()) {
                    Arrays.sort(fileArray2, LastModifiedFileComparator.LASTMODIFIED_COMPARATOR);
                    n = fileArray2.length - Global.getMaxLogCount();
                    for (int i = 0; i < n; ++i) {
                        Output.print("Removing TFA Syserrorout Log " + fileArray2[i].getName() + ", Last Modified on " + new Date(fileArray2[i].lastModified()));
                        if (fileArray2[i].delete()) continue;
                        Output.print("Unable to remove TFA Syserrorout Log " + fileArray2[i].getName());
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Output.printTrace("Exception in Thread PurgeTFALogs", 1);
        }
    }
}

