/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.util;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.RepositoryManager;
import oracle.rat.tfa.TFADirectoryManager;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.db.DataAccessor.ClusterDA;
import oracle.rat.tfa.db.DataAccessor.TFACookieDA;
import oracle.rat.tfa.entity.Cluster;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.TFACookie;
import oracle.rat.tfa.entity.TFAHost;
import oracle.rat.tfa.entity.TFAReceiver;
import oracle.rat.tfa.entity.Timezone;
import oracle.rat.tfa.receiver.MetadataIndexer;
import oracle.rat.tfa.receiver.RGlobal;
import oracle.rat.tfa.singletons.CollectAllDirectories;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.singletons.DirectoryMappings;
import oracle.rat.tfa.singletons.MaskStrings;
import oracle.rat.tfa.util.EncryptionUtil;
import oracle.rat.tfa.util.FileHelper;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.PurgeTFALogs;
import oracle.rat.tfa.util.SocketManager;
import oracle.rat.tfa.util.TimeZoneUtil;
import oracle.rat.tfa.util.Utilities;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.PrefixFileFilter;

public class Properties {
    private static Properties instance = null;
    public static String tfaVersion = "12.2.1.0.0";
    private static String tfaCookie = null;
    public static String tfaHome;
    public static String tfaBase;
    public static String crsHome;
    public static String oracleBase;
    public static String tfaPropertiesFile;
    public static String tfaDirectoriesFile;
    public static String resourcesDir;
    public static String outputDir;
    public static String dbDirectory;
    public static String inventoryDir;
    public static String internalDir;
    public static String inputDir;
    public static String logDir;
    public static String tmpDir;
    public static String browserDir;
    public static File dbHome;
    public static String fileTypesXml;
    public static String directoryPatternsXML;
    public static String componentsXML;
    public static String datePatternsXml;
    public static String problemSetsXml;
    public static String taskSetsXml;
    public static String noExclusionsXML;
    public static String extensionsFile;
    public static String inventoryXMLFile;
    public static String filesWithNoFileTypes;
    public static String directoriesWithNoMappings;
    public static String filesIgnoredDuringInventory;
    public static String removedDirectoriesFile;
    public static String removedHostsFile;
    public static String removedReceiversFile;
    public static String configPropertiesFile;
    public static String rconfigPropertiesFile;
    public static String rPatternsFile;
    public static String buildVersionFile;
    public static String usablePortsFile;
    public static String portFile;
    public static String NonRootportFile;
    public static List<Integer> usablePorts;
    public static String portMappingFile;
    public static String cookiesFile;
    public static String ignorePatternsFile;
    public static String alertlogXMLFile;
    public static String genericXMLFile;
    public static String alertlogClusterXMLFile;
    public static String simileTimelineXMLFile;
    public static String tracefileRequestFile;
    public static String tracefileOutputDir;
    public static String dbzipDir;
    public static String logFile;
    public static String sysLogFile;
    public static PrintStream printStream;
    public static String searchStringsXml;
    public static String searchStringsInternalXml;
    public static String maskStringsXml;
    public static String scanFileListXml;
    public static String srFileId;
    public static String environment;
    public static boolean samplingEnabled;
    public static boolean darwinFile;
    public static String mergeDbDir;
    public static String dbZipName;
    public static String statusFileName;
    public static String srContext;
    public static String srOrBugNum;
    public static boolean isSupportMode;
    public static String socketPort;
    public static Boolean publicIp;
    public static Boolean tfaClusterMode;
    public static String trustStore;
    private static String trustStorePass;
    private static String keyStorePass;
    public static String trustStorePassword;
    public static String serverTrustStorePassword;
    public static String keyStore;
    public static String clientKeyStorePassword;
    public static String serverKeyStorePassword;
    public static String diagcollectFile;
    private static String clusterName;
    private static String clusterClass;
    private static boolean autoPatchingEnabled;
    private static boolean keystoresUpdated;
    public static String nodeType;
    public static String installType;
    public static String adeUser;
    private String walletPass;
    public static String timezone;
    public static String perlexe;
    public static String TFARunMode;
    public static String jdbcConUrl;
    public static String dbPasscode;
    public static String logViewCommandsXMLFile;
    public static String platform;
    public static boolean isCloud;
    public static int sslSwitch;
    public static int userCert;
    public static String TFAARGSEP;

    public void setDbHome(String string) {
        Output.print("Setting DBHome : " + string);
        dbHome = new File(string);
    }

    public void setLogFile(String string) {
        logFile = string;
    }

    public String getSysLogFile() {
        PrefixFileFilter prefixFileFilter;
        File[] fileArray;
        String string = null;
        File file = new File(logDir);
        if (file.exists() && (fileArray = file.listFiles((FilenameFilter)(prefixFileFilter = new PrefixFileFilter("syserrorout.", IOCase.SENSITIVE)))).length > 0) {
            Arrays.sort(fileArray, LastModifiedFileComparator.LASTMODIFIED_REVERSE);
            string = fileArray[0].getName();
        }
        return string;
    }

    public static void setSysLogFile(String string) {
        if (string == null || string != null && string.length() == 0) {
            string = "syserrorout." + Properties.getCurrentDate();
        }
        sysLogFile = logDir + File.separator + string;
        try {
            if (printStream != null) {
                printStream.close();
            }
            printStream = new PrintStream(new FileOutputStream(sysLogFile));
            System.setOut(printStream);
            System.setErr(printStream);
        }
        catch (Exception exception) {
            Output.print("Exception in setSysLogFile");
        }
    }

    public void setTfaPropertiesFile(String string) {
        tfaPropertiesFile = string;
    }

    public void setNoSampling() {
        samplingEnabled = false;
        LogFile.writeLog("!!!!!  SAMPLING HAS BEEN DISABLED !!!!");
    }

    public void setDarwinFile() {
        darwinFile = true;
        LogFile.writeLog("!!!!!  DARWIN FILE PROCESSING  !!!!");
    }

    public void setOutputDir(String string) {
        outputDir = string;
        inventoryDir = outputDir + File.separator + "inventory";
        inventoryXMLFile = inventoryDir + File.separator + "inventory.xml";
        filesWithNoFileTypes = inventoryDir + File.separator + "filesWithNoFileTypes.xml";
        directoriesWithNoMappings = inventoryDir + File.separator + "directoriesWithNoMappings.xml";
        filesIgnoredDuringInventory = inventoryDir + File.separator + "filesIgnoredDuringInventory.txt";
        alertlogXMLFile = inventoryDir + File.separator + "alertlog.xml";
        alertlogClusterXMLFile = inventoryDir + File.separator + "alertlogcluster.xml";
        genericXMLFile = inventoryDir + File.separator + "genericevent.xml";
        simileTimelineXMLFile = inventoryDir + File.separator + "simile_events.xml";
        dbzipDir = outputDir + File.separator + "dbzip" + File.separator;
        tracefileOutputDir = outputDir + File.separator + "tracefiles" + File.separator;
    }

    public void setResourceDir(String string, boolean bl) {
        fileTypesXml = string + File.separator + "file_type_patterns.xml";
        if (bl) {
            if (nodeType.equals("JCS")) {
                directoryPatternsXML = string + File.separator + "directory_patterns_jcs.xml";
                componentsXML = string + File.separator + "components_jcs.xml";
            } else if (nodeType.equals("FMW")) {
                directoryPatternsXML = string + File.separator + "directory_patterns_saas.xml";
                componentsXML = string + File.separator + "components_saas.xml";
            } else {
                directoryPatternsXML = string + File.separator + "directory_patterns.xml";
                componentsXML = string + File.separator + "components.xml";
            }
        } else {
            componentsXML = string + File.separator + "components.xml";
            directoryPatternsXML = string + File.separator + "directory_patterns.xml";
        }
        datePatternsXml = string + File.separator + "date_patterns.xml";
        problemSetsXml = string + File.separator + "problemset.xml";
        taskSetsXml = string + File.separator + "tasks.xml";
        extensionsFile = string + File.separator + "ignore_extensions.txt";
        searchStringsXml = string + File.separator + "searchStrings.xml";
        searchStringsInternalXml = string + File.separator + "searchStrings_internal.xml";
        maskStringsXml = string + File.separator + "mask_strings.xml";
        scanFileListXml = string + File.separator + "scanFileList.xml";
        ignorePatternsFile = string + File.separator + "ignorefiles.txt";
        noExclusionsXML = string + File.separator + "collect_all_directories.xml";
        logViewCommandsXMLFile = string + File.separator + "log_view_commands.xml";
    }

    public void setInternalDir(String string) {
        removedDirectoriesFile = string + File.separator + "removed_directories.txt";
        removedHostsFile = string + File.separator + "removed_hosts.txt";
        configPropertiesFile = string + File.separator + "config.properties";
        rconfigPropertiesFile = string + File.separator + "rconfig.properties";
        rPatternsFile = string + File.separator + "rpatterns.json";
        usablePortsFile = string + File.separator + "usableports.txt";
        portFile = string + File.separator + "port.txt";
        NonRootportFile = string + File.separator + "NonRootport.txt";
        portMappingFile = string + File.separator + "portmapping.txt";
        cookiesFile = string + File.separator + ".tfacookie";
        buildVersionFile = string + File.separator + ".buildid";
        statusFileName = string + File.separator + "runstatus.txt";
    }

    public void setTFADirectories(String string) {
        resourcesDir = string + File.separator + "resources";
        outputDir = string + File.separator + "output";
        internalDir = string + File.separator + "internal";
        inputDir = string + File.separator + "input";
        logDir = string + File.separator + "log";
        dbDirectory = string + File.separator + "database";
        browserDir = string + File.separator + "browser" + File.separator;
        tmpDir = string + File.separator + "tmp" + File.separator;
    }

    public static String getInitDirectory() {
        String string = File.separator + "etc" + File.separator + "init.d";
        if (Properties.isAIX()) {
            string = File.separator + "etc";
        } else if (Properties.isHPUX()) {
            string = File.separator + "sbin" + File.separator + "init.d";
        }
        return string;
    }

    public static boolean isTFAOnADE() {
        boolean bl = false;
        String string = System.getenv("ADE_VIEW_NAME");
        if (string != null && string.length() > 0) {
            bl = true;
        }
        return bl;
    }

    public static String getHomeDirectory() {
        String string = System.getenv("ORA_TFA_USER_HOME");
        if (string == null || string != null && string.length() == 0) {
            string = System.getenv("HOME");
            if (string == null || string != null && string.length() == 0) {
                string = System.getProperty("user.home");
            }
            if (Properties.isTFAOnADE()) {
                String string2 = new Host().getHostname().trim();
                string = string + File.separator + string2;
            }
        }
        return string;
    }

    public static boolean isTFAOnJCS() {
        return new File(File.separator + "u01" + File.separator + "data" + File.separator + "domains" + File.separator + "jaas.properties").exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties(String string) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        tfaHome = string.replaceAll(File.separator + "$", "");
        tfaHome = tfaHome.replaceAll("\\\\\\\\", "\\\\");
        if (platform == null) {
            platform = System.getProperty("os.name").toLowerCase();
        }
        String string2 = Properties.getInitDirectory();
        String string3 = string2 + File.separator + "init.tfa";
        boolean bl = false;
        if (!new File(string3).exists()) {
            if (new File(tfaHome + File.separator + "tfa_setup.txt").exists()) {
                try {
                    boolean bl2 = false;
                    object8 = new BufferedReader(new FileReader(tfaHome + File.separator + "tfa_setup.txt"));
                    while ((object7 = ((BufferedReader)object8).readLine()) != null) {
                        if (!((String)object7).startsWith("NODE_TYPE=CELL")) continue;
                        bl2 = true;
                    }
                    ((BufferedReader)object8).close();
                    if (!bl2) {
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        } else {
            String string4 = Properties.getHomeDirectory();
            object8 = new File(string4 + File.separator + ".tfa" + File.separator + "tfa_setup.txt");
            if (((File)object8).exists()) {
                try {
                    boolean bl3 = false;
                    object6 = new BufferedReader(new FileReader((File)object8));
                    while ((object5 = ((BufferedReader)object6).readLine()) != null) {
                        if (!((String)object5).startsWith("NODE_TYPE=SI")) continue;
                        bl3 = true;
                        nodeType = ((String)object5).substring(10).trim();
                        break;
                    }
                    ((BufferedReader)object6).close();
                    if (bl3) {
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (Properties.isWindows()) {
            bl = false;
        }
        if (bl) {
            String string5 = new Host().getHostname().trim();
            object8 = System.getProperty("user.name");
            object7 = Properties.getHomeDirectory();
            object6 = (String)object7 + File.separator + ".tfa" + File.separator + "tfa_setup.txt";
            tfaBase = File.separator + "tmp" + File.separator + "oracle.tfa" + File.separator + string5 + File.separator + (String)object8;
            if (new File((String)object6).exists()) {
                try {
                    object5 = new BufferedReader(new FileReader((String)object6));
                    while ((object4 = ((BufferedReader)object5).readLine()) != null) {
                        if (((String)object4).startsWith("TFA_BASE=")) {
                            tfaBase = ((String)object4).substring(9);
                            continue;
                        }
                        if (!((String)object4).startsWith("NODE_TYPE=ADE_ND")) continue;
                        nodeType = "ADE_ND";
                    }
                    ((BufferedReader)object5).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            tfaDirectoriesFile = tfaBase + File.separator + "tfa_directories.txt";
            this.setTFADirectories(tfaBase);
        } else {
            tfaPropertiesFile = tfaHome + File.separator + "tfa_setup.txt";
            tfaDirectoriesFile = tfaHome + File.separator + "tfa_directories.txt";
            this.setTFADirectories(tfaHome);
        }
        String string6 = internalDir + File.separator + "ssl.properties";
        if (new File(string6).exists()) {
            this.readSslConfig(string6);
        } else {
            trustStore = tfaHome + File.separator + "public.jks";
            keyStore = tfaHome + File.separator + "tfa.jks";
        }
        this.setResourceDir(resourcesDir, bl);
        this.setOutputDir(outputDir);
        this.setInternalDir(internalDir);
        if (bl) {
            object8 = Properties.getHomeDirectory();
            tfaPropertiesFile = (String)object8 + File.separator + ".tfa" + File.separator + "tfa_setup.txt";
            configPropertiesFile = (String)object8 + File.separator + ".tfa" + File.separator + "config.properties";
        }
        tracefileRequestFile = inputDir + File.separator + "tracefileRequest.txt";
        mergeDbDir = tfaHome + File.separator + "mergeDb" + File.separator + "BERKELEY_JE_DB" + File.separator;
        environment = "";
        srOrBugNum = "";
        diagcollectFile = logDir + File.separator + "diagcollect.log";
        logFile = logDir + File.separator + "tfa." + Properties.getCurrentDate() + ".log";
        this.readPropertiesFile();
        this.readConfigPropertiesFile();
        this.readRConfigPropertiesFile();
        this.updatePublicIp();
        dbHome = new File(dbDirectory + File.separator + "BERKELEY_JE_DB");
        object8 = new Host().getHostname().trim();
        if (installType.equals("GI") || installType.equals("DB")) {
            object7 = oracleBase + File.separator + "tfa" + File.separator + (String)object8 + File.separator + "database" + File.separator + "BERKELEY_JE_DB";
            dbHome = new File((String)object7);
        }
        new DbManager();
        object7 = DbManager.getInstance();
        object6 = DbManager.getInstance().getAllEntities(Timezone.class);
        object5 = object6.entities();
        try {
            object4 = object5.iterator();
            if (object4.hasNext()) {
                object3 = (Timezone)object4.next();
                object2 = ((Timezone)object3).getTimezone();
                timezone = object2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            object5.close();
        }
        if (timezone == null) {
            timezone = TimeZoneUtil.getSessionTimeZone();
            if (timezone != null) {
                if (!timezone.equals(TimeZone.getDefault().getID())) {
                    Global.invalidateBDB = true;
                }
                object4 = new Timezone(timezone);
                ((Timezone)object4).store();
                TimeZone.setDefault(TimeZone.getTimeZone(timezone));
            }
        } else {
            object4 = TimeZoneUtil.getSessionTimeZone();
            if (object4 != null && !((String)object4).equals(timezone)) {
                boolean bl4 = false;
                object2 = null;
                for (String string7 : TimeZone.getAvailableIDs()) {
                    if (!timezone.equalsIgnoreCase(TimeZone.getTimeZone(string7).getDisplayName())) continue;
                    object2 = string7;
                    bl4 = true;
                    break;
                }
                if (bl4) {
                    if (!TimeZone.getTimeZone(timezone).getID().equals(object4)) {
                        Global.invalidateBDB = true;
                    }
                    if (Timezone.delete(timezone)) {
                        object = new Timezone((String)object2);
                        ((Timezone)object).store();
                    }
                    timezone = object2;
                    TimeZone.setDefault(TimeZone.getTimeZone(timezone));
                }
            } else {
                TimeZone.setDefault(TimeZone.getTimeZone(timezone));
            }
        }
        logFile = logDir + File.separator + "tfa." + Properties.getCurrentDate() + ".log";
        object4 = new File(tfaHome + File.separator + "diagnostics_to_collect");
        if (installType.equals("GI") || installType.equals("DB")) {
            logDir = oracleBase + File.separator + "tfa" + File.separator + (String)object8 + File.separator + "log";
            logFile = logDir + File.separator + "tfa." + Properties.getCurrentDate() + ".log";
            object3 = oracleBase + File.separator + "tfa" + File.separator + (String)object8 + File.separator + "output";
            this.setOutputDir((String)object3);
            object4 = new File(Properties.getOracleBase() + File.separator + "tfa" + File.separator + (String)object8 + File.separator + "diagnostics_to_collect");
        }
        if (!Global.offlineMode.booleanValue()) {
            Properties.setSysLogFile(this.getSysLogFile());
            LogFile.writeLog("System Error Log is set to " + sysLogFile);
        }
        Output.printTrace("Properties tfaHome " + tfaHome + " for TFAMain", 3);
        object3 = new File(crsHome + File.separator + "perl" + File.separator + "bin" + File.separator + "perl");
        object2 = new File(File.separator + "usr" + File.separator + "bin" + File.separator + "perl");
        if (((File)object3).exists()) {
            perlexe = ((File)object3).toString();
        } else if (((File)object2).exists()) {
            perlexe = ((File)object2).toString();
        }
        if (Properties.isWindows() && new File(tfaPropertiesFile).exists()) {
            try {
                String string8;
                object = new BufferedReader(new FileReader(tfaPropertiesFile));
                while ((string8 = ((BufferedReader)object).readLine()) != null) {
                    if (!string8.startsWith("PERL=")) continue;
                    perlexe = string8.substring(5);
                }
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        LogFile.writeLog("Perl Executable set to :" + perlexe);
        Output.print("Timezone : " + timezone);
        Output.print("Install Type : " + installType);
        Output.printTrace("Creating bucket directory: " + ((File)object4).toString(), 3);
        ((File)object4).mkdir();
        if (clusterName != null) {
            object = new Cluster(clusterName);
            DbManager.getInstance().getDbPut().storeClusterEntity((Cluster)object);
        }
        if (Global.offlineMode.booleanValue()) {
            Properties.readDirectoriesFile();
            Output.print("SR Number : " + srOrBugNum);
        } else {
            Output.printTrace("Reading port file ....", 3);
            this.readPortFile();
        }
        this.getCookieFromBdb();
        DirectoryMappings.getInstance();
        Output.print("Node Type : " + nodeType);
        object = RepositoryManager.getInstance();
        ((RepositoryManager)object).printRepository();
        this.fillRobjectsFromDb();
        String string9 = RGlobal.kvStr.get("r.repository");
        if (string9 != null && string9.equals("NONE")) {
            RGlobal.setProperty("r.repository", ((RepositoryManager)object).getDirectory().trim(), "STRING");
        }
        if (TFARunMode.equals("receiver")) {
            String string7;
            Output.printTrace("Indexing meta patterns ....", 1);
            String string10 = RGlobal.kvStr.get("r.repository");
            string7 = new Host().getHostname().trim();
            String string11 = string10.trim() + File.separator + "receiver" + File.separator + string7 + File.separator + "index" + File.separator + "metadataindex";
            Output.printTrace("Indexing location:" + string11, 1);
            this.indexRPatternsFile(string11);
            Output.printTrace("Indexing meta patterns done", 1);
        }
        this.setClusterMetadata();
        MaskStrings.getInstance();
        CollectAllDirectories.getInstance();
        if (bl) {
            Global.setTrimmingOn(false);
        }
        isCloud = bl;
        if (Global.offlineMode.booleanValue()) {
            new PurgeTFALogs().start();
        }
    }

    public static Properties getInstance(String string) {
        if (instance == null) {
            instance = new Properties(string);
        }
        return instance;
    }

    public static String getCurrentDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.yyyy-HH.mm.ss");
        String string = timezone;
        if (string != null) {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string));
        }
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    public static String getLogTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String string = timezone;
        if (string != null) {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string));
        }
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    public static Properties getInstance() {
        return instance;
    }

    public static void setSrFileId(String string) {
        srFileId = string;
    }

    public static void setScanFileListXml(String string) {
        scanFileListXml = string;
    }

    public static String getScanFileListXml() {
        return scanFileListXml;
    }

    public static boolean isDarwinFile() {
        return darwinFile;
    }

    public static void setSearchStringsXml(String string) {
        searchStringsXml = string;
    }

    public static String getSearchStringsXml() {
        return searchStringsXml;
    }

    public static void setSearchStringsInternalXml(String string) {
        searchStringsInternalXml = string;
    }

    public static String getSearchStringsInternalXml() {
        return searchStringsInternalXml;
    }

    public static void setMaskStringsXml(String string) {
        maskStringsXml = string;
    }

    public static String getMaskStringsXml() {
        return maskStringsXml;
    }

    public void setEnvironment(String string) {
        environment = string;
    }

    public static String getEnvironment() {
        return environment;
    }

    public static void setDbZipName(String string) {
        dbZipName = string;
    }

    public static String getDbZipName() {
        return dbZipName;
    }

    public static String getTmpDir() {
        return tmpDir;
    }

    private static void readDirectoriesFile() {
        try {
            String string;
            Output.printTrace("Reading File: " + tfaDirectoriesFile, 3);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(tfaDirectoriesFile));
            Object var1_2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.contains("DIAGDEST")) continue;
                TFADirectoryManager.addFromFileLine(string);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void readPropertiesFile() {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(tfaPropertiesFile));
            Object var2_3 = null;
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                if (string.startsWith("DBDIR=")) {
                    this.setDbHome(string.substring(6));
                    continue;
                }
                if (string.startsWith("SAMPLING_DISABLED")) {
                    this.setNoSampling();
                    continue;
                }
                if (string.startsWith("DARWIN_FILE")) {
                    this.setDarwinFile();
                    continue;
                }
                if (string.startsWith("LOGFILE=")) {
                    this.setLogFile(string.substring(8));
                    continue;
                }
                if (string.startsWith("OUTPUTDIR=")) {
                    this.setOutputDir(string.substring(10));
                    continue;
                }
                if (string.startsWith("SR_FILE_ID=")) {
                    Properties.setSrFileId(string.substring(11));
                    continue;
                }
                if (string.startsWith("SCAN_HOME=")) {
                    Properties.setScanFileListXml(string.substring(10) + File.separator + "scanFileList.xml");
                    Properties.setSearchStringsXml(string.substring(10) + File.separator + "searchStrings.xml");
                    continue;
                }
                if (string.startsWith("RESTART_SCAN=TRUE")) {
                    Global.setSaveRestartPoint(true);
                    continue;
                }
                if (string.startsWith("RESTART_SCAN=FALSE")) {
                    Global.setSaveRestartPoint(false);
                    continue;
                }
                if (string.startsWith("ENVIRONMENT=")) {
                    this.setEnvironment(string.substring(12));
                    continue;
                }
                if (string.startsWith("SUPPORT_MODE=TRUE")) {
                    Properties.enableSupportMode();
                    continue;
                }
                if (string.startsWith("SR=")) {
                    Properties.enableSupportMode();
                    Properties.setSrOrBugNum(string.substring(3));
                    continue;
                }
                if (string.contains("CLUSTER_NAME")) {
                    string2 = string.substring(13).trim();
                    Properties.setClusterName(string2);
                    continue;
                }
                if (string.contains("CLUSTER_CLASS")) {
                    string2 = string.substring(14).trim();
                    Properties.setClusterClass(string2);
                    continue;
                }
                if (string.contains("CRS_HOME=")) {
                    this.setCRSHome(string.substring(9));
                    continue;
                }
                if (string.contains("ORACLE_BASE=")) {
                    Properties.setOracleBase(string.substring(12));
                    continue;
                }
                if (string.contains("NODE_TYPE=")) {
                    nodeType = string.substring(10).trim();
                    continue;
                }
                if (string.contains("INSTALL_TYPE=")) {
                    installType = string.substring(13);
                    continue;
                }
                if (string.contains("ADE_USER=")) {
                    adeUser = string.substring(9).trim();
                    continue;
                }
                if (!string.startsWith("RUN_MODE=")) continue;
                TFARunMode = string.substring(9);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String getBrowserDir() {
        return browserDir;
    }

    public static void enableSupportMode() {
        isSupportMode = true;
    }

    public static boolean isSupportMode() {
        return isSupportMode;
    }

    public static String getSrContext() {
        return srContext;
    }

    public static void setSocketPort(String string) {
        socketPort = string;
    }

    public static String getSocketPort() {
        return socketPort;
    }

    public static void setSrOrBugNum(String string) {
        srOrBugNum = string;
    }

    public static String getSrOrBugNum() {
        return srOrBugNum;
    }

    public static void setTFAVersion(String string) {
        tfaVersion = string;
    }

    public static String getTFAVersion() {
        return tfaVersion;
    }

    public static void setTFACookie(String string) {
        tfaCookie = string;
    }

    public static String getTFACookie() {
        return tfaCookie;
    }

    private void getCookieFromBdb() {
        TFACookieDA tFACookieDA = new TFACookieDA();
        String string = new Host().getHostname().trim();
        TFACookie tFACookie = (TFACookie)tFACookieDA.pIdx.get((Object)string);
        if (tFACookie == null) {
            Output.printTrace("No cookie in Bdb", 3);
        } else {
            tfaCookie = tFACookie.getCookie();
        }
    }

    private void fillRobjectsFromDb() {
        TFAReceiver.loadRObjectsData("hostkey");
        TFAReceiver.loadRObjectsData("port");
    }

    public void readSslConfig(String string) {
        try {
            Object object;
            String string2;
            java.util.Properties properties = new java.util.Properties();
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            fileInputStream.close();
            keyStore = properties.getProperty("serverCert") != null ? (string2 = properties.getProperty("serverCert").trim()) : tfaHome + File.separator + "server.jks";
            trustStore = properties.getProperty("clientCert") != null ? (string2 = properties.getProperty("clientCert").trim()) : tfaHome + File.separator + "client.jks";
            string2 = properties.getProperty("serverKeyStorePass").trim();
            serverKeyStorePassword = EncryptionUtil.decrypt(string2);
            String string3 = properties.getProperty("clientKeyStorePass").trim();
            clientKeyStorePassword = EncryptionUtil.decrypt(string3);
            String string4 = properties.getProperty("serverTrustStorePass").trim();
            serverTrustStorePassword = EncryptionUtil.decrypt(string4);
            String string5 = properties.getProperty("clientTrustStorePass").trim();
            trustStorePassword = EncryptionUtil.decrypt(string5);
            if (properties.getProperty("sslKey") != null) {
                object = properties.getProperty("sslKey").trim();
                sslSwitch = new Integer((String)object);
            }
            if (properties.getProperty("userCert") != null) {
                object = properties.getProperty("userCert").trim();
                userCert = new Integer((String)object);
            }
            if (sslSwitch == 0 && userCert == 0) {
                properties.setProperty("sslKey", "1");
                object = new FileOutputStream(string);
                properties.store((OutputStream)object, null);
                ((FileOutputStream)object).close();
                sslSwitch = 1;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void readConfigPropertiesFile() {
        if (!new File(configPropertiesFile).exists()) {
            return;
        }
        try {
            String string;
            String string2;
            Object object2;
            String[] stringArray;
            String string3;
            String string4;
            String string5;
            java.util.Properties properties = new java.util.Properties();
            FileInputStream fileInputStream = new FileInputStream(configPropertiesFile);
            properties.load(fileInputStream);
            fileInputStream.close();
            String string6 = properties.getProperty("maxLogSize").trim();
            Global.setMaxLogSize(new Long(string6) * 1024L * 1024L);
            String string7 = properties.getProperty("maxLogCount").trim();
            Global.setMaxLogCount(new Integer(string7));
            String string8 = properties.getProperty("fileCountInventorySwitch").trim();
            Global.setFileCountInventorySwitch(new Long(string8));
            if (Global.offlineMode.booleanValue()) {
                string5 = properties.getProperty("inventoryThreadPoolSizeOffline").trim();
                Global.setThreadPoolSizeForInventory(new Integer(string5));
            } else {
                string5 = properties.getProperty("inventoryThreadPoolSize").trim();
                Global.setThreadPoolSizeForInventory(new Integer(string5));
            }
            string5 = properties.getProperty("rtscan").trim();
            Global.setRtScanOn(Boolean.parseBoolean(string5));
            String string9 = properties.getProperty("diskUsageMon").trim();
            Global.setDiskUsageMonOn(Boolean.parseBoolean(string9));
            String string10 = properties.getProperty("manageLogsAutoPurge").trim();
            Global.setManageLogsAutoPurgeOn(Boolean.parseBoolean(string10));
            String string11 = properties.getProperty("odscan").trim();
            Global.setOdScanOn(Boolean.parseBoolean(string11));
            String string12 = properties.getProperty("trimfiles").trim();
            Global.setTrimmingOn(Boolean.parseBoolean(string12));
            String string13 = properties.getProperty("trimsize").trim();
            Global.setTrimsize(new Long(string13));
            String string14 = properties.getProperty("firediagcollectRT").trim();
            Global.setFireZipsInRT(Boolean.parseBoolean(string14));
            String string15 = properties.getProperty("firediagcollectOD").trim();
            Global.setFireZipsInOD(Boolean.parseBoolean(string15));
            String string16 = properties.getProperty("firediagcollect").trim();
            Global.setAllowZips(Boolean.parseBoolean(string16));
            String string17 = properties.getProperty("minTimeForAutoDiagCollection").trim();
            Global.setMinTimeForAutoDiagCollection(new Long(string17));
            String string18 = properties.getProperty("inventorytraceLevel").trim();
            Global.setInventorytraceLevel(new Integer(string18));
            String string19 = properties.getProperty("collectiontraceLevel").trim();
            Global.setCollectiontraceLevel(new Integer(string19));
            String string20 = properties.getProperty("scantraceLevel").trim();
            Global.setScantraceLevel(new Integer(string20));
            String string21 = properties.getProperty("othertraceLevel").trim();
            Global.setOthertraceLevel(new Integer(string21));
            String string22 = properties.getProperty("traceLevel").trim();
            Global.setTraceLevel(new Integer(string22));
            String string23 = properties.getProperty("collectAllDirsByFile").trim();
            Global.setCollectAllDirsByFile(Boolean.parseBoolean(string23));
            String string24 = properties.getProperty("internalSearchString").trim();
            Global.setInternalSearchString(Boolean.parseBoolean(string24));
            String string25 = properties.getProperty("maxCoreFileSize");
            Global.setMaxCoreFileSize(new Integer(string25));
            String string26 = properties.getProperty("maxCoreCollectionSize");
            Global.setMaxCoreCollectionSize(new Integer(string26));
            String string27 = properties.getProperty("autoPurge").trim();
            Global.setAutoPurge(Boolean.parseBoolean(string27));
            String string28 = properties.getProperty("purgeFrequency").trim();
            Global.setPurgeFrequency(new Integer(string28));
            String string29 = properties.getProperty("minFileAgeToPurge").trim();
            Global.setMinFileAgeToPurge(new Integer(string29));
            String string30 = properties.getProperty("minPossibleSpaceForPurge").trim();
            Global.setMinPossibleSpaceForPurge(new Integer(string30));
            String string31 = properties.getProperty("minSpaceForRTScan").trim();
            Global.setMinSpaceForRTScan(new Integer(string31));
            String string32 = properties.getProperty("diskUsageMonInterval").trim();
            Global.setDiskUsageMonInterval(new Integer(string32));
            String string33 = properties.getProperty("manageLogsAutoPurgeInterval").trim();
            Global.setManageLogsAutoPurgeInterval(new Integer(string33));
            String string34 = properties.getProperty("manageLogsAutoPurgePolicyAge").trim();
            Global.setManageLogsAutoPurgePolicyAge(string34);
            String string35 = properties.getProperty("language").trim();
            Global.setLanguage(string35);
            String string36 = properties.getProperty("encoding").trim();
            Global.setEncoding(string36);
            String string37 = properties.getProperty("country").trim();
            Global.setCountry(string37);
            String string38 = properties.getProperty("debugips").trim();
            Global.setDebugIps(Boolean.parseBoolean(string38));
            String string39 = properties.getProperty("tfaIpsPoolSize").trim();
            Global.setTfaIpsPoolSize(new Integer(string39));
            if (properties.getProperty("AlertLogLevel") != null) {
                string4 = properties.getProperty("AlertLogLevel").trim();
                Global.setAlertLogLevel(string4);
            }
            if (properties.getProperty("UserLogLevel") != null) {
                string4 = properties.getProperty("UserLogLevel").trim();
                Global.setUserLogLevel(string4);
            }
            if (properties.getProperty("BaseLogPath") != null) {
                string4 = properties.getProperty("BaseLogPath").trim();
                Global.setBaseLogPath(string4);
            }
            if ((string4 = properties.getProperty("firstDiscovery")) == null) {
                Global.setFirstDiscovery(0);
            } else {
                Global.setFirstDiscovery(1);
            }
            if (nodeType.equals("ADE")) {
                string3 = properties.getProperty("ignoreEventsInADE").trim();
                Global.setIgnoreEventsInADE(Boolean.parseBoolean(string3));
            }
            if ((string3 = properties.getProperty("restrictedProtocols")) != null) {
                string3 = string3.trim();
                stringArray = string3.split(",");
                object2 = stringArray;
                int n = ((String[])object2).length;
                for (int i = 0; i < n; ++i) {
                    Object object3 = object2[i];
                    Global.restrictedProtocols.add((String)object3);
                }
            }
            if ((stringArray = properties.getProperty("protocol")) != null) {
                Global.protocol = stringArray.trim();
            }
            if ((object2 = properties.getProperty("notificationAddress")) != null) {
                Global.notificationAddress = ((String)object2).trim();
            }
            Set<String> set = properties.stringPropertyNames();
            for (String string40 : set) {
                if (!string40.contains("NotificationAddress")) continue;
                string2 = string40.substring(0, string40.indexOf("NotificationAddress"));
                string = properties.getProperty(string40);
                Global.userAddresses.put(string2, string);
            }
            String string40 = properties.getProperty("collectTrm").trim();
            Global.collectTrm = Boolean.parseBoolean(string40);
            String string41 = properties.getProperty("skipScanThreshold");
            Global.setSkipScanThreshold(new Long(string41));
            string2 = properties.getProperty("tfaClusterMode");
            if (string2 != null) {
                tfaClusterMode = Boolean.parseBoolean(string2);
            }
            if ((string = properties.getProperty("publicIp")) != null) {
                publicIp = Boolean.parseBoolean(string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void updatePublicIp() {
        if (tfaClusterMode == null) {
            tfaClusterMode = crsHome == null || crsHome != null && crsHome.length() == 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
            Utilities.updateConfigPropertiesFile("tfaClusterMode", tfaClusterMode.toString());
            if (publicIp == null) {
                publicIp = crsHome == null || crsHome != null && crsHome.length() == 0 ? Boolean.valueOf(false) : Boolean.valueOf(true);
                Utilities.updateConfigPropertiesFile("publicIp", publicIp.toString());
            }
            return;
        }
        if (publicIp == null) {
            publicIp = tfaClusterMode != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
            Utilities.updateConfigPropertiesFile("publicIp", publicIp.toString());
            return;
        }
        if (tfaClusterMode.booleanValue() && !publicIp.booleanValue()) {
            publicIp = true;
            Utilities.updateConfigPropertiesFile("publicIp", publicIp.toString());
        }
    }

    private void readRConfigPropertiesFile() {
        if (!new File(rconfigPropertiesFile).exists()) {
            return;
        }
        try {
            java.util.Properties properties = new java.util.Properties();
            FileInputStream fileInputStream = new FileInputStream(rconfigPropertiesFile);
            properties.load(fileInputStream);
            RGlobal.setProperty("k.producer.port", properties.getProperty("k.producer.port").trim(), "INTEGER");
            RGlobal.setProperty("k.consumer.port", properties.getProperty("k.consumer.port").trim(), "INTEGER");
            RGlobal.setProperty("r.repository", properties.getProperty("r.repository").trim(), "STRING");
            RGlobal.setProperty("r.port", properties.getProperty("r.port").trim(), "INTEGER");
            RGlobal.setProperty("r.send.collections", properties.getProperty("r.send.collections").trim(), "BOOLEAN");
            RGlobal.setProperty("r.send.data.realtime", properties.getProperty("r.send.data.realtime").trim(), "BOOLEAN");
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void indexRPatternsFile(String string) {
        MetadataIndexer metadataIndexer = new MetadataIndexer(string.trim());
        if (!new File(rPatternsFile).exists()) {
            return;
        }
        try {
            String string2 = null;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(rPatternsFile));
            while ((string2 = bufferedReader.readLine()) != null) {
                metadataIndexer.addToMetadataIndex(string2);
                Output.printTrace("MetadataIndexer::Indexed:" + string2, 3);
            }
            metadataIndexer.close();
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Output.printTrace("File not found in indexRPatternsFile", 1);
        }
        catch (IOException iOException) {
            Output.printTrace("IO exception in indexRPatternsFile", 1);
        }
    }

    public void setCRSHome(String string) {
        crsHome = string;
    }

    public String getCRSHome() {
        return crsHome;
    }

    public void setUsablePorts(List<Integer> list) {
        usablePorts = list;
    }

    public List<Integer> getUsablePorts() {
        return usablePorts;
    }

    private void setUsablePorts() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(usablePortsFile));
            while ((string = bufferedReader.readLine()) != null) {
                string = string.trim();
                arrayList.add((int)new Integer(string));
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Output.printTrace("Setting usablePorts " + arrayList, 3);
        this.setUsablePorts(arrayList);
    }

    public void writePortToFile(int n) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(portFile));
            Output.printTrace("Writing port : " + n + " to port.txt", 3);
            bufferedWriter.write(Integer.toString(n));
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void writeNonRootPortToFile(int n) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(NonRootportFile));
            Output.printTrace("Writing port : " + n + " to NonRootport.txt", 3);
            bufferedWriter.write(Integer.toString(n));
            bufferedWriter.close();
            FileHelper.changePermission("755", NonRootportFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getPortFromFile() {
        String string = null;
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(portFile));
            while ((string2 = bufferedReader.readLine()) != null) {
                string = string2.trim();
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    public int getAvailablePortToUse() {
        int n = -1;
        for (int n2 : usablePorts) {
            boolean bl = Properties.isPortAvailable(n2);
            Output.printTrace("Checking if port " + n2 + " is available : " + bl, 3);
            if (!bl) continue;
            n = n2;
            break;
        }
        return n;
    }

    private void readPortFile() {
        int n;
        this.setUsablePorts();
        String string = null;
        boolean bl = false;
        File file = new File(portFile);
        if (file.exists()) {
            string = this.getPortFromFile();
            n = Properties.isPortAvailable(new Integer(string));
            if (n == 0) {
                bl = true;
                Output.print("Previously used port " + string + " is not available now. Getting a new available port ...");
                int n2 = this.getAvailablePortToUse();
                string = Integer.toString(n2);
                Output.print("New available port to use : " + string);
                Output.printTrace("Updating port in port.txt...", 3);
                this.writePortToFile(n2);
            }
        } else {
            Output.print("Getting available port to use from " + usablePorts);
            n = this.getAvailablePortToUse();
            Output.print("Available port : " + n);
            Output.printTrace("port file does not exist, so creating one...", 3);
            this.writePortToFile(n);
            string = Integer.toString(n);
        }
        Output.printTrace("Setting port in Global : " + string, 3);
        Properties.setSocketPort(string);
        String string2 = new Host().getHostname().trim();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        File file2 = new File(portMappingFile);
        if (Global.offlineMode.booleanValue()) {
            if (file2.exists() && hashMap.containsKey(string2) && file2.length() != 0L) {
                hashMap = Properties.createPortMappingFromFile();
                if (bl || !((Integer)hashMap.get(string2)).equals(new Integer(string))) {
                    Output.printTrace("Updating port for localhost in portMapping...", 3);
                    hashMap.put(string2, (int)new Integer(string));
                    Properties.writePortMappingToFile(hashMap);
                }
            } else {
                hashMap.put(string2, new Integer(string));
                Properties.writePortMappingToFile(hashMap);
            }
        } else if (file2.exists() && file2.length() != 0L) {
            hashMap = Properties.createPortMappingFromFile();
            Output.printTrace("portChanged: " + bl, 3);
            if (bl || !((Integer)hashMap.get(string2)).equals(new Integer(string))) {
                Output.printTrace("Updating port for localhost in portMapping...", 3);
                Properties.updatePortMapping(string2, string);
            }
        } else {
            hashMap.put(string2, new Integer(string));
            Properties.writePortMappingToFile(hashMap);
        }
        Global.setPortMapping(hashMap);
    }

    private static Map<String, Integer> createPortMappingFromFile() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(portMappingFile));
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split(":");
                hashMap.put(stringArray[0].trim(), (int)new Integer(stringArray[1].trim()));
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Output.printTrace("Created port mapping from file " + hashMap, 3);
        return hashMap;
    }

    public static void writePortMappingToFile(Map<String, Integer> map) {
        Output.printTrace("Writing portMapping to file " + map, 3);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(portMappingFile));
            for (String string : map.keySet()) {
                bufferedWriter.write(string + ":" + Integer.toString(map.get(string)) + "\n");
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void updatePortMapping(String string, String string2) {
        Map<String, Integer> map = Global.getPortMapping();
        if (map == null) {
            map = new HashMap<String, Integer>();
            map.put(string, (int)new Integer(string2));
            Properties.writePortMappingToFile(map);
            Global.setPortMapping(map);
            return;
        }
        map.put(string, (int)new Integer(string2));
        Output.printTrace("Writing portMapping to file " + map, 3);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(portMappingFile));
            for (String object : map.keySet()) {
                bufferedWriter.write(object + ":" + Integer.toString(map.get(object)) + "\n");
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string3 = new Host().getHostname().trim();
        if (string.equalsIgnoreCase(string3)) {
            Object var5_7 = null;
            PrintWriter printWriter = null;
            String string4 = null;
            EntityCursor entityCursor = null;
            Properties.getInstance();
            String string5 = trustStore;
            Properties.getInstance();
            String string6 = trustStorePassword;
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            entityCursor = primaryIndex.entities(null, cursorConfig);
            String string7 = (String)string3 + ":updateportmapping:" + string + ":" + string2;
            for (TFAHost tFAHost : entityCursor) {
                try {
                    String string8;
                    string4 = tFAHost.getHostname();
                    if (string4.equalsIgnoreCase(string3)) continue;
                    Output.printTrace("Making Socket connection to :" + string4, 3);
                    SSLSocket sSLSocket = SocketManager.getSecureSocketConnection(string4.trim(), Global.getSocketPort(), string5, string6);
                    if (sSLSocket == null) {
                        Output.printTrace("Could not update portmapping in " + string4, 1);
                        continue;
                    }
                    printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                    printWriter.println(string7);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                    while ((string8 = bufferedReader.readLine()) != null && !string8.equals("DONE")) {
                    }
                    bufferedReader.close();
                    if (sSLSocket.isClosed()) continue;
                    sSLSocket.close();
                }
                catch (Exception exception) {
                    Output.printTrace("Could not update portmapping in " + string4 + " -" + exception.getMessage(), 1);
                }
            }
        } else {
            Global.setPortMapping(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortAvailable(int n) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(n);
            serverSocket.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            Output.printTrace("Port " + n + " : " + exception.getMessage(), 3);
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return false;
    }

    private void setClusterMetadata() {
        String string = Properties.getClusterName();
        if (string == null) {
            Output.print("Could not determine clusterName. Cannot set cluster metadata");
            return;
        }
        Cluster cluster = (Cluster)new ClusterDA().pIdx.get((Object)string);
        if (cluster == null) {
            cluster = new Cluster(string);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Output.printTrace("Reading cluster metadata from " + tfaPropertiesFile, 3);
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(tfaPropertiesFile));
            while ((string2 = bufferedReader.readLine()) != null) {
                List<String> list;
                if (string2.contains("%")) continue;
                String[] stringArray = string2.split("=");
                String string3 = null;
                if (stringArray.length >= 1) {
                    string3 = stringArray[0].trim();
                }
                String string4 = "";
                if (stringArray.length > 1) {
                    string4 = stringArray[1].trim();
                }
                if (string3 == null || string3.equalsIgnoreCase("CLUSTER_NAME") || string3.contains("DIAGDEST")) continue;
                if (string3.equalsIgnoreCase("RDBMS_ORACLE_HOME")) {
                    list = new ArrayList<String>();
                    if (hashMap.containsKey(string3)) {
                        list = (List)hashMap.get(string3);
                    }
                    list.add(string4);
                    hashMap.put(string3, list);
                    continue;
                }
                if (string3.contains("INSTANCE_NAME")) {
                    list = new ArrayList();
                    if (hashMap.containsKey("database")) {
                        list = (List)hashMap.get("database");
                    }
                    String string5 = string3.split("\\.")[1].trim();
                    list.add(string5);
                    hashMap.put("database", list);
                    continue;
                }
                hashMap.put(string3, string4);
            }
            Cluster.setClusterMetadata(hashMap);
            Output.printTrace("Storing cluster entity...", 3);
            DbManager.getInstance().getDbPut().storeClusterEntity(cluster);
            Output.printTrace("Metadata from cluster : ", 3);
            for (String string3 : cluster.getClusterMetadata().keySet()) {
                Output.printTrace(string3 + " : " + cluster.getClusterMetadata().get(string3), 3);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void setClusterName(String string) {
        clusterName = string;
    }

    public static String getClusterName() {
        return clusterName;
    }

    public static void setClusterClass(String string) {
        clusterClass = string;
    }

    public static String getClusterClass() {
        return clusterClass;
    }

    public static void setAutoPatchingEnabled(boolean bl) {
        autoPatchingEnabled = bl;
    }

    public static boolean isAutoPatchingEnabled() {
        return autoPatchingEnabled;
    }

    public static void setOracleBase(String string) {
        oracleBase = string;
    }

    public static String getOracleBase() {
        return oracleBase;
    }

    public static void setKeystoresUpdated(boolean bl) {
        keystoresUpdated = bl;
    }

    public static boolean isKeystoresUpdated() {
        return keystoresUpdated;
    }

    public static boolean isWindows() {
        return platform.indexOf("windows") >= 0;
    }

    public static boolean isSolaris() {
        return platform.indexOf("sunos") >= 0;
    }

    public static boolean isAIX() {
        return platform.indexOf("aix") >= 0;
    }

    public static boolean isHPUX() {
        return platform.indexOf("hp-ux") >= 0;
    }

    public static boolean isLinux() {
        return platform.indexOf("linux") >= 0;
    }

    public static boolean isZlinux() {
        String string = System.getProperty("os.arch").toLowerCase();
        return string.indexOf("s390") >= 0;
    }

    public void setWalletPassword(String string) {
        this.walletPass = string;
    }

    public String getWalletPass() {
        return this.walletPass;
    }

    public String getNodeType() {
        return nodeType;
    }

    public static String getInstallType() {
        return installType;
    }

    public int getPrivatePort() {
        int n = -1;
        int n2 = -1;
        if (Properties.getSocketPort() != null) {
            n2 = new Integer(Properties.getSocketPort());
        }
        for (int n3 : this.getUsablePorts()) {
            if (!Properties.isPortAvailable(n3) || n3 == n2) continue;
            n = n3;
            break;
        }
        return n;
    }

    public static String getTFABuildID() {
        Object object;
        BufferedReader bufferedReader;
        Object object2 = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(internalDir + File.separator + ".buildid"));
            while ((object = bufferedReader.readLine()) != null) {
                Output.printTrace("Inside getTFABuildID: " + (String)object, 3);
                object2 = object;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = new File(internalDir + File.separator + ".buildversion");
        if (((File)object).exists()) {
            try {
                String string;
                bufferedReader = new BufferedReader(new FileReader((File)object));
                String string2 = null;
                while ((string = bufferedReader.readLine()) != null) {
                    Output.printTrace("Inside getTFABuildID: " + string, 3);
                    string2 = string;
                }
                bufferedReader.close();
                if (string2 != null) {
                    object2 = string2.trim() + ((String)object2).trim();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return object2;
    }

    public static boolean isExadata() {
        return new File("/etc/oracle/cell/network-config/cellip.ora").exists();
    }

    public static boolean isExadataConfigured() {
        return new File(internalDir + File.separator + "cellnames.txt").exists();
    }

    public static boolean isWindowsAdminUser() {
        boolean bl = false;
        try {
            String string = "reg query \"HKU\\S-1-5-19\"";
            Process process = Runtime.getRuntime().exec(string);
            process.waitFor();
            int n = process.exitValue();
            if (0 == n) {
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public static String getUserName() {
        String string = System.getProperty("user.name");
        if (Properties.isWindows()) {
            if (Properties.isWindowsAdminUser()) {
                string = "root";
            } else {
                String string2 = System.getenv("USERDOMAIN");
                if (null != string2 && !"".equalsIgnoreCase(string2)) {
                    string = string2 + "\\" + string;
                }
            }
        }
        return string;
    }

    public String getRemoteTFAHome(String string) {
        String string2 = "";
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        Properties.getInstance();
        String string3 = trustStore;
        Properties.getInstance();
        String string4 = trustStorePassword;
        String string5 = new Host().getHostname().trim();
        String string6 = string5 + ":printtfahome";
        try {
            if (!string.equalsIgnoreCase(string5)) {
                String string7;
                Output.printTrace("Making Socket connection to :" + string, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), string3, string4);
                if (sSLSocket == null) {
                    Output.print("Connection refused by " + string);
                    return "CONNECTION REFUSED";
                }
                printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter.println(string6);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string7 = bufferedReader.readLine()) != null && !string7.equals("DONE") && !string7.equals("FAIL")) {
                    string2 = string2 + string7;
                }
                bufferedReader.close();
                if (!sSLSocket.isClosed()) {
                    sSLSocket.close();
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.print("Unknown host: " + string);
        }
        catch (IOException iOException) {
            Output.print("MessageHandler : IOException while getTFAHome");
        }
        Output.printTrace("tfahome: " + string2, 3);
        return string2;
    }

    public static String getEscapedUserName(String string) {
        if (null != string && string.contains("\\")) {
            string = string.replace("\\", "__");
        }
        return string;
    }

    public static String getRemoteTFAVersion(String string) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        String string2 = new Host().getHostname().trim();
        Properties.getInstance();
        String string3 = trustStore;
        Properties.getInstance();
        String string4 = trustStorePassword;
        String string5 = "12.2.0.1.0";
        try {
            String string6 = string + ":checkversion:";
            Output.printTrace("getRemoteTFAVersion : Request Command : " + string6, 3);
            if (!string.equals(string2)) {
                String string7;
                Output.printTrace("Making Socket connection to :" + string, 3);
                sSLSocket = SocketManager.getSecureSocketConnection(string.trim(), Global.getSocketPort(), string3, string4);
                if (sSLSocket == null) {
                    Output.print("Connection refused! " + string);
                    return string5;
                }
                printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter.println(string6);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
                while ((string7 = bufferedReader.readLine()) != null) {
                    Output.printTrace("getRemoteTFAVersion: From " + string + " : " + string7, 3);
                    if (string7.startsWith("TFA Version : ")) {
                        string5 = string7.replaceAll("TFA Version : ", "");
                        continue;
                    }
                    if (!string7.equals("DONE") && !string7.equals("TFA is not yet secured to run all commands")) continue;
                }
                bufferedReader.close();
                if (!sSLSocket.isClosed()) {
                    sSLSocket.close();
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Unknown Host : " + string, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Unable to communicate with Host : " + string, 1);
            Output.print("IOException in getRemoteTFAVersion");
        }
        Output.printTrace("getRemoteTFAVersion : TFA Version : " + string5, 3);
        return string5;
    }

    static {
        printStream = null;
        samplingEnabled = true;
        darwinFile = false;
        isSupportMode = false;
        publicIp = null;
        tfaClusterMode = null;
        trustStorePass = "lifeislife";
        keyStorePass = "lifeislife";
        trustStorePassword = trustStorePass;
        serverTrustStorePassword = trustStorePass;
        clientKeyStorePassword = keyStorePass;
        serverKeyStorePassword = keyStorePass;
        autoPatchingEnabled = true;
        keystoresUpdated = false;
        nodeType = "TYPICAL";
        installType = "TYPICAL";
        adeUser = null;
        timezone = null;
        perlexe = "perl";
        TFARunMode = "Collector";
        jdbcConUrl = "";
        dbPasscode = "";
        sslSwitch = 0;
        userCert = 0;
        TFAARGSEP = ":(?!\\\\)";
    }
}

