/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.util.LogFile;
import oracle.rat.tfa.util.Properties;

public class Output {
    private static Boolean tracingOn = true;

    public static void print(String string) {
        if (tracingOn.booleanValue()) {
            if (Global.offlineMode.booleanValue()) {
                string = "[" + Thread.currentThread().getName() + "] " + string;
                LogFile.writeLog("[OFFLINE] " + string);
            } else {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                String string2 = Properties.timezone;
                if (string2 != null) {
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string2));
                }
                Date date = new Date();
                System.out.println(simpleDateFormat.format(date) + "  [" + Thread.currentThread().getName() + "-" + Thread.currentThread().getId() + "] " + string);
            }
        }
    }

    public static void printTrace(String string, Integer n) {
        if (Global.tracingOn.booleanValue() && Global.traceLevel >= n) {
            string = Thread.currentThread().getName() + "] " + string;
            if (n == 1) {
                LogFile.writeLog("[ERROR] [" + string);
            }
            if (n == 2) {
                LogFile.writeLog("[WARNING] [" + string);
            }
            if (n == 3) {
                LogFile.writeLog("[MESSAGE] [" + string);
            }
            if (n == 4) {
                LogFile.writeLog("[MESSAGE] [" + string);
            }
        }
    }

    public static void printTrace(String string, String string2, Integer n) {
        if (Global.tracingOn.booleanValue()) {
            if (n == 1) {
                LogFile.writeLog("[ERROR] [" + Thread.currentThread().getName() + "] " + string);
            } else if (string2.equalsIgnoreCase("INVENTORY") && Global.getInventorytraceLevel() >= n || string2.equalsIgnoreCase("COLLECT") && Global.getCollectiontraceLevel() >= n || string2.equalsIgnoreCase("SCAN") && Global.getScantraceLevel() >= n || string2.equalsIgnoreCase("OTHER") && Global.getOthertraceLevel() >= n) {
                string = Thread.currentThread().getName() + "] " + string;
                if (n == 2) {
                    LogFile.writeLog("[WARNING] [" + string);
                } else {
                    LogFile.writeLog("[MESSAGE] [" + string);
                }
            }
        }
    }
}

