/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class ManageTfa {
    private String oraclehome;
    private String tfaconf;
    private String tfapatch;
    private String tfahome;
    private String buildversion;
    private String builddate;

    public ManageTfa(String string) {
        this.oraclehome = string;
        this.tfaconf = string + "/install/.tfa.configured";
        this.tfapatch = string + "/install/.tfa.patched";
        this.LoadProps();
    }

    public boolean isTFAConfigured() {
        File file = new File(this.tfaconf);
        return file.exists();
    }

    public boolean isTFAPatched() {
        File file = new File(this.tfapatch);
        return file.exists();
    }

    public String getTFAHome() {
        return this.tfahome;
    }

    public String getBuildVersion() {
        return this.buildversion;
    }

    public String getBuildDate() {
        return this.builddate;
    }

    public void LoadProps() {
        try {
            FileInputStream fileInputStream;
            Properties properties = new Properties();
            if (this.isTFAConfigured()) {
                fileInputStream = new FileInputStream(this.tfaconf);
            } else if (this.isTFAPatched()) {
                fileInputStream = new FileInputStream(this.tfapatch);
            } else {
                return;
            }
            properties.load(fileInputStream);
            this.tfahome = properties.getProperty("TFA_HOME");
            this.buildversion = properties.getProperty("BUILD_VERSION");
            this.builddate = properties.getProperty("BUILD_DATE");
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getTFADeinstallCommand() {
        return this.tfahome + "/bin/tfactl uninstall";
    }

    public static void main(String[] stringArray) {
        ManageTfa manageTfa = new ManageTfa(stringArray[0].trim());
        if (manageTfa.isTFAConfigured()) {
            System.out.println("TFA is configured");
        }
        if (manageTfa.isTFAPatched()) {
            System.out.println("TFA is Patched");
        }
        System.out.println("TFA Home is " + manageTfa.getTFAHome());
        System.out.println("Build Version is " + manageTfa.getBuildVersion());
        System.out.println("Build Date is " + manageTfa.getBuildDate());
        System.out.println("deinstall command is " + manageTfa.getTFADeinstallCommand());
    }
}

