/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Grepper {
    private static Charset charset = Charset.forName("ISO-8859-15");
    private static CharsetDecoder decoder = charset.newDecoder();
    private static Pattern linePattern = Pattern.compile(".*\r?\n");
    private static Pattern pattern;

    private static void compile(String string) {
        try {
            pattern = Pattern.compile(string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            System.err.println(patternSyntaxException.getMessage());
            System.exit(1);
        }
    }

    private static boolean grep(File file, CharBuffer charBuffer) {
        Matcher matcher = linePattern.matcher(charBuffer);
        Matcher matcher2 = null;
        int n = 0;
        while (matcher.find()) {
            ++n;
            String string = matcher.group();
            if (matcher2 == null) {
                matcher2 = pattern.matcher(string);
            } else {
                matcher2.reset(string);
            }
            if (!matcher2.find()) continue;
            System.out.print(file + ":" + n + ":" + string);
            return true;
        }
        return false;
    }

    private static boolean grep(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        int n = (int)fileChannel.size();
        int n2 = n < 1000000 ? n : 1000000;
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, n2);
        CharBuffer charBuffer = decoder.decode(mappedByteBuffer);
        boolean bl = Grepper.grep(file, charBuffer);
        fileChannel.close();
        return bl;
    }

    public static boolean grepFile(File file, String string) {
        boolean bl = false;
        Grepper.compile(string);
        try {
            bl = Grepper.grep(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        Grepper.compile("foo.*.txt");
        File file = new File("C:\\temp\\real1.txt");
        try {
            Grepper.grep(file);
        }
        catch (IOException iOException) {
            System.err.println(file + ": " + iOException);
        }
    }
}

