/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.util;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.db.DataAccessor.ComponentFilePatternDA;
import oracle.rat.tfa.db.DataAccessor.TFADirectoryDA;
import oracle.rat.tfa.db.DbGet;
import oracle.rat.tfa.entity.ComponentEntity;
import oracle.rat.tfa.entity.ComponentFilePattern;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.TFADirectory;
import oracle.rat.tfa.entity.entitykey.ComponentFilePatternKey;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.singletons.IgnoreExtensions;
import oracle.rat.tfa.singletons.IgnoreFilesList;
import oracle.rat.tfa.util.FileHelper;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FileList {
    public static long fileCount = 0L;
    public static long totalFileSize = 0L;
    public static long coreCollectionSize;

    public static File[] listFilesAsArray(File file, FilenameFilter filenameFilter, boolean bl, boolean bl2) {
        Collection<File> collection = FileList.listFiles(file, filenameFilter, bl);
        File[] fileArray = new File[collection.size()];
        return collection.toArray(fileArray);
    }

    private static boolean isFileWorthKeeping(File file, IgnoreExtensions ignoreExtensions) {
        try {
            if (Properties.darwinFile) {
                Output.printTrace("Will process - Raccheck file - " + file.getAbsolutePath(), 3);
                return true;
            }
            if (file.isDirectory()) {
                Output.printTrace("Skipped - Directory - " + file.getAbsolutePath(), 3);
                return false;
            }
            if (ignoreExtensions.ignoreThisFile(file.getName())) {
                Output.printTrace("Skipped - Ignore List - " + file.getAbsolutePath(), 3);
                return false;
            }
            if (!file.canRead()) {
                Output.printTrace("Skipped - Not readable - " + file.getAbsolutePath(), 3);
                return false;
            }
            if (file.getName().endsWith("filelist")) {
                Output.printTrace("Skipped - filelist - " + file.getAbsolutePath(), 3);
                return false;
            }
            if (file.getName().contains("rat_timings")) {
                Output.printTrace("Skipped - rat_timings file - " + file.getAbsolutePath(), 3);
                return false;
            }
            if (!(file.getName().endsWith(".trc") || file.getName().endsWith(".log") || file.getName().endsWith(".trm") || file.getName().endsWith(".trw") || FileHelper.isAsciiText(file.getAbsolutePath()))) {
                Output.printTrace("Skipped - NOT ASCII - " + file.getAbsolutePath(), 3);
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    private static void collectCoreStack(FileEntity fileEntity, LinkedBlockingQueue linkedBlockingQueue) {
        File file = new File(File.separator + "usr" + File.separator + "bin" + File.separator + "gdb");
        if (file.exists()) {
            String string = Properties.crsHome + File.separator + "bin" + File.separator + "oracle";
            String string2 = Properties.resourcesDir + File.separator + "gdb_commands";
            String string3 = fileEntity.getFileName().substring(0, fileEntity.getFileName().lastIndexOf(File.separator));
            String string4 = fileEntity.getFileName().substring(fileEntity.getFileName().lastIndexOf(File.separator) + 1);
            string4 = string4.replace(".", "_") + "_stack";
            String string5 = string3 + File.separator + string4;
            File file2 = new File(string5);
            Output.printTrace("CollectCoreStack Core File : " + fileEntity.getFileName(), 3);
            Output.printTrace("CollectCoreStack Stack File : " + string5, 3);
            if (file2.exists()) {
                Output.printTrace("CollectCoreStack Core File " + string5 + " already exists", 3);
                linkedBlockingQueue.add(new FileEntity(file2));
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(file.toString());
            arrayList.add("-e");
            arrayList.add(string);
            arrayList.add("-c");
            arrayList.add(fileEntity.getFileName());
            arrayList.add("-batch");
            arrayList.add("-x");
            arrayList.add(string2);
            Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
            Process process = null;
            try {
                Output.printTrace("CollectCoreStack Extracting Stack from Core File", 3);
                Output.printTrace("CollectCoreStack Command to execute : " + Arrays.toString(objectArray), 3);
                process = Runtime.getRuntime().exec((String[])objectArray);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string5));
                String string6 = null;
                while ((string6 = bufferedReader.readLine()) != null) {
                    bufferedWriter.write(string6 + "\n");
                }
                bufferedReader.close();
                bufferedWriter.close();
                int n = process.waitFor();
                Output.printTrace("CollectCoreStack Command Exit Value : " + n, 3);
                if (n > 1) {
                    Output.print("CollectCoreStack Command : " + arrayList + " FAILED with Exit Code : " + n);
                }
                if (file2.exists()) {
                    linkedBlockingQueue.add(new FileEntity(file2));
                }
            }
            catch (IOException iOException) {
                Output.printTrace("IOException in executing CollectCoreStack", 1);
                iOException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                Output.printTrace("InterruptedException in executing CollectCoreStack", 3);
                interruptedException.printStackTrace();
            }
        }
    }

    private static void collectCoreFile(FileEntity fileEntity, boolean bl, long l, long l2, LinkedBlockingQueue linkedBlockingQueue) {
        try {
            if (!bl && fileEntity.getFileSize() <= l && fileEntity.getFileSize() + coreCollectionSize <= l2) {
                Output.printTrace("Adding Core File: " + fileEntity.getShortName(), 3);
                coreCollectionSize += fileEntity.getFileSize().longValue();
                linkedBlockingQueue.put(fileEntity);
                FileList.collectCoreStack(fileEntity, linkedBlockingQueue);
            } else {
                Output.printTrace("Ignoring Core File : " + fileEntity.getShortName(), 3);
                Output.printTrace("Core File Size : " + fileEntity.getFileSize(), 3);
                Output.printTrace("Max Core File Size : " + l, 3);
                Output.printTrace("Core Collection Size : " + coreCollectionSize, 3);
                Output.printTrace("Max Core Collection Size : " + l2, 3);
            }
        }
        catch (Exception exception) {
            Output.print("Exception in collectCoreFiles: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private static boolean isFileChanged(File file, FileEntity fileEntity) {
        Date date;
        Date date2 = new Date(file.lastModified());
        int n = date2.compareTo(date = fileEntity.getLastModified());
        if (n > 0) {
            Output.printTrace("CHANGED FILE -- " + file.getAbsolutePath(), 3);
            return true;
        }
        Output.printTrace("UNCHANGED FILE -- " + file.getAbsolutePath(), 3);
        return false;
    }

    public static boolean isFileWorthProcessing(File file, FileEntity fileEntity) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Output.printTrace("EVALUATING ENTRY: " + file.getAbsolutePath(), 3);
        if (fileEntity != null) {
            bl2 = FileList.isFileChanged(file, fileEntity);
            if (bl2) {
                bl4 = true;
            }
        } else {
            if (Properties.darwinFile) {
                Output.printTrace("Keeping Raccheck file -- " + file.getAbsolutePath(), 3);
                bl3 = true;
            } else if (Global.offlineMode.booleanValue()) {
                bl3 = true;
            } else {
                Calendar calendar = Calendar.getInstance();
                calendar.add(6, -30);
                long l = calendar.getTime().getTime();
                if (file.lastModified() >= l) {
                    bl3 = true;
                }
            }
            if (bl3) {
                bl4 = true;
            }
        }
        if (bl4) {
            bl = true;
            Output.printTrace("NEW FILE Added -- " + file.getAbsolutePath(), 3);
        } else {
            Output.printTrace("FILE NOT Added -- " + file.getAbsolutePath(), 3);
        }
        Output.printTrace("fileChanged: " + bl2 + " worthKeeping: " + bl3 + " finalAnswer: " + bl4, 3);
        return bl;
    }

    public static Collection<File> listFilesInDirectory(File file, FilenameFilter filenameFilter, boolean bl) {
        Vector<File> vector = new Vector<File>();
        File[] fileArray = file.listFiles();
        boolean bl2 = false;
        boolean bl3 = false;
        if (fileArray != null) {
            for (File file2 : fileArray) {
                bl2 = false;
                bl3 = false;
                if (Properties.darwinFile) {
                    Output.printTrace("Keeping Raccheck file -- " + file2.getAbsolutePath(), 3);
                    bl2 = true;
                } else {
                    Properties.getInstance();
                    if (Properties.samplingEnabled) {
                        bl2 = true;
                    }
                }
                if (bl2) {
                    bl3 = true;
                }
                if (bl3) {
                    vector.add(file2);
                    Output.printTrace("NEW FILE Added -- " + file2.getAbsolutePath(), 3);
                } else {
                    Output.printTrace("FILE NOT Added -- " + file2.getAbsolutePath(), 3);
                }
                if (!bl || !file2.isDirectory()) continue;
                vector.addAll(FileList.listFilesInDirectory(file2, filenameFilter, bl));
            }
        }
        return vector;
    }

    public static Collection<File> listFiles(File file, FilenameFilter filenameFilter, boolean bl) {
        Vector<File> vector = new Vector<File>();
        File[] fileArray = file.listFiles();
        IgnoreExtensions ignoreExtensions = IgnoreExtensions.getInstance();
        IgnoreFilesList ignoreFilesList = IgnoreFilesList.getInstance();
        DbGet dbGet = new DbGet();
        FileEntity fileEntity = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(Properties.filesIgnoredDuringInventory, true));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isHidden() || file2.length() == 0L) continue;
                bl2 = false;
                bl3 = false;
                bl4 = false;
                bl5 = false;
                Output.printTrace("EVALUATING ENTRY: " + file2.getAbsolutePath(), 3);
                if (ignoreFilesList.ignoreThisFile(file2.getAbsolutePath())) {
                    try {
                        if (bufferedWriter == null) continue;
                        bufferedWriter.write(file2.getAbsolutePath() + "\n");
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    continue;
                }
                fileEntity = dbGet.lookupFile(file2.getAbsolutePath());
                if (fileEntity != null) {
                    bl4 = true;
                }
                if (bl4) {
                    bl2 = FileList.isFileChanged(file2, fileEntity);
                    if (bl2) {
                        bl5 = true;
                    }
                } else {
                    if (Properties.darwinFile) {
                        Output.printTrace("Keeping Raccheck file -- " + file2.getAbsolutePath(), 3);
                        bl3 = true;
                    } else {
                        Properties.getInstance();
                        if (Properties.samplingEnabled) {
                            bl3 = FileList.isFileWorthKeeping(file2, ignoreExtensions);
                        }
                    }
                    if (bl3) {
                        bl5 = true;
                    }
                }
                if (bl5) {
                    vector.add(file2);
                    Output.printTrace("NEW FILE Added -- " + file2.getAbsolutePath(), 3);
                } else {
                    Output.printTrace("FILE NOT Added -- " + file2.getAbsolutePath(), 3);
                }
                Output.printTrace("fileChanged: " + bl2 + " worthKeeping: " + bl3 + " finalAnswer: " + bl5, 3);
                if (!bl || !file2.isDirectory()) continue;
                vector.addAll(FileList.listFiles(file2, filenameFilter, bl));
            }
        }
        if (bufferedWriter != null) {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return vector;
    }

    public static boolean checkInDocumentFilter(Document document, FileEntity fileEntity) {
        Object object;
        Object object2;
        Output.printTrace("In checkInDocumentFilter  : ", 3);
        if (document == null) {
            return true;
        }
        document.getDocumentElement().normalize();
        Output.printTrace("Checking file_types  : ", 3);
        NodeList nodeList = document.getElementsByTagName("filter_file_type");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            Output.printTrace("Checking file_type  : " + fileEntity.getType() + " == " + element.getTextContent(), 3);
            if (!fileEntity.getType().equalsIgnoreCase(element.getTextContent())) continue;
            return true;
        }
        NodeList nodeList2 = document.getElementsByTagName("filter_file_exclude_pattern");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Element element = (Element)nodeList2.item(i);
            Output.printTrace("Checking exclude pattern  : " + element.getTextContent() + " == " + fileEntity.getFileName(), 3);
            object2 = Pattern.compile(element.getTextContent(), 2);
            object = ((Pattern)object2).matcher(fileEntity.getFileName());
            if (!((Matcher)object).find()) continue;
            return false;
        }
        NodeList nodeList3 = document.getElementsByTagName("filter_file_pattern");
        for (int i = 0; i < nodeList3.getLength(); ++i) {
            object2 = (Element)nodeList3.item(i);
            Output.printTrace("Checking pattern  : " + object2.getTextContent() + " == " + fileEntity.getFileName(), 3);
            object = Pattern.compile(object2.getTextContent(), 2);
            Matcher matcher = ((Pattern)object).matcher(fileEntity.getFileName());
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    public static void getFilesForDates(LinkedBlockingQueue linkedBlockingQueue, Date date, Date date2, Map<String, List<String>> map, boolean bl, String string, boolean bl2, File file, boolean bl3, List<ComponentEntity> list, Document document) {
        String string2 = "COLLECT";
        Calendar calendar = Calendar.getInstance();
        String string3 = file.getAbsolutePath() + File.separator + "checkFileListAccess" + calendar.getTimeInMillis();
        LinkedBlockingQueue<String> linkedBlockingQueue2 = null;
        Thread thread = null;
        coreCollectionSize = 0L;
        long l = Global.getMaxCoreFileSize() * 1024 * 1024;
        long l2 = Global.getMaxCoreCollectionSize() * 1024 * 1024;
        Output.printTrace("maxCoreFileSize in FileList : " + l, 3);
        Output.printTrace("maxCoreCollectionSize in FileList : " + l2, 3);
        Output.printTrace("About to try in getFilesForDates", string2, 3);
        EntityCursor entityCursor = null;
        Transaction transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
        try {
            EntityStore entityStore;
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(FileEntity.class);
            SecondaryIndex secondaryIndex = DbManager.getInstance().getEntityStore().getSecondaryIndex(primaryIndex, String.class, "component");
            if (map != null) {
                List<String> list2;
                Object object;
                Object object2;
                Object object3;
                boolean bl4;
                String string4;
                entityStore = DbManager.getInstance().getEntityStore();
                TFADirectoryDA tFADirectoryDA = new TFADirectoryDA(entityStore);
                if (l <= 0L || l2 <= 0L) {
                    bl3 = true;
                }
                if (!string.equalsIgnoreCase("root")) {
                    linkedBlockingQueue2 = new LinkedBlockingQueue<String>(20000);
                    thread = new Thread((Runnable)new CheckAccess(linkedBlockingQueue2, string, string3, linkedBlockingQueue), "CheckAccess");
                    thread.start();
                    Output.printTrace("Started CheckAccessThread", string2, 4);
                } else {
                    Output.printTrace("root user does not need check access", 4);
                }
                for (String object4 : map.keySet()) {
                    Object object5 = map.get(object4);
                    string4 = secondaryIndex.subIndex((Object)object4.toUpperCase());
                    entityCursor = string4.entities(transaction, cursorConfig);
                    Output.printTrace("About to loop through files of comp:" + object4.toUpperCase(), string2, 4);
                    for (FileEntity fileEntity : entityCursor) {
                        try {
                            TFADirectory exception;
                            if (Thread.currentThread().isInterrupted()) {
                                Output.printTrace("IndentifyFilesToCollect Thread interrupted while iterating files.", 1);
                                break;
                            }
                            if (bl && (exception = (TFADirectory)tFADirectoryDA.pIdx.get((Object)fileEntity.getBaseDirectory())) != null && exception.isCollectAll()) continue;
                            Output.printTrace("Considering file : " + fileEntity.getFileName(), string2, 4);
                            boolean bl10 = false;
                            bl4 = false;
                            boolean bl5 = FileList.checkInDocumentFilter(document, fileEntity);
                            if (fileEntity.isSymbolicLink()) {
                                Output.printTrace("Found Symbolic Link File : " + fileEntity.getFileName(), 4);
                                if (!string.equals("root")) {
                                    bl10 = true;
                                }
                            }
                            if (!string.equalsIgnoreCase("root")) {
                                object3 = (TFADirectory)tFADirectoryDA.pIdx.get((Object)fileEntity.getBaseDirectory());
                                Output.printTrace("Permission for directory " + ((TFADirectory)object3).getDirectoryPath() + " is : " + ((TFADirectory)object3).getPermission(), string2, 4);
                                Output.printTrace("Owner is : " + ((TFADirectory)object3).owner, 3);
                                if (object3 != null && ((TFADirectory)object3).getPermission().equals("private")) {
                                    Output.printTrace("Found private file: " + fileEntity, string2, 3);
                                    bl10 = true;
                                }
                            }
                            if (fileEntity.doesFileContainDates(date, date2)) {
                                bl4 = fileEntity.getIsCore();
                                if (object4.equalsIgnoreCase("RDBMS")) {
                                    object3 = fileEntity.getDatabase();
                                    String string5 = fileEntity.getInstance();
                                    if (object5 == null) {
                                        if (bl10) {
                                            if (!bl5) continue;
                                            linkedBlockingQueue2.put(fileEntity.getFileName());
                                            continue;
                                        }
                                        if (bl4) {
                                            FileList.collectCoreFile(fileEntity, bl3, l, l2, linkedBlockingQueue);
                                            continue;
                                        }
                                        Output.printTrace("Adding File: " + fileEntity.getShortName(), string2, 3);
                                        if (!bl5) continue;
                                        linkedBlockingQueue.put(fileEntity);
                                        continue;
                                    }
                                    boolean bl6 = false;
                                    if (object5.contains(((String)object3).toLowerCase()) || object5.contains(((String)object3).toUpperCase())) {
                                        bl6 = true;
                                    } else {
                                        object2 = object5.iterator();
                                        while (object2.hasNext()) {
                                            String[] stringArray;
                                            object = (String)object2.next();
                                            if (!((String)object).contains("~") || (stringArray = ((String)object).split("~")) == null || stringArray.length <= 0) continue;
                                            list2 = stringArray[0];
                                            for (int i = 1; i < stringArray.length; ++i) {
                                                String string6 = stringArray[i];
                                                Output.printTrace("compDb: " + (String)((Object)list2) + " compInst: " + string6, string2, 4);
                                                Output.printTrace("database: " + (String)object3 + " instance: " + (String)string5, string2, 4);
                                                if (!((String)((Object)list2)).equalsIgnoreCase((String)object3) || !string6.equalsIgnoreCase(string5)) continue;
                                                bl6 = true;
                                                Output.printTrace("compValue: " + (String)object + " toCollect: " + bl6, string2, 4);
                                            }
                                        }
                                    }
                                    if (!bl6) continue;
                                    if (bl10) {
                                        if (!bl5) continue;
                                        linkedBlockingQueue2.put(fileEntity.getFileName());
                                        continue;
                                    }
                                    if (bl4) {
                                        FileList.collectCoreFile(fileEntity, bl3, l, l2, linkedBlockingQueue);
                                        continue;
                                    }
                                    Output.printTrace("Adding File: " + fileEntity.getFileName(), string2, 4);
                                    if (!bl5) continue;
                                    linkedBlockingQueue.put(fileEntity);
                                    continue;
                                }
                                if (object4.equalsIgnoreCase("ASM")) {
                                    object3 = fileEntity.getInstance();
                                    if (object5 == null) {
                                        if (bl10) {
                                            if (!bl5) continue;
                                            linkedBlockingQueue2.put(fileEntity.getFileName());
                                            continue;
                                        }
                                        if (bl4) {
                                            FileList.collectCoreFile(fileEntity, bl3, l, l2, linkedBlockingQueue);
                                            continue;
                                        }
                                        Output.printTrace("Adding File: " + fileEntity.getShortName(), string2, 4);
                                        if (!bl5) continue;
                                        linkedBlockingQueue.put(fileEntity);
                                        continue;
                                    }
                                    if (!object5.contains(((String)object3).toLowerCase()) && !object5.contains(((String)object3).toUpperCase())) continue;
                                    if (bl10) {
                                        if (!bl5) continue;
                                        linkedBlockingQueue2.put(fileEntity.getFileName());
                                        continue;
                                    }
                                    if (bl4) {
                                        FileList.collectCoreFile(fileEntity, bl3, l, l2, linkedBlockingQueue);
                                        continue;
                                    }
                                    Output.printTrace("Adding File: " + fileEntity.getShortName(), string2, 4);
                                    if (!bl5) continue;
                                    linkedBlockingQueue.put(fileEntity);
                                    continue;
                                }
                                if (bl10) {
                                    if (!bl5) continue;
                                    linkedBlockingQueue2.put(fileEntity.getFileName());
                                    continue;
                                }
                                if (bl4) {
                                    FileList.collectCoreFile(fileEntity, bl3, l, l2, linkedBlockingQueue);
                                    continue;
                                }
                                Output.printTrace("Adding File: " + fileEntity.getShortName(), string2, 4);
                                if (!bl5) continue;
                                linkedBlockingQueue.put(fileEntity);
                                continue;
                            }
                            if (fileEntity.getType() == null) continue;
                            if (object4.equalsIgnoreCase("RDBMS")) {
                                if (object5 == null && fileEntity.getType().equalsIgnoreCase("Alert Log - DB")) {
                                    Output.printTrace("Adding DB alert log even though it does not contain date range " + date + " to " + date2, 3);
                                    if (linkedBlockingQueue.size() > 0) {
                                        if (bl10) {
                                            if (bl5) {
                                                linkedBlockingQueue2.put(fileEntity.getFileName());
                                            }
                                        } else {
                                            Output.printTrace("Adding File: " + fileEntity.getShortName(), 3);
                                            if (bl5) {
                                                linkedBlockingQueue.put(fileEntity);
                                            }
                                        }
                                    }
                                } else if (object5 != null && object5.contains(fileEntity.getDatabase()) && fileEntity.getType().equalsIgnoreCase("Alert Log - DB")) {
                                    Output.printTrace("Adding DB alert log even though it does not contain date range " + date + " to " + date2, 3);
                                    if (linkedBlockingQueue.size() > 0) {
                                        if (bl10) {
                                            if (bl5) {
                                                linkedBlockingQueue2.put(fileEntity.getFileName());
                                            }
                                        } else {
                                            Output.printTrace("Adding File: " + fileEntity.getShortName(), 3);
                                            if (bl5) {
                                                linkedBlockingQueue.put(fileEntity);
                                            }
                                        }
                                    }
                                }
                            }
                            if (!object4.equalsIgnoreCase("asm") || !fileEntity.getType().equalsIgnoreCase("Alert Log - ASM")) continue;
                            Output.printTrace("Adding ASM alert log even though it does not contain date range " + date + " to " + date2, 3);
                            if (linkedBlockingQueue.size() <= 0) continue;
                            if (bl10) {
                                if (!bl5) continue;
                                linkedBlockingQueue2.put(fileEntity.getFileName());
                                continue;
                            }
                            Output.printTrace("Adding File: " + fileEntity.getShortName(), 3);
                            if (!bl5) continue;
                            linkedBlockingQueue.put(fileEntity);
                        }
                        catch (InterruptedException interruptedException) {
                            Output.print("InterruptedException in getFilesForDates: ");
                            throw interruptedException;
                        }
                        catch (Exception exception) {
                            Output.print("Exception in getFilesForDates: " + exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                    entityCursor.close();
                    entityCursor = null;
                }
                Object object6 = secondaryIndex.subIndex((Object)"NULL");
                entityCursor = object6.entities(transaction, cursorConfig);
                for (Object object5 : entityCursor) {
                    string4 = ((FileEntity)object5).getFileName().trim();
                    boolean bl7 = false;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    bl4 = FileList.checkInDocumentFilter(document, (FileEntity)object5);
                    try {
                        String string7;
                        if (((FileEntity)object5).isSymbolicLink()) {
                            Output.printTrace("Found Symbolic Link File : " + ((FileEntity)object5).getFileName(), 3);
                            if (!string.equals("root")) {
                                bl7 = true;
                            }
                        }
                        if ((string7 = ((FileEntity)object5).getBaseDirectory()) == null || (object3 = (TFADirectory)tFADirectoryDA.pIdx.get((Object)string7)) == null) continue;
                        if (list != null && list.size() > 0) {
                            for (ComponentEntity componentEntity : list) {
                                block89: {
                                    if (((TFADirectory)object3).getComponents() == null || !((TFADirectory)object3).getComponents().contains(componentEntity.getComponent())) continue;
                                    try {
                                        object2 = new ComponentFilePatternDA();
                                        object = new ComponentFilePatternKey(componentEntity.getComponent(), string7);
                                        ComponentFilePattern componentFilePattern = (ComponentFilePattern)((ComponentFilePatternDA)object2).pIdx.get(object);
                                        if (componentFilePattern != null) {
                                            list2 = componentFilePattern.getFilePatterns();
                                            if (list2 != null && list2.size() > 0) {
                                                Pattern[] patternArray = new Pattern[list2.size()];
                                                int n = 2;
                                                int n2 = 0;
                                                for (String string8 : list2) {
                                                    patternArray[n2++] = Pattern.compile(string8, n);
                                                }
                                                for (Pattern pattern : patternArray) {
                                                    if (!pattern.matcher(string4).matches()) continue;
                                                    bl8 = true;
                                                    break block89;
                                                }
                                                break block89;
                                            }
                                            bl8 = true;
                                            break block89;
                                        }
                                        bl8 = true;
                                    }
                                    catch (DatabaseException databaseException) {
                                        databaseException.printStackTrace();
                                    }
                                }
                                if (bl8 && bl4) {
                                    object2 = ((TFADirectory)object3).getSubComponentByComponent(componentEntity.getComponent());
                                    object = componentEntity.getSubComponents();
                                    if (object2 != null && object2.size() > 0) {
                                        boolean bl10 = false;
                                        for (Map.Entry entry : object2.entrySet()) {
                                            String string9 = (String)entry.getKey();
                                            String string10 = (String)entry.getValue();
                                            if (object.containsKey(string9)) {
                                                bl10 = true;
                                                if (((String)object.get(string9)).equalsIgnoreCase(string10)) {
                                                    bl9 = true;
                                                    continue;
                                                }
                                                bl9 = false;
                                                break;
                                            }
                                            bl9 = true;
                                        }
                                        if (!bl10) {
                                            bl9 = false;
                                        }
                                        if (!bl9) continue;
                                        Output.print("Collecting file " + ((FileEntity)object5).getFileName() + " for " + componentEntity.getComponent() + " " + componentEntity.getSubComponents());
                                        break;
                                    }
                                    bl9 = true;
                                    break;
                                }
                                bl9 = false;
                            }
                            if (bl9) {
                                if (!string.equalsIgnoreCase("root")) {
                                    Output.printTrace("Permission for directory " + ((TFADirectory)object3).getDirectoryPath() + " is : " + ((TFADirectory)object3).getPermission(), 3);
                                    Output.printTrace("Owner is : " + ((TFADirectory)object3).owner, 3);
                                    if (object3 != null && ((TFADirectory)object3).getPermission().equals("private")) {
                                        Output.printTrace("Found private file: " + object5, 3);
                                        bl7 = true;
                                    }
                                }
                                if (((FileEntity)object5).doesFileContainDates(date, date2) || ((TFADirectory)object3).isCollectAll()) {
                                    if (bl7) {
                                        if (!bl4) continue;
                                        linkedBlockingQueue2.put(((FileEntity)object5).getFileName());
                                        continue;
                                    }
                                    Output.printTrace("Adding File: " + ((FileEntity)object5).getShortName(), 3);
                                    if (!bl4) continue;
                                    linkedBlockingQueue.put(object5);
                                    continue;
                                }
                            }
                        }
                        if (map == null || map.size() <= 0 || ((TFADirectory)object3).getComponents() == null) continue;
                        for (String string11 : ((TFADirectory)object3).getComponents()) {
                            if (!map.containsKey(string11.toLowerCase())) continue;
                            if (string11.equalsIgnoreCase("RDBMS")) {
                                object2 = map.get(string11.toLowerCase());
                                object = ((FileEntity)object5).getDatabase();
                                if (null != object && null != object2 && !object2.contains(((String)object).toLowerCase()) && !object2.contains(((String)object).toUpperCase())) continue;
                            }
                            if (!string.equalsIgnoreCase("root")) {
                                Output.printTrace("Permission for directory " + ((TFADirectory)object3).getDirectoryPath() + " is : " + ((TFADirectory)object3).getPermission(), 3);
                                Output.printTrace("Owner is : " + ((TFADirectory)object3).owner, 3);
                                if (object3 != null && ((TFADirectory)object3).getPermission().equals("private")) {
                                    Output.printTrace("Found private file: " + object5, 3);
                                    bl7 = true;
                                }
                            }
                            if (!((FileEntity)object5).doesFileContainDates(date, date2)) continue;
                            if (bl7) {
                                if (!bl4) continue;
                                linkedBlockingQueue2.put(((FileEntity)object5).getFileName());
                                continue;
                            }
                            Output.printTrace("Adding File: " + ((FileEntity)object5).getShortName(), 3);
                            if (!bl4) continue;
                            linkedBlockingQueue.put(object5);
                        }
                    }
                    catch (DatabaseException databaseException) {
                        Output.print("DatabaseException in getFilesForDatesfor files with no filetypes " + databaseException.getMessage());
                    }
                }
                entityCursor.close();
                entityCursor = null;
            }
            if (!bl2) {
                entityStore = DbManager.getInstance().getAllEntities(FileEntity.class);
                entityCursor = entityStore.entities(transaction, cursorConfig);
                block22: for (Object object6 : entityCursor) {
                    String string12 = ((FileEntity)object6).getAlsoCollectFor();
                    if (string12 == null || !((FileEntity)object6).doesFileContainDates(date, date2)) continue;
                    for (String string4 : map.keySet()) {
                        if (!string12.contains(string4.toUpperCase()) || ((FileEntity)object6).getComponent().equalsIgnoreCase(string4)) continue;
                        linkedBlockingQueue.put(object6);
                        continue block22;
                    }
                }
                entityCursor.close();
                entityCursor = null;
            }
            transaction.commit();
            transaction = null;
        }
        catch (DatabaseException databaseException) {
            Output.print("DatabaseException in getFilesForDates: " + databaseException.getMessage());
            databaseException.printStackTrace();
            if (transaction != null) {
                transaction.abort();
                transaction = null;
            }
            if (entityCursor != null) {
                entityCursor.close();
                entityCursor = null;
            }
        }
        catch (InterruptedException interruptedException) {
            Output.printTrace("IdentifyFilesToCollect Interrupted", 1);
        }
        if (!string.equalsIgnoreCase("root") && thread != null) {
            Output.printTrace("Adding ALLDONE to checkaccessfiles List", 3);
            linkedBlockingQueue2.add("ALLDONE");
            while (thread.isAlive()) {
                Output.printTrace("Sleeping waiting for CheckAccess to complete", 3);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    thread.interrupt();
                    Output.printTrace("getFilesForDates interrupted whilst waiting for CheckAccessThread", 3);
                    Output.print("getFilesForDates interrupted whilst waiting for CheckAccessThread");
                }
            }
            Output.printTrace("CheckAccess Complete Will Now Continue", 3);
        }
        Output.printTrace("Completed getFilesForDates", 3);
    }

    public static int getFileCount() {
        int n = 0;
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(FileEntity.class);
        EntityCursor entityCursor = primaryIndex.entities();
        for (FileEntity fileEntity : entityCursor) {
            ++n;
        }
        entityCursor.close();
        return n;
    }

    public static Long getTotalFileSize() {
        long l = 0L;
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(FileEntity.class);
        EntityCursor entityCursor = primaryIndex.entities();
        for (FileEntity fileEntity : entityCursor) {
            l += fileEntity.getFileSize().longValue();
        }
        entityCursor.close();
        return l;
    }

    public static int countLines(String string) throws IOException {
        int n = 0;
        Output.printTrace("Counting lines in file : " + string, 3);
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(string));
        int n2 = 0;
        String string2 = "";
        try {
            while ((string2 = lineNumberReader.readLine()) != null && ++n != 1000) {
            }
        }
        catch (Error error) {
            Output.print("Error occurred while counting lines for : " + string);
            lineNumberReader.close();
            return -1;
        }
        n2 = lineNumberReader.getLineNumber();
        lineNumberReader.close();
        return n2;
    }

    public static void executeReadAccessScript(File file, String string) {
        try {
            Process process = null;
            StringBuilder stringBuilder = new StringBuilder();
            Properties.getInstance();
            String string2 = stringBuilder.append(Properties.tfaHome).append(File.separator).append("bin").append(File.separator).append("tfactl").toString();
            Output.printTrace("checkfileaccess sript : " + string2, 3);
            process = Runtime.getRuntime().exec(new String[]{string2, "checkfileaccessusingsu", file.getAbsolutePath(), string});
            if (process != null) {
                String string3;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string3 = bufferedReader.readLine()) != null) {
                    Output.printTrace("checkfileaccess script --->>> " + string3, 4);
                }
                Output.printTrace("Out of while loop in checkfileaccess script ", 4);
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            Output.print("Exception in executeReadAccessScript: " + exception.getMessage());
        }
    }

    public static long countFilesInDirectory(String string) {
        String string2 = null;
        try {
            String string3 = "find " + string + " -type f | wc -l";
            Process process = Runtime.getRuntime().exec(string3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string2 = bufferedReader.readLine();
            if (string2 != null) {
                // empty if block
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Output.print("InventoryManager: Exception in countFilesInDirectory");
            exception.printStackTrace();
        }
        if (string2 != null) {
            return Long.parseLong(string2.trim());
        }
        return 0L;
    }

    public static File createFileList(String string, long l) {
        String string2 = Properties.internalDir + File.separator + "filelist";
        File file = new File(string2);
        if (file.exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            Process process;
            if (l == 0L) {
                String[] stringArray = new String[]{"/bin/sh", "-c", "find " + string + " -type f > " + string2};
                Output.printTrace("CreateFileList Command : " + stringArray, 3);
                process = Runtime.getRuntime().exec(stringArray);
            } else if (Properties.platform.equalsIgnoreCase("HP-UX")) {
                StringBuilder stringBuilder = new StringBuilder();
                Properties.getInstance();
                String string3 = stringBuilder.append(Properties.tfaHome).append(File.separator).append("bin").append(File.separator).append("tfactl").toString();
                String string4 = string3 + " generatefilelist " + string + " " + l;
                Output.printTrace("Generate FileList command: " + string4, 3);
                process = Runtime.getRuntime().exec(string4);
            } else {
                String string5 = "find " + string + " -type f -mmin -" + l + "  > " + string2;
                process = Runtime.getRuntime().exec(string5);
            }
            process.waitFor();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return file;
    }

    public static class CheckAccess
    extends Thread {
        private LinkedBlockingQueue<String> checkaccessfiles;
        private String requestUser;
        private String fileListName;
        private LinkedBlockingQueue<FileEntity> mainQueue;

        public CheckAccess(LinkedBlockingQueue<String> linkedBlockingQueue, String string, String string2, LinkedBlockingQueue<FileEntity> linkedBlockingQueue2) {
            this.checkaccessfiles = linkedBlockingQueue;
            this.requestUser = string;
            this.fileListName = string2;
            this.mainQueue = linkedBlockingQueue2;
        }

        @Override
        public void run() {
            Output.printTrace("In CheckAccess Thread", 3);
            String string = null;
            BufferedWriter bufferedWriter = null;
            Boolean bl = true;
            HashSet<String> hashSet = new HashSet<String>();
            File file = null;
            Output.printTrace("Processing checkaccessfiles queue", 3);
            while (bl.booleanValue()) {
                try {
                    Serializable serializable;
                    Object object;
                    hashSet.clear();
                    file = new File(this.fileListName + ".lst");
                    if (!file.exists()) {
                        if (!file.getParentFile().exists()) {
                            Output.printTrace("Directory path " + file.getParentFile() + " does not exists", 1);
                            bl = false;
                            break;
                        }
                        file.createNewFile();
                    }
                    bufferedWriter = new BufferedWriter(new FileWriter(file, true));
                    for (int i = 1; i < 500; ++i) {
                        string = this.checkaccessfiles.poll(1L, TimeUnit.SECONDS);
                        if (string == null) continue;
                        Output.printTrace("Taken file : " + string.trim() + " from checkaccessfiles", 3);
                        if (string.trim().equals("ALLDONE")) {
                            Output.printTrace("Finshed Processing checkaccessfiles queue", 3);
                            bl = false;
                            break;
                        }
                        Output.printTrace("Adding file : " + string.trim() + " to filestokeep", 3);
                        hashSet.add(string.trim());
                        if (file == null || !file.exists() || bufferedWriter == null) continue;
                        Output.printTrace("Writing : " + string.trim() + " to file " + file, 3);
                        bufferedWriter.write(string.trim() + "\n");
                    }
                    bufferedWriter.close();
                    Output.printTrace("Proceesing filestokeep set and tempFileListAccess", 3);
                    if (file != null && file.exists()) {
                        FileList.executeReadAccessScript(file, this.requestUser);
                        File file2 = new File(this.fileListName + ".out");
                        Output.printTrace("CHecking Non Access File: " + file2, 3);
                        if (file2 != null && file2.exists()) {
                            Output.printTrace("Reading Non Access File: " + file2, 3);
                            BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
                            while ((object = bufferedReader.readLine()) != null) {
                                Output.printTrace("Entry to be removed: " + (String)object, 3);
                                serializable = Boolean.valueOf(hashSet.remove(((String)object).trim()));
                                Output.printTrace("FileEntity removed: " + ((String)object).trim() + " " + serializable, 3);
                            }
                            bufferedReader.close();
                        }
                        file2.delete();
                    }
                    Output.printTrace("Draining set to Main zip Queue", 3);
                    for (String string2 : hashSet) {
                        object = new File(string2);
                        serializable = new FileEntity((File)object);
                        this.mainQueue.put((FileEntity)serializable);
                    }
                    file.delete();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Output.print("FileNotFoundException encountered in collecting private files");
                }
                catch (IOException iOException) {
                    Output.print("IOException in check file permission: " + iOException.getMessage());
                }
                catch (InterruptedException interruptedException) {
                    Output.printTrace("InterruptedException in CheckAccess thread", 1);
                    bl = false;
                }
                catch (Exception exception) {
                    Output.print("Exception in check file permission: " + exception.getMessage());
                }
            }
            Output.printTrace("Leaving CheckAccess Thread", 3);
        }
    }
}

