/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;

public class FileHelper {
    public static void parseLinesFromLast(byte[] byArray, Vector vector) {
        String string = new String(byArray);
        StringBuffer stringBuffer = new StringBuffer(string);
        string = stringBuffer.reverse().toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            StringBuffer stringBuffer2 = new StringBuffer(stringTokenizer.nextToken());
            vector.add(stringBuffer2.reverse().toString());
        }
    }

    public static boolean isAsciiText(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(".*_CELLSRVSTAT_.*\\.DAT\\.(BZ2|GZ)");
        arrayList.add(".*_INFINIBAND_.*\\.DAT\\.(BZ2|GZ)");
        arrayList.add(".*_EXADATAOSW_.*\\.DAT\\.(BZ2|GZ)");
        arrayList.add(".*_IPMITOOL_.*\\.DAT\\.(BZ2|GZ)");
        arrayList.add(".*_LSOF_.*\\.DAT\\.(BZ2|GZ)");
        arrayList.add(".*_EXADATARDS_.*\\.DAT\\.(BZ2|GZ)");
        arrayList.add(".*_DISKIO_.*\\.DAT\\.(BZ2|GZ)");
        arrayList.add(".*_IOSTAT_.*\\.DAT\\.(BZ2|GZ)");
        arrayList.add(".*_MEMINFO_.*\\.DAT\\.(BZ2|GZ)");
        arrayList.add(".*_MPSTAT_.*\\.DAT\\.(BZ2|GZ)");
        arrayList.add(".*_NETSTAT_.*\\.DAT\\.(BZ2|GZ)");
        arrayList.add(".*_NETSTATUDP_.*\\.DAT\\.(BZ2|GZ)");
        arrayList.add(".*_PRVTNET_.*\\.DAT\\.(BZ2|GZ)");
        arrayList.add(".*_PS_.*\\.DAT\\.(BZ2|GZ)");
        arrayList.add(".*_PSEO_.*\\.DAT\\.(BZ2|GZ)");
        arrayList.add(".*_SLABINFO_.*\\.DAT\\.(BZ2|GZ)");
        arrayList.add(".*_TOP_.*\\.DAT\\.(BZ2|GZ)");
        arrayList.add(".*_VMSTAT_.*\\.DAT\\.(BZ2|GZ)");
        arrayList.add(".*ExaWatcher_.*\\.DAT\\.(BZ2|GZ)");
        arrayList.add(".*afd\\.file\\.order");
        arrayList.add(".*acfs\\.file\\.order");
        arrayList.add(".*binlog\\.config");
        arrayList.add(".*advm\\.bin\\.0");
        arrayList.add(".*advm\\.bin\\.dbg");
        arrayList.add(".*advm\\.bin\\.file\\.order");
        arrayList.add(".*asm_volumes\\.out");
        for (String string2 : arrayList) {
            String object2 = string2.toUpperCase().trim();
            if (!string.toUpperCase().trim().matches(object2)) continue;
            Output.printTrace("Passed ASCII test : " + string, 3);
            return true;
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[200];
        ((InputStream)fileInputStream).read(byArray, 0, byArray.length);
        int n = 0;
        int n2 = 0;
        for (byte by : byArray) {
            char c = (char)by;
            if (!Character.isWhitespace(c) && Character.isISOControl(c)) {
                n2 = (short)(n2 + 1);
            }
            if (n2 >= 5) {
                Output.printTrace("Failed ASCII test : " + string, 3);
                return false;
            }
            ++n;
        }
        ((InputStream)fileInputStream).close();
        Output.printTrace("Passed ASCII test : " + string, 3);
        return true;
    }

    public static boolean isValidASCII(byte[] byArray) {
        String string = new String(byArray);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u0000' && c < '\u00ff') continue;
            return false;
        }
        return true;
    }

    public static long getCurrentPosition(byte[] byArray) {
        char c;
        long l = 0L;
        String string = new String(byArray);
        for (int i = 0; i < string.length() && (c = string.charAt(i)) > '\u0000' && c < '\u00ff'; ++i) {
            ++l;
        }
        return l;
    }

    public static long sizeOfDirectory(String string) {
        String string2 = "";
        String string3 = "";
        long l = 0L;
        string2 = new File(Properties.perlexe).exists() ? Properties.perlexe : File.separator + "usr" + File.separator + "bin" + File.separator + "perl";
        try {
            String string4 = string2 + " " + Properties.tfaHome + File.separator + "bin" + File.separator + "tfaosutils.pl du " + string;
            Output.printTrace("FileHelper : Command : " + string4, 3);
            Process process = Runtime.getRuntime().exec(string4);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string3 = bufferedReader.readLine();
            if (string3 != null) {
                Output.printTrace("FileHelper : LINE : " + string3, 3);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Output.printTrace("FileHelper : Exception in sizeOfDirectory " + exception.getMessage(), 1);
        }
        if (string3 != null) {
            l = Long.parseLong(string3.trim());
        }
        Output.printTrace("FileHelper : Size : " + l, 3);
        return l;
    }

    public static void changePermission(String string, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "~~";
        string3 = new File(Properties.perlexe).exists() ? Properties.perlexe : File.separator + "usr" + File.separator + "bin" + File.separator + "perl";
        try {
            String string6 = string3 + " " + Properties.tfaHome + File.separator + "bin" + File.separator + "tfaosutils.pl chmod -perm=" + string + string5 + "-path=" + string2;
            Output.printTrace("FileHelper : Command : " + string6, 3);
            Process process = Runtime.getRuntime().exec(string6);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string4 = bufferedReader.readLine();
            if (string4 != null) {
                Output.printTrace("FileHelper : LINE : " + string4, 3);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Output.printTrace("FileHelper : Exception in changePermission " + exception.getMessage(), 1);
        }
    }

    public static void copy(String string, String string2, String string3) {
        String string4 = "";
        String string5 = "";
        string4 = new File(Properties.perlexe).exists() ? Properties.perlexe : File.separator + "usr" + File.separator + "bin" + File.separator + "perl";
        try {
            if (!string3.equals("1")) {
                string3 = "0";
            }
            String string6 = string4 + " " + Properties.tfaHome + File.separator + "bin" + File.separator + "tfaosutils.pl cp " + string + " " + string2 + " " + string3;
            Output.printTrace("FileHelper : Command : " + string6, 3);
            Process process = Runtime.getRuntime().exec(string6);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string5 = bufferedReader.readLine();
            if (string5 != null) {
                Output.printTrace("FileHelper : LINE : " + string5, 3);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Output.printTrace("FileHelper : Exception in copy " + exception.getMessage(), 1);
        }
    }

    public static String getFileOwner(String string) {
        String string2 = "";
        String string3 = null;
        try {
            String string4 = Properties.perlexe + " " + Properties.tfaHome + File.separator + "bin" + File.separator + "tfaosutils.pl getfileowner " + string;
            Output.printTrace("FileHelper getFileOwner : Command : " + string4, 3);
            Process process = Runtime.getRuntime().exec(string4);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string2 = bufferedReader.readLine();
            if (string2 != null) {
                Output.printTrace("FileHelper getFileOwner : LINE : " + string2, 3);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Output.printTrace("FileHelper : Exception in getFileOwner " + exception.getMessage(), 1);
        }
        if (string2 != null) {
            string3 = string2.trim();
        }
        Output.printTrace("FileHelper : getFileOwner : " + string3, 3);
        return string3;
    }

    public static String getGroupName(String string) {
        String string2 = "";
        String string3 = "/usr/bin/id -g -n " + string;
        if (Properties.isSolaris()) {
            string3 = "/usr/xpg4/bin/id -g -n " + string;
        }
        if (Properties.isAIX()) {
            string3 = "/bin/id -g -n " + string;
        }
        Output.printTrace("FileHelper getGroupName : Command : " + string3, 3);
        try {
            Process process = Runtime.getRuntime().exec(string3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string2 = bufferedReader.readLine();
            bufferedReader.close();
            process.waitFor();
        }
        catch (Exception exception) {
            Output.printTrace("FileHelper : Exception in getGroupName " + exception.getMessage(), 1);
        }
        Output.printTrace("FileHelper : getGroupName : " + string2, 3);
        return string2;
    }
}

