/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.util;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import oracle.rat.tfa.RepositoryManager;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.StringUtil;

public class DiagcollectLog {
    String repo = RepositoryManager.getInstance().getDirectory() + File.separator;
    String replacedHostname = "";
    String logid = "";
    String consoleLog = "";
    String diagLog = "";

    public DiagcollectLog() {
    }

    public DiagcollectLog(String string, String string2, String string3) {
        this.replacedHostname = StringUtil.getReplacementFor(string3);
        this.logid = string2;
        this.consoleLog = this.repo + string + File.separator + "diagcollect_console_" + this.logid + "_" + this.replacedHostname + ".log";
        this.diagLog = this.repo + string + File.separator + "diagcollect_" + string2 + "_" + this.replacedHostname + ".log";
    }

    public String getConsoleLog() {
        return this.consoleLog;
    }

    public String getDiagLog() {
        return this.diagLog;
    }

    public static void startLog(String string, String string2) {
        String string3 = "";
        if (string2 != null) {
            string3 = string2;
        } else {
            Properties.getInstance();
            string3 = Properties.diagcollectFile;
        }
        try {
            String string4 = System.getProperty("line.separator");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z");
            String string5 = Properties.timezone;
            if (string5 != null) {
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string5));
            }
            Date date = new Date();
            FileOutputStream fileOutputStream = new FileOutputStream(string3, false);
            String string6 = simpleDateFormat.format(date) + " : " + string + string4;
            fileOutputStream.write(string6.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            Output.print("Exception in starting log for new diagcollection run " + exception.getMessage());
        }
    }

    public void writeLog(String string, String string2) {
        this.writeLog(string, true);
    }

    public void writeLog(String string, Boolean bl) {
        String[] stringArray = new String[2];
        stringArray[0] = this.diagLog;
        if (bl.booleanValue()) {
            stringArray[1] = this.consoleLog;
        }
        for (String string2 : stringArray) {
            try {
                if (string2 == null) continue;
                String string3 = System.getProperty("line.separator");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss z");
                String string4 = Properties.timezone;
                if (string4 != null) {
                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string4));
                }
                Date date = new Date();
                FileOutputStream fileOutputStream = new FileOutputStream(string2, true);
                String string5 = simpleDateFormat.format(date) + " : " + string + string3;
                fileOutputStream.write(string5.getBytes());
                fileOutputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

