/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import oracle.rat.tfa.RepositoryManager;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.receiver.RGlobal;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;

public class ConfigManager {
    public static void set(String string, String string2, String string3) {
        RGlobal.setProperty(string, string2, string3);
        ConfigManager.updateRConfigPropertiesFile(string, string2);
    }

    public static String get(String string) {
        Output.printTrace("Conifg print requested for " + string, 3);
        if (RGlobal.kvStr.containsKey(string)) {
            return RGlobal.kvStr.get(string);
        }
        if (RGlobal.kvInt.containsKey(string)) {
            return String.valueOf(RGlobal.kvInt.get(string));
        }
        if (RGlobal.kvBool.containsKey(string)) {
            return Boolean.toString(RGlobal.kvBool.get(string));
        }
        return string + "=Config Parameter Not Found";
    }

    private static void updateRConfigPropertiesFile(String string, String string2) {
        try {
            FileInputStream fileInputStream = new FileInputStream(Properties.rconfigPropertiesFile);
            java.util.Properties properties = new java.util.Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            properties.setProperty(string, string2);
            FileOutputStream fileOutputStream = new FileOutputStream(Properties.rconfigPropertiesFile);
            properties.store(fileOutputStream, null);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Output.printTrace("IOException while updating rconfig file: " + iOException.getMessage(), 3);
        }
        catch (Exception exception) {
            Output.printTrace("Exception while updating rconfig file " + exception.getMessage(), 3);
        }
    }

    public static String getFromRConfigPropertiesFile(String string) {
        String string2 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(Properties.rconfigPropertiesFile);
            java.util.Properties properties = new java.util.Properties();
            properties.load(fileInputStream);
            string2 = properties.getProperty(string);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            Output.printTrace("IOException while updating rconfig file: " + iOException.getMessage(), 3);
        }
        catch (Exception exception) {
            Output.printTrace("Exception while updating rconfig file " + exception.getMessage(), 3);
        }
        return string2;
    }

    public static void printConfig(PrintWriter printWriter, String string) {
        String string2 = new Host().getHostname().trim();
        String string3 = null;
        if (!string.equalsIgnoreCase("all")) {
            String string4 = ConfigManager.get(string);
            if (string4.contains("Config Parameter Not Found")) {
                string3 = "Config Parameter not supported with -name flag";
            } else {
                string3 = "host=" + string2 + "!" + string + "=" + ConfigManager.get(string);
                Output.printTrace("output=" + string3, 3);
            }
        } else {
            String string5 = System.getProperty("java.version");
            string5 = string5.substring(0, 3);
            string3 = "host=" + string2 + "!" + "tfaversion=" + Properties.tfaVersion + "!" + "javaVersion=" + string5 + "!" + "publicIp=" + Properties.publicIp + "!" + "firezipsinrt=" + Global.isFireZipsInRT() + "!" + "rtscan=" + Global.isRtScanOn() + "!" + "diskUsageMon=" + Global.isDiskUsageMonOn() + "!" + "manageLogsAutoPurge=" + Global.isManageLogsAutoPurgeOn() + "!" + "trimmingon=" + Global.isTrimmingOn() + "!" + "inventorytracelevel=" + Global.getInventorytraceLevel() + "!" + "collectiontracelevel=" + Global.getCollectiontraceLevel() + "!" + "scantracelevel=" + Global.getScantraceLevel() + "!" + "othertracelevel=" + Global.getOthertraceLevel() + "!" + "currentsizemegabytes=" + RepositoryManager.getInstance().getCurrentSizeMegabytes() + "!" + "maxsizemegabytes=" + RepositoryManager.getInstance().getMaxSizeMegabytes() + "!" + "maxlogSize=" + Global.getMaxLogSize() / 0x100000L + "!" + "maxlogcount=" + Global.getMaxLogCount() + "!" + "maxcorefilesize=" + Global.getMaxCoreFileSize() + "!" + "maxcorecollectionsize=" + Global.getMaxCoreCollectionSize() + "!" + "minSpaceForRTScan=" + Global.getMinSpaceForRTScan() + "!" + "diskUsageMonInterval=" + Global.getDiskUsageMonInterval() + "!" + "manageLogsAutoPurgeInterval=" + Global.getManageLogsAutoPurgeInterval() + "!" + "manageLogsAutoPurgePolicyAge=" + Global.getManageLogsAutoPurgePolicyAge() + "!" + "autopurge=" + Global.isAutoPurge() + "!" + "minfileagetopurge=" + Global.getMinFileAgeToPurge() + "!" + "language=" + Global.getLanguage() + "!" + "encoding=" + Global.getEncoding() + "!" + "country=" + Global.getCountry() + "!" + "AlertLogLevel=" + Global.getAlertLogLevel() + "!" + "UserLogLevel=" + Global.getUserLogLevel() + "!" + "BaseLogPath=" + Global.getBaseLogPath() + "!" + "tfaIpsPoolSize=" + Global.getTfaIpsPoolSize();
        }
        printWriter.println(string3);
    }
}

