/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.uc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import oracle.clscred.CredAttribute;
import oracle.clscred.CredDom;
import oracle.clscred.CredException;
import oracle.clscred.CredFlags;
import oracle.clscred.CredSet;
import oracle.clscred.CredType;
import oracle.clscred.UserPass;
import oracle.clscred.impl.CredNative;
import oracle.ops.mgmt.cluster.Version;

public class TFAManageCredentials {
    public static int exportTFACred(String string, String string2, String string3, String string4, String string5, String string6) {
        CredNative credNative = null;
        CredDom credDom = null;
        CredDom credDom2 = null;
        CredSet credSet = null;
        int n = -1;
        UserPass userPass = null;
        try {
            credNative = new CredNative(CredFlags.NONE);
            credDom2 = credNative.getRootDom();
            if (credDom2 == null) {
                System.out.println("Error creating root dom");
                return 1;
            }
            credDom = credDom2.findDom(CredFlags.NONE, "tfa");
            if (credDom != null) {
                credDom.delete(CredFlags.RECURSIVE);
            }
            if ((credDom = credDom2.createDom("tfa", CredFlags.NONE)) == null) {
                System.out.println("Failed to create tfa DOM");
                return 1;
            }
            credDom.attrSet(CredFlags.NONE, "SERVER_HOSTS", string5);
            credDom.attrSet(CredFlags.NONE, "SERVER_VERSION", string6);
            credDom.attrSet(CredFlags.NONE, "CLIENT_NAME", string2);
            credDom.attrSet(CredFlags.NONE, "CLIENT_GUID", string3);
            userPass = new UserPass.Builder(string2, string4).build();
            credSet = credDom.createCredSet(CredFlags.NONE, CredType.USERPASS);
            n = credSet.addMemberUserPass(userPass);
            credDom.exportToXMLFileAsSection("tfa", string, CredFlags.REPLACEEXISTING);
            credDom.close();
            System.out.println("Exported TFA cred to " + string);
            return 0;
        }
        catch (CredException credException) {
            System.out.println("ERROR: " + credException.getMessage());
            credException.printStackTrace();
            return 1;
        }
        catch (Exception exception) {
            System.out.println("ERROR: Exception occurred during export" + exception.getMessage());
            exception.printStackTrace();
            return 1;
        }
    }

    public static void importTFACred(String string, String string2, boolean bl) {
        CredNative credNative = null;
        CredDom credDom = null;
        CredDom credDom2 = null;
        Object var6_6 = null;
        try {
            credNative = new CredNative(CredFlags.NONE);
            credDom = credNative.getRootDom();
            credDom2 = credDom.findDom(CredFlags.NONE, "tfa");
            if (credDom2 != null) {
                credDom2.delete(CredFlags.RECURSIVE);
            }
            credDom2 = credDom.createDom("tfa", CredFlags.NONE);
            credDom2.importFromXMLFileSection("tfa", string, CredFlags.REPLACEEXISTING);
            CredDom credDom3 = credDom2.findDom(CredFlags.NONE, "tfa");
            if (credDom3 == null) {
                System.out.println("Failed to find tfa cred");
            }
            String string3 = "<tfa>";
            string3 = string3 + "<SERVER_HOSTS>" + credDom3.attrGet(CredFlags.NONE, "SERVER_HOSTS") + "</SERVER_HOSTS>";
            string3 = string3 + "<SERVER_VERSION>" + credDom3.attrGet(CredFlags.NONE, "SERVER_VERSION") + "</SERVER_VERSION>";
            string3 = string3 + "<CLIENT_NAME>" + credDom3.attrGet(CredFlags.NONE, "CLIENT_NAME") + "</CLIENT_NAME>";
            string3 = string3 + "<CLIENT_GUID>" + credDom3.attrGet(CredFlags.NONE, "CLIENT_GUID") + "</CLIENT_GUID>";
            CredSet credSet = credDom3.getCredSet(CredFlags.NONE, CredType.USERPASS);
            if (credSet != null) {
                string3 = string3 + "<CLIENT_KEY>" + credSet.memberAttrGet(0, CredAttribute.USERPASS) + "</CLIENT_KEY>";
            }
            string3 = string3 + "/tfa>";
            PrintWriter printWriter = new PrintWriter(string2, "UTF-8");
            printWriter.println(string3);
            printWriter.close();
            if (bl) {
                System.out.println("Config : ");
                System.out.println("SERVER_HOSTS   : " + credDom3.attrGet(CredFlags.NONE, "SERVER_HOSTS"));
                System.out.println("SERVER_VERSION : " + credDom3.attrGet(CredFlags.NONE, "SERVER_VERSION"));
                System.out.println("CLIENT_NAME    : " + credDom3.attrGet(CredFlags.NONE, "CLIENT_NAME"));
                System.out.println("CLIENT_GUID    : " + credDom3.attrGet(CredFlags.NONE, "CLIENT_GUID"));
                if (credSet != null) {
                    System.out.println("Client Name : " + credSet.memberAttrGet(0, CredAttribute.USERNAME));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void print_usage(String string) {
        System.out.println("Error : " + string);
        System.out.println("\nUsage :  \nExport : $ORACLE_HOME/jdk/bin/java -cp .:$ORACLE_HOME/jlib/clscred.jar:$ORACLE_HOME/jlib/srvm.jar oracle.rat.tfa.uc.TFAManageCredentials -export <wrap file> -client <name> -keyfile <keyfile> -guid <guid> -servers <server1:port,server2:port..> -version <version>");
        System.out.println("Import : $ORACLE_HOME/jdk/bin/java -cp .:$ORACLE_HOME/jlib/clscred.jar:$ORACLE_HOME/jlib/srvm.jar oracle.rat.tfa.uc.TFAManageCredentials -import <wrap file> -out <xml output file>");
        System.exit(0);
    }

    private static String getKey(String string, String string2) {
        BufferedReader bufferedReader = null;
        String string3 = null;
        String string4 = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string2));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!string3.startsWith(string)) continue;
                String[] stringArray = string3.split("=");
                string4 = stringArray[1];
                break;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string4;
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        int n = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string10;
            if ((string10 = stringArray[n++]).equals("-export")) {
                string = "export";
                string2 = stringArray[n++];
                continue;
            }
            if (string10.equals("-printccversion")) {
                String string11 = Version.getCurrentVersion().toString();
                System.out.println(string11);
                System.exit(0);
                continue;
            }
            if (string10.equals("-import")) {
                string = "import";
                string2 = stringArray[n++];
                continue;
            }
            if (string10.equals("-client")) {
                string3 = stringArray[n++];
                continue;
            }
            if (string10.equals("-keyfile")) {
                string5 = stringArray[n++];
                continue;
            }
            if (string10.equals("-guid")) {
                string4 = stringArray[n++];
                continue;
            }
            if (string10.equals("-servers")) {
                string7 = stringArray[n++];
                continue;
            }
            if (string10.equals("-version")) {
                string8 = stringArray[n++];
                continue;
            }
            if (!string10.equals("-out")) continue;
            string9 = stringArray[n++];
        }
        if (string2 == null) {
            TFAManageCredentials.print_usage("Option -export/-import is missing");
        }
        if (string.equals("export")) {
            if (string3 == null) {
                TFAManageCredentials.print_usage("Option -client is missing");
            }
            if (string4 == null) {
                TFAManageCredentials.print_usage("Option -guid is missing");
            }
            if (string7 == null) {
                TFAManageCredentials.print_usage("Option -servers is missing");
            }
            if (string8 == null) {
                TFAManageCredentials.print_usage("Option -version is missing");
            }
            if (string5 == null || !new File(string5).exists()) {
                TFAManageCredentials.print_usage("Option -keyfile is missing or file does not exists");
            }
            try {
                string6 = TFAManageCredentials.getKey(string3, string5);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string6.trim().equals("")) {
                TFAManageCredentials.print_usage("Client key cannot be null");
            }
            int n2 = TFAManageCredentials.exportTFACred(string2, string3, string4, string6, string7, string8);
        } else if (string.equals("import")) {
            if (string9 == null) {
                TFAManageCredentials.print_usage("Option -out is missing");
            }
            TFAManageCredentials.importTFACred(string2, string9, false);
        } else {
            TFAManageCredentials.print_usage("");
        }
    }
}

