/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.type;

import java.util.ArrayList;
import java.util.List;
import oracle.rat.tfa.analysis.Globals.GlobalWrapper;
import oracle.rat.tfa.util.Output;

public class SearchString {
    private String searchString;
    private List<String> searchFiles = new ArrayList<String>();
    private String useClass;
    private String useGlobalClass;
    private String eventId;
    private String linesToProcess;
    private String searchEndString;
    private long eventStartTrimBuffer;
    private long eventEndTrimBuffer;
    private String[] actionString = new String[1];
    private int numberUseClass = 0;
    private int numberClassParams = 0;
    private GlobalWrapper globalWrapper = null;
    private boolean generate_trim;
    private List<String> extraFilesToCollect = null;
    private String tracefac = "SCAN";
    private boolean disableInADE = false;
    private boolean clusterwide = false;
    private boolean notify = false;
    private int score = 0;

    private void expandActions(int n) {
        String[] stringArray = new String[n];
        System.arraycopy(this.actionString, 0, stringArray, 0, this.actionString.length);
        this.actionString = stringArray;
    }

    public synchronized boolean ismatchString(String string) {
        Output output = new Output();
        if (this.searchString == null) {
            Output.printTrace("SearchString was Null in ismatchString", this.tracefac, 2);
        }
        Output.printTrace("Entered ismatchString for : " + string, this.tracefac, 4);
        Output.printTrace("Search String : " + this.searchString, this.tracefac, 4);
        try {
            if (string.matches(this.searchString)) {
                if (this.searchString.equalsIgnoreCase("Incident details in")) {
                    Output.printTrace("Found ADR incident", this.tracefac, 3);
                }
                Output.printTrace("Found event : " + this.searchString + " in line: " + string, this.tracefac, 3);
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            Output.printTrace("CAUGHT :: SearchString was Null in isMatchString ", 2);
        }
        return false;
    }

    public synchronized boolean isLineAfterEvent() {
        Output output = new Output();
        if (!this.useGlobalClass.equalsIgnoreCase("NONE")) {
            try {
                Output.printTrace("Global Class : " + this.useGlobalClass, this.tracefac, 4);
                if (this.globalWrapper.getParamValue(this.eventId).contains("TRUE")) {
                    Output.printTrace("Storing line after event : " + this.searchString, this.tracefac, 4);
                    return true;
                }
            }
            catch (Exception exception) {
                Output.print("SearchString : Exception in getting parameter value");
            }
        }
        return false;
    }

    public synchronized void setSearchString(String string) {
        this.searchString = string;
    }

    public synchronized void setSearchFiles(List<String> list) {
        this.searchFiles = list;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public List<String> getSearchFiles() {
        return this.searchFiles;
    }

    public synchronized void setClass(String string) {
        this.useClass = string;
        ++this.numberUseClass;
    }

    public void setGlobalClass(String string) {
        this.useGlobalClass = string;
    }

    public void setEventId(String string) {
        this.eventId = string;
    }

    public void setLinesToProcess(String string) {
        this.linesToProcess = string;
    }

    public void listClasses() {
        Output.printTrace("Class            : " + this.useClass, this.tracefac, 3);
        Output.printTrace("Global Class     : " + this.useGlobalClass, this.tracefac, 3);
        Output.printTrace("Event Id         : " + this.eventId, this.tracefac, 3);
        Output.printTrace("Lines TO process : " + this.linesToProcess, this.tracefac, 3);
        Output.printTrace("Search End       : " + this.searchEndString, this.tracefac, 3);
        for (int i = 0; i < this.getActionStrings().length; ++i) {
            Output.printTrace("Action String: " + this.getActionStrings()[i], this.tracefac, 3);
        }
    }

    public int getNumberUseClass() {
        return this.numberUseClass;
    }

    public int getNumberClassParams() {
        return this.numberClassParams;
    }

    public String getUseGlobalClass() {
        return this.useGlobalClass;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getLinesToProcess() {
        return this.linesToProcess;
    }

    public String getUseClass() {
        return this.useClass;
    }

    public Object getObject() {
        Object object = new Object();
        try {
            Class<?> clazz = Class.forName(this.getUseClass());
            object = clazz.newInstance();
        }
        catch (Exception exception) {
            Output.print("SearchString : Exception in getObject");
        }
        return object;
    }

    public void setSearchEndString(String string) {
        this.searchEndString = string;
    }

    public String getSearchEndString() {
        return this.searchEndString;
    }

    public void addActionString(String string) {
        int n = string.length() + 1;
        this.expandActions(n);
        this.actionString[n - 1] = string;
    }

    public String[] getActionStrings() {
        return this.actionString;
    }

    public void setGlobalWrapper(GlobalWrapper globalWrapper) {
        this.globalWrapper = globalWrapper;
    }

    public GlobalWrapper getGlobalWrapper() {
        return this.globalWrapper;
    }

    public void setEventStartTrimBuffer(long l) {
        this.eventStartTrimBuffer = l;
    }

    public long getEventStartTrimBuffer() {
        return this.eventStartTrimBuffer;
    }

    public void setGenerateTrim(boolean bl) {
        this.generate_trim = bl;
    }

    public boolean getGenerateTrim() {
        return this.generate_trim;
    }

    public void setEventEndTrimBuffer(long l) {
        this.eventEndTrimBuffer = l;
    }

    public long getEventEndTrimBuffer() {
        return this.eventEndTrimBuffer;
    }

    public void setExtraFilesToCollect(List<String> list) {
        this.extraFilesToCollect = list;
    }

    public List<String> getExtraFilesToCollect() {
        return this.extraFilesToCollect;
    }

    public void setDisableInADE(boolean bl) {
        this.disableInADE = bl;
    }

    public boolean isDisableInADE() {
        return this.disableInADE;
    }

    public void setClusterwide(boolean bl) {
        this.clusterwide = bl;
    }

    public boolean isClusterwide() {
        return this.clusterwide;
    }

    public void setNotify(boolean bl) {
        this.notify = bl;
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setScore(int n) {
        this.score = n;
    }

    public int getScore() {
        return this.score;
    }
}

