/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.type;

import com.sleepycat.persist.model.Entity;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.rat.tfa.util.Grepper;
import oracle.rat.tfa.util.Output;

@Entity(version=2)
public class FileType {
    private String name;
    private Vector<String> namePatterns = new Vector();
    private Vector<String> contentPatterns = new Vector();
    private Vector<String> dirPathPatterns = new Vector();
    private int numberNamePatterns = 0;
    private int numberContentPatterns = 0;
    private int numberDirPathPatterns = 0;
    private String inventoryAction;
    private String category;
    private String component;
    private String alsoCollectFor;
    private String datePattern;
    private Set<String> datePatterns = new HashSet<String>();
    private boolean useDfOnly = false;
    private long keepHeaderLines = 0L;

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void addNamePattern(String string) {
        this.namePatterns.add(string);
        ++this.numberNamePatterns;
    }

    public void addContentPattern(String string) {
        this.contentPatterns.add(string);
        ++this.numberContentPatterns;
    }

    public void addDirPathPattern(String string) {
        this.dirPathPatterns.add(string);
        ++this.numberDirPathPatterns;
    }

    public void listPatterns() {
        Iterator<String> iterator = this.namePatterns.iterator();
        Iterator<String> iterator2 = this.contentPatterns.iterator();
        while (iterator.hasNext()) {
        }
        while (iterator2.hasNext()) {
        }
    }

    public int getNumberNamePatterns() {
        return this.numberNamePatterns;
    }

    public int getNumberContentPatterns() {
        return this.numberContentPatterns;
    }

    public int getNumberDirPathPatterns() {
        return this.numberDirPathPatterns;
    }

    public Vector<String> getNamePatterns() {
        return this.namePatterns;
    }

    public boolean checkNamePatterns(String string) {
        boolean bl = false;
        for (String string2 : this.namePatterns) {
            string2 = string2.toUpperCase().trim();
            bl = string.toUpperCase().trim().matches(string2);
            if (!bl) continue;
            Output.printTrace("For dir : " + string + " name match with pattern " + string2, 3);
            return bl;
        }
        return bl;
    }

    public boolean checkContentPatterns(String string) {
        boolean bl = false;
        File file = new File(string);
        Iterator<String> iterator = this.contentPatterns.iterator();
        Output.print("Start grepping file " + string);
        while (iterator.hasNext() && !bl) {
            String string2 = iterator.next();
            bl = Grepper.grepFile(file, string2);
            if (!bl) continue;
            Output.print("*** Content Pattern Match: " + string2);
            return true;
        }
        return false;
    }

    public boolean checkDirPathPatterns(String string) {
        Output.printTrace("Inside checkDirPatterns for type : " + this.getName() + " for file: " + string, 3);
        boolean bl = false;
        Iterator<String> iterator = this.dirPathPatterns.iterator();
        while (iterator.hasNext() && !bl) {
            String string2 = iterator.next();
            Pattern pattern = Pattern.compile(string2 = string2.toUpperCase().trim());
            Matcher matcher = pattern.matcher(string.toUpperCase().trim());
            bl = matcher.find();
            if (!bl) continue;
            Output.printTrace("Dir Pattern Match: " + string2, 3);
            return bl;
        }
        return bl;
    }

    public void setInventoryAction(String string) {
        this.inventoryAction = string;
    }

    public String getInventoryAction() {
        return this.inventoryAction;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public String getCategory() {
        return this.category;
    }

    public void setComponent(String string) {
        this.component = string;
    }

    public String getComponent() {
        return this.component;
    }

    public void setAlsoCollectFor(String string) {
        this.alsoCollectFor = string;
    }

    public String getAlsoCollectFor() {
        return this.alsoCollectFor;
    }

    public void setDatePattern(String string) {
        this.datePattern = string;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePatterns(Set<String> set) {
        this.datePatterns = set;
    }

    public Set<String> getDatePatterns() {
        return this.datePatterns;
    }

    public void setUseDfOnly(boolean bl) {
        this.useDfOnly = bl;
    }

    public boolean isUseDfOnly() {
        return this.useDfOnly;
    }

    public void setKeepHeaderLines(long l) {
        this.keepHeaderLines = l;
    }

    public long getKeepHeaderLines() {
        return this.keepHeaderLines;
    }
}

