/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.tfar15;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TimerTask;
import java.util.TreeMap;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.receiver.TFAMessage;
import oracle.rat.tfa.util.Output;

public class FileWatcher15
extends TimerTask {
    private long timeStamp;
    private File file;
    public String hostName;
    public String topic;
    public TreeMap<String, Long> fileList;
    public ObjectOutputStream oos;

    public FileWatcher15(File file, String string, ObjectOutputStream objectOutputStream) {
        this.file = file;
        this.topic = string;
        this.oos = objectOutputStream;
        this.timeStamp = file.lastModified();
        this.readFileList();
        this.hostName = new Host().getHostname().trim();
    }

    public void readFileList() {
        TreeMap treeMap = new TreeMap();
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream("filelist.properties"));
        }
        catch (Exception exception) {
            System.out.println("Read Error");
        }
        this.fileList = new TreeMap(treeMap);
    }

    public void dumpFileList() {
        TreeMap<String, Long> treeMap = new TreeMap<String, Long>((SortedMap<String, Long>)this.fileList);
        Properties properties = new Properties();
        for (Map.Entry entry : treeMap.entrySet()) {
            properties.put(entry.getKey(), ((Long)entry.getValue()).toString());
        }
        try {
            properties.store(new FileOutputStream("filelist.properties"), null);
        }
        catch (Exception exception) {
            System.out.println("Dump Error " + exception.getMessage());
        }
    }

    public void sendDataToKafka(String string, String string2, long l) {
        String string3 = this.hostName + "-" + string2;
        TFAMessage tFAMessage = null;
        long l2 = 0L;
        if (this.fileList.containsKey(string3)) {
            l2 = this.fileList.get(string3);
        }
        this.fileList.put(string3, l);
        RandomAccessFile randomAccessFile = null;
        Object var10_8 = null;
        String string4 = null;
        Output.printTrace("Source: " + this.hostName, 3);
        try {
            randomAccessFile = new RandomAccessFile(string2, "r");
            long l3 = l - l2;
            int n = 524288;
            byte[] byArray = null;
            while (l3 > 0L) {
                randomAccessFile.seek(l2);
                if (l3 < (long)n) {
                    n = (int)l3;
                }
                byArray = new byte[n];
                randomAccessFile.readFully(byArray);
                string4 = new String(byArray);
                Output.printTrace("\nContent Length:" + string4.length(), 3);
                Output.printTrace("\nFile Content:" + string4, 3);
                tFAMessage = new TFAMessage(this.hostName, string2, string4);
                this.oos.writeObject(tFAMessage);
                this.oos.reset();
                l3 = l - (l2 += (long)n);
            }
            randomAccessFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onChange(File file) {
        this.sendDataToKafka(new String("change"), file.getAbsolutePath(), file.length());
    }

    @Override
    public final void run() {
        long l = this.file.lastModified();
        if (this.timeStamp != l) {
            this.timeStamp = l;
            this.onChange(this.file);
        }
    }
}

