/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.tfar15;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.rat.tfa.db.DataAccessor.FileEntityDA;
import oracle.rat.tfa.entity.FileEntity;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.receiver.RGlobal;
import oracle.rat.tfa.receiver.TFAMessage;
import oracle.rat.tfa.tfar15.FileMonitor15;
import oracle.rat.tfa.util.MD5Checksum;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver;

public class FileAlterationListenerImpl15
implements FileAlterationListener {
    public String hostName;
    public String topic;
    public OutputStream os;
    public ObjectOutputStream oos;
    public Socket sock;
    public int port;
    public String hostkey;
    int cnt;
    HashSet<String> ftypes;
    public HashMap<String, FileDetails> fileList;
    public TreeMap<Long, String> filesTMOrder;

    public FileAlterationListenerImpl15(String string, ObjectOutputStream objectOutputStream, int n) {
        Output.printTrace("FileAlterationListenerImpl15: In Constructor. Dir/File No = " + n, 3);
        this.topic = string;
        this.oos = objectOutputStream;
        this.cnt = n;
        this.fileList = new HashMap();
        this.hostName = new Host().getHostname().trim();
    }

    public FileAlterationListenerImpl15(String string, ObjectOutputStream objectOutputStream, File file, int n, Map<File, String> map, Socket socket, int n2, String string2) {
        List<Object> list;
        Output.printTrace("FileAlterationListenerImpl15: In Constructor. Dir/File No = " + n, 3);
        this.topic = string;
        this.oos = objectOutputStream;
        this.cnt = n;
        this.sock = socket;
        this.port = n2;
        this.hostkey = string2;
        this.hostName = new Host().getHostname().trim();
        this.fileList = new HashMap();
        this.ftypes = new HashSet();
        this.ftypes.add("Alert Log");
        this.ftypes.add("CSSD Agent Log (OHASD)");
        this.ftypes.add("System Messages Log");
        this.ftypes.add("_METRICS");
        this.ftypes.add("OSW");
        String string3 = null;
        int n3 = -1;
        if (map == null) {
            list = FileAlterationListenerImpl15.getFiles(file, this.ftypes);
        } else {
            list = new ArrayList();
            list.addAll(map.keySet());
        }
        this.filesTMOrder = new TreeMap();
        if (map == null && list.size() > 0) {
            for (File file2 : list) {
                n3 = -1;
                String string4 = file2.getAbsolutePath();
                long l = file2.length();
                try {
                    if (l >= 256L) {
                        string3 = MD5Checksum.getMD5Checksum(string4);
                        Output.printTrace("checksumorig: File: " + string4 + " length:" + l, 3);
                    } else if (l > 0L && l < 256L) {
                        string3 = MD5Checksum.getMD5Checksum_len(string4, (int)l);
                        n3 = (int)l;
                        Output.printTrace("checksum: File: " + string4 + " length:" + l, 3);
                    } else {
                        string3 = "0";
                        Output.printTrace("checksum0: File: " + string4 + " length:" + l, 3);
                    }
                }
                catch (Exception exception) {
                    Output.printTrace("Error while caliculating checksum of " + string4, 1);
                    exception.printStackTrace();
                }
                Output.printTrace(string4 + "==" + string3, 3);
                FileDetails fileDetails = new FileDetails();
                fileDetails.size = 0L;
                fileDetails.currentOffset = 0L;
                fileDetails.prevOffset = 0L;
                fileDetails.chunkid = 1L;
                fileDetails.chunkSize = 0L;
                fileDetails.checksum = string3;
                fileDetails.checksumlength = n3;
                this.fileList.put(string4, fileDetails);
                Output.printTrace("File added:" + string4 + " len:" + n3, 1);
                this.filesTMOrder.put(file2.lastModified(), string4 + "~CHANGE~SENDDATA");
            }
        } else {
            for (File file3 : list) {
                String string5 = map.get(file3);
                Output.printTrace("processing listener:" + string5, 3);
                String[] stringArray = string5.split("~");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashMap.put(stringArray[i].split("=")[0].trim(), stringArray[i].split("=")[1].trim());
                }
                FileDetails fileDetails = new FileDetails();
                fileDetails.size = Long.parseLong((String)hashMap.get("size"));
                fileDetails.currentOffset = Long.parseLong((String)hashMap.get("currentOffset"));
                fileDetails.prevOffset = Long.parseLong((String)hashMap.get("prevOffset"));
                fileDetails.chunkid = Long.parseLong((String)hashMap.get("chunkid"));
                fileDetails.chunkSize = Long.parseLong((String)hashMap.get("chunkSize"));
                fileDetails.checksum = (String)hashMap.get("checksum");
                fileDetails.checksumlength = Integer.parseInt((String)hashMap.get("checksumlength"));
                String string6 = (String)hashMap.get("lastModified");
                this.fileList.put(file3.getAbsolutePath(), fileDetails);
                this.filesTMOrder.put(file3.lastModified(), (String)hashMap.get("key") + "~CHANGE~SENDDATA");
            }
        }
        Output.printTrace("fileList Length=" + this.fileList.size(), 3);
    }

    static List<File> getFiles(File file, HashSet<String> hashSet) {
        ArrayList<File> arrayList = new ArrayList<File>();
        Object var3_3 = null;
        try {
            String string = file.getAbsolutePath();
            file = file.getCanonicalFile();
            File[] fileArray = file.listFiles();
            List<File> list = Arrays.asList(fileArray);
            for (File file2 : list) {
                Object object;
                if (!(file2 = file2.getCanonicalFile()).isFile()) {
                    object = FileAlterationListenerImpl15.getFiles(file2, hashSet);
                    arrayList.addAll((Collection<File>)object);
                    continue;
                }
                object = new FileEntityDA();
                FileEntity fileEntity = (FileEntity)((FileEntityDA)object).pIdx.get((Object)file2.getAbsolutePath());
                String string2 = file2.getAbsolutePath();
                if (!string2.contains("tfar_m") && fileEntity == null) {
                    Output.printTrace("got fe null for " + file2.getAbsolutePath(), 3);
                    continue;
                }
                String string3 = fileEntity.getType();
                if (!string2.contains("tfar_m") && string3 == null) continue;
                for (String string4 : hashSet) {
                    if (!string2.contains("tfar_m") && (string3.indexOf(string4) < 0 || file2.getAbsolutePath().endsWith(".swp"))) continue;
                    Output.printTrace("Listener added for:" + file2, 3);
                    arrayList.add(file2);
                }
            }
        }
        catch (Exception exception) {
            Output.printTrace("Failed to get files list for " + file.getAbsolutePath(), 1);
            exception.printStackTrace();
        }
        return arrayList;
    }

    public void onStart(FileAlterationObserver fileAlterationObserver) {
        Output.printTrace("FileAlterationListenerImpl15: onStart. Dir/File No = " + this.cnt, 3);
        this.filesTMOrder = new TreeMap();
    }

    public void dumpFileList(File file, String string) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            Output.printTrace("dumpFileList for dir " + string, 3);
            FileWriter fileWriter = new FileWriter(file.getAbsoluteFile(), true);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            Output.printTrace("dumpFileList for dir " + this.fileList.entrySet(), 3);
            String string2 = "directory=" + string;
            bufferedWriter.write(string2);
            bufferedWriter.newLine();
            bufferedWriter.flush();
            if (this.fileList.entrySet().size() > 0) {
                for (Map.Entry<String, FileDetails> entry : this.fileList.entrySet()) {
                    String string3 = entry.getKey();
                    FileDetails fileDetails = entry.getValue();
                    String string4 = this.get_file_record(string3, fileDetails);
                    bufferedWriter.write(string4);
                    bufferedWriter.newLine();
                    bufferedWriter.flush();
                }
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String get_file_record(String string, FileDetails fileDetails) {
        File file = new File(string);
        String string2 = "key=" + string + "~";
        string2 = string2 + "size=" + fileDetails.size.toString() + "~";
        string2 = string2 + "checksum=" + fileDetails.checksum + "~";
        string2 = string2 + "chunkid=" + fileDetails.chunkid.toString() + "~";
        string2 = string2 + "currentOffset=" + fileDetails.currentOffset.toString() + "~";
        string2 = string2 + "prevOffset=" + fileDetails.prevOffset.toString() + "~";
        string2 = string2 + "chunkSize=" + fileDetails.chunkSize.toString() + "~";
        string2 = string2 + "checksumlength=" + Integer.toString(fileDetails.checksumlength) + "~";
        string2 = string2 + "lastModified=" + new Long(file.lastModified()).toString();
        return string2;
    }

    public void printFileList() {
        Output.printTrace("File details:", 3);
        for (Map.Entry<String, FileDetails> entry : this.fileList.entrySet()) {
            String string = entry.getKey();
            FileDetails fileDetails = entry.getValue();
            Output.printTrace("File name = " + string, 3);
            Output.printTrace("File size = " + fileDetails.size, 3);
            Output.printTrace("File checksum = " + fileDetails.checksum, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDataToReceiver(String string, String string2, long l) {
        long l2;
        String string32;
        Object object;
        Socket socket = SocketManager.getAuthenticatedSocketConnectionR(this.topic, this.port, this.hostkey);
        if (socket == null) {
            Output.printTrace("sendDataToReceiver sock1 is null", 3);
            Output.printTrace("sendDataToReceiver: stopping monitor", 3);
            try {
                FileMonitor15.monitor.stop();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
            return;
        }
        long l3 = 0L;
        String string4 = null;
        String string5 = string2;
        FileEntityDA fileEntityDA = new FileEntityDA();
        FileEntity fileEntity = (FileEntity)fileEntityDA.pIdx.get((Object)string2);
        Output.printTrace("key = " + string5, 3);
        boolean bl = false;
        if (string2.contains("metadata") && (string2.endsWith("params.out") || string2.endsWith("timeline.out") || string2.contains("tfar_m"))) {
            bl = true;
        } else {
            if (fileEntity == null) {
                return;
            }
            object = fileEntity.getType();
            Output.printTrace("got file type " + (String)object, 3);
            if (object == null) {
                return;
            }
            for (String string32 : this.ftypes) {
                Output.printTrace("got file type " + string32, 3);
                if (((String)object).indexOf(string32) < 0 || string2.endsWith(".swp")) continue;
                bl = true;
                break;
            }
        }
        object = new File(string2);
        Output.printTrace("found for key :" + string2 + " is :" + bl, 3);
        if (!bl) {
            return;
        }
        Object object2 = "";
        string32 = "";
        String string6 = RGlobal.c_name;
        if (fileEntity != null) {
            Output.printTrace("fe is not null", 3);
            if (string6 == null) {
                Output.printTrace("RGlobal.c_name is null", 3);
                string6 = this.getclustername(this.hostName);
            }
            Output.printTrace("cluster name:" + string6, 3);
            object2 = fileEntity.getType() + "~" + fileEntity.getComponent() + "~" + fileEntity.getInstance() + "~" + fileEntity.getDatabase() + "~" + string6;
        } else if (string2.contains("metadata")) {
            Output.printTrace("found file" + string2, 3);
            object2 = "_METRICS~_METRICS~_METRICS~_METRICS~" + string6;
        }
        Output.printTrace("FileName,length=" + string2 + "," + l, 3);
        Output.printTrace("FileName,filetype=" + string2 + "," + (String)object2, 3);
        if (this.fileList.containsKey(string5)) {
            l3 = this.fileList.get((Object)string5).size;
            Output.printTrace("Found file " + string5 + " in the list and prev len = " + l3, 3);
            this.fileList.get((Object)string5).size = l;
        } else {
            try {
                string4 = l >= 256L ? MD5Checksum.getMD5Checksum(string2) : (l > 0L && l < 256L ? MD5Checksum.getMD5Checksum_len(string2, (int)l) : "0");
            }
            catch (Exception exception) {
                Output.printTrace("Error while caliculating checksum", 1);
                exception.printStackTrace();
            }
            FileDetails fileDetails = new FileDetails();
            fileDetails.size = l;
            fileDetails.currentOffset = 0L;
            fileDetails.prevOffset = 0L;
            fileDetails.chunkid = 1L;
            fileDetails.chunkSize = l;
            fileDetails.checksum = string4;
            fileDetails.checksumlength = (int)l;
            this.fileList.put(string5, fileDetails);
            Output.printTrace("File added:" + string5 + " len:" + l, 3);
            Output.printTrace("Added file to the list", 3);
        }
        RandomAccessFile randomAccessFile = null;
        Object var20_19 = null;
        String string7 = null;
        int n = 524288;
        byte[] byArray = null;
        long l4 = 0L;
        Output.printTrace("param len:" + l, 3);
        if (string2.contains("tfar_m") && l == 0L) {
            try {
                Thread.sleep(300L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        l = l2 = new File(string2).length();
        Output.printTrace("currlen:" + l2, 3);
        try {
            Output.printTrace("got type " + string, 3);
            if (string.equals("create")) {
                l3 = 0L;
                Output.printTrace("Setting prevLength as 0", 3);
            }
            randomAccessFile = new RandomAccessFile(string2, "r");
            l4 = l - l3;
            Output.printTrace("dataLength to send to R=" + l4, 3);
            if (l4 < 0L) {
                l4 = l;
                l3 = 0L;
            }
            while (l4 > 0L) {
                randomAccessFile.seek(l3);
                if (l4 < (long)n) {
                    n = (int)l4;
                }
                Output.printTrace("chunkSize=" + n, 3);
                byArray = new byte[n];
                randomAccessFile.readFully(byArray);
                string7 = new String(byArray);
                Output.printTrace("\nContent Length:" + string7.length(), 3);
                Output.printTrace("\nFile Content:" + string7, 3);
                if (this.oos == null) {
                    Output.printTrace("object output stream is null", 3);
                    return;
                }
                if (!string.equals("create")) {
                    this.fileList.get((Object)string5).chunkid = this.fileList.get((Object)string5).chunkid + 1L;
                    this.fileList.get((Object)string5).prevOffset = this.fileList.get((Object)string5).currentOffset;
                    this.fileList.get((Object)string5).currentOffset = this.fileList.get((Object)string5).currentOffset + this.fileList.get((Object)string5).chunkSize;
                    this.fileList.get((Object)string5).chunkSize = n;
                }
                Output.printTrace("msg:" + this.hostName + "," + string2 + "," + this.fileList.get((Object)string5).currentOffset, 3);
                TFAMessage tFAMessage = new TFAMessage(this.hostName, string2, string7, this.fileList.get((Object)string5).currentOffset, this.fileList.get((Object)string5).prevOffset, this.fileList.get((Object)string5).chunkid, this.fileList.get((Object)string5).chunkSize, (String)object2, fileEntity);
                if (this.oos == null) {
                    Output.printTrace("oos is null", 3);
                }
                this.oos.writeObject(tFAMessage);
                this.oos.reset();
                l4 = l - (l3 += (long)n);
            }
        }
        catch (EOFException eOFException) {
            System.out.println("EOFException while sending data to R");
            System.out.println("File Details: " + string + "," + string2 + "," + l);
            System.out.println("prevLength,dataLength=" + l3 + "," + l4);
            eOFException.printStackTrace();
        }
        catch (Exception exception) {
            Output.printTrace("Error  while sending data to R", 1);
            System.out.println("Error while sending data to R for the file: \n" + string + "," + string2 + "," + l);
            exception.printStackTrace();
        }
        finally {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void sendCommandToReceiver(String string, String string2) {
        TFAMessage tFAMessage = new TFAMessage(this.hostName, string, null, string2);
        try {
            this.oos.writeObject(tFAMessage);
            this.oos.reset();
        }
        catch (Exception exception) {
            Output.printTrace("Error occured while sending ommand " + string2 + "to R", 1);
            System.out.println("Error occured while sending command " + string2 + "to R");
            exception.printStackTrace();
        }
    }

    public void sendData(String string) {
    }

    public void onDirectoryCreate(File file) {
        Output.printTrace("Directory Create: " + file.getAbsolutePath(), 3);
    }

    public void onDirectoryChange(File file) {
        Output.printTrace("Directory Change: " + file.getAbsolutePath(), 3);
    }

    public void onDirectoryDelete(File file) {
        Output.printTrace("Directory Delete: " + file.getAbsolutePath(), 3);
    }

    public void onFileCreate(File file) {
        String string = file.getAbsolutePath();
        Output.printTrace("File Create: " + string, 3);
        int n = 0;
        String string2 = null;
        String string3 = "0";
        try {
            if (string.contains("tfar_m")) {
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (file.length() > 0L) {
                string3 = MD5Checksum.getMD5Checksum(string);
                Output.printTrace("Checksum of file " + string + " is " + string3, 3);
                for (Map.Entry<String, FileDetails> entry : this.fileList.entrySet()) {
                    String string4 = entry.getKey();
                    FileDetails fileDetails = entry.getValue();
                    Output.printTrace("File Name = " + string4, 3);
                    Output.printTrace("File Size = " + fileDetails.size, 3);
                    Output.printTrace("File Checksum = " + fileDetails.checksum, 3);
                    if (!string3.equals(fileDetails.checksum)) continue;
                    n = 2;
                    string2 = string4;
                    break;
                }
            } else {
                n = 1;
            }
            if (n == 1) {
                Output.printTrace("Touch file " + string, 3);
                this.filesTMOrder.put(file.lastModified(), string + "~CREATE~SENDDATA");
            } else if (n == 2) {
                Output.printTrace("Move " + string2 + " to " + string, 3);
                this.filesTMOrder.put(file.lastModified(), string + "~CREATE~MVFILE~" + string2);
            } else {
                Output.printTrace("New file " + string + " created", 3);
                this.addFileToFilesList(file);
                this.filesTMOrder.put(file.lastModified(), string + "~CREATE~SENDDATA");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onFileChange(File file) {
        FileDetails fileDetails;
        String string;
        String string2;
        String string3;
        block20: {
            string3 = file.getAbsolutePath();
            string2 = null;
            String string4 = file.getAbsolutePath();
            string = null;
            Output.printTrace("File Change: " + string3, 3);
            try {
                if (file.length() > 0L) {
                    if (this.fileList.keySet().contains(string4)) {
                        if (this.fileList.get((Object)string4).checksumlength == -1) {
                            string2 = MD5Checksum.getMD5Checksum(string3);
                            Output.printTrace("full checksum:" + string4, 3);
                        } else {
                            string2 = MD5Checksum.getMD5Checksum_len(string3, this.fileList.get((Object)string4).checksumlength);
                            Output.printTrace("len checksum:" + string4 + " len:" + this.fileList.get((Object)string4).checksumlength, 3);
                        }
                        break block20;
                    }
                    Output.printTrace("fileList does not contain file :" + string4, 3);
                    int n = -1;
                    long l = file.length();
                    try {
                        if (l >= 256L) {
                            string2 = MD5Checksum.getMD5Checksum(string4);
                            Output.printTrace("checksumorig: File: " + string4 + " length:" + l, 3);
                        } else if (l > 0L && l < 256L) {
                            string2 = MD5Checksum.getMD5Checksum_len(string4, (int)l);
                            n = (int)l;
                            Output.printTrace("checksum: File: " + string4 + " length:" + l, 3);
                        } else {
                            string2 = "0";
                            Output.printTrace("checksum0: File: " + string4 + " length:" + l, 3);
                        }
                    }
                    catch (Exception exception) {
                        Output.printTrace("onFileChange:Error while caliculating checksum of " + string4, 1);
                        exception.printStackTrace();
                    }
                    fileDetails = new FileDetails();
                    fileDetails.size = 0L;
                    fileDetails.currentOffset = 0L;
                    fileDetails.prevOffset = 0L;
                    fileDetails.chunkid = 1L;
                    fileDetails.chunkSize = 0L;
                    fileDetails.checksum = string2;
                    fileDetails.checksumlength = n;
                    this.fileList.put(string4, fileDetails);
                    Output.printTrace("fileList added file file :" + string4, 3);
                    break block20;
                }
                string2 = "0";
            }
            catch (Exception exception) {
                Output.printTrace("Error while caliculating checksum", 1);
                exception.printStackTrace();
            }
        }
        if (!this.fileList.containsKey(string3)) {
            Output.printTrace("Did not find the file " + string3, 3);
            return;
        }
        Output.printTrace("checksum of file before change=" + this.fileList.get((Object)string3).checksum, 3);
        Output.printTrace("checksum of file after change:" + string2, 3);
        if (this.fileList.get((Object)string3).checksum.equals(string2)) {
            Output.printTrace("Content added to file " + string3, 3);
            this.filesTMOrder.put(file.lastModified(), string3 + "~CHANGE~SENDDATA");
        } else if (file.length() == 0L && this.fileList.get((Object)string3).size >= 0L) {
            this.filesTMOrder.put(file.lastModified(), string3 + "~CHANGE~EMPTYFILE");
        } else {
            for (Map.Entry<String, FileDetails> entry : this.fileList.entrySet()) {
                String string5 = entry.getKey();
                fileDetails = entry.getValue();
                Output.printTrace("File Name = " + string5, 3);
                Output.printTrace("File Size = " + fileDetails.size, 3);
                Output.printTrace("File Checksum = " + fileDetails.checksum, 3);
                if (!string2.equals(fileDetails.checksum)) continue;
                string = string5;
                break;
            }
            if (string != null) {
                Output.printTrace("Move " + string + " to " + string3, 3);
                this.filesTMOrder.put(file.lastModified(), string3 + "~CHANGE~MVFILE~" + string);
            } else {
                Output.printTrace("Check sum of file " + string3 + " not matched with any file", 3);
            }
        }
    }

    public void onFileDelete(File file) {
        Output.printTrace("File Delete: " + file.getAbsolutePath(), 3);
        String string = file.getAbsolutePath();
        this.filesTMOrder.put(file.lastModified(), string + "~DELETE~ARCHIVE~" + string);
    }

    public void onStop(FileAlterationObserver fileAlterationObserver) {
        Output.printTrace("FileAlterationListenerImpl15: onStop. Dir/File No = " + this.cnt, 3);
        Output.printTrace("No of files changed = " + this.filesTMOrder.size(), 3);
        for (Map.Entry<Long, String> entry : this.filesTMOrder.entrySet()) {
            Long l = entry.getKey();
            String string = entry.getValue();
            Output.printTrace(l + " => " + string, 3);
            String[] stringArray = string.split("~");
            String string2 = stringArray[0];
            File file = new File(string2);
            if (stringArray[1].equals("CREATE")) {
                if (stringArray[2].equals("SENDDATA")) {
                    this.sendDataToReceiver("create", string2, file.length());
                    continue;
                }
                if (!stringArray[2].equals("MVFILE")) continue;
                this.sendCommandToReceiver(stringArray[3], "COMMAND:MOVETO=" + string2);
                continue;
            }
            if (stringArray[1].equals("CHANGE")) {
                if (stringArray[2].equals("SENDDATA")) {
                    this.sendDataToReceiver("change", string2, file.length());
                    continue;
                }
                if (stringArray[2].equals("MVFILE")) {
                    this.sendCommandToReceiver(stringArray[3], "COMMAND:MOVETO=" + string2);
                    continue;
                }
                if (!stringArray[2].equals("EMPTYFILE")) continue;
                this.sendCommandToReceiver(stringArray[3], "COMMAND:EMPTYFILE=" + stringArray[3]);
                continue;
            }
            if (!stringArray[1].equals("DELETE")) continue;
            this.sendCommandToReceiver(stringArray[3], "COMMAND:ARCHIVE=" + stringArray[3]);
        }
        this.filesTMOrder.clear();
    }

    public String getclustername(String string) {
        Properties.getInstance();
        String string2 = Properties.getClusterName();
        if (string2 == null) {
            System.out.println("c_name null from prop");
            String string3 = Properties.crsHome;
            if (string3 == null || string3.isEmpty()) {
                System.out.println("crs home is null");
                string2 = string;
            } else {
                System.out.println("crs_home:" + string3);
                String string4 = string3.trim() + "/bin/cemutlo -n";
                try {
                    Runtime runtime = Runtime.getRuntime();
                    Process process = runtime.exec(string4);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String string5 = null;
                    while ((string5 = bufferedReader.readLine()) != null) {
                        System.out.println("new:" + string5);
                        string2 = string5.trim();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println("Exception getclustername FileAlterationListenerImpl15");
                }
            }
        }
        System.out.println("final c_name:" + string2);
        RGlobal.c_name = string2;
        return string2;
    }

    public void addFileToFilesList(File file) {
        String string = file.getAbsolutePath();
        FileDetails fileDetails = new FileDetails();
        String string2 = "0";
        int n = -1;
        try {
            if (file.length() >= 256L) {
                string2 = MD5Checksum.getMD5Checksum(string);
            } else if (file.length() > 0L && file.length() < 256L) {
                string2 = MD5Checksum.getMD5Checksum_len(string, (int)file.length());
                n = (int)file.length();
            }
        }
        catch (Exception exception) {
            Output.printTrace("Error while caliculating checksum of " + file, 1);
            exception.printStackTrace();
        }
        fileDetails.size = file.length();
        fileDetails.currentOffset = 0L;
        fileDetails.prevOffset = 0L;
        fileDetails.chunkid = 1L;
        fileDetails.chunkSize = file.length();
        fileDetails.checksum = string2;
        fileDetails.checksumlength = n;
        this.fileList.put(string, fileDetails);
        Output.printTrace("File added:" + string + " len:" + n, 3);
    }

    public class FileDetails {
        public Long size;
        public String checksum;
        public Long chunkid;
        public Long currentOffset;
        public Long prevOffset;
        public Long chunkSize;
        public int checksumlength;
        public Date firsttime;
        public Date lasttime;
        public Date lastModified;
    }
}

