/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.singletons;

import java.util.Vector;
import oracle.rat.tfa.type.FileType;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.xml.FileTypePatternXMLReader;

public class MatchFileTypes {
    private static MatchFileTypes instance = null;
    private Vector<FileType> fileTypes = new Vector();
    private Vector<FileType> oda_types = new Vector();
    private Vector<FileType> asm_types = new Vector();
    private Vector<FileType> non_asm_types = new Vector();
    private Vector<FileType> cell_exadata_types = new Vector();
    private Vector<FileType> dbwlm_types = new Vector();
    private Vector<FileType> acfs_types = new Vector();
    private boolean setupComplete = false;

    public static MatchFileTypes getInstance() {
        if (instance == null) {
            instance = new MatchFileTypes();
        }
        return instance;
    }

    private MatchFileTypes() {
        this.setup();
    }

    private void setup() {
        if (!this.setupComplete) {
            Output.printTrace("Start Read data patterns XML", 2);
            FileTypePatternXMLReader.processXML(this.fileTypes, Properties.fileTypesXml);
            Output.printTrace("End Read data patterns XML", 2);
            for (FileType fileType : this.fileTypes) {
                if (fileType.getComponent().equals("ASM")) {
                    this.asm_types.add(fileType);
                    continue;
                }
                if (fileType.getComponent().equals("ODA")) {
                    this.oda_types.add(fileType);
                    continue;
                }
                if (fileType.getComponent().equals("CELL")) {
                    this.cell_exadata_types.add(fileType);
                    continue;
                }
                if (fileType.getComponent().equals("DBWLM")) {
                    this.dbwlm_types.add(fileType);
                    continue;
                }
                if (fileType.getComponent().equals("ACFS")) {
                    this.acfs_types.add(fileType);
                    continue;
                }
                this.non_asm_types.add(fileType);
            }
            this.setupComplete = true;
        }
    }

    public Vector<FileType> getFileTypes() {
        return this.fileTypes;
    }

    public Vector<FileType> getASMFileTypes() {
        return this.asm_types;
    }

    public Vector<FileType> getODAFileTypes() {
        return this.oda_types;
    }

    public Vector<FileType> getNonASMFileTypes() {
        return this.non_asm_types;
    }

    public Vector<FileType> getCellExadataFileTypes() {
        return this.cell_exadata_types;
    }

    public Vector<FileType> getDBWLMFileTypes() {
        return this.dbwlm_types;
    }

    public Vector<FileType> getACFSFileTypes() {
        return this.acfs_types;
    }
}

