/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.singletons;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;

public class IgnoreFilesList {
    private static IgnoreFilesList instance;
    private Vector<String> patterns = new Vector();
    private boolean setupComplete = false;

    public static IgnoreFilesList getInstance() {
        if (instance == null) {
            instance = new IgnoreFilesList();
        }
        return instance;
    }

    private IgnoreFilesList() {
        this.setup();
    }

    private void setup() {
        if (!this.setupComplete) {
            Output.printTrace("Start setting up list of file name patterns to ignore", 3);
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(Properties.ignorePatternsFile));
                while ((string = bufferedReader.readLine()) != null) {
                    this.patterns.add(string);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.setupComplete = true;
        }
    }

    public boolean ignoreThisFile(String string) {
        this.setup();
        for (String string2 : this.patterns) {
            if (!Pattern.matches(string2, string)) continue;
            Output.printTrace("Skipping file due to pattern match: " + string2, 3);
            return true;
        }
        return false;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }
}

