/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.singletons;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;

public class IgnoreExtensions {
    private static IgnoreExtensions instance = null;
    private Vector<String> extensions = new Vector();
    private boolean setupComplete = false;

    public static IgnoreExtensions getInstance() {
        if (instance == null) {
            instance = new IgnoreExtensions();
        }
        return instance;
    }

    private IgnoreExtensions() {
        this.setup();
    }

    private void setup() {
        if (!this.setupComplete) {
            Output.printTrace("Start setting up array of file-extensions to ignore", 3);
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(Properties.extensionsFile));
                while ((string = bufferedReader.readLine()) != null) {
                    this.extensions.add(string);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.setupComplete = true;
        }
    }

    public boolean ignoreThisFile(String string) {
        this.setup();
        for (String string2 : this.extensions) {
            string2 = string2.startsWith(".") ? ".*\\" + string2.toUpperCase() + "$" : "%" + string2.toUpperCase() + "%";
            if (!Pattern.matches(string2, string.toUpperCase())) continue;
            Output.printTrace("Skip file due to ext : " + string2, 3);
            return true;
        }
        return false;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }
}

