/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.singletons;

import java.util.Vector;
import oracle.rat.tfa.TFADirectoryManager;
import oracle.rat.tfa.type.Component;
import oracle.rat.tfa.type.DirectoryMappingType;
import oracle.rat.tfa.type.DirectoryPattern;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.xml.ComponentXMLReader;
import oracle.rat.tfa.xml.DirectoryPatternXMLReader;

public class DirectoryMappings {
    private Vector directoryMappings = new Vector();
    private Vector<DirectoryPattern> validDirPatterns = new Vector();
    private Vector<Component> validComponents = new Vector();
    private Vector<Component> collectionComponents = null;
    private Vector<Component> actionComponents = null;
    private boolean setupComplete = false;

    public static DirectoryMappings getInstance() {
        return SingletonHolder.instance;
    }

    private DirectoryMappings() {
        this.setup();
    }

    public Vector getDirectories() {
        return this.directoryMappings;
    }

    private void setup() {
        if (!this.setupComplete) {
            Output.printTrace("Start Read directory_patterns.xml", 3);
            DirectoryPatternXMLReader.processXML(this.validDirPatterns);
            Output.printTrace("End Read directory_patterns.xml", 3);
            Output.printTrace("Start Read components.xml", 3);
            ComponentXMLReader.processXML(this.validComponents);
            Output.printTrace("End Read components.xml", 3);
            Output.printTrace("Start setting up array of directoryMappings", 3);
            this.directoryMappings = TFADirectoryManager.getDirectoryMappings();
            Output.printTrace("Done setting up array of directory mappings", 3);
            this.setupComplete = true;
        }
    }

    public Vector<DirectoryPattern> getValidDirectoryPatterns() {
        return this.validDirPatterns;
    }

    public Vector<Component> getValidComponents() {
        return this.validComponents;
    }

    public Vector<Component> getCollectionComponents() {
        if (this.collectionComponents == null) {
            this.collectionComponents = new Vector();
            for (Component component : this.validComponents) {
                if (!component.isCollection()) continue;
                this.collectionComponents.add(component);
            }
        }
        return this.collectionComponents;
    }

    public Vector<Component> getActionComponents() {
        if (this.actionComponents == null) {
            this.actionComponents = new Vector();
            for (Component component : this.validComponents) {
                if (!component.isAction()) continue;
                this.actionComponents.add(component);
            }
        }
        return this.actionComponents;
    }

    public void resetMappings() {
        this.directoryMappings = TFADirectoryManager.getDirectoryMappings();
    }

    public void dump() {
        for (DirectoryMappingType directoryMappingType : this.directoryMappings) {
            Output.print(directoryMappingType.directoryPath);
        }
    }

    public DirectoryMappingType lookForDirectory(String string) {
        this.setup();
        String string2 = string;
        String string3 = System.getProperty("os.name").toLowerCase();
        if (string3.indexOf("windows") < 0) {
            string2 = string2.replaceAll("\\\\", "/");
        }
        int n = Integer.MIN_VALUE;
        DirectoryMappingType directoryMappingType = null;
        for (DirectoryMappingType directoryMappingType2 : this.directoryMappings) {
            boolean bl = string2.contains(directoryMappingType2.directoryPath);
            if (!bl || n >= directoryMappingType2.directoryPath.length()) continue;
            n = directoryMappingType2.directoryPath.length();
            directoryMappingType = directoryMappingType2;
        }
        if (directoryMappingType != null) {
            return directoryMappingType;
        }
        return null;
    }

    public boolean lookForDeletedDirectory(String string) {
        this.setup();
        boolean bl = true;
        for (DirectoryMappingType directoryMappingType : this.directoryMappings) {
            if (!string.equals(directoryMappingType.directoryPath)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static class SingletonHolder {
        private static final DirectoryMappings instance = new DirectoryMappings();

        private SingletonHolder() {
        }
    }
}

