/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.singletons;

import com.sleepycat.je.Environment;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import oracle.rat.tfa.db.DbGet;
import oracle.rat.tfa.db.DbPut;

public class DbManager {
    private DbGet dbGet = new DbGet();
    private DbPut dbPut = new DbPut();
    private EntityStore es;
    private Environment env;

    public DbManager() {
        this.dbGet.setup();
        this.dbPut.setup();
        this.es = this.dbGet.getStore();
        this.env = this.dbGet.getEnvmnt();
    }

    public static DbManager getInstance() {
        return SingletonHolder.instance;
    }

    public DbGet getDbGet() {
        return this.dbGet;
    }

    public DbPut getDbPut() {
        return this.dbPut;
    }

    public void closeConnections() {
        try {
            this.es.close();
            this.env.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.es = null;
        this.env = null;
        this.dbGet = null;
        this.dbPut = null;
    }

    public EntityStore getEntityStore() {
        return this.es;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public PrimaryIndex getAllEntities(Class clazz) {
        return this.es.getPrimaryIndex(String.class, clazz);
    }

    private static class SingletonHolder {
        private static final DbManager instance = new DbManager();

        private SingletonHolder() {
        }
    }
}

