/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.receiver;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.net.ssl.SSLSocket;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.Action;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.receiver.RGlobal;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;

public class TransferFile
implements Runnable {
    private String sourceNode;
    private String sourceFilePath;
    private String fileSize;
    private String destBaseDir;
    private String dirTag;
    private InputStream is;
    private String cluster_name;
    private String user = "root";
    private static final int BUFFER_SIZE = 8192;

    public TransferFile() {
    }

    public TransferFile(String string, String string2, String string3, InputStream inputStream) {
        this(string, string2, string3);
        this.is = inputStream;
    }

    public TransferFile(String string, String string2, String string3, InputStream inputStream, String string4) {
        this(string, string2, string3);
        this.is = inputStream;
        this.cluster_name = string4;
    }

    public TransferFile(String string, String string2, String string3) {
        this.sourceNode = string;
        this.sourceFilePath = string2;
        this.fileSize = string3;
        this.dirTag = "collections";
        this.destBaseDir = RGlobal.kvStr.get("r.repository") + File.separator + this.dirTag;
    }

    public TransferFile(String string, String string2, String string3, String string4) {
        this.sourceNode = string;
        this.sourceFilePath = string2;
        this.fileSize = string3;
        this.dirTag = "collections";
        this.destBaseDir = string4;
    }

    public TransferFile(String string, String string2, String string3, String string4, InputStream inputStream, String string5) {
        this.sourceNode = string;
        this.sourceFilePath = string2;
        this.fileSize = string3;
        this.dirTag = "collections";
        this.destBaseDir = string4;
        this.is = inputStream;
        this.user = string5;
    }

    public TransferFile(String string, String string2, String string3, String string4, InputStream inputStream) {
        this.sourceNode = string;
        this.sourceFilePath = string2;
        this.fileSize = string3;
        this.dirTag = "collections";
        this.destBaseDir = string4;
        this.is = inputStream;
    }

    @Override
    public void run() {
        Output.printTrace("TransferFile.run(): Start", 3);
        Output.printTrace("sn,sfp,fs,dbd=" + this.sourceNode + "," + this.sourceFilePath + "," + this.fileSize + "," + this.destBaseDir, 3);
        this.doFileTransfer();
        Output.printTrace("TransferFile.run(): End", 3);
    }

    public void doFileTransfer() {
        String string = new Host().getHostname();
        String[] stringArray = this.sourceFilePath.split(File.separator);
        String string2 = null;
        String string3 = "NA";
        if (stringArray.length > 1) {
            string2 = this.destBaseDir + File.separator + stringArray[stringArray.length - 2];
            string2 = string2 + File.separator + stringArray[stringArray.length - 1];
            this.destBaseDir = this.destBaseDir + File.separator + stringArray[stringArray.length - 2];
            string3 = stringArray[stringArray.length - 2];
        } else {
            string2 = this.destBaseDir + File.separator + stringArray[stringArray.length - 1];
        }
        File file = new File(this.destBaseDir);
        try {
            Object object;
            Object object2;
            int n;
            if (!file.exists()) {
                file.mkdirs();
            }
            byte[] byArray = new byte[8192];
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            int n2 = 0;
            Output.printTrace("Reading from socket input stream of " + this.sourceNode + " to " + string2, 3);
            Output.printTrace("Transferring file of size : " + Long.valueOf(this.fileSize), 3);
            while ((n = this.is.read(byArray)) != -1 && Long.valueOf(this.fileSize) > (long)n2) {
                bufferedOutputStream.write(byArray, 0, n);
                bufferedOutputStream.flush();
                if ((long)(n2 += n) != Long.valueOf(this.fileSize)) continue;
            }
            Output.printTrace("Total number of bytes written : " + n2, 3);
            bufferedOutputStream.close();
            if (!this.user.equals("root")) {
                object2 = Runtime.getRuntime().exec("chmod 700 " + string2);
                ((Process)object2).waitFor();
                object = Runtime.getRuntime().exec("chown " + this.user + " " + string2);
                ((Process)object).waitFor();
            }
            if (new File(string2).exists() && !this.destBaseDir.contains("tfa_home")) {
                object2 = ":";
                object = "collection=" + string2 + (String)object2 + "source=" + this.sourceNode + (String)object2 + "destbase=" + this.destBaseDir + (String)object2 + "prefix=" + string3 + (String)object2 + "cluster_name=" + this.cluster_name;
                Action action = new Action("processcollection", string, "Collector", (String)object);
                action.store();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Output.printTrace("Can not create dest file: " + string2, 3);
            fileNotFoundException.printStackTrace();
        }
        catch (Exception exception) {
            Output.printTrace("Failed to transfer file: " + this.sourceFilePath, 3);
            exception.printStackTrace();
        }
    }

    public void doFileTransfer_old() {
        String string = new Host().getHostname();
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        String string2 = string + ":dodiagcollectiontransfer:" + this.sourceFilePath;
        String[] stringArray = this.sourceFilePath.split(File.separator);
        String string3 = null;
        if (stringArray.length > 1) {
            string3 = this.destBaseDir + File.separator + stringArray[stringArray.length - 2];
            string3 = string3 + File.separator + stringArray[stringArray.length - 1];
            this.destBaseDir = this.destBaseDir + File.separator + stringArray[stringArray.length - 2];
        } else {
            string3 = this.destBaseDir + File.separator + stringArray[stringArray.length - 1];
        }
        File file = new File(this.destBaseDir);
        try {
            if (!file.exists()) {
                file.mkdirs();
            }
            Properties.getInstance();
            String string4 = Properties.trustStore;
            Properties.getInstance();
            String string5 = Properties.trustStorePassword;
            sSLSocket = SocketManager.getSecureSocketConnection(this.sourceNode, Global.getSocketPort(), string4, string5);
            if (null == sSLSocket) {
                Output.printTrace("Unable to connect to node" + this.sourceNode, 3);
            } else {
                int n;
                InputStream inputStream = sSLSocket.getInputStream();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
                printWriter.println(string2);
                byte[] byArray = new byte[8192];
                FileOutputStream fileOutputStream = new FileOutputStream(string3);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                int n2 = 0;
                Output.printTrace("Reading from socket input stream of " + this.sourceNode + " to " + string3, 3);
                Output.printTrace("Transferring file of size : " + Long.valueOf(this.fileSize), 3);
                while ((n = inputStream.read(byArray)) != -1 && Long.valueOf(this.fileSize) > (long)n2) {
                    bufferedOutputStream.write(byArray, 0, n);
                    bufferedOutputStream.flush();
                    if ((long)(n2 += n) != Long.valueOf(this.fileSize)) continue;
                }
                Output.printTrace("Total number of bytes written : " + n2, 3);
                bufferedOutputStream.close();
                if (!sSLSocket.isClosed()) {
                    sSLSocket.close();
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Output.printTrace("Can not create dest file: " + string3, 3);
            fileNotFoundException.printStackTrace();
        }
        catch (Exception exception) {
            Output.printTrace("Failed to transfer file: " + this.sourceFilePath, 3);
            exception.printStackTrace();
        }
    }
}

