/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.receiver;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Deque;
import oracle.rat.tfa.receiver.RGlobal;
import oracle.rat.tfa.util.ConfigManager;
import oracle.rat.tfa.util.Output;

public class TFARRecordInfo {
    public String tfarfile = "NULL";
    public String nodename = "NULL";
    public String filename = "NULL";
    public String firsttime = "NULL";
    public String lasttime = "NULL";
    public String lastmodified = "NULL";
    public String filesize = "NULL";
    public String command = "NULL";
    public String prevoffset = "NULL";
    public String currentoffset = "NULL";
    public String chunkid = "NULL";
    public String chunksize = "NULL";
    public String filetype = "NULL";
    public String filetoWrite;
    public String dirtoWrite;
    File file = null;
    Deque<String> sharedQueue = null;
    public int num_of_lines = 0;
    BufferedWriter bw = null;
    static int seq_no = 0;
    static int maxlines = 1500;
    public String tfa_home = null;

    public TFARRecordInfo(String string) {
        String string2 = ConfigManager.getFromRConfigPropertiesFile("r.m_seq_no");
        seq_no = Integer.parseInt(string2);
        Output.printTrace("got m_seq_no:" + string2, 3);
        this.tfa_home = string;
        this.dirtoWrite = string + File.separator + "internal";
        this.filetoWrite = this.dirtoWrite + File.separator + "tfarrecordmeta_" + Integer.toString(seq_no) + ".info";
        this.file = new File(this.filetoWrite);
        this.num_of_lines = 0;
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
                this.bw = new BufferedWriter(new FileWriter(this.file, true));
            }
            catch (IOException iOException) {
                System.out.println("FIle creation Failed");
                iOException.printStackTrace();
            }
        } else {
            try {
                this.bw = new BufferedWriter(new FileWriter(this.file, true));
            }
            catch (IOException iOException) {
                System.out.println("File reader creation Failed");
                iOException.printStackTrace();
            }
        }
        RGlobal.m_seq_no = seq_no;
    }

    public void stop() {
        ConfigManager.set("r.m_seq_no", Integer.toString(seq_no), "INTEGER");
        Output.printTrace("stopping with seq_no:" + seq_no, 3);
    }

    public void write_to_file() {
        block5: {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("TFARFILE=" + this.tfarfile + ";");
                stringBuilder.append("NODENAME=" + this.nodename + ";");
                stringBuilder.append("FILETYPE=" + this.filetype + ";");
                stringBuilder.append("FIRSTTIME=" + this.firsttime + ";");
                stringBuilder.append("LASTTIME=" + this.lasttime + ";");
                stringBuilder.append("LASTMODIFIED=" + this.lastmodified + ";");
                stringBuilder.append("FILESIZE=" + this.filesize + ";");
                stringBuilder.append("FILENAME=" + this.filename + ";");
                stringBuilder.append("CURRENTOFFSET=" + this.currentoffset + ";");
                stringBuilder.append("PREVOFFSET=" + this.prevoffset + ";");
                stringBuilder.append("CHUNKID=" + this.chunkid + ";");
                stringBuilder.append("CHUNKSIZE=" + this.chunksize + ";");
                String string = stringBuilder.toString();
                this.bw.write(string);
                this.bw.newLine();
                this.bw.flush();
                ++this.num_of_lines;
                if (this.num_of_lines != maxlines) break block5;
                this.filetoWrite = this.dirtoWrite + File.separator + "tfarrecordmeta_" + Integer.toString(++seq_no) + ".info";
                this.file = new File(this.filetoWrite);
                if (!this.file.exists()) {
                    try {
                        this.bw.close();
                        this.file.createNewFile();
                        this.bw = new BufferedWriter(new FileWriter(this.file, true));
                    }
                    catch (IOException iOException) {
                        System.out.println("FIle creation Failed");
                        iOException.printStackTrace();
                    }
                }
                RGlobal.m_seq_no = seq_no;
                this.num_of_lines = 0;
            }
            catch (IOException iOException) {
                System.out.println("FIle write Failed");
                iOException.printStackTrace();
            }
        }
    }
}

