/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.receiver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import oracle.rat.tfa.receiver.CaseInsensitiveWhitespaceAnalyzer;
import oracle.rat.tfa.receiver.SearchHelper;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.DrillSideways;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.LongRangeFacetCounts;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.util.Version;

public class SearchWorkerThread
extends Thread {
    private Socket socket = null;
    private HashMap<String, SearchHelper> readers;
    private IndexReader ireader;
    private IndexSearcher isearcher;
    private TaxonomyReader treader;
    private SimpleDateFormat ft = new SimpleDateFormat("yyyyMMddHHmmssSSS");

    public SearchWorkerThread(Socket socket, Map<String, SearchHelper> map) {
        super("SearchWorkerThread");
        this.socket = socket;
        this.readers = (HashMap)map;
    }

    @Override
    public void run() {
        try {
            PrintWriter printWriter = new PrintWriter(this.socket.getOutputStream(), true);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            JsonReader jsonReader = Json.createReader((Reader)new InputStreamReader(this.socket.getInputStream()));
            JsonObject jsonObject = jsonReader.readObject();
            String string = jsonObject.getString("sr");
            long l = Long.parseLong(jsonObject.getString("access"));
            if (this.readers.containsKey(string)) {
                SearchHelper searchHelper = this.readers.get(string);
                this.ireader = searchHelper.getReader();
                this.isearcher = searchHelper.getSearcher();
                this.treader = searchHelper.getTaxoReader();
                searchHelper.setLastAccessedTime(l);
            } else {
                SearchHelper searchHelper = this.createReader(string, this.readers, l);
                this.ireader = searchHelper.getReader();
                this.isearcher = searchHelper.getSearcher();
                this.treader = searchHelper.getTaxoReader();
            }
            JsonObject jsonObject2 = null;
            try {
                jsonObject2 = this.get_query_result(jsonObject);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);
            jsonWriter.writeObject(jsonObject2);
            jsonWriter.close();
            printWriter.println(stringWriter.toString());
            this.socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private JsonObject get_query_result(JsonObject jsonObject) throws Exception {
        JsonArrayBuilder jsonArrayBuilder;
        DrillDownQuery drillDownQuery;
        CaseInsensitiveWhitespaceAnalyzer caseInsensitiveWhitespaceAnalyzer = new CaseInsensitiveWhitespaceAnalyzer(Version.LUCENE_47);
        long l = Long.parseLong(jsonObject.getString("from"));
        long l2 = Long.parseLong(jsonObject.getString("to"));
        int n = Integer.parseInt(jsonObject.getString("pagenum"));
        int n2 = Integer.parseInt(jsonObject.getString("context"));
        int n3 = Integer.parseInt(jsonObject.getString("paging"));
        String string = jsonObject.getString("s_op");
        String string2 = jsonObject.getString("fq");
        String string3 = jsonObject.getString("q");
        BooleanQuery booleanQuery = this.create_query(string3, l, l2, caseInsensitiveWhitespaceAnalyzer);
        FacetsConfig facetsConfig = new FacetsConfig();
        DrillDownQuery drillDownQuery2 = drillDownQuery = new DrillDownQuery(facetsConfig, (Query)booleanQuery);
        if (!string2.isEmpty()) {
            jsonArrayBuilder = this.create_facet_query(string2, drillDownQuery);
            drillDownQuery2 = jsonArrayBuilder;
        }
        jsonArrayBuilder = Json.createArrayBuilder();
        ArrayList<FacetResult> arrayList = new ArrayList<FacetResult>();
        this.get_facetresults(arrayList, (Query)drillDownQuery2, l, l2, jsonArrayBuilder);
        SortField sortField = new SortField("Time", SortField.Type.LONG, true);
        Sort sort = string.equals("sort_ta") ? new Sort(new SortField[]{new SortField("Time", SortField.Type.LONG), new SortField("Filepath", SortField.Type.STRING), new SortField("Linenumber", SortField.Type.LONG)}) : (string.equals("sort_td") ? new Sort(new SortField[]{new SortField("Time", SortField.Type.LONG, true), new SortField("Filepath", SortField.Type.LONG), new SortField("Linenumber", SortField.Type.LONG)}) : (string.equals("sort_rv") ? Sort.RELEVANCE : new Sort(new SortField[]{new SortField("Filepath", SortField.Type.LONG), new SortField("Time", SortField.Type.LONG), new SortField("Linenumber", SortField.Type.LONG)})));
        JsonObject jsonObject2 = this.doPagingSearch((Query)drillDownQuery2, n3, n, n2, caseInsensitiveWhitespaceAnalyzer, jsonArrayBuilder, sort);
        return jsonObject2;
    }

    private void get_facetresults(List<FacetResult> list, Query query, long l, long l2, JsonArrayBuilder jsonArrayBuilder) throws Exception {
        String[] stringArray = new String[6];
        stringArray[0] = "Time";
        stringArray[1] = "Hostname";
        stringArray[2] = "Database";
        stringArray[3] = "Instance";
        stringArray[4] = "Filetype";
        int n = 5;
        FacetResult facetResult = this.fsearch(query, l, l2);
        list.add(facetResult);
        this.fsearch1(list, query);
        for (int i = 0; i < n; ++i) {
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
            jsonObjectBuilder.add("Facet", stringArray[i]);
            FacetResult facetResult2 = list.get(i);
            if (facetResult2 != null) {
                LabelAndValue[] labelAndValueArray = facetResult2.labelValues;
                JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
                for (int j = 0; j < labelAndValueArray.length; ++j) {
                    jsonArrayBuilder2.add(Json.createObjectBuilder().add(labelAndValueArray[j].label, labelAndValueArray[j].value.toString()));
                }
                JsonArray jsonArray = jsonArrayBuilder2.build();
                jsonObjectBuilder = jsonObjectBuilder.add("values", (JsonValue)jsonArray);
            }
            jsonArrayBuilder.add(jsonObjectBuilder);
        }
    }

    private void fsearch1(List<FacetResult> list, Query query) throws Exception {
        FacetsConfig facetsConfig = new FacetsConfig();
        DrillSideways drillSideways = new DrillSideways(this.isearcher, facetsConfig, this.treader);
        DrillSideways.DrillSidewaysResult drillSidewaysResult = drillSideways.search((DrillDownQuery)query, 1000);
        list.add(drillSidewaysResult.facets.getTopChildren(1000, "Hostname", new String[0]));
        list.add(drillSidewaysResult.facets.getTopChildren(1000, "Database", new String[0]));
        list.add(drillSidewaysResult.facets.getTopChildren(1000, "Instance", new String[0]));
        list.add(drillSidewaysResult.facets.getTopChildren(1000, "Filetype", new String[0]));
    }

    public static Date get_start_interval(long l, String string) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        if (string.equals("year")) {
            ++n;
            n2 = 0;
            n3 = 1;
            n4 = 0;
            n5 = 0;
            n6 = 0;
        } else if (string.equals("month")) {
            ++n2;
            n3 = 1;
            n4 = 0;
            n5 = 0;
            n6 = 0;
        } else if (string.equals("week")) {
            n3 += 7;
        } else if (string.equals("day")) {
            ++n3;
            n4 = 0;
            n5 = 0;
            n6 = 0;
        } else if (string.equals("hour")) {
            ++n4;
            n5 = 0;
            n6 = 0;
        } else if (string.equals("minute")) {
            ++n5;
            n6 = 0;
        }
        calendar2.set(1, n);
        calendar2.set(2, n2);
        calendar2.set(5, n3);
        calendar2.set(11, n4);
        calendar2.set(12, n5);
        calendar2.set(13, n6);
        calendar2.set(14, 0);
        return calendar2.getTime();
    }

    public static String get_label(Date date, Date date2, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String string2 = "";
        if (string.equals("year")) {
            simpleDateFormat = new SimpleDateFormat("yyyy");
        } else if (string.equals("month")) {
            simpleDateFormat = new SimpleDateFormat("MMM yyyy");
        } else if (!string.equals("week")) {
            simpleDateFormat = string.equals("day") ? new SimpleDateFormat("dd MMM yyyy") : new SimpleDateFormat("yyyy MMM dd HH:mm:ss");
        }
        string2 = simpleDateFormat.format(date);
        return string2;
    }

    public static void create_range(List<LongRange> list, long l, long l2, long l3, String string) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String string2 = "";
        Date date = simpleDateFormat.parse(Long.toString(l));
        Date date2 = simpleDateFormat.parse(Long.toString(l2));
        Date date3 = simpleDateFormat.parse(Long.toString(l));
        long l4 = date.getTime();
        long l5 = date2.getTime();
        Date date4 = SearchWorkerThread.get_start_interval(l4, string);
        Calendar calendar = Calendar.getInstance();
        string2 = SearchWorkerThread.get_label(date, date4, string);
        list.add(new LongRange(string2, Long.parseLong(simpleDateFormat.format(date3)), true, Long.parseLong(simpleDateFormat.format(date4)), false));
        boolean bl = false;
        int n = 1;
        while (true) {
            String string3 = simpleDateFormat.format(date4);
            date3 = simpleDateFormat.parse(string3);
            calendar.setTimeInMillis(date3.getTime());
            if (string.equals("year")) {
                calendar.add(1, 1);
            } else if (string.equals("month")) {
                calendar.add(2, 1);
            } else if (string.equals("week")) {
                calendar.add(5, 7);
            } else if (string.equals("day")) {
                calendar.add(5, 1);
            } else if (string.equals("hour")) {
                calendar.add(11, 1);
            } else if (string.equals("minute")) {
                calendar.add(12, 1);
            } else {
                calendar.add(13, 1);
            }
            date4.setTime(calendar.getTimeInMillis());
            string2 = SearchWorkerThread.get_label(date3, date2, string);
            if (date4.getTime() >= l5) {
                string2 = SearchWorkerThread.get_label(date3, date2, string);
                date4 = date2;
                bl = true;
            }
            list.add(new LongRange(string2, Long.parseLong(simpleDateFormat.format(date3)), true, Long.parseLong(simpleDateFormat.format(date4)), false));
            if (bl) break;
            ++n;
        }
    }

    private FacetResult fsearch(Query query, long l, long l2) throws Exception {
        long l3 = 1000L;
        long l4 = 60L * l3;
        long l5 = 60L * l4;
        long l6 = 24L * l5;
        long l7 = 7L * l6;
        long l8 = 30L * l6;
        long l9 = 365L * l6;
        long l10 = l;
        long l11 = l2;
        Date date = this.ft.parse(Long.toString(l10));
        Date date2 = this.ft.parse(Long.toString(l11));
        long l12 = (date2.getTime() - date.getTime()) / l6;
        ArrayList<LongRange> arrayList = new ArrayList<LongRange>();
        if (l12 > 2000L) {
            SearchWorkerThread.create_range(arrayList, l10, l11, l9, "year");
        } else if (l12 <= 2000L && l12 > 365L) {
            SearchWorkerThread.create_range(arrayList, l10, l11, l8, "month");
        } else if (l12 <= 365L && l12 > 30L) {
            SearchWorkerThread.create_range(arrayList, l10, l11, l7, "week");
        } else if (l12 <= 30L && l12 > 4L) {
            SearchWorkerThread.create_range(arrayList, l10, l11, l6, "day");
        } else if (l12 <= 4L && (double)l12 > 0.1) {
            SearchWorkerThread.create_range(arrayList, l10, l11, l5, "hour");
        } else {
            SearchWorkerThread.create_range(arrayList, l10, l11, l4, "minute");
        }
        if (query == null) {
            query = new MatchAllDocsQuery();
        }
        FacetsCollector facetsCollector = new FacetsCollector();
        FacetsCollector.search((IndexSearcher)this.isearcher, (Query)query, (int)100, (Collector)facetsCollector);
        LongRange[] longRangeArray = new LongRange[arrayList.size()];
        arrayList.toArray(longRangeArray);
        LongRangeFacetCounts longRangeFacetCounts = new LongRangeFacetCounts("Time", facetsCollector, longRangeArray);
        return longRangeFacetCounts.getTopChildren(100, "Time", new String[0]);
    }

    private DrillDownQuery create_facet_query(String string, DrillDownQuery drillDownQuery) {
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            String[] stringArray3 = stringArray2[1].split(",");
            for (int j = 0; j < stringArray3.length; ++j) {
                drillDownQuery.add(stringArray2[0], new String[]{stringArray3[j]});
            }
        }
        return drillDownQuery;
    }

    private BooleanQuery create_query(String string, long l, long l2, Analyzer analyzer) throws Exception {
        QueryParser queryParser = new QueryParser(Version.LUCENE_40, "Contents", analyzer);
        BooleanQuery booleanQuery = new BooleanQuery();
        Query query = null;
        if ((string = string.toLowerCase()).endsWith("\"")) {
            System.out.println("Query ends with quote");
        } else {
            string = QueryParser.escape((String)string);
            string = string + "*";
        }
        query = queryParser.parse(string);
        NumericRangeQuery numericRangeQuery = NumericRangeQuery.newLongRange((String)"Time", (Long)l, (Long)l2, (boolean)true, (boolean)false);
        booleanQuery.add(query, BooleanClause.Occur.MUST);
        booleanQuery.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        return booleanQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchHelper createReader(String string, HashMap<String, SearchHelper> hashMap, long l) {
        SearchHelper searchHelper = new SearchHelper(string, l);
        SearchWorkerThread searchWorkerThread = this;
        synchronized (searchWorkerThread) {
            this.readers.put(string, searchHelper);
        }
        return searchHelper;
    }

    public JsonObject doPagingSearch(Query query, int n, int n2, int n3, Analyzer analyzer, JsonArrayBuilder jsonArrayBuilder, Sort sort) throws IOException {
        TopFieldDocs topFieldDocs = this.isearcher.search(query, 1 + n2 * n, sort);
        ScoreDoc[] scoreDocArray = topFieldDocs.scoreDocs;
        int n4 = topFieldDocs.totalHits;
        int n5 = (n2 - 1) * n;
        int n6 = Math.min(n4, n2 * n);
        JsonObject jsonObject = null;
        JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
        n6 = Math.min(scoreDocArray.length, n5 + n);
        int n7 = -1;
        String string = "";
        String string2 = "";
        for (int i = n5; i < n6; ++i) {
            Document document = this.isearcher.doc(scoreDocArray[i].doc);
            try {
                string2 = document.get("Filepath");
                if (!string.equals(string2)) {
                    n7 = -1;
                }
                this.addContextDocs(jsonArrayBuilder2, document, n3, analyzer, n7);
                String string3 = document.get("Linenumber");
                string = string2;
                n7 = Integer.parseInt(string3);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        jsonObject = this.get_json_output(jsonArrayBuilder, jsonArrayBuilder2, n6 - n5);
        return jsonObject;
    }

    private JsonObject get_json_output(JsonArrayBuilder jsonArrayBuilder, JsonArrayBuilder jsonArrayBuilder2, int n) {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        JsonArray jsonArray = jsonArrayBuilder.build();
        JsonArray jsonArray2 = jsonArrayBuilder2.build();
        jsonObjectBuilder.add("Facets", (JsonValue)jsonArray);
        jsonObjectBuilder.add("Hits", n);
        jsonObjectBuilder.add("Results", (JsonValue)jsonArray2);
        JsonObject jsonObject = jsonObjectBuilder.build();
        return jsonObject;
    }

    private void addContextDocs(JsonArrayBuilder jsonArrayBuilder, Document document, int n, Analyzer analyzer, int n2) throws Exception {
        long l;
        String string = document.get("Linenumber");
        String string2 = document.get("Fid");
        Long l2 = Long.parseLong(string);
        int n3 = n / 2;
        Long l3 = Math.max(1L, l2 - (long)n3);
        Long l4 = l2 + (long)n3;
        if (n2 > 0) {
            l = l2 - (long)(n2 + n3 + 1);
            l3 = l <= 0L ? Long.valueOf(l2 - l) : (l <= (long)n3 ? Long.valueOf(l2 - l) : Long.valueOf(l2 - (long)n3));
            long l5 = l2 + (long)n3 - l3;
            l4 = l5 < 0L ? Long.valueOf(l2 + l5) : (l5 >= (long)n3 ? Long.valueOf(l2 + (long)n3) : Long.valueOf(l3 + l5));
        }
        l = l4 - l3 + 1L;
        BooleanQuery booleanQuery = new BooleanQuery();
        QueryParser queryParser = new QueryParser(Version.LUCENE_40, "Fid", analyzer);
        Query query = queryParser.parse(string2);
        NumericRangeQuery numericRangeQuery = NumericRangeQuery.newLongRange((String)"Linenumber", (Long)l3, (Long)l4, (boolean)true, (boolean)true);
        booleanQuery.add(query, BooleanClause.Occur.MUST);
        booleanQuery.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        TopFieldDocs topFieldDocs = this.isearcher.search((Query)booleanQuery, 10, new Sort(new SortField[]{new SortField("Linenumber", SortField.Type.LONG)}));
        int n4 = topFieldDocs.totalHits;
        ScoreDoc[] scoreDocArray = topFieldDocs.scoreDocs;
        long l6 = Math.min((long)n4, l);
        int n5 = 0;
        while ((long)n5 < l6) {
            Document document2 = this.isearcher.doc(scoreDocArray[n5].doc);
            this.addToJsonArray(jsonArrayBuilder, document2);
            ++n5;
        }
    }

    public void addToJsonArray(JsonArrayBuilder jsonArrayBuilder, Document document) throws IOException {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("ID", document.get("ID"));
        jsonObjectBuilder.add("Fid", document.get("Fid"));
        jsonObjectBuilder.add("Linenumber", document.get("Linenumber"));
        jsonObjectBuilder.add("Filepath", document.get("Filepath"));
        jsonObjectBuilder.add("Filename", document.get("Filename"));
        jsonObjectBuilder.add("Time", document.get("Time"));
        jsonObjectBuilder.add("Contents", document.get("Contents"));
        jsonArrayBuilder.add(jsonObjectBuilder);
    }
}

