/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.receiver;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.stream.JsonParser;
import oracle.rat.tfa.receiver.CaseInsensitiveWhitespaceAnalyzer;
import oracle.rat.tfa.receiver.SetOps;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.DrillSideways;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.LongRangeFacetCounts;
import org.apache.lucene.facet.taxonomy.FastTaxonomyFacetCounts;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PrefixFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class SearchJsonReceiver {
    private IndexSearcher isearcher;
    private TaxonomyReader treader;
    private SimpleDateFormat ft = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private String facet_name;
    public IndexReader reader = null;
    public TaxonomyReader taxoReader = null;

    public SearchJsonReceiver(String string) {
        String string2 = string;
        String string3 = string2 + "_t";
        String string4 = "Contents";
        this.reader = null;
        this.taxoReader = null;
        try {
            this.reader = DirectoryReader.open((Directory)FSDirectory.open((File)new File(string2)));
            this.taxoReader = new DirectoryTaxonomyReader((Directory)FSDirectory.open((File)new File(string3)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        IndexSearcher indexSearcher = new IndexSearcher(this.reader);
        this.isearcher = new IndexSearcher(this.reader);
        this.treader = this.taxoReader;
    }

    public void setFacetName(String string) {
        this.facet_name = string;
    }

    public String get_result(String string) {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(string));
        JsonObject jsonObject = jsonReader.readObject();
        JsonObject jsonObject2 = null;
        try {
            jsonObject2 = this.get_query_result(jsonObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);
        jsonWriter.writeObject(jsonObject2);
        jsonWriter.close();
        return stringWriter.toString();
    }

    public JsonObject get_result_injobj(String string) {
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(string));
        JsonObject jsonObject = jsonReader.readObject();
        JsonObject jsonObject2 = null;
        try {
            jsonObject2 = this.get_query_result(jsonObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jsonObject2;
    }

    public JsonObject get_val_json(String string) {
        string = string.substring(1, string.length() - 1);
        String[] stringArray = string.split(",");
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].lastIndexOf(58);
            String string2 = stringArray[i].substring(0, n);
            String string3 = stringArray[i].substring(n + 1);
            string3 = string3.replace('-', ',');
            jsonObjectBuilder.add(string2, string3);
        }
        JsonObject jsonObject = jsonObjectBuilder.build();
        return jsonObject;
    }

    private String getValue(JsonObject jsonObject, String string) {
        String string2 = "";
        try {
            string2 = jsonObject.getString(string);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return string2;
    }

    private String getLongTimeValue(JsonObject jsonObject, String string) {
        String string2 = "20150101000000000";
        try {
            string2 = jsonObject.getString(string);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return string2;
    }

    private String getLongValue(JsonObject jsonObject, String string) {
        String string2 = "0";
        try {
            string2 = jsonObject.getString(string);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return string2;
    }

    private String getIntValue(JsonObject jsonObject, String string) {
        String string2 = "1";
        try {
            string2 = jsonObject.getString(string);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return string2;
    }

    public ArrayList<Document> get_jsonq_res(String string) {
        ScoreDoc[] scoreDocArray;
        String string2;
        JsonParser.Event event;
        StringReader stringReader = new StringReader(string);
        JsonParser jsonParser = Json.createParser((Reader)stringReader);
        String string3 = null;
        FacetsConfig facetsConfig = new FacetsConfig();
        DrillDownQuery drillDownQuery = new DrillDownQuery(facetsConfig);
        while (jsonParser.hasNext()) {
            event = jsonParser.next();
            switch (event) {
                case KEY_NAME: {
                    string3 = jsonParser.getString().trim();
                    break;
                }
                case VALUE_STRING: {
                    string2 = jsonParser.getString().trim();
                    if (string3.startsWith("_req_")) break;
                    drillDownQuery.add(string3, new String[]{string2});
                    break;
                }
                case VALUE_NUMBER: {
                    scoreDocArray = Long.valueOf(jsonParser.getLong());
                    break;
                }
                case VALUE_FALSE: {
                    break;
                }
                case VALUE_TRUE: {
                    break;
                }
                case VALUE_NULL: {
                    break;
                }
            }
        }
        jsonParser.close();
        event = drillDownQuery;
        string2 = null;
        try {
            string2 = this.isearcher.search((Query)event, 10000);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        scoreDocArray = ((TopDocs)string2).scoreDocs;
        int n = ((TopDocs)string2).totalHits;
        int n2 = 0;
        int n3 = Math.min(scoreDocArray.length, 10000);
        ArrayList<Document> arrayList = new ArrayList<Document>();
        for (int i = n2; i < n3; ++i) {
            Document document = null;
            try {
                document = this.isearcher.doc(scoreDocArray[i].doc);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            arrayList.add(document);
        }
        return arrayList;
    }

    private JsonObject get_query_result(JsonObject jsonObject) throws Exception {
        JsonObject jsonObject2;
        NumericRangeQuery numericRangeQuery;
        JsonArrayBuilder jsonArrayBuilder;
        BooleanQuery booleanQuery;
        CaseInsensitiveWhitespaceAnalyzer caseInsensitiveWhitespaceAnalyzer = new CaseInsensitiveWhitespaceAnalyzer(Version.LUCENE_47);
        long l = Long.parseLong(this.getLongTimeValue(jsonObject, "from"));
        long l2 = Long.parseLong(this.getLongTimeValue(jsonObject, "to"));
        long l3 = Long.parseLong(this.getLongTimeValue(jsonObject, "ifrom"));
        long l4 = Long.parseLong(this.getLongTimeValue(jsonObject, "ito"));
        int n = Integer.parseInt(this.getIntValue(jsonObject, "pagenum"));
        String string = Long.toString(l);
        String string2 = Long.toString(l3);
        String string3 = Long.toString(l2);
        String string4 = Long.toString(l4);
        String string5 = Integer.toString(n);
        int n2 = Integer.parseInt(this.getIntValue(jsonObject, "nchildren"));
        if (n2 == 1) {
            n2 = 100;
        }
        int n3 = Integer.parseInt(this.getIntValue(jsonObject, "paging"));
        String string6 = Integer.toString(n3);
        String string7 = this.getValue(jsonObject, "s_op");
        String string8 = this.getValue(jsonObject, "fq");
        String string9 = this.getValue(jsonObject, "nfq");
        String string10 = this.getValue(jsonObject, "nfacet");
        String string11 = this.getValue(jsonObject, "q");
        String string12 = this.getValue(jsonObject, "facet_name");
        String string13 = this.getValue(jsonObject, "facet_names");
        String string14 = this.getValue(jsonObject, "aq");
        String string15 = this.getValue(jsonObject, "fetchpath");
        String string16 = this.getValue(jsonObject, "prefix_key");
        String string17 = this.getValue(jsonObject, "prefix_val");
        String string18 = this.getValue(jsonObject, "fp_fname");
        String string19 = this.getValue(jsonObject, "fetchclusters");
        String string20 = this.getValue(jsonObject, "getfacets");
        String string21 = this.getValue(jsonObject, "specialquery");
        String string22 = this.getValue(jsonObject, "nofacets");
        String string23 = this.getValue(jsonObject, "notimefacet");
        long l5 = Long.parseLong(this.getLongValue(jsonObject, "currentOffsetstart"));
        long l6 = Long.parseLong(this.getLongValue(jsonObject, "currentOffsetend"));
        long l7 = Long.parseLong(this.getLongValue(jsonObject, "chunkidstart"));
        long l8 = Long.parseLong(this.getLongValue(jsonObject, "chunkidend"));
        long l9 = Long.parseLong(this.getLongValue(jsonObject, "prevOffsetstart"));
        long l10 = Long.parseLong(this.getLongValue(jsonObject, "prevOffsetend"));
        long l11 = Long.parseLong(this.getLongValue(jsonObject, "lineNumberstart"));
        long l12 = Long.parseLong(this.getLongValue(jsonObject, "lineNumberend"));
        if (jsonObject.containsKey((Object)"specialquery")) {
            if (string21.contains("allhosts")) {
                return this.fillAllHosts(string, string3, string5, string6);
            }
            if (string21.contains("allclusters")) {
                return this.fillAllClusters(string, string3, string5, string6);
            }
            if (string21.contains("alldcs")) {
                return this.fillAllDCs(string, string3, string5, string6);
            }
            if (string21.contains("perdc")) {
                String[] stringArray = string21.split("=");
                return this.fillClustersinDC(stringArray[1].trim(), string, string3, string5, string6);
            }
            if (string21.contains("percluster")) {
                String[] stringArray = string21.split("=");
                return this.fillNodesinCluster(stringArray[1].trim(), string, string3, string5, string6);
            }
            if (string21.equals("treemapsclusters")) {
                return this.fillAllClustersTreemap(string, string3, string5, string6);
            }
            if (string21.equals("treemapsclusters2")) {
                return this.fillAllClustersTreemap2(string, string3, string5, string6);
            }
            if (string21.equals("listclustersbymetrics")) {
                return this.fillAllClustersList(string, string3, string5, string6);
            }
            if (string21.equals("cpumemorymetrics")) {
                return this.fillAllClusterscpumem(string, string3, string5, string6);
            }
        }
        boolean bl = false;
        if (jsonObject.containsKey((Object)"ifrom")) {
            bl = true;
            booleanQuery = this.create_iquery(string11, l3, l4, caseInsensitiveWhitespaceAnalyzer, string14);
            l = l3;
            l2 = l4;
        } else {
            booleanQuery = this.create_query(string11, l, l2, caseInsensitiveWhitespaceAnalyzer, string14, jsonObject);
        }
        if (jsonObject.containsKey((Object)"currentOffsetstart")) {
            booleanQuery.add((Query)NumericRangeQuery.newLongRange((String)"currentOffset", (Long)l5, (Long)l6, (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
        }
        if (jsonObject.containsKey((Object)"chunkidstart")) {
            booleanQuery.add((Query)NumericRangeQuery.newLongRange((String)"chunkid", (Long)l7, (Long)l8, (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
        }
        if (jsonObject.containsKey((Object)"prevOffsetstart")) {
            booleanQuery.add((Query)NumericRangeQuery.newLongRange((String)"prevOffset", (Long)l9, (Long)l10, (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
        }
        if (jsonObject.containsKey((Object)"lineNumberstart")) {
            booleanQuery.add((Query)NumericRangeQuery.newLongRange((String)"LineNumber", (Long)l11, (Long)l12, (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
        }
        FacetsConfig facetsConfig = new FacetsConfig();
        DrillDownQuery drillDownQuery = new DrillDownQuery(facetsConfig, (Query)booleanQuery);
        if (!jsonObject.containsKey((Object)"q") && (jsonObject.containsKey((Object)"from") || jsonObject.containsKey((Object)"proc_nfq"))) {
            jsonArrayBuilder = new BooleanQuery();
            if (jsonObject.containsKey((Object)"from")) {
                numericRangeQuery = bl ? NumericRangeQuery.newLongRange((String)"ITime", (Long)l, (Long)l2, (boolean)true, (boolean)false) : NumericRangeQuery.newLongRange((String)"Time", (Long)l, (Long)l2, (boolean)true, (boolean)false);
                jsonArrayBuilder.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
            }
            if (!string9.isEmpty()) {
                if (!string8.isEmpty() || !string10.isEmpty()) {
                    jsonArrayBuilder = this.create_facet_bool_query(string8, (BooleanQuery)jsonArrayBuilder);
                }
                jsonArrayBuilder = this.create_nfacet_query(string9, (BooleanQuery)jsonArrayBuilder);
            }
            drillDownQuery = new DrillDownQuery(facetsConfig, (Query)jsonArrayBuilder);
        }
        DrillDownQuery drillDownQuery2 = drillDownQuery;
        if (!string8.isEmpty() && string9.isEmpty()) {
            jsonArrayBuilder = this.create_facet_query(string8, drillDownQuery);
            drillDownQuery2 = jsonArrayBuilder;
        }
        jsonArrayBuilder = Json.createArrayBuilder();
        numericRangeQuery = new ArrayList();
        if (string18.isEmpty()) {
            string18 = "_mpath";
        }
        if (jsonObject.containsKey((Object)"fetchpath")) {
            this.get_fetchpath((List<FacetResult>)numericRangeQuery, l, l2, jsonArrayBuilder, n2, string15, string8, string18, string16, string17, string9);
            if (!jsonObject.containsKey((Object)"q")) {
                JsonObject jsonObject3 = this.buildJson(jsonArrayBuilder, "Facets");
                return jsonObject3;
            }
        }
        if (jsonObject.containsKey((Object)"fetchclusters")) {
            this.get_fetchclusters((List<FacetResult>)numericRangeQuery, l, l2, jsonArrayBuilder, n2, string19, string8);
            jsonObject2 = this.buildJson(jsonArrayBuilder, "Facets");
            if (!jsonObject.containsKey((Object)"q")) {
                return jsonObject2;
            }
        }
        if (jsonObject.containsKey((Object)"getfacets")) {
            this.getfacets((List<FacetResult>)numericRangeQuery, l, l2, jsonArrayBuilder, (Query)drillDownQuery2);
            jsonObject2 = this.buildJson(jsonArrayBuilder, "Facets");
            return jsonObject2;
        }
        if (!(string22.equals("true") || jsonObject.containsKey((Object)"fetchclusters") || jsonObject.containsKey((Object)"fetchpath"))) {
            if (!jsonObject.containsKey((Object)"q")) {
                this.get_facetresults((List<FacetResult>)numericRangeQuery, (Query)drillDownQuery2, l, l2, jsonArrayBuilder, string12, n2, bl, string13, jsonObject);
            } else {
                this.get_facetresults((List<FacetResult>)numericRangeQuery, (Query)drillDownQuery2, l, l2, jsonArrayBuilder, string12, n2, bl, string13, jsonObject);
            }
            if (!string12.isEmpty()) {
                jsonObject2 = this.buildJson(jsonArrayBuilder, "Facets");
                return jsonObject2;
            }
            if (!string13.isEmpty()) {
                jsonObject2 = this.buildJson(jsonArrayBuilder, "Facets");
                return jsonObject2;
            }
            if (!jsonObject.containsKey((Object)"q")) {
                jsonObject2 = this.buildJson(jsonArrayBuilder, "Facets");
                return jsonObject2;
            }
        }
        SortField sortField = new SortField("Time", SortField.Type.LONG, true);
        jsonObject2 = string7.equals("sort_ta") ? (bl ? new Sort(new SortField[]{new SortField("ITime", SortField.Type.LONG), new SortField("Filepath", SortField.Type.STRING), new SortField("LineNumber", SortField.Type.LONG)}) : new Sort(new SortField[]{new SortField("Time", SortField.Type.LONG), new SortField("Filepath", SortField.Type.STRING), new SortField("LineNumber", SortField.Type.LONG)})) : (string7.equals("sort_td") ? (bl ? new Sort(new SortField[]{new SortField("ITime", SortField.Type.LONG, true), new SortField("Filepath", SortField.Type.LONG), new SortField("LineNumber", SortField.Type.LONG)}) : new Sort(new SortField[]{new SortField("Time", SortField.Type.LONG, true), new SortField("Filepath", SortField.Type.LONG), new SortField("LineNumber", SortField.Type.LONG)})) : (string7.equals("sort_ita") ? new Sort(new SortField[]{new SortField("ITime", SortField.Type.LONG), new SortField("Filepath", SortField.Type.LONG), new SortField("LineNumber", SortField.Type.LONG)}) : (string7.equals("sort_itd") ? new Sort(new SortField[]{new SortField("ITime", SortField.Type.LONG, true), new SortField("Filepath", SortField.Type.LONG), new SortField("LineNumber", SortField.Type.LONG)}) : (string7.equals("sort_rv") ? Sort.RELEVANCE : new Sort(new SortField[]{new SortField("Filepath", SortField.Type.LONG), new SortField("Time", SortField.Type.LONG), new SortField("LineNumber", SortField.Type.LONG)})))));
        JsonObject jsonObject4 = this.doPagingSearch((Query)drillDownQuery2, n3, n, caseInsensitiveWhitespaceAnalyzer, jsonArrayBuilder, (Sort)jsonObject2, string16, string17);
        return jsonObject4;
    }

    private void getfacets(List<FacetResult> list, long l, long l2, JsonArrayBuilder jsonArrayBuilder, Query query) throws Exception {
        FacetsConfig facetsConfig = new FacetsConfig();
        DrillSideways drillSideways = new DrillSideways(this.isearcher, facetsConfig, this.treader);
        DrillSideways.DrillSidewaysResult drillSidewaysResult = drillSideways.search((DrillDownQuery)query, 5000);
        List list2 = drillSidewaysResult.facets.getAllDims(100);
        for (int i = 0; i < list2.size(); ++i) {
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
            FacetResult facetResult = (FacetResult)list2.get(i);
            if (facetResult != null) {
                jsonObjectBuilder.add("Facet", facetResult.dim);
                jsonObjectBuilder.add("name", facetResult.dim);
            }
            jsonArrayBuilder.add(jsonObjectBuilder);
        }
    }

    private Query get_fetchpath(List<FacetResult> list, long l, long l2, JsonArrayBuilder jsonArrayBuilder, int n, String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        String[] stringArray;
        DrillDownQuery drillDownQuery;
        FacetsCollector facetsCollector = new FacetsCollector();
        FacetsConfig facetsConfig = new FacetsConfig();
        facetsConfig.setIndexFieldName("_mfname", "Filename_p");
        facetsConfig.setIndexFieldName("_mpath", "facet_path");
        facetsConfig.setIndexFieldName("_mdash", "facet_dpath");
        facetsConfig.setIndexFieldName("_mcpath", "facet_cpath");
        facetsConfig.setIndexFieldName("_mepath", "facet_epath");
        facetsConfig.setIndexFieldName("_mhhost", "facet_host");
        facetsConfig.setIndexFieldName("_mhftype", "facet_ftype");
        facetsConfig.setHierarchical("_mpath", true);
        facetsConfig.setHierarchical("_mdash", true);
        facetsConfig.setHierarchical("_mcpath", true);
        facetsConfig.setHierarchical("_mepath", true);
        facetsConfig.setHierarchical("_mhhost", true);
        facetsConfig.setHierarchical("_mhftype", true);
        BooleanQuery booleanQuery = new BooleanQuery();
        if (!string6.isEmpty()) {
            booleanQuery = this.create_nfacet_query(string6, booleanQuery);
            drillDownQuery = new DrillDownQuery(facetsConfig, (Query)booleanQuery);
        } else {
            drillDownQuery = new DrillDownQuery(facetsConfig);
        }
        DrillDownQuery drillDownQuery2 = this.create_facet_query(string2, drillDownQuery);
        PrefixFilter prefixFilter = new PrefixFilter(new Term(string4, string5));
        if (string4.isEmpty()) {
            FacetsCollector.search((IndexSearcher)this.isearcher, (Query)drillDownQuery2, (int)100, (Collector)facetsCollector);
        } else {
            FacetsCollector.search((IndexSearcher)this.isearcher, (Query)drillDownQuery2, (Filter)prefixFilter, (int)100, (Collector)facetsCollector);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string7 : stringArray = string.split("/")) {
            if (string7.isEmpty()) continue;
            arrayList.add(string7);
        }
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        FastTaxonomyFacetCounts fastTaxonomyFacetCounts = string3.equals("_mhhost") ? new FastTaxonomyFacetCounts("facet_host", this.treader, facetsConfig, facetsCollector) : (string3.equals("_mhftype") ? new FastTaxonomyFacetCounts("facet_ftype", this.treader, facetsConfig, facetsCollector) : (string3.equals("_mcpath") ? new FastTaxonomyFacetCounts("facet_cpath", this.treader, facetsConfig, facetsCollector) : (string3.equals("_mepath") ? new FastTaxonomyFacetCounts("facet_epath", this.treader, facetsConfig, facetsCollector) : (string3.equals("_mdash") ? new FastTaxonomyFacetCounts("facet_dpath", this.treader, facetsConfig, facetsCollector) : new FastTaxonomyFacetCounts("facet_path", this.treader, facetsConfig, facetsCollector)))));
        FacetResult facetResult = fastTaxonomyFacetCounts.getTopChildren(n, string3, stringArray2);
        list.add(facetResult);
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
            FacetResult facetResult2 = list.get(i);
            if (facetResult2 != null) {
                jsonObjectBuilder.add("Facet", facetResult2.dim);
                LabelAndValue[] labelAndValueArray = facetResult2.labelValues;
                JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
                for (int j = 0; j < labelAndValueArray.length; ++j) {
                    jsonArrayBuilder2.add(Json.createObjectBuilder().add(labelAndValueArray[j].label, labelAndValueArray[j].value.toString()));
                }
                JsonArray jsonArray = jsonArrayBuilder2.build();
                jsonObjectBuilder = jsonObjectBuilder.add("values", (JsonValue)jsonArray);
            }
            jsonArrayBuilder.add(jsonObjectBuilder);
        }
        return drillDownQuery2;
    }

    private void get_fetchclusters(List<FacetResult> list, long l, long l2, JsonArrayBuilder jsonArrayBuilder, int n, String string, String string2) throws Exception {
        String[] stringArray;
        FacetsCollector facetsCollector = new FacetsCollector();
        FacetsConfig facetsConfig = new FacetsConfig();
        facetsConfig.setIndexFieldName("_mcluster", "facet_cluster");
        facetsConfig.setHierarchical("_mcluster", true);
        DrillDownQuery drillDownQuery = new DrillDownQuery(facetsConfig);
        DrillDownQuery drillDownQuery2 = this.create_facet_query(string2, drillDownQuery);
        FacetsCollector.search((IndexSearcher)this.isearcher, (Query)drillDownQuery2, (int)10, (Collector)facetsCollector);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : stringArray = string.split("/")) {
            if (string3.isEmpty()) continue;
            arrayList.add(string3);
        }
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        FastTaxonomyFacetCounts fastTaxonomyFacetCounts = new FastTaxonomyFacetCounts("facet_cluster", this.treader, facetsConfig, facetsCollector);
        FacetResult facetResult = fastTaxonomyFacetCounts.getTopChildren(n, "_mcluster", stringArray2);
        list.add(facetResult);
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
            FacetResult facetResult2 = list.get(i);
            if (facetResult2 != null) {
                jsonObjectBuilder.add("Facet", facetResult2.dim);
                LabelAndValue[] labelAndValueArray = facetResult2.labelValues;
                JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
                for (int j = 0; j < labelAndValueArray.length; ++j) {
                    jsonArrayBuilder2.add(Json.createObjectBuilder().add(labelAndValueArray[j].label, labelAndValueArray[j].value.toString()));
                }
                JsonArray jsonArray = jsonArrayBuilder2.build();
                jsonObjectBuilder = jsonObjectBuilder.add("values", (JsonValue)jsonArray);
            }
            jsonArrayBuilder.add(jsonObjectBuilder);
        }
    }

    private void get_facetresults(List<FacetResult> list, Query query, long l, long l2, JsonArrayBuilder jsonArrayBuilder, String string, int n, boolean bl, String string2, JsonObject jsonObject) throws Exception {
        FacetResult facetResult = null;
        if (jsonObject.containsKey((Object)"from") && !jsonObject.containsKey((Object)"notimefacet")) {
            facetResult = this.fsearch(query, l, l2, bl);
        }
        if (string.isEmpty() && string2.isEmpty() && jsonObject.containsKey((Object)"from")) {
            list.add(facetResult);
        }
        int n2 = this.fsearch1(list, query, string, n, string2);
        for (int i = 0; i < list.size(); ++i) {
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
            FacetResult facetResult2 = list.get(i);
            if (facetResult2 != null) {
                jsonObjectBuilder.add("Facet", facetResult2.dim);
                LabelAndValue[] labelAndValueArray = facetResult2.labelValues;
                JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
                for (int j = 0; j < labelAndValueArray.length; ++j) {
                    jsonArrayBuilder2.add(Json.createObjectBuilder().add(labelAndValueArray[j].label, labelAndValueArray[j].value.toString()));
                }
                JsonArray jsonArray = jsonArrayBuilder2.build();
                jsonObjectBuilder = jsonObjectBuilder.add("values", (JsonValue)jsonArray);
            }
            jsonArrayBuilder.add(jsonObjectBuilder);
        }
    }

    private int fsearch1(List<FacetResult> list, Query query, String string, int n, String string2) throws Exception {
        FacetsConfig facetsConfig = new FacetsConfig();
        DrillSideways drillSideways = new DrillSideways(this.isearcher, facetsConfig, this.treader);
        DrillSideways.DrillSidewaysResult drillSidewaysResult = drillSideways.search((DrillDownQuery)query, 1000);
        if (drillSidewaysResult.hits.totalHits != 0) {
            if (string.isEmpty() && string2.isEmpty()) {
                List list2 = drillSidewaysResult.facets.getAllDims(100);
                for (int i = 0; i < list2.size(); ++i) {
                    FacetResult facetResult = (FacetResult)list2.get(i);
                    String string3 = facetResult.dim;
                    list.add(drillSidewaysResult.facets.getTopChildren(n, string3, new String[0]));
                }
                return list2.size();
            }
            if (!string2.isEmpty()) {
                String[] stringArray;
                for (String string4 : stringArray = string2.split(",")) {
                    list.add(drillSidewaysResult.facets.getTopChildren(n, string4, new String[0]));
                }
                return list.size();
            }
            list.add(drillSidewaysResult.facets.getTopChildren(n, string, new String[0]));
            return list.size();
        }
        return list.size();
    }

    public static Date get_start_interval(long l, String string) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        if (string.equals("year")) {
            ++n;
            n2 = 0;
            n3 = 1;
            n4 = 0;
            n5 = 0;
            n6 = 0;
        } else if (string.equals("month")) {
            ++n2;
            n3 = 1;
            n4 = 0;
            n5 = 0;
            n6 = 0;
        } else if (string.equals("week")) {
            n3 += 7;
        } else if (string.equals("day")) {
            ++n3;
            n4 = 0;
            n5 = 0;
            n6 = 0;
        } else if (string.equals("hour")) {
            ++n4;
            n5 = 0;
            n6 = 0;
        } else if (string.equals("minute")) {
            ++n5;
            n6 = 0;
        }
        calendar2.set(1, n);
        calendar2.set(2, n2);
        calendar2.set(5, n3);
        calendar2.set(11, n4);
        calendar2.set(12, n5);
        calendar2.set(13, n6);
        calendar2.set(14, 0);
        return calendar2.getTime();
    }

    public static String get_label(Date date, Date date2, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String string2 = "";
        if (string.equals("year")) {
            simpleDateFormat = new SimpleDateFormat("yyyy");
        } else if (string.equals("month")) {
            simpleDateFormat = new SimpleDateFormat("MMM yyyy");
        } else if (!string.equals("week")) {
            simpleDateFormat = string.equals("day") ? new SimpleDateFormat("dd MMM yyyy") : new SimpleDateFormat("yyyy MMM dd HH:mm:ss");
        }
        string2 = simpleDateFormat.format(date);
        return string2;
    }

    public static void create_range(List<LongRange> list, long l, long l2, long l3, String string) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String string2 = "";
        Date date = simpleDateFormat.parse(Long.toString(l));
        Date date2 = simpleDateFormat.parse(Long.toString(l2));
        Date date3 = simpleDateFormat.parse(Long.toString(l));
        long l4 = date.getTime();
        long l5 = date2.getTime();
        Date date4 = SearchJsonReceiver.get_start_interval(l4, string);
        Calendar calendar = Calendar.getInstance();
        string2 = SearchJsonReceiver.get_label(date, date4, string);
        list.add(new LongRange(string2, Long.parseLong(simpleDateFormat.format(date3)), true, Long.parseLong(simpleDateFormat.format(date4)), false));
        boolean bl = false;
        int n = 1;
        while (true) {
            String string3 = simpleDateFormat.format(date4);
            date3 = simpleDateFormat.parse(string3);
            calendar.setTimeInMillis(date3.getTime());
            if (string.equals("year")) {
                calendar.add(1, 1);
            } else if (string.equals("month")) {
                calendar.add(2, 1);
            } else if (string.equals("week")) {
                calendar.add(5, 14);
            } else if (string.equals("day")) {
                calendar.add(5, 1);
            } else if (string.equals("hour")) {
                calendar.add(11, 2);
            } else if (string.equals("minute")) {
                calendar.add(12, 2);
            } else {
                calendar.add(13, 2);
            }
            date4.setTime(calendar.getTimeInMillis());
            string2 = SearchJsonReceiver.get_label(date3, date2, string);
            if (date4.getTime() >= l5) {
                string2 = SearchJsonReceiver.get_label(date3, date2, string);
                date4 = date2;
                bl = true;
            }
            list.add(new LongRange(string2, Long.parseLong(simpleDateFormat.format(date3)), true, Long.parseLong(simpleDateFormat.format(date4)), false));
            if (bl) break;
            ++n;
        }
    }

    private FacetResult fsearch(Query query, long l, long l2, boolean bl) throws Exception {
        long l3 = 1000L;
        long l4 = 60L * l3;
        long l5 = 60L * l4;
        long l6 = 24L * l5;
        long l7 = 7L * l6;
        long l8 = 30L * l6;
        long l9 = 365L * l6;
        long l10 = l;
        long l11 = l2;
        Date date = this.ft.parse(Long.toString(l10));
        Date date2 = this.ft.parse(Long.toString(l11));
        long l12 = (date2.getTime() - date.getTime()) / l6;
        ArrayList<LongRange> arrayList = new ArrayList<LongRange>();
        if (l12 > 2000L) {
            SearchJsonReceiver.create_range(arrayList, l10, l11, l9, "year");
        } else if (l12 <= 2000L && l12 > 365L) {
            SearchJsonReceiver.create_range(arrayList, l10, l11, l8, "month");
        } else if (l12 <= 365L && l12 > 30L) {
            SearchJsonReceiver.create_range(arrayList, l10, l11, l7, "week");
        } else if (l12 <= 30L && l12 > 4L) {
            SearchJsonReceiver.create_range(arrayList, l10, l11, l6, "day");
        } else if (l12 <= 4L && (double)l12 > 0.1) {
            SearchJsonReceiver.create_range(arrayList, l10, l11, l5, "hour");
        } else {
            SearchJsonReceiver.create_range(arrayList, l10, l11, l4, "minute");
        }
        if (query == null) {
            query = new MatchAllDocsQuery();
        }
        FacetsCollector facetsCollector = new FacetsCollector();
        FacetsCollector.search((IndexSearcher)this.isearcher, (Query)query, (int)100, (Collector)facetsCollector);
        LongRange[] longRangeArray = new LongRange[arrayList.size()];
        arrayList.toArray(longRangeArray);
        if (bl) {
            LongRangeFacetCounts longRangeFacetCounts = new LongRangeFacetCounts("ITime", facetsCollector, longRangeArray);
            return longRangeFacetCounts.getTopChildren(20, "ITime", new String[0]);
        }
        LongRangeFacetCounts longRangeFacetCounts = new LongRangeFacetCounts("Time", facetsCollector, longRangeArray);
        return longRangeFacetCounts.getTopChildren(20, "Time", new String[0]);
    }

    private FacetResult fsearch_f(Query query, String string, long l, long l2) throws Exception {
        FacetsCollector facetsCollector = new FacetsCollector();
        FacetsCollector.search((IndexSearcher)this.isearcher, (Query)query, (int)100, (Collector)facetsCollector);
        LongRange longRange = new LongRange("Range", l, true, l2, true);
        LongRangeFacetCounts longRangeFacetCounts = new LongRangeFacetCounts(string, facetsCollector, new LongRange[]{longRange});
        return longRangeFacetCounts.getTopChildren(20, string, new String[0]);
    }

    private DrillDownQuery create_facet_query(String string, DrillDownQuery drillDownQuery) {
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            String[] stringArray3 = stringArray2[1].split(",");
            for (int j = 0; j < stringArray3.length; ++j) {
                drillDownQuery.add(stringArray2[0], new String[]{stringArray3[j]});
            }
        }
        return drillDownQuery;
    }

    private BooleanQuery create_facet_bool_query(String string, BooleanQuery booleanQuery) {
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            String[] stringArray3 = stringArray2[1].split(",");
            for (int j = 0; j < stringArray3.length; ++j) {
                TermQuery termQuery = new TermQuery(new Term(stringArray2[0], stringArray3[j]));
                booleanQuery.add((Query)termQuery, BooleanClause.Occur.MUST);
            }
        }
        return booleanQuery;
    }

    private BooleanQuery create_nfacet_query(String string, BooleanQuery booleanQuery) {
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            String[] stringArray3 = stringArray2[1].split(",");
            for (int j = 0; j < stringArray3.length; ++j) {
                TermQuery termQuery = new TermQuery(new Term(stringArray2[0], stringArray3[j]));
                booleanQuery.add((Query)termQuery, BooleanClause.Occur.MUST_NOT);
            }
        }
        return booleanQuery;
    }

    private BooleanQuery create_query(String string, long l, long l2, Analyzer analyzer, String string2, JsonObject jsonObject) throws Exception {
        Object object;
        QueryParser queryParser = new QueryParser(Version.LUCENE_47, "Contents", analyzer);
        BooleanQuery booleanQuery = new BooleanQuery();
        Query query = null;
        queryParser.setAllowLeadingWildcard(true);
        string = string.toLowerCase();
        if (!string.endsWith("\"")) {
            string = QueryParser.escape((String)string);
            string = "*" + string + "*";
        }
        query = queryParser.parse(string);
        if (jsonObject.containsKey((Object)"from")) {
            object = NumericRangeQuery.newLongRange((String)"Time", (Long)l, (Long)l2, (boolean)true, (boolean)false);
            booleanQuery.add(query, BooleanClause.Occur.MUST);
            booleanQuery.add((Query)object, BooleanClause.Occur.MUST);
        } else {
            booleanQuery.add(query, BooleanClause.Occur.MUST);
        }
        if (!string2.isEmpty()) {
            object = "*" + string2.trim() + "*";
            Query query2 = queryParser.parse((String)object);
            booleanQuery.add(query2, BooleanClause.Occur.MUST);
        }
        return booleanQuery;
    }

    private BooleanQuery create_iquery(String string, long l, long l2, Analyzer analyzer, String string2) throws Exception {
        QueryParser queryParser = new QueryParser(Version.LUCENE_47, "Contents", analyzer);
        BooleanQuery booleanQuery = new BooleanQuery();
        Query query = null;
        queryParser.setAllowLeadingWildcard(true);
        string = string.toLowerCase();
        if (!string.endsWith("\"")) {
            string = QueryParser.escape((String)string);
            string = "*" + string + "*";
        }
        query = queryParser.parse(string);
        NumericRangeQuery numericRangeQuery = NumericRangeQuery.newLongRange((String)"ITime", (Long)l, (Long)l2, (boolean)true, (boolean)false);
        booleanQuery.add(query, BooleanClause.Occur.MUST);
        booleanQuery.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        if (!string2.isEmpty()) {
            String string3 = "*" + string2.trim() + "*";
            Query query2 = queryParser.parse(string3);
            booleanQuery.add(query2, BooleanClause.Occur.MUST);
        }
        return booleanQuery;
    }

    public JsonObject doPagingSearch(Query query, int n, int n2, Analyzer analyzer, JsonArrayBuilder jsonArrayBuilder, Sort sort, String string, String string2) throws IOException {
        PrefixFilter prefixFilter = new PrefixFilter(new Term(string, string2));
        TopFieldDocs topFieldDocs = string.isEmpty() ? this.isearcher.search(query, 1 + n2 * n, sort) : this.isearcher.search(query, (Filter)prefixFilter, 1 + n2 * n, sort);
        ScoreDoc[] scoreDocArray = topFieldDocs.scoreDocs;
        int n3 = topFieldDocs.totalHits;
        int n4 = (n2 - 1) * n;
        int n5 = Math.min(n3, n2 * n);
        JsonObject jsonObject = null;
        JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
        n5 = Math.min(scoreDocArray.length, n4 + n);
        int n6 = -1;
        String string3 = "";
        String string4 = "";
        for (int i = n4; i < n5; ++i) {
            Document document = null;
            try {
                document = this.isearcher.doc(scoreDocArray[i].doc);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            SearchJsonReceiver.addContextDocs2(jsonArrayBuilder2, document);
        }
        jsonObject = this.get_json_output(jsonArrayBuilder, jsonArrayBuilder2, n5 - n4);
        return jsonObject;
    }

    public static void addContextDocs2(JsonArrayBuilder jsonArrayBuilder, Document document) {
        List list = document.getFields();
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Field field = (Field)list.get(i);
            jsonObjectBuilder.add(field.name(), field.stringValue());
        }
        jsonArrayBuilder.add(jsonObjectBuilder);
    }

    private JsonObject get_json_output(JsonArrayBuilder jsonArrayBuilder, JsonArrayBuilder jsonArrayBuilder2, int n) {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        JsonArray jsonArray = jsonArrayBuilder.build();
        JsonArray jsonArray2 = jsonArrayBuilder2.build();
        jsonObjectBuilder.add("Facets", (JsonValue)jsonArray);
        jsonObjectBuilder.add("Hits", n);
        jsonObjectBuilder.add("Results", (JsonValue)jsonArray2);
        JsonObject jsonObject = jsonObjectBuilder.build();
        return jsonObject;
    }

    private JsonObject buildJson(JsonArrayBuilder jsonArrayBuilder, String string) {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        JsonArray jsonArray = jsonArrayBuilder.build();
        jsonObjectBuilder.add(string, (JsonValue)jsonArray);
        jsonObjectBuilder.add("Results", 0);
        JsonObject jsonObject = jsonObjectBuilder.build();
        return jsonObject;
    }

    public Set<String> getAll_f(String string, String string2, String string3, String string4, String string5) {
        JsonObject jsonObject;
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("pagenum", string4);
        jsonObjectBuilder.add("paging", string5);
        jsonObjectBuilder.add("fq", "_dtype=meta");
        jsonObjectBuilder.add("facet_name", string);
        JsonObject jsonObject2 = jsonObjectBuilder.build();
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);
        jsonWriter.writeObject(jsonObject2);
        jsonWriter.close();
        String string6 = stringWriter.toString();
        JsonObject jsonObject3 = this.get_result_injobj(string6);
        TreeSet<String> treeSet = new TreeSet<String>();
        JsonArray jsonArray = jsonObject3.getJsonArray("Facets");
        if (!jsonArray.isEmpty() && !(jsonObject = jsonArray.getJsonObject(0)).isEmpty()) {
            JsonArray jsonArray2 = jsonObject.getJsonArray("values");
            for (int i = 0; i < jsonArray2.size(); ++i) {
                JsonObject jsonObject4 = jsonArray2.getJsonObject(i);
                treeSet.addAll(jsonObject4.keySet());
            }
        }
        return treeSet;
    }

    public Set<String> getAll_kvf(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        JsonObject jsonObject;
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("pagenum", string6);
        jsonObjectBuilder.add("paging", string7);
        String string8 = string + "=" + string2;
        jsonObjectBuilder.add("fq", string8);
        jsonObjectBuilder.add("facet_name", string3);
        JsonObject jsonObject2 = jsonObjectBuilder.build();
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);
        jsonWriter.writeObject(jsonObject2);
        jsonWriter.close();
        String string9 = stringWriter.toString();
        JsonObject jsonObject3 = this.get_result_injobj(string9);
        JsonArray jsonArray = jsonObject3.getJsonArray("Facets");
        TreeSet<String> treeSet = new TreeSet<String>();
        if (!jsonArray.isEmpty() && !(jsonObject = jsonArray.getJsonObject(0)).isEmpty()) {
            JsonArray jsonArray2 = jsonObject.getJsonArray("values");
            for (int i = 0; i < jsonArray2.size(); ++i) {
                JsonObject jsonObject4 = jsonArray2.getJsonObject(i);
                treeSet.addAll(jsonObject4.keySet());
            }
        }
        return treeSet;
    }

    public Set<String> getCritical_f(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        JsonObject jsonObject;
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("from", string5);
        jsonObjectBuilder.add("to", string6);
        jsonObjectBuilder.add("pagenum", string7);
        jsonObjectBuilder.add("paging", string8);
        jsonObjectBuilder.add("fq", "Critical=" + string3 + ";" + string + "=" + string2.trim());
        jsonObjectBuilder.add("facet_name", string4);
        JsonObject jsonObject2 = jsonObjectBuilder.build();
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);
        jsonWriter.writeObject(jsonObject2);
        jsonWriter.close();
        String string9 = stringWriter.toString();
        JsonObject jsonObject3 = this.get_result_injobj(string9);
        JsonArray jsonArray = jsonObject3.getJsonArray("Facets");
        TreeSet<String> treeSet = new TreeSet<String>();
        if (!jsonArray.isEmpty() && !(jsonObject = jsonArray.getJsonObject(0)).isEmpty()) {
            JsonArray jsonArray2 = jsonObject.getJsonArray("values");
            for (int i = 0; i < jsonArray2.size(); ++i) {
                JsonObject jsonObject4 = jsonArray2.getJsonObject(i);
                treeSet.addAll(jsonObject4.keySet());
            }
        }
        return treeSet;
    }

    public JsonObjectBuilder getRowPerHost_byfq(String string, String string2, String string3, String string4, String string5, String string6) {
        Set<String> set = this.getAll_f("Component", string3, string4, string5, string6);
        Set<String> set2 = this.getAll_kvf("Hostname", string, "Component", string3, string4, string5, string6);
        Set<String> set3 = this.getCritical_f("Hostname", string, "1", "Component", string3, string4, string5, string6);
        int n = set3.size();
        Set<String> set4 = this.getCritical_f("Hostname", string, "2", "Component", string3, string4, string5, string6);
        int n2 = set4.size();
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
        if (n == 0 && n2 == 0) {
            for (String string7 : set2) {
                jsonObjectBuilder.add(string7, "3");
            }
            Set<String> set5 = SetOps.difference(set, set2);
            for (String string7 : set5) {
                jsonObjectBuilder.add(string7, "-1");
            }
        } else if (n != 0 && n2 != 0) {
            Set<String> set6 = set3;
            Set<String> set7 = SetOps.difference(set4, set3);
            Set<String> set8 = SetOps.difference(set2, set7);
            set8 = SetOps.difference(set8, set6);
            Set<String> set9 = SetOps.difference(set, set2);
            for (String string8 : set6) {
                jsonObjectBuilder.add(string8, "1");
            }
            for (String string8 : set7) {
                jsonObjectBuilder.add(string8, "2");
            }
            for (String string8 : set8) {
                jsonObjectBuilder.add(string8, "3");
            }
            for (String string8 : set9) {
                jsonObjectBuilder.add(string8, "-1");
            }
        } else if (n != 0) {
            Set<String> set10 = set3;
            Set<String> set11 = SetOps.difference(set2, set10);
            Set<String> set12 = SetOps.difference(set, set2);
            for (String string9 : set10) {
                jsonObjectBuilder.add(string9, "1");
            }
            for (String string9 : set11) {
                jsonObjectBuilder.add(string9, "3");
            }
            for (String string9 : set12) {
                jsonObjectBuilder.add(string9, "-1");
            }
        } else if (n2 != 0) {
            Set<String> set13 = set4;
            Set<String> set14 = SetOps.difference(set2, set13);
            Set<String> set15 = SetOps.difference(set, set2);
            for (String string10 : set13) {
                jsonObjectBuilder.add(string10, "2");
            }
            for (String string10 : set14) {
                jsonObjectBuilder.add(string10, "3");
            }
            for (String string10 : set15) {
                jsonObjectBuilder.add(string10, "-1");
            }
        }
        jsonObjectBuilder2.add("Hostname", string);
        jsonObjectBuilder2.add("Components", jsonObjectBuilder);
        return jsonObjectBuilder2;
    }

    public JsonObjectBuilder getRowPerHost(String string, String string2, String string3, String string4, String string5) {
        Set<String> set = this.getAll_f("Component", string2, string3, string4, string5);
        Set<String> set2 = this.getAll_kvf("Hostname", string, "Component", string2, string3, string4, string5);
        Set<String> set3 = this.getCritical_f("Hostname", string, "1", "Component", string2, string3, string4, string5);
        int n = set3.size();
        Set<String> set4 = this.getCritical_f("Hostname", string, "2", "Component", string2, string3, string4, string5);
        int n2 = set4.size();
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
        if (n == 0 && n2 == 0) {
            for (String string6 : set2) {
                jsonObjectBuilder.add(string6, "3");
            }
            Set<String> set5 = SetOps.difference(set, set2);
            for (String string6 : set5) {
                jsonObjectBuilder.add(string6, "-1");
            }
        } else if (n != 0 && n2 != 0) {
            Set<String> set6 = set3;
            Set<String> set7 = SetOps.difference(set4, set3);
            Set<String> set8 = SetOps.difference(set2, set7);
            set8 = SetOps.difference(set8, set6);
            Set<String> set9 = SetOps.difference(set, set2);
            for (String string7 : set6) {
                jsonObjectBuilder.add(string7, "1");
            }
            for (String string7 : set7) {
                jsonObjectBuilder.add(string7, "2");
            }
            for (String string7 : set8) {
                jsonObjectBuilder.add(string7, "3");
            }
            for (String string7 : set9) {
                jsonObjectBuilder.add(string7, "-1");
            }
        } else if (n != 0) {
            Set<String> set10 = set3;
            Set<String> set11 = SetOps.difference(set2, set10);
            Set<String> set12 = SetOps.difference(set, set2);
            for (String string8 : set10) {
                jsonObjectBuilder.add(string8, "1");
            }
            for (String string8 : set11) {
                jsonObjectBuilder.add(string8, "3");
            }
            for (String string8 : set12) {
                jsonObjectBuilder.add(string8, "-1");
            }
        } else if (n2 != 0) {
            Set<String> set13 = set4;
            Set<String> set14 = SetOps.difference(set2, set13);
            Set<String> set15 = SetOps.difference(set, set2);
            for (String string9 : set13) {
                jsonObjectBuilder.add(string9, "2");
            }
            for (String string9 : set14) {
                jsonObjectBuilder.add(string9, "3");
            }
            for (String string9 : set15) {
                jsonObjectBuilder.add(string9, "-1");
            }
        }
        jsonObjectBuilder2.add("Hostname", string);
        jsonObjectBuilder2.add("Components", jsonObjectBuilder);
        return jsonObjectBuilder2;
    }

    public JsonObjectBuilder getRowPerCluster(String string, String string2, String string3, String string4, String string5) {
        Set<String> set = this.getAll_f("Component", string2, string3, string4, string5);
        Set<String> set2 = this.getAll_kvf("Cluster", string, "Component", string2, string3, string4, string5);
        Set<String> set3 = this.getCritical_f("Cluster", string, "1", "Component", string2, string3, string4, string5);
        Set<String> set4 = this.getCritical_f("Cluster", string, "2", "Component", string2, string3, string4, string5);
        Set<String> set5 = set3;
        Set<String> set6 = SetOps.difference(set4, set3);
        Set<String> set7 = SetOps.difference(set2, set6);
        set7 = SetOps.difference(set7, set3);
        Set<String> set8 = SetOps.difference(set, set2);
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("Header", string);
        JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
        for (String string6 : set5) {
            jsonObjectBuilder.add(string6, "1");
        }
        for (String string6 : set6) {
            jsonObjectBuilder.add(string6, "2");
        }
        for (String string6 : set7) {
            jsonObjectBuilder.add(string6, "3");
        }
        for (String string6 : set8) {
            jsonObjectBuilder.add(string6, "-1");
        }
        jsonObjectBuilder2.add("Cluster", string);
        jsonObjectBuilder2.add("Components", jsonObjectBuilder);
        return jsonObjectBuilder2;
    }

    public JsonObjectBuilder getRowPerDC(String string, String string2, String string3, String string4, String string5) {
        Set<String> set = this.getAll_f("Component", string2, string3, string4, string5);
        Set<String> set2 = this.getAll_kvf("DC", string, "Component", string2, string3, string4, string5);
        Set<String> set3 = this.getCritical_f("DC", string, "1", "Component", string2, string3, string4, string5);
        Set<String> set4 = this.getCritical_f("DC", string, "2", "Component", string2, string3, string4, string5);
        Set<String> set5 = set3;
        Set<String> set6 = SetOps.difference(set4, set3);
        Set<String> set7 = SetOps.difference(set2, set6);
        set7 = SetOps.difference(set7, set3);
        Set<String> set8 = SetOps.difference(set, set2);
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("Header", string);
        JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
        for (String string6 : set5) {
            jsonObjectBuilder.add(string6, "1");
        }
        for (String string6 : set6) {
            jsonObjectBuilder.add(string6, "2");
        }
        for (String string6 : set7) {
            jsonObjectBuilder.add(string6, "3");
        }
        for (String string6 : set8) {
            jsonObjectBuilder.add(string6, "-1");
        }
        jsonObjectBuilder2.add("DC", string);
        jsonObjectBuilder2.add("Components", jsonObjectBuilder);
        return jsonObjectBuilder2;
    }

    public JsonObject fillClustersinDC(String string, String string2, String string3, String string4, String string5) {
        Set<String> set = this.getAll_kvf("DC", string, "Cluster", string2, string3, string4, string5);
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        for (String string6 : set) {
            JsonObjectBuilder jsonObjectBuilder2 = this.getRowPerCluster(string6, string2, string3, string4, string5);
            jsonArrayBuilder.add(jsonObjectBuilder2);
        }
        jsonObjectBuilder.add("Result", jsonArrayBuilder);
        return jsonObjectBuilder.build();
    }

    public JsonObject fillNodesinCluster(String string, String string2, String string3, String string4, String string5) {
        Set<String> set = this.getAll_kvf("Cluster", string, "Hostname", string2, string3, string4, string5);
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        for (String string6 : set) {
            String string7 = "Cluster=" + string + ";Hostname=" + string6;
            JsonObjectBuilder jsonObjectBuilder2 = this.getRowPerHost_byfq(string6, string7, string2, string3, string4, string5);
            jsonArrayBuilder.add(jsonObjectBuilder2);
        }
        jsonObjectBuilder.add("Result", jsonArrayBuilder);
        return jsonObjectBuilder.build();
    }

    public JsonObject fillAllDCs(String string, String string2, String string3, String string4) {
        Set<String> set = this.getAll_f("DC", string, string2, string3, string4);
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        for (String string5 : set) {
            JsonObjectBuilder jsonObjectBuilder2 = this.getRowPerDC(string5, string, string2, string3, string4);
            jsonArrayBuilder.add(jsonObjectBuilder2);
        }
        jsonObjectBuilder.add("Result", jsonArrayBuilder);
        return jsonObjectBuilder.build();
    }

    public JsonObject fillAllHosts(String string, String string2, String string3, String string4) {
        Set<String> set = this.getAll_f("Hostname", string, string2, string3, string4);
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        for (String string5 : set) {
            JsonObjectBuilder jsonObjectBuilder2 = this.getRowPerHost(string5, string, string2, string3, string4);
            jsonArrayBuilder.add(jsonObjectBuilder2);
        }
        jsonObjectBuilder.add("Result", jsonArrayBuilder);
        return jsonObjectBuilder.build();
    }

    public JsonObject fillAllClusters(String string, String string2, String string3, String string4) {
        Set<String> set = this.getAll_f("Cluster", string, string2, string3, string4);
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        for (String string5 : set) {
            JsonObjectBuilder jsonObjectBuilder2 = this.getRowPerCluster(string5, string, string2, string3, string4);
            jsonArrayBuilder.add(jsonObjectBuilder2);
        }
        jsonObjectBuilder.add("Result", jsonArrayBuilder);
        return jsonObjectBuilder.build();
    }

    public JsonObject fillAllClustersTreemap(String string, String string2, String string3, String string4) {
        Set<String> set = this.getAll_f("Cluster", string, string2, string3, string4);
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        for (String string5 : set) {
            JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
            Set<String> set2 = this.getAll_kvf("Cluster", string5, "Hostname", string, string2, string3, string4);
            for (String string6 : set2) {
                JsonObjectBuilder jsonObjectBuilder2 = this.getRowPerHost(string6, string, string2, string3, string4);
                jsonArrayBuilder2.add(jsonObjectBuilder2);
            }
            jsonObjectBuilder.add("Cluster", string5);
            jsonObjectBuilder.add("Hosts", jsonArrayBuilder2);
            jsonArrayBuilder.add(jsonObjectBuilder);
        }
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("Header", "perdc");
        jsonObjectBuilder.add("Clusters", jsonArrayBuilder);
        return jsonObjectBuilder.build();
    }

    public Set<String> getAll_f_byfq(String string, String string2, String string3, String string4, String string5, String string6) {
        JsonObject jsonObject;
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("pagenum", string5);
        jsonObjectBuilder.add("paging", string6);
        jsonObjectBuilder.add("fq", string);
        jsonObjectBuilder.add("facet_name", string2);
        JsonObject jsonObject2 = jsonObjectBuilder.build();
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);
        jsonWriter.writeObject(jsonObject2);
        jsonWriter.close();
        String string7 = stringWriter.toString();
        JsonObject jsonObject3 = this.get_result_injobj(string7);
        JsonArray jsonArray = jsonObject3.getJsonArray("Facets");
        TreeSet<String> treeSet = new TreeSet<String>();
        if (!jsonArray.isEmpty() && !(jsonObject = jsonArray.getJsonObject(0)).isEmpty()) {
            JsonArray jsonArray2 = jsonObject.getJsonArray("values");
            for (int i = 0; i < jsonArray2.size(); ++i) {
                JsonObject jsonObject4 = jsonArray2.getJsonObject(i);
                treeSet.addAll(jsonObject4.keySet());
            }
        }
        return treeSet;
    }

    public JsonObjectBuilder getRowPerComponent(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        JsonObjectBuilder jsonObjectBuilder;
        JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
        jsonObjectBuilder2.add("from", string4);
        jsonObjectBuilder2.add("to", string5);
        jsonObjectBuilder2.add("pagenum", string6);
        jsonObjectBuilder2.add("paging", string7);
        jsonObjectBuilder2.add("fq", string2);
        jsonObjectBuilder2.add("facet_name", string3);
        JsonObject jsonObject = jsonObjectBuilder2.build();
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);
        jsonWriter.writeObject(jsonObject);
        jsonWriter.close();
        String string8 = stringWriter.toString();
        JsonObject jsonObject2 = this.get_result_injobj(string8);
        JsonArray jsonArray = jsonObject2.getJsonArray("Facets");
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        if (!jsonArray.isEmpty() && !(jsonObjectBuilder = jsonArray.getJsonObject(0)).isEmpty()) {
            JsonArray jsonArray2 = jsonObjectBuilder.getJsonArray("values");
            for (int i = 0; i < jsonArray2.size(); ++i) {
                JsonObject jsonObject3 = jsonArray2.getJsonObject(i);
                Set set = jsonObject3.entrySet();
                JsonObjectBuilder jsonObjectBuilder3 = Json.createObjectBuilder();
                for (Map.Entry entry : set) {
                    String string9 = (String)entry.getKey();
                    String string10 = ((JsonValue)entry.getValue()).toString();
                    jsonObjectBuilder3.add(string9, string10);
                }
                jsonArrayBuilder.add(jsonObjectBuilder3);
            }
        }
        jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("type", string);
        jsonObjectBuilder.add("name", string);
        jsonObjectBuilder.add("status", "up");
        jsonObjectBuilder.add("events", jsonArrayBuilder);
        return jsonObjectBuilder;
    }

    public JsonObjectBuilder getRowPerMetric(String string, String string2, String string3, String string4, String string5, String string6) {
        JsonObjectBuilder jsonObjectBuilder;
        JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
        jsonObjectBuilder2.add("from", string3);
        jsonObjectBuilder2.add("to", string4);
        jsonObjectBuilder2.add("pagenum", string5);
        jsonObjectBuilder2.add("paging", string6);
        jsonObjectBuilder2.add("fq", string);
        jsonObjectBuilder2.add("facet_name", string2);
        JsonObject jsonObject = jsonObjectBuilder2.build();
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);
        jsonWriter.writeObject(jsonObject);
        jsonWriter.close();
        String string7 = stringWriter.toString();
        JsonObject jsonObject2 = this.get_result_injobj(string7);
        JsonArray jsonArray = jsonObject2.getJsonArray("Facets");
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        if (!jsonArray.isEmpty() && !(jsonObjectBuilder = jsonArray.getJsonObject(0)).isEmpty()) {
            JsonArray jsonArray2 = jsonObjectBuilder.getJsonArray("values");
            for (int i = 0; i < jsonArray2.size(); ++i) {
                JsonObject jsonObject3 = jsonArray2.getJsonObject(i);
                Set set = jsonObject3.entrySet();
                JsonObjectBuilder jsonObjectBuilder3 = Json.createObjectBuilder();
                for (Map.Entry entry : set) {
                    String string8 = (String)entry.getKey();
                    String string9 = ((JsonValue)entry.getValue()).toString();
                    jsonObjectBuilder3.add(string8, string9);
                }
                jsonArrayBuilder.add(jsonObjectBuilder3);
            }
        }
        jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("type", string2);
        jsonObjectBuilder.add("name", string2);
        jsonObjectBuilder.add("status", "up");
        jsonObjectBuilder.add("values", jsonArrayBuilder);
        return jsonObjectBuilder;
    }

    public JsonObject fillAllClustersTreemap2(String string, String string2, String string3, String string4) {
        Set<String> set = this.getAll_f("_mCluster", string, string2, string3, string4);
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        for (String string5 : set) {
            JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
            Set<String> set2 = this.getAll_kvf("_mCluster", string5, "Hostname", string, string2, string3, string4);
            for (String string6 : set2) {
                JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
                String string7 = "_mCluster=" + string5 + ";" + "_mHostname=" + string6;
                Set<String> set3 = this.getAll_f_byfq(string7, "_mComponent", string, string2, string3, string4);
                JsonArrayBuilder jsonArrayBuilder3 = Json.createArrayBuilder();
                for (String string8 : set3) {
                    string7 = "Cluster=" + string5 + ";" + "Hostname=" + string6 + ";Component=" + string8;
                    JsonObjectBuilder jsonObjectBuilder3 = this.getRowPerComponent(string8, string7, "Eventtype", string, string2, string3, string4);
                    jsonArrayBuilder3.add(jsonObjectBuilder3);
                }
                jsonObjectBuilder2.add("name", string6);
                jsonObjectBuilder2.add("Components", jsonArrayBuilder3);
                jsonArrayBuilder2.add(jsonObjectBuilder2);
            }
            jsonObjectBuilder.add("name", string5);
            jsonObjectBuilder.add("Cluster", string5);
            jsonObjectBuilder.add("Hosts", jsonArrayBuilder2);
            jsonArrayBuilder.add(jsonObjectBuilder);
        }
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("Header", "perdc");
        jsonObjectBuilder.add("Clusters", jsonArrayBuilder);
        return jsonObjectBuilder.build();
    }

    public JsonArrayBuilder getCpuMemPerHost(String string, String string2, String string3, String string4, String string5) {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("q", "");
        jsonObjectBuilder.add("from", string2);
        jsonObjectBuilder.add("to", string3);
        jsonObjectBuilder.add("pagenum", string4);
        jsonObjectBuilder.add("paging", string5);
        jsonObjectBuilder.add("fq", string);
        jsonObjectBuilder.add("s_op", "sort_td");
        JsonObject jsonObject = jsonObjectBuilder.build();
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);
        jsonWriter.writeObject(jsonObject);
        jsonWriter.close();
        String string6 = stringWriter.toString();
        JsonObject jsonObject2 = this.get_result_injobj(string6);
        JsonArray jsonArray = jsonObject2.getJsonArray("Results");
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        if (!jsonArray.isEmpty()) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject jsonObject3 = jsonArray.getJsonObject(i);
                Set set = jsonObject3.entrySet();
                JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
                for (Map.Entry entry : set) {
                    String string7 = (String)entry.getKey();
                    String string8 = ((JsonValue)entry.getValue()).toString();
                    jsonObjectBuilder2.add(string7, string8);
                }
                jsonArrayBuilder.add(jsonObjectBuilder2);
            }
        }
        return jsonArrayBuilder;
    }

    public JsonObject fillAllClusterscpumem(String string, String string2, String string3, String string4) {
        Set<String> set = this.getAll_f("_mCluster", string, string2, string3, string4);
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        for (String string5 : set) {
            JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
            Set<String> set2 = this.getAll_kvf("_mCluster", string5, "Hostname", string, string2, string3, string4);
            for (String string6 : set2) {
                JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
                String string7 = "Cluster=" + string5 + ";" + "Hostname=" + string6 + ";metrics=vmstat;";
                JsonArrayBuilder jsonArrayBuilder3 = this.getCpuMemPerHost(string7, string, string2, string3, string4);
                jsonObjectBuilder2.add("name", string6);
                jsonObjectBuilder2.add("values", jsonArrayBuilder3);
                jsonArrayBuilder2.add(jsonObjectBuilder2);
            }
            jsonObjectBuilder.add("name", string5);
            jsonObjectBuilder.add("Cluster", string5);
            jsonObjectBuilder.add("Hosts", jsonArrayBuilder2);
            jsonArrayBuilder.add(jsonObjectBuilder);
        }
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("Header", "perdc");
        jsonObjectBuilder.add("Clusters", jsonArrayBuilder);
        return jsonObjectBuilder.build();
    }

    public JsonObject fillAllDCsList(String string, String string2, String string3, String string4) {
        Set<String> set = this.getAll_f("DC", string, string2, string3, string4);
        Set<String> set2 = this.getAll_f("Cluster", string, string2, string3, string4);
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        for (String string5 : set2) {
            JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
            Set<String> set3 = this.getAll_kvf("Cluster", string5, "Hostname", string, string2, string3, string4);
            for (String string6 : set3) {
                JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
                String string7 = "Cluster=" + string5 + ";" + "Hostname=" + string6;
                TreeSet<String> treeSet = new TreeSet<String>();
                treeSet.add("cpu_sy");
                treeSet.add("cpu_us");
                treeSet.add("memory_usage");
                JsonArrayBuilder jsonArrayBuilder3 = Json.createArrayBuilder();
                for (String string8 : treeSet) {
                    string7 = "Cluster=" + string5 + ";" + "Hostname=" + string6 + ";Filetype=_METRICS";
                    JsonObjectBuilder jsonObjectBuilder3 = this.getRowPerMetric(string7, string8, string, string2, string3, string4);
                    jsonArrayBuilder3.add(jsonObjectBuilder3);
                }
                jsonObjectBuilder2.add("name", string6);
                jsonObjectBuilder2.add("Components", jsonArrayBuilder3);
                jsonArrayBuilder2.add(jsonObjectBuilder2);
            }
            jsonObjectBuilder.add("name", string5);
            jsonObjectBuilder.add("Cluster", string5);
            jsonObjectBuilder.add("Hosts", jsonArrayBuilder2);
            jsonArrayBuilder.add(jsonObjectBuilder);
        }
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("Header", "perdc");
        jsonObjectBuilder.add("Clusters", jsonArrayBuilder);
        return jsonObjectBuilder.build();
    }

    public JsonObject fillAllClustersList(String string, String string2, String string3, String string4) {
        Set<String> set = this.getAll_f("_mCluster", string, string2, string3, string4);
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        for (String string5 : set) {
            JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
            Set<String> set2 = this.getAll_kvf("_mCluster", string5, "_mHostname", string, string2, string3, string4);
            for (String string6 : set2) {
                JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
                String string7 = "Cluster=" + string5 + ";" + "Hostname=" + string6;
                TreeSet<String> treeSet = new TreeSet<String>();
                treeSet.add("cpu_sy");
                treeSet.add("cpu_us");
                treeSet.add("memory_usage");
                treeSet.add("ROOT_UsePercent");
                JsonArrayBuilder jsonArrayBuilder3 = Json.createArrayBuilder();
                for (String string8 : treeSet) {
                    string7 = "Cluster=" + string5 + ";" + "Hostname=" + string6 + ";Filetype=_METRICS";
                    JsonObjectBuilder jsonObjectBuilder3 = this.getRowPerMetric(string7, string8, string, string2, string3, string4);
                    jsonArrayBuilder3.add(jsonObjectBuilder3);
                }
                jsonObjectBuilder2.add("name", string6);
                jsonObjectBuilder2.add("Components", jsonArrayBuilder3);
                jsonArrayBuilder2.add(jsonObjectBuilder2);
            }
            jsonObjectBuilder.add("name", string5);
            jsonObjectBuilder.add("Cluster", string5);
            jsonObjectBuilder.add("Hosts", jsonArrayBuilder2);
            jsonArrayBuilder.add(jsonObjectBuilder);
        }
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("Header", "perdc");
        jsonObjectBuilder.add("Clusters", jsonArrayBuilder);
        return jsonObjectBuilder.build();
    }

    public static void main(String[] stringArray) throws IOException {
        String string = null;
        Object var2_2 = null;
        String string2 = null;
        Object var4_4 = null;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if ("-indexloc".equals(stringArray[i])) {
                string = stringArray[i + 1];
                ++i;
                continue;
            }
            if ("-json".equals(stringArray[i])) {
                string2 = stringArray[i + 1];
                ++i;
                continue;
            }
            System.out.println("Incorrect usage ");
            System.exit(0);
        }
        if (string == null) {
            System.out.println("specify index location with -indexloc");
            System.exit(0);
        }
        SearchJsonReceiver searchJsonReceiver = new SearchJsonReceiver(string);
        String string3 = searchJsonReceiver.get_result(string2);
    }
}

