/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.receiver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class SearchIndexFacets {
    private SearchIndexFacets() {
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "Usage:\tjava org.apache.lucene.demo.SearchFiles [-index dir] [-field f] [-repeat n] [-queries file] [-query string] [-raw] [-paging hitsPerPage]\n\nSee http://lucene.apache.org/core/4_1_0/demo/ for details.";
        if (stringArray.length > 0 && ("-h".equals(stringArray[0]) || "-help".equals(stringArray[0]))) {
            System.out.println(string);
            System.exit(0);
        }
        String string2 = "index";
        String string3 = "contents";
        String string4 = null;
        int n = 0;
        boolean bl = false;
        String string5 = null;
        int n2 = 10;
        for (int i = 0; i < stringArray.length; ++i) {
            if ("-index".equals(stringArray[i])) {
                string2 = stringArray[i + 1];
                ++i;
                continue;
            }
            if ("-field".equals(stringArray[i])) {
                string3 = stringArray[i + 1];
                ++i;
                continue;
            }
            if ("-queries".equals(stringArray[i])) {
                string4 = stringArray[i + 1];
                ++i;
                continue;
            }
            if ("-query".equals(stringArray[i])) {
                string5 = stringArray[i + 1];
                ++i;
                continue;
            }
            if ("-repeat".equals(stringArray[i])) {
                n = Integer.parseInt(stringArray[i + 1]);
                ++i;
                continue;
            }
            if ("-raw".equals(stringArray[i])) {
                bl = true;
                continue;
            }
            if (!"-paging".equals(stringArray[i])) continue;
            n2 = Integer.parseInt(stringArray[i + 1]);
            if (n2 <= 0) {
                System.err.println("There must be at least 1 hit per page.");
                System.exit(1);
            }
            ++i;
        }
        string2 = "/tmp/tfaluceneindex";
        DirectoryReader directoryReader = DirectoryReader.open((Directory)FSDirectory.open((File)new File(string2)));
        IndexSearcher indexSearcher = new IndexSearcher((IndexReader)directoryReader);
        StandardAnalyzer standardAnalyzer = new StandardAnalyzer(Version.LUCENE_47);
        BufferedReader bufferedReader = null;
        bufferedReader = string4 != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string4), "UTF-8")) : new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        QueryParser queryParser = new QueryParser(Version.LUCENE_47, string3, (Analyzer)standardAnalyzer);
        do {
            String string6;
            if (string4 == null && string5 == null) {
                System.out.println("Enter query: ");
            }
            String string7 = string6 = string5 != null ? string5 : bufferedReader.readLine();
            if (string6 == null || string6.length() == -1 || (string6 = string6.trim()).length() == 0) break;
            Query query = queryParser.parse(string6);
            System.out.println("Searching for: " + query.toString(string3));
            if (n > 0) {
                Date date = new Date();
                for (int i = 0; i < n; ++i) {
                    indexSearcher.search(query, null, 100);
                }
                Date date2 = new Date();
                System.out.println("Time: " + (date2.getTime() - date.getTime()) + "ms");
            }
            SearchIndexFacets.doPagingSearch(bufferedReader, indexSearcher, query, n2, bl, string4 == null && string5 == null);
        } while (string5 == null);
        directoryReader.close();
    }

    public static void doPagingSearch(BufferedReader bufferedReader, IndexSearcher indexSearcher, Query query, int n, boolean bl, boolean bl2) throws IOException {
        TopDocs topDocs = indexSearcher.search(query, 5 * n);
        ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
        int n2 = topDocs.totalHits;
        System.out.println(n2 + " total matching documents");
        int n3 = 0;
        int n4 = Math.min(n2, n);
        while (true) {
            Object object;
            int n5;
            if (n4 > scoreDocArray.length) {
                System.out.println("Only results 1 - " + scoreDocArray.length + " of " + n2 + " total matching documents collected.");
                System.out.println("Collect more (y/n) ?");
                String string = bufferedReader.readLine();
                if (string.length() == 0 || string.charAt(0) == 'n') break;
                scoreDocArray = indexSearcher.search((Query)query, (int)n2).scoreDocs;
            }
            n4 = Math.min(scoreDocArray.length, n3 + n);
            for (n5 = n3; n5 < n4; ++n5) {
                if (bl) {
                    System.out.println("doc=" + scoreDocArray[n5].doc + " score=" + scoreDocArray[n5].score);
                    continue;
                }
                object = indexSearcher.doc(scoreDocArray[n5].doc);
                String string = object.get("path");
                if (string != null) {
                    System.out.println(n5 + 1 + ". " + string);
                    String string2 = object.get("contents");
                    if (string2 == null) continue;
                    System.out.println("   Contents: " + object.get("contents"));
                    continue;
                }
                System.out.println(n5 + 1 + ". " + "No path for this document");
            }
            if (!bl2 || n4 == 0) break;
            if (n2 < n4) continue;
            n5 = 0;
            while (true) {
                System.out.print("Press ");
                if (n3 - n >= 0) {
                    System.out.print("(p)revious page, ");
                }
                if (n3 + n < n2) {
                    System.out.print("(n)ext page, ");
                }
                System.out.println("(q)uit or enter number to jump to a page.");
                object = bufferedReader.readLine();
                if (((String)object).length() == 0 || ((String)object).charAt(0) == 'q') {
                    n5 = 1;
                    break;
                }
                if (((String)object).charAt(0) == 'p') {
                    n3 = Math.max(0, n3 - n);
                    break;
                }
                if (((String)object).charAt(0) == 'n') {
                    if (n3 + n >= n2) break;
                    n3 += n;
                    break;
                }
                int n6 = Integer.parseInt((String)object);
                if ((n6 - 1) * n < n2) {
                    n3 = (n6 - 1) * n;
                    break;
                }
                System.out.println("No such page");
            }
            if (n5 != 0) break;
            n4 = Math.min(n2, n3 + n);
        }
    }
}

