/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.receiver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSocket;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.rat.tfa.RepositoryManager;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.Action;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.receiver.RGlobal;
import oracle.rat.tfa.receiver.SendToKafka;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SocketManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProcessCollection
implements Runnable {
    private String destBaseDir;
    private String sourceNode;
    private String cluster_name;
    private Action callingAction = null;

    public ProcessCollection() {
    }

    public ProcessCollection(Action action) {
        this.callingAction = action;
    }

    @Override
    public void run() {
        String string = this.callingAction.getActionRequestArgs();
        Output.printTrace("Args in ProcessCollection: " + string, 3);
        String[] stringArray = string.split(":");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = null;
        try {
            int n;
            Object object;
            if (!RepositoryManager.getInstance().isRepositoryOpen()) {
                Output.printTrace("ProcessCollection: The Repository is full and closed", 3);
                this.callingAction.setActionStatus("REQUESTED");
                this.callingAction.store();
                return;
            }
            for (String object22 : stringArray) {
                object = object22.split("=");
                hashMap.put(object[0].trim(), object[1].trim());
                Output.printTrace("ProcessCollection: Key=" + object[0] + ", Value=" + object[1], 3);
            }
            string2 = "unzip -o -q " + (String)hashMap.get("collection") + " -d " + (String)hashMap.get("destbase");
            Output.printTrace("ProcessCollection: unzip command " + string2, 3);
            Process process = Runtime.getRuntime().exec(string2);
            process.waitFor();
            if (process.exitValue() != 0) {
                this.callingAction.setActionFailed("Unzip failed");
                this.callingAction.store();
                return;
            }
            String string3 = (String)hashMap.get("destbase") + File.separator + (String)hashMap.get("source") + ".zip_inventory.xml";
            Output.printTrace("ProcessCollection: Collection inv file " + string3, 3);
            this.processFile(string3, (String)hashMap.get("prefix"), (String)hashMap.get("cluster_name"));
            String string4 = (String)hashMap.get("destbase") + File.separator + (String)hashMap.get("source");
            File file = new File(string4);
            object = (String)hashMap.get("source") + "_";
            File[] fileArray = file.listFiles();
            for (n = 0; n < fileArray.length; ++n) {
                if (!fileArray[n].isFile() || !fileArray[n].getName().startsWith((String)object)) continue;
                this.processExtraFile(fileArray[n], (String)hashMap.get("source"), (String)hashMap.get("prefix"), (String)hashMap.get("cluster_name"));
            }
            string4 = (String)hashMap.get("destbase");
            Output.printTrace("ProcessCollection: " + string4, 1);
            File file2 = new File(string4);
            fileArray = file2.listFiles();
            for (n = 0; n < fileArray.length; ++n) {
                if (!fileArray[n].isFile() || !fileArray[n].getName().endsWith(".zip.txt")) continue;
                Output.printTrace("ProcessCollection: " + fileArray[n], 1);
                this.processMetaFile(fileArray[n], (String)hashMap.get("source"), (String)hashMap.get("prefix"), (String)hashMap.get("cluster_name"));
            }
            this.callingAction.setActionComplete();
            this.callingAction.store();
        }
        catch (Exception exception) {
            Output.printTrace("ProcessCollection: Failed to process collection", 1);
            exception.printStackTrace();
            this.callingAction.setActionFailed("Process collection failed");
            this.callingAction.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_content(File file, String string) {
        Matcher matcher = null;
        BufferedReader bufferedReader = null;
        Pattern pattern = Pattern.compile("^((\\w\\w\\w)\\s+(\\w\\w\\w)\\s(\\d+)\\s+(\\d\\d):(\\d\\d):(\\d\\d)\\s+(\\w+)\\s+(\\d\\d\\d\\d))((\\s+)|($))(.*)");
        String string2 = "EEE MMM dd HH:mm:ss ZZZ yyyy";
        Pattern pattern2 = Pattern.compile("^((\\w\\w\\w)\\s+(\\w\\w\\w)\\s(\\d+)\\s+(\\d\\d\\d\\d)\\s+(\\d\\d):(\\d\\d):(\\d\\d)\\s+(\\w+))((\\s+)|($))(.*)");
        String string3 = "EEE MMM dd yyyy HH:mm:ss ZZZ";
        try {
            String string4;
            bufferedReader = new BufferedReader(new FileReader(file));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat();
            Calendar calendar = Calendar.getInstance();
            boolean bl = false;
            while ((string4 = bufferedReader.readLine()) != null) {
                String string5;
                Date date;
                String[] stringArray;
                if (string4.startsWith("User initiated")) {
                    System.out.println(string4);
                } else if (string4.contains("Start date :")) {
                    stringArray = string4.split(":\\s+");
                    matcher = pattern2.matcher(stringArray[1]);
                    if (matcher.find()) {
                        simpleDateFormat2.applyPattern(string3);
                        date = simpleDateFormat2.parse(matcher.group(1));
                        calendar.setTime(date);
                        string5 = simpleDateFormat.format(date);
                        System.out.println("macthed st: " + string5);
                        string = string + " Start_time:" + string5;
                    }
                } else if (string4.contains("End date :")) {
                    System.out.println(string4);
                    stringArray = string4.split(":\\s+");
                    matcher = pattern2.matcher(stringArray[1]);
                    if (matcher.find()) {
                        System.out.println(matcher.group(1));
                        simpleDateFormat2.applyPattern(string3);
                        date = simpleDateFormat2.parse(matcher.group(1));
                        calendar.setTime(date);
                        string5 = simpleDateFormat.format(date);
                        System.out.println("macthed eet: " + string5);
                        string = string + " end_time:" + string5;
                    }
                } else if (string4.startsWith("Events triggering")) {
                    bl = true;
                }
                if (!bl) continue;
                if (string4.startsWith("Event:")) {
                    stringArray = string4.split(":\\s+");
                    System.out.println("Event:" + stringArray[1]);
                    string = string + " Event_pat:" + stringArray[1];
                    continue;
                }
                if (string4.startsWith("Event time:")) {
                    stringArray = string4.split(":\\s+");
                    matcher = pattern.matcher(stringArray[1]);
                    if (!matcher.find()) continue;
                    simpleDateFormat2.applyPattern(string2);
                    date = simpleDateFormat2.parse(matcher.group(1));
                    calendar.setTime(date);
                    string5 = simpleDateFormat.format(date);
                    System.out.println("macthed et: " + string5);
                    string = string + " Event_time:" + string5;
                    continue;
                }
                if (string4.startsWith("File containing event:")) {
                    stringArray = string4.split(":\\s+");
                    string = string + " Event_File:" + stringArray[1];
                    continue;
                }
                if (!string4.startsWith("String containing event:")) continue;
                stringArray = string4.split(":\\s+");
                string = string + " Event_String:" + stringArray[1];
            }
            string = bl ? string + " Trigger_by:auto" : string + " Trigger_by:user";
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string;
    }

    public void processMetaFile(File file, String string, String string2, String string3) {
        System.out.println("processExtraFile " + file.getName());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
        Date date = new Date();
        String string4 = simpleDateFormat.format(date);
        String string5 = string + string4 + ".cinfo";
        String string6 = "collectionpath:" + string2 + " node:" + string + " cluster:" + string3;
        String string7 = this.get_content(file, string6);
        Output.printTrace("ProcessCollection: msg::" + string7, 1);
        String string8 = new Host().getHostname().trim();
        if (string8.equals(RGlobal.topic)) {
            SendToKafka.send(string, string5, string7, 0L, 0L, 1L, 1L, null, "cinfo~TFAR~TFAR~TFAR~" + string3, "NA", "NA", "NA", "NA");
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("TFARFILE=NONE;");
            stringBuilder.append("NODENAME=" + string + ";");
            stringBuilder.append("FILETYPE=cinfo~TFAR~TFAR~TFAR~" + string3 + ";");
            stringBuilder.append("FIRSTTIME=NA;");
            stringBuilder.append("LASTTIME=NA;");
            stringBuilder.append("LASTMODIFIED=NA;");
            stringBuilder.append("FILESIZE=NA;");
            stringBuilder.append("FILENAME=" + string5 + ";");
            stringBuilder.append("CURRENTOFFSET=0;");
            stringBuilder.append("PREVOFFSET=0;");
            stringBuilder.append("CHUNKID=1;");
            stringBuilder.append("CHUNKSIZE=1;");
            stringBuilder.append("MSG=" + string7 + ";");
            String string9 = stringBuilder.toString();
            this.send_to_mainR(RGlobal.topic, string9);
        }
    }

    public void processExtraFile(File file, String string, String string2, String string3) {
        String string4 = "Metrics";
        String string5 = "Collection Metrics";
        String string6 = null;
        String string7 = null;
        String string8 = string4 + "~" + string5 + "~" + string6 + "~" + string7 + "~" + string3 + "~" + string2;
        String string9 = string2 + "/" + file.getName();
        long l = file.lastModified();
        String string10 = Long.toString(l);
        long l2 = file.length();
        String string11 = Long.toString(l2);
        String string12 = new Host().getHostname().trim();
        if (string12.equals(RGlobal.topic)) {
            SendToKafka.send(string, string9, string9, 0L, 0L, 1L, 1L, null, string8, "NA", "NA", string10, string11);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("TFARFILE=NONE;");
            stringBuilder.append("NODENAME=" + string + ";");
            stringBuilder.append("FILETYPE=" + string8 + ";");
            stringBuilder.append("FIRSTTIME=NA;");
            stringBuilder.append("LASTTIME=NA;");
            stringBuilder.append("LASTMODIFIED=" + string10 + ";");
            stringBuilder.append("FILESIZE=" + string11 + ";");
            stringBuilder.append("FILENAME=" + string9 + ";");
            stringBuilder.append("CURRENTOFFSET=0;");
            stringBuilder.append("PREVOFFSET=0;");
            stringBuilder.append("CHUNKID=1;");
            stringBuilder.append("CHUNKSIZE=1;");
            stringBuilder.append("MSG=" + string9 + ";");
            String string13 = stringBuilder.toString();
            this.send_to_mainR(RGlobal.topic, string13);
        }
    }

    public void send_to_mainR(String string, String string2) {
        SSLSocket sSLSocket = null;
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        Object var6_6 = null;
        String string3 = new Host().getHostname().trim();
        String string4 = string3.trim() + ":remotecollection:" + string2;
        try {
            Output.printTrace("BroadcastMessage.broadcastInC: Make socket con to: " + string, 3);
            Properties.getInstance();
            String string5 = Properties.trustStore;
            Properties.getInstance();
            String string6 = Properties.trustStorePassword;
            sSLSocket = SocketManager.getSecureSocketConnection(string, Global.getSocketPort(), string5, string6);
            if (null == sSLSocket) {
                Output.printTrace("Couldn't get socket for the connection to Host : " + string, 1);
                return;
            }
            printWriter = new PrintWriter(sSLSocket.getOutputStream(), true);
            printWriter.println(string4);
            bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
            bufferedReader.close();
            if (!sSLSocket.isClosed()) {
                sSLSocket.close();
            }
        }
        catch (UnknownHostException unknownHostException) {
            Output.printTrace("Don't know about host: " + string, 1);
        }
        catch (IOException iOException) {
            Output.printTrace("Couldn't get I/O for the connection to Host : " + string, 1);
            iOException.printStackTrace();
        }
    }

    public void processFile(String string, String string2, String string3) {
        String string4 = null;
        String string5 = null;
        File file = new File(string);
        if (!file.exists()) {
            Output.printTrace("ProcessCollection: File " + file + " does not exist", 3);
            return;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("file");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                string4 = element.getElementsByTagName("hostname").item(0).getTextContent();
                string5 = element.getElementsByTagName("file_name").item(0).getTextContent();
                string5 = string2 + string5;
                String string6 = element.getElementsByTagName("file_name").item(0).getTextContent();
                Long l = 0L;
                Long l2 = 0L;
                Long l3 = 0L;
                Object var18_19 = null;
                String string7 = element.getElementsByTagName("file_type").item(0).getTextContent();
                String string8 = element.getElementsByTagName("instance").item(0).getTextContent();
                String string9 = element.getElementsByTagName("database").item(0).getTextContent();
                String string10 = element.getElementsByTagName("component").item(0).getTextContent();
                String string11 = string7 + "~" + string10 + "~" + string8 + "~" + string9 + "~" + string3 + "~" + string2;
                String string12 = element.getElementsByTagName("first_timestamp").item(0).getTextContent();
                String string13 = element.getElementsByTagName("last_timestamp").item(0).getTextContent();
                String string14 = element.getElementsByTagName("last_modified").item(0).getTextContent();
                String string15 = element.getElementsByTagName("size").item(0).getTextContent();
                SendToKafka.send(string4, string5, string6, 0L, 0L, 1L, 1L, null, string11, string12, string13, string14, string15);
            }
        }
        catch (Exception exception) {
            Output.printTrace("ProcessCollection: Exception in process file " + string5, 1);
            exception.printStackTrace();
        }
    }
}

