/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.receiver;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.stream.JsonParser;
import oracle.rat.tfa.receiver.CaseInsensitiveWhitespaceAnalyzer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.DrillSideways;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.LongRangeFacetCounts;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class MetadataSearcher {
    private IndexSearcher misearcher;
    private TaxonomyReader taxoReader;
    private Analyzer analyzer;
    private SimpleDateFormat ft = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private boolean only_counts = false;

    public MetadataSearcher(String string) {
        DirectoryReader directoryReader = null;
        try {
            directoryReader = DirectoryReader.open((Directory)FSDirectory.open((File)new File(string)));
            String string2 = string + "_t";
            this.taxoReader = new DirectoryTaxonomyReader((Directory)FSDirectory.open((File)new File(string2)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.misearcher = new IndexSearcher((IndexReader)directoryReader);
        this.analyzer = new WhitespaceAnalyzer(Version.LUCENE_47);
    }

    public ArrayList<Document> get_query_docs(String string, String string2) {
        FacetsConfig facetsConfig = new FacetsConfig();
        DrillDownQuery drillDownQuery = new DrillDownQuery(facetsConfig);
        drillDownQuery.add(string, new String[]{string2});
        DrillDownQuery drillDownQuery2 = drillDownQuery;
        TopDocs topDocs = null;
        try {
            topDocs = this.misearcher.search((Query)drillDownQuery2, 10000);
        }
        catch (IOException iOException) {
            System.out.println("MetadataSearcher::Exception caught while searching");
            iOException.printStackTrace();
        }
        ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
        int n = topDocs.totalHits;
        int n2 = 0;
        int n3 = Math.min(scoreDocArray.length, 10000);
        ArrayList<Document> arrayList = new ArrayList<Document>();
        for (int i = n2; i < n3; ++i) {
            Document document = null;
            try {
                document = this.misearcher.doc(scoreDocArray[i].doc);
            }
            catch (IOException iOException) {
                System.out.println("MetadataSearcher::Exception caught while fetching document");
                iOException.printStackTrace();
            }
            arrayList.add(document);
        }
        return arrayList;
    }

    public ArrayList<Document> get_jsonq_res(String string) {
        TermQuery termQuery;
        String string2;
        JsonParser.Event event;
        StringReader stringReader = new StringReader(string);
        JsonParser jsonParser = Json.createParser((Reader)stringReader);
        String string3 = null;
        FacetsConfig facetsConfig = new FacetsConfig();
        DrillDownQuery drillDownQuery = new DrillDownQuery(facetsConfig);
        BooleanQuery booleanQuery = new BooleanQuery();
        while (jsonParser.hasNext()) {
            event = jsonParser.next();
            switch (event) {
                case KEY_NAME: {
                    string3 = jsonParser.getString().trim();
                    break;
                }
                case VALUE_STRING: {
                    string2 = jsonParser.getString().trim();
                    if (string3.startsWith("_req_")) break;
                    drillDownQuery.add(string3, new String[]{string2});
                    termQuery = new TermQuery(new Term(string3, string2));
                    booleanQuery.add(new BooleanClause((Query)termQuery, BooleanClause.Occur.MUST));
                    break;
                }
                case VALUE_NUMBER: {
                    termQuery = Long.valueOf(jsonParser.getLong());
                    break;
                }
                case VALUE_FALSE: {
                    break;
                }
                case VALUE_TRUE: {
                    break;
                }
                case VALUE_NULL: {
                    System.out.println("Got null for key:" + string3);
                    break;
                }
            }
        }
        jsonParser.close();
        event = booleanQuery;
        string2 = null;
        try {
            string2 = this.misearcher.search((Query)event, 10000);
        }
        catch (IOException iOException) {
            System.out.println("MetadataSearcher::Exception caught while searching");
            iOException.printStackTrace();
        }
        termQuery = ((TopDocs)string2).scoreDocs;
        int n = ((TopDocs)string2).totalHits;
        int n2 = 0;
        int n3 = Math.min(((ScoreDoc[])termQuery).length, 10000);
        ArrayList<Document> arrayList = new ArrayList<Document>();
        for (int i = n2; i < n3; ++i) {
            Document document = null;
            try {
                document = this.misearcher.doc(termQuery[i].doc);
            }
            catch (IOException iOException) {
                System.out.println("MetadataSearcher::Exception caught while fetching document");
                iOException.printStackTrace();
            }
            arrayList.add(document);
        }
        return arrayList;
    }

    public String get_val_json(String string) {
        Object object;
        string = string.substring(1, string.length() - 1);
        String[] stringArray = string.split(",");
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].lastIndexOf(58);
            object = stringArray[i].substring(0, n);
            String string2 = stringArray[i].substring(n + 1);
            jsonObjectBuilder.add((String)object, string2);
        }
        JsonObject jsonObject = jsonObjectBuilder.build();
        StringWriter stringWriter = new StringWriter();
        object = Json.createWriter((Writer)stringWriter);
        object.writeObject(jsonObject);
        object.close();
        return stringWriter.toString();
    }

    public String get_result(String string) {
        Document document;
        ArrayList<Document> arrayList = this.get_jsonq_res(string);
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        for (int i = 0; i < arrayList.size(); ++i) {
            document = arrayList.get(i);
            MetadataSearcher.addContextDocs2(jsonArrayBuilder, document);
        }
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        document = jsonArrayBuilder.build();
        jsonObjectBuilder.add("Results", (JsonValue)document);
        JsonObject jsonObject = jsonObjectBuilder.build();
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);
        jsonWriter.writeObject(jsonObject);
        jsonWriter.close();
        return stringWriter.toString();
    }

    private JsonObject get_query_result(JsonObject jsonObject) throws Exception {
        JsonArrayBuilder jsonArrayBuilder;
        DrillDownQuery drillDownQuery;
        CaseInsensitiveWhitespaceAnalyzer caseInsensitiveWhitespaceAnalyzer = new CaseInsensitiveWhitespaceAnalyzer(Version.LUCENE_47);
        long l = Long.parseLong(jsonObject.getString("from"));
        long l2 = Long.parseLong(jsonObject.getString("to"));
        int n = Integer.parseInt(jsonObject.getString("pagenum"));
        int n2 = Integer.parseInt(jsonObject.getString("paging"));
        String string = jsonObject.getString("s_op");
        String string2 = jsonObject.getString("fq");
        String string3 = jsonObject.getString("q");
        String string4 = jsonObject.getString("aq");
        String string5 = jsonObject.getString("facet_name");
        String string6 = jsonObject.getString("facet_size");
        String string7 = jsonObject.getString("facet_orderby");
        String string8 = jsonObject.getString("facet_function");
        if (!string8.isEmpty()) {
            this.only_counts = true;
        }
        BooleanQuery booleanQuery = this.create_query(string3, l, l2, caseInsensitiveWhitespaceAnalyzer);
        if (!string4.isEmpty()) {
            booleanQuery = this.create_query(string3, l, l2, caseInsensitiveWhitespaceAnalyzer);
        }
        FacetsConfig facetsConfig = new FacetsConfig();
        DrillDownQuery drillDownQuery2 = drillDownQuery = new DrillDownQuery(facetsConfig, (Query)booleanQuery);
        if (!string2.isEmpty()) {
            jsonArrayBuilder = this.create_facet_query(string2, drillDownQuery);
            drillDownQuery2 = jsonArrayBuilder;
        }
        jsonArrayBuilder = Json.createArrayBuilder();
        ArrayList<FacetResult> arrayList = new ArrayList<FacetResult>();
        if (string5 != null) {
            int n3 = Integer.parseInt(string6.trim());
            this.get_facetresults_byfacet(arrayList, (Query)drillDownQuery2, l, l2, jsonArrayBuilder, string5, n3);
        } else {
            this.get_facetresults(arrayList, (Query)drillDownQuery2, l, l2, jsonArrayBuilder);
        }
        if (this.only_counts) {
            JsonObject jsonObject2 = this.buildJson(jsonArrayBuilder, "Facets");
            return jsonObject2;
        }
        SortField sortField = new SortField("Time", SortField.Type.LONG, true);
        Sort sort = string.equals("sort_ta") ? new Sort(new SortField[]{new SortField("Time", SortField.Type.LONG), new SortField("Filepath", SortField.Type.STRING), new SortField("Linenumber", SortField.Type.LONG)}) : (string.equals("sort_td") ? new Sort(new SortField[]{new SortField("Time", SortField.Type.LONG, true), new SortField("Filepath", SortField.Type.LONG), new SortField("Linenumber", SortField.Type.LONG)}) : (string.equals("sort_rv") ? Sort.RELEVANCE : new Sort(new SortField[]{new SortField("Filepath", SortField.Type.LONG), new SortField("Time", SortField.Type.LONG), new SortField("Linenumber", SortField.Type.LONG)})));
        JsonObject jsonObject3 = this.doPagingSearch((Query)drillDownQuery2, n2, n, caseInsensitiveWhitespaceAnalyzer, jsonArrayBuilder, sort);
        return jsonObject3;
    }

    private void get_facetresults_byfacet(List<FacetResult> list, Query query, long l, long l2, JsonArrayBuilder jsonArrayBuilder, String string, int n) throws Exception {
        int n2 = this.fsearch1_byfacet(list, query, string, n);
        for (int i = 0; i < n2; ++i) {
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
            FacetResult facetResult = list.get(i);
            if (facetResult != null) {
                jsonObjectBuilder.add("Facet", facetResult.dim);
                LabelAndValue[] labelAndValueArray = facetResult.labelValues;
                JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
                for (int j = 0; j < labelAndValueArray.length; ++j) {
                    jsonArrayBuilder2.add(Json.createObjectBuilder().add(labelAndValueArray[j].label, labelAndValueArray[j].value.toString()));
                }
                JsonArray jsonArray = jsonArrayBuilder2.build();
                jsonObjectBuilder = jsonObjectBuilder.add("values", (JsonValue)jsonArray);
            }
            jsonArrayBuilder.add(jsonObjectBuilder);
        }
    }

    private int fsearch1_byfacet(List<FacetResult> list, Query query, String string, int n) throws Exception {
        FacetsConfig facetsConfig = new FacetsConfig();
        DrillSideways drillSideways = new DrillSideways(this.misearcher, facetsConfig, this.taxoReader);
        DrillSideways.DrillSidewaysResult drillSidewaysResult = drillSideways.search((DrillDownQuery)query, 1000);
        list.add(drillSidewaysResult.facets.getTopChildren(n, string, new String[0]));
        return 1;
    }

    private void get_facetresults(List<FacetResult> list, Query query, long l, long l2, JsonArrayBuilder jsonArrayBuilder) throws Exception {
        FacetResult facetResult = this.fsearch(query, l, l2);
        list.add(facetResult);
        int n = this.fsearch1(list, query);
        for (int i = 0; i < n; ++i) {
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
            FacetResult facetResult2 = list.get(i);
            if (facetResult2 != null) {
                jsonObjectBuilder.add("Facet", facetResult2.dim);
                LabelAndValue[] labelAndValueArray = facetResult2.labelValues;
                JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
                for (int j = 0; j < labelAndValueArray.length; ++j) {
                    jsonArrayBuilder2.add(Json.createObjectBuilder().add(labelAndValueArray[j].label, labelAndValueArray[j].value.toString()));
                }
                JsonArray jsonArray = jsonArrayBuilder2.build();
                jsonObjectBuilder = jsonObjectBuilder.add("values", (JsonValue)jsonArray);
            }
            jsonArrayBuilder.add(jsonObjectBuilder);
        }
    }

    private int fsearch1(List<FacetResult> list, Query query) throws Exception {
        FacetsConfig facetsConfig = new FacetsConfig();
        DrillSideways drillSideways = new DrillSideways(this.misearcher, facetsConfig, this.taxoReader);
        DrillSideways.DrillSidewaysResult drillSidewaysResult = drillSideways.search((DrillDownQuery)query, 1000);
        List list2 = drillSidewaysResult.facets.getAllDims(100);
        for (int i = 0; i < list2.size(); ++i) {
            FacetResult facetResult = (FacetResult)list2.get(i);
            String string = facetResult.dim;
            list.add(drillSidewaysResult.facets.getTopChildren(1000, string, new String[0]));
        }
        return list2.size();
    }

    public static Date get_start_interval(long l, String string) {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        if (string.equals("year")) {
            ++n;
            n2 = 0;
            n3 = 1;
            n4 = 0;
            n5 = 0;
            n6 = 0;
        } else if (string.equals("month")) {
            ++n2;
            n3 = 1;
            n4 = 0;
            n5 = 0;
            n6 = 0;
        } else if (string.equals("week")) {
            n3 += 7;
        } else if (string.equals("day")) {
            ++n3;
            n4 = 0;
            n5 = 0;
            n6 = 0;
        } else if (string.equals("hour")) {
            ++n4;
            n5 = 0;
            n6 = 0;
        } else if (string.equals("minute")) {
            ++n5;
            n6 = 0;
        }
        calendar2.set(1, n);
        calendar2.set(2, n2);
        calendar2.set(5, n3);
        calendar2.set(11, n4);
        calendar2.set(12, n5);
        calendar2.set(13, n6);
        calendar2.set(14, 0);
        return calendar2.getTime();
    }

    public static String get_label(Date date, Date date2, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String string2 = "";
        if (string.equals("year")) {
            simpleDateFormat = new SimpleDateFormat("yyyy");
        } else if (string.equals("month")) {
            simpleDateFormat = new SimpleDateFormat("MMM yyyy");
        } else if (!string.equals("week")) {
            simpleDateFormat = string.equals("day") ? new SimpleDateFormat("dd MMM yyyy") : new SimpleDateFormat("yyyy MMM dd HH:mm:ss");
        }
        string2 = simpleDateFormat.format(date);
        return string2;
    }

    public static void create_range(List<LongRange> list, long l, long l2, long l3, String string) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String string2 = "";
        Date date = simpleDateFormat.parse(Long.toString(l));
        Date date2 = simpleDateFormat.parse(Long.toString(l2));
        Date date3 = simpleDateFormat.parse(Long.toString(l));
        long l4 = date.getTime();
        long l5 = date2.getTime();
        Date date4 = MetadataSearcher.get_start_interval(l4, string);
        Calendar calendar = Calendar.getInstance();
        string2 = MetadataSearcher.get_label(date, date4, string);
        list.add(new LongRange(string2, Long.parseLong(simpleDateFormat.format(date3)), true, Long.parseLong(simpleDateFormat.format(date4)), false));
        boolean bl = false;
        int n = 1;
        while (true) {
            String string3 = simpleDateFormat.format(date4);
            date3 = simpleDateFormat.parse(string3);
            calendar.setTimeInMillis(date3.getTime());
            if (string.equals("year")) {
                calendar.add(1, 1);
            } else if (string.equals("month")) {
                calendar.add(2, 1);
            } else if (string.equals("week")) {
                calendar.add(5, 7);
            } else if (string.equals("day")) {
                calendar.add(5, 1);
            } else if (string.equals("hour")) {
                calendar.add(11, 1);
            } else if (string.equals("minute")) {
                calendar.add(12, 1);
            } else {
                calendar.add(13, 1);
            }
            date4.setTime(calendar.getTimeInMillis());
            string2 = MetadataSearcher.get_label(date3, date2, string);
            if (date4.getTime() >= l5) {
                string2 = MetadataSearcher.get_label(date3, date2, string);
                date4 = date2;
                bl = true;
            }
            list.add(new LongRange(string2, Long.parseLong(simpleDateFormat.format(date3)), true, Long.parseLong(simpleDateFormat.format(date4)), false));
            if (bl) break;
            ++n;
        }
    }

    private FacetResult fsearch(Query query, long l, long l2) throws Exception {
        long l3 = 1000L;
        long l4 = 60L * l3;
        long l5 = 60L * l4;
        long l6 = 24L * l5;
        long l7 = 7L * l6;
        long l8 = 30L * l6;
        long l9 = 365L * l6;
        long l10 = l;
        long l11 = l2;
        Date date = this.ft.parse(Long.toString(l10));
        Date date2 = this.ft.parse(Long.toString(l11));
        long l12 = (date2.getTime() - date.getTime()) / l6;
        ArrayList<LongRange> arrayList = new ArrayList<LongRange>();
        if (l12 > 2000L) {
            MetadataSearcher.create_range(arrayList, l10, l11, l9, "year");
        } else if (l12 <= 2000L && l12 > 365L) {
            MetadataSearcher.create_range(arrayList, l10, l11, l8, "month");
        } else if (l12 <= 365L && l12 > 30L) {
            MetadataSearcher.create_range(arrayList, l10, l11, l7, "week");
        } else if (l12 <= 30L && l12 > 4L) {
            MetadataSearcher.create_range(arrayList, l10, l11, l6, "day");
        } else if (l12 <= 4L && (double)l12 > 0.1) {
            MetadataSearcher.create_range(arrayList, l10, l11, l5, "hour");
        } else {
            MetadataSearcher.create_range(arrayList, l10, l11, l4, "minute");
        }
        if (query == null) {
            query = new MatchAllDocsQuery();
        }
        FacetsCollector facetsCollector = new FacetsCollector();
        FacetsCollector.search((IndexSearcher)this.misearcher, (Query)query, (int)100, (Collector)facetsCollector);
        LongRange[] longRangeArray = new LongRange[arrayList.size()];
        arrayList.toArray(longRangeArray);
        LongRangeFacetCounts longRangeFacetCounts = new LongRangeFacetCounts("Time", facetsCollector, longRangeArray);
        return longRangeFacetCounts.getTopChildren(100, "Time", new String[0]);
    }

    private DrillDownQuery create_facet_query(String string, DrillDownQuery drillDownQuery) {
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            String[] stringArray3 = stringArray2[1].split(",");
            for (int j = 0; j < stringArray3.length; ++j) {
                drillDownQuery.add(stringArray2[0], new String[]{stringArray3[j]});
            }
        }
        return drillDownQuery;
    }

    private BooleanQuery create_query(String string, long l, long l2, Analyzer analyzer) throws Exception {
        QueryParser queryParser = new QueryParser(Version.LUCENE_47, "ID", analyzer);
        BooleanQuery booleanQuery = new BooleanQuery();
        Query query = null;
        queryParser.setAllowLeadingWildcard(true);
        string = string.toLowerCase();
        if (string.endsWith("\"")) {
            System.out.println("Query ends with quote");
        } else {
            string = QueryParser.escape((String)string);
            string = "*" + string + "*";
        }
        query = queryParser.parse(string);
        NumericRangeQuery numericRangeQuery = NumericRangeQuery.newLongRange((String)"Time", (Long)l, (Long)l2, (boolean)true, (boolean)false);
        booleanQuery.add(query, BooleanClause.Occur.MUST);
        booleanQuery.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        return booleanQuery;
    }

    public JsonObject doPagingSearch(Query query, int n, int n2, Analyzer analyzer, JsonArrayBuilder jsonArrayBuilder, Sort sort) throws IOException {
        TopFieldDocs topFieldDocs = this.misearcher.search(query, 1 + n2 * n, sort);
        ScoreDoc[] scoreDocArray = topFieldDocs.scoreDocs;
        int n3 = topFieldDocs.totalHits;
        int n4 = (n2 - 1) * n;
        int n5 = Math.min(n3, n2 * n);
        JsonObject jsonObject = null;
        JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
        n5 = Math.min(scoreDocArray.length, n4 + n);
        int n6 = -1;
        String string = "";
        String string2 = "";
        for (int i = n4; i < n5; ++i) {
            Document document = null;
            try {
                document = this.misearcher.doc(scoreDocArray[i].doc);
            }
            catch (IOException iOException) {
                System.out.println("Failed while fetching doc");
                iOException.printStackTrace();
            }
            MetadataSearcher.addContextDocs2(jsonArrayBuilder2, document);
        }
        jsonObject = this.get_json_output(jsonArrayBuilder, jsonArrayBuilder2, n5 - n4);
        return jsonObject;
    }

    public static void addContextDocs2(JsonArrayBuilder jsonArrayBuilder, Document document) {
        List list = document.getFields();
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        for (int i = 0; i < list.size(); ++i) {
            Field field = (Field)list.get(i);
            jsonObjectBuilder.add(field.name(), field.stringValue());
        }
        jsonArrayBuilder.add(jsonObjectBuilder);
    }

    private JsonObject buildJson(JsonArrayBuilder jsonArrayBuilder, String string) {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        JsonArray jsonArray = jsonArrayBuilder.build();
        jsonObjectBuilder.add(string, (JsonValue)jsonArray);
        jsonObjectBuilder.add("Results", 0);
        JsonObject jsonObject = jsonObjectBuilder.build();
        return jsonObject;
    }

    private JsonObject get_json_output(JsonArrayBuilder jsonArrayBuilder, JsonArrayBuilder jsonArrayBuilder2, int n) {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        JsonArray jsonArray = jsonArrayBuilder.build();
        JsonArray jsonArray2 = jsonArrayBuilder2.build();
        jsonObjectBuilder.add("Facets", (JsonValue)jsonArray);
        jsonObjectBuilder.add("Hits", n);
        jsonObjectBuilder.add("Results", (JsonValue)jsonArray2);
        JsonObject jsonObject = jsonObjectBuilder.build();
        return jsonObject;
    }

    public static void main(String[] stringArray) throws IOException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "/scratch/tmp/tfaMetadata";
        for (int i = 0; i < stringArray.length; ++i) {
            if ("-input".equals(stringArray[i])) {
                string = stringArray[i + 1];
                ++i;
                continue;
            }
            if ("-json".equals(stringArray[i])) {
                string2 = stringArray[i + 1];
                ++i;
                continue;
            }
            if ("-kv".equals(stringArray[i])) {
                string3 = stringArray[i + 1];
                ++i;
                continue;
            }
            if ("-indexloc".equals(stringArray[i])) {
                string4 = stringArray[i + 1];
                ++i;
                continue;
            }
            System.out.println("Incorrect usage ");
            System.exit(0);
        }
        if (string4 == null) {
            System.out.println("Specify -indexloc <loc>");
            System.exit(0);
        }
        MetadataSearcher metadataSearcher = new MetadataSearcher(string4);
        String string5 = metadataSearcher.get_result(string2);
        System.out.println(string5);
    }
}

