/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.receiver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import oracle.rat.tfa.receiver.JsonIndexer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class MetadataParseIndexer {
    private String indexloc;
    public IndexWriter metaiw;
    public DirectoryTaxonomyWriter taxow;
    private FacetsConfig config;
    private JsonIndexer jsonindexer;

    public MetadataParseIndexer(String string) {
        this.indexloc = string;
        this.metaiw = this.fixIndexWriter(string);
        this.taxow = this.fixTaxoWriter(string);
        this.config = new FacetsConfig();
        this.jsonindexer = new JsonIndexer(this.metaiw, this.taxow, this.config);
    }

    private DirectoryTaxonomyWriter fixTaxoWriter(String string) {
        String string2 = this.indexloc + "_t";
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        DirectoryTaxonomyWriter directoryTaxonomyWriter = null;
        try {
            FSDirectory fSDirectory = FSDirectory.open((File)file);
            directoryTaxonomyWriter = new DirectoryTaxonomyWriter((Directory)fSDirectory);
        }
        catch (IOException iOException) {
            System.out.println("MetadataIndexer:: Error while IW creation");
            iOException.printStackTrace();
        }
        return directoryTaxonomyWriter;
    }

    private IndexWriter fixIndexWriter(String string) {
        WhitespaceAnalyzer whitespaceAnalyzer = new WhitespaceAnalyzer(Version.LUCENE_47);
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(Version.LUCENE_47, (Analyzer)whitespaceAnalyzer);
        File file = new File(string);
        String string2 = string + "_t";
        File file2 = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        indexWriterConfig.setRAMBufferSizeMB(56.0);
        indexWriterConfig.setMaxThreadStates(64);
        IndexWriter indexWriter = null;
        try {
            FSDirectory fSDirectory = FSDirectory.open((File)file);
            indexWriter = new IndexWriter((Directory)fSDirectory, indexWriterConfig);
        }
        catch (IOException iOException) {
            System.out.println("MetadataIndexer:: Error while IW creation");
            iOException.printStackTrace();
        }
        return indexWriter;
    }

    public void addToMetadataIndex(String string) {
        this.jsonindexer.index_json(string);
        try {
            this.metaiw.commit();
            this.taxow.commit();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = "/scratch/tmp/tfaMetadata";
        MetadataParseIndexer metadataParseIndexer = new MetadataParseIndexer(string);
        String string2 = "{\"Patid\":\"1\",\"Filetype_f\":\"apache_log\",   \"pattern_text\": \"^([\\\\d\\\\.]+)( - )(.*)\\\\[(.*)\\\\]\\\\s*(\\\\\\\".*\\\\\\\")\\\\s*(\\\\d+)\\\\s*(\\\\d+)\\\\s*\\\\*\\\\*(\\\\d+)/(\\\\d+)\",   \"match\": \"7\",\"values\":[    { \"pos1\": \"1\", \"field1\": \"Ip\",\"facet1\": \"yes\"},    { \"pos2\": \"3\", \"field2\": \"User\",\"facet3\": \"yes\"},   { \"pos3\": \"4\", \"field3\": \"Time\",\"facet4\": \"yes\"},     { \"pos4\": \"6\", \"field4\": \"Request\",\"facet5\": \"yes\"},     { \"pos5\": \"7\", \"field5\": \"Response_Code\",\"facet5\": \"yes\"},    { \"pos6\": \"8\", \"field6\": \"Response_Time_sec\",\"facet6\": \"yes\" },   { \"pos7\": \"9\", \"field7\": \"Response_Time_Microsec\", \"facet7\": \"yes\" }  ],\"critical\":\"NA\"\"date_pattern\":\"dd/MMM/yyyy:HH:mm:ss Z\"\"date_match_pos\":\"4\"}";
        String string3 = null;
        String string4 = null;
        Object var6_6 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if ("-indexpat".equals(stringArray[i])) {
                string3 = stringArray[i + 1];
                ++i;
                continue;
            }
            if ("-ijfile".equals(stringArray[i])) {
                string4 = stringArray[i + 1];
                ++i;
                continue;
            }
            if ("-indexloc".equals(stringArray[i])) {
                string = stringArray[i + 1];
                ++i;
                continue;
            }
            System.out.println("Incorrect usage ");
            System.exit(0);
        }
        if (string3 != null) {
            metadataParseIndexer.addToMetadataIndex(string3);
            System.out.println("MetadataIndexer::Indexed" + string3);
        } else if (string4 != null) {
            String string5 = null;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string4));
            while ((string5 = bufferedReader.readLine()) != null) {
                metadataParseIndexer.addToMetadataIndex(string5);
            }
        } else {
            System.out.println("MetadataIndexer::Nothing to index");
        }
        metadataParseIndexer.metaiw.close();
        metadataParseIndexer.taxow.close();
    }
}

