/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.receiver;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import oracle.rat.tfa.receiver.JsonIndexer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class MetadataIndexer {
    private String indexloc;
    public IndexWriter metaiw;
    public DirectoryTaxonomyWriter taxow;
    private FacetsConfig config;
    private JsonIndexer jsonindexer;

    public MetadataIndexer(String string) {
        this.indexloc = string;
        this.metaiw = this.fixIndexWriter(string);
        this.taxow = this.fixTaxoWriter(string);
        this.config = new FacetsConfig();
        this.jsonindexer = new JsonIndexer(this.metaiw, this.taxow, this.config);
    }

    private DirectoryTaxonomyWriter fixTaxoWriter(String string) {
        String string2 = this.indexloc + "_t";
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        DirectoryTaxonomyWriter directoryTaxonomyWriter = null;
        try {
            FSDirectory fSDirectory = FSDirectory.open((File)file);
            DirectoryTaxonomyWriter.unlock((Directory)fSDirectory);
            if (fSDirectory.fileExists("write.lock")) {
                fSDirectory.clearLock("write.lock");
            }
            directoryTaxonomyWriter = new DirectoryTaxonomyWriter((Directory)fSDirectory);
            directoryTaxonomyWriter.commit();
        }
        catch (IOException iOException) {
            System.out.println("MetadataIndexer:: Error while TIW creation");
            iOException.printStackTrace();
        }
        return directoryTaxonomyWriter;
    }

    private IndexWriter fixIndexWriter(String string) {
        WhitespaceAnalyzer whitespaceAnalyzer = new WhitespaceAnalyzer(Version.LUCENE_47);
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(Version.LUCENE_47, (Analyzer)whitespaceAnalyzer);
        File file = new File(string);
        String string2 = string + "_t";
        File file2 = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        indexWriterConfig.setRAMBufferSizeMB(56.0);
        indexWriterConfig.setMaxThreadStates(64);
        IndexWriterConfig.setDefaultWriteLockTimeout((long)6000L);
        IndexWriter indexWriter = null;
        try {
            FSDirectory fSDirectory = FSDirectory.open((File)file);
            IndexWriter.unlock((Directory)fSDirectory);
            if (fSDirectory.fileExists("write.lock")) {
                fSDirectory.clearLock("write.lock");
            }
            indexWriter = new IndexWriter((Directory)fSDirectory, indexWriterConfig);
            indexWriter.commit();
        }
        catch (IOException iOException) {
            System.out.println("MetadataIndexer:: Error while IW creation");
            iOException.printStackTrace();
        }
        return indexWriter;
    }

    public Query get_query_json(String string) {
        BooleanQuery booleanQuery = new BooleanQuery();
        string = string.substring(1, string.length() - 1);
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].lastIndexOf(58);
            String string2 = stringArray[i].substring(0, n);
            String string3 = stringArray[i].substring(n + 1);
            string2 = string2.substring(1, string2.length() - 1);
            string3 = string3.substring(1, string3.length() - 1);
            if (string2.contains("_req")) continue;
            TermQuery termQuery = new TermQuery(new Term(string2, string3));
            booleanQuery.add(new BooleanClause((Query)termQuery, BooleanClause.Occur.MUST));
        }
        BooleanQuery booleanQuery2 = booleanQuery;
        return booleanQuery2;
    }

    public String get_val_json(String string) {
        Object object;
        string = string.substring(1, string.length() - 1);
        String[] stringArray = string.split(",");
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].lastIndexOf(58);
            object = stringArray[i].substring(0, n);
            String string2 = stringArray[i].substring(n + 1);
            jsonObjectBuilder.add((String)object, string2);
        }
        JsonObject jsonObject = jsonObjectBuilder.build();
        StringWriter stringWriter = new StringWriter();
        object = Json.createWriter((Writer)stringWriter);
        object.writeObject(jsonObject);
        object.close();
        return stringWriter.toString();
    }

    public void deleteMetadataIndex(Query query) {
        try {
            this.metaiw.deleteDocuments(new Query[]{query});
            this.metaiw.commit();
        }
        catch (IOException iOException) {
            System.out.println("MetadataIndexer::error deleting");
            iOException.printStackTrace();
        }
    }

    public void addToMetadataIndex(String string) {
        this.jsonindexer.index_json(string);
        try {
            this.taxow.commit();
            this.metaiw.commit();
        }
        catch (IOException iOException) {
            System.out.println("MetadataIndexer:: error adding");
            iOException.printStackTrace();
        }
    }

    public void close() {
        try {
            this.taxow.close();
            this.metaiw.close();
        }
        catch (IOException iOException) {
            System.out.println("MetadataIndexer:: error closing");
            iOException.printStackTrace();
        }
    }

    public void deleteIndex(String string) {
        Query query = this.get_query_json(string);
        this.deleteMetadataIndex(query);
    }
}

