/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.receiver;

import java.io.File;
import oracle.rat.tfa.receiver.CaseInsensitiveWhitespaceAnalyzer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.TrackingIndexWriter;
import org.apache.lucene.search.ControlledRealTimeReopenThread;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class LucenedIndex {
    public static Directory indexDirectory;
    public static Analyzer analyzer;
    public static IndexWriter indexWriter;
    public static TrackingIndexWriter trackingIndexWriter;
    public static ReferenceManager<IndexSearcher> indexSearcherManager;
    public static ControlledRealTimeReopenThread<IndexSearcher> indexReopenThread;
    public static DirectoryTaxonomyWriter taxoWriter;
    public static String dindexloc;

    public static void init(String string) {
        try {
            dindexloc = string;
            File file = new File(string);
            String string2 = string + "_t";
            File file2 = new File(string2);
            FSDirectory fSDirectory = FSDirectory.open((File)file2);
            indexDirectory = FSDirectory.open((File)file);
            analyzer = new CaseInsensitiveWhitespaceAnalyzer(Version.LUCENE_47);
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(Version.LUCENE_47, analyzer);
            indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            indexWriterConfig.setRAMBufferSizeMB(56.0);
            indexWriterConfig.setMaxThreadStates(6);
            indexWriterConfig.setUseCompoundFile(false);
            indexWriter = new IndexWriter(indexDirectory, indexWriterConfig);
            taxoWriter = new DirectoryTaxonomyWriter((Directory)fSDirectory);
            trackingIndexWriter = new TrackingIndexWriter(indexWriter);
            indexSearcherManager = new SearcherManager(indexWriter, true, null);
            indexReopenThread = new ControlledRealTimeReopenThread(trackingIndexWriter, indexSearcherManager, 1.0, 0.1);
            indexReopenThread.start();
        }
        catch (Exception exception) {
            System.out.println("Excpetion in LucenedIndex");
        }
    }
}

