/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.receiver;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.json.Json;
import javax.json.stream.JsonParser;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;

public class JsonIndexer {
    private FacetsConfig config;
    private IndexWriter writer;
    private DirectoryTaxonomyWriter taxoWriter;

    public JsonIndexer(IndexWriter indexWriter, DirectoryTaxonomyWriter directoryTaxonomyWriter, FacetsConfig facetsConfig) {
        this.writer = indexWriter;
        this.config = facetsConfig;
        this.taxoWriter = directoryTaxonomyWriter;
    }

    public IndexWriter getWriter() {
        return this.writer;
    }

    public void setWriter(IndexWriter indexWriter) {
        this.writer = indexWriter;
    }

    public void deleteIndex(Query query) {
        try {
            this.writer.deleteDocuments(new Query[]{query});
            this.writer.commit();
        }
        catch (IOException iOException) {
            System.out.println("JsonIndexer::error deleting");
            iOException.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void index_json(String string) {
        StringReader stringReader = new StringReader(string);
        JsonParser jsonParser = Json.createParser((Reader)stringReader);
        String string2 = null;
        boolean bl = false;
        boolean bl2 = false;
        Document document = new Document();
        try {
            block12: while (jsonParser.hasNext()) {
                JsonParser.Event event = jsonParser.next();
                switch (event) {
                    case KEY_NAME: {
                        string2 = jsonParser.getString();
                        if (string2.contains("_mpath_f") || string2.contains("_mcluster_f") || string2.contains("_mhftype_f") || string2.contains("_mhhost_f") || string2.contains("_mcpath_f") || string2.contains("_mepath_f") || string2.contains("_mdash_f")) {
                            bl2 = true;
                            bl = false;
                            string2 = string2.substring(0, string2.lastIndexOf(95));
                            break;
                        }
                        if (string2.contains("_f")) {
                            bl = true;
                            bl2 = false;
                            string2 = string2.substring(0, string2.lastIndexOf(95));
                            break;
                        }
                        bl = false;
                        bl2 = false;
                        break;
                    }
                    case VALUE_STRING: {
                        String[] stringArray;
                        Object object;
                        Long l;
                        String string3 = jsonParser.getString();
                        if (string3.isEmpty()) {
                            string3 = "Null";
                        }
                        if (string2.equals("Contents")) {
                            l = new TextField(string2, string3, Field.Store.YES);
                            document.add((IndexableField)l);
                            break;
                        }
                        if (string2.startsWith("_req_")) break;
                        l = new StringField(string2, string3, Field.Store.YES);
                        document.add((IndexableField)l);
                        if (bl2) {
                            object = new ArrayList();
                            for (String string4 : stringArray = string3.split("/")) {
                                if (string4.isEmpty()) continue;
                                object.add(string4);
                            }
                            String[] stringArray2 = object.toArray(new String[object.size()]);
                            FacetField facetField = new FacetField(string2, stringArray2);
                            document.add((IndexableField)facetField);
                            break;
                        }
                        if (!bl) continue block12;
                        object = new FacetField(string2, new String[]{string3});
                        document.add((IndexableField)object);
                        break;
                    }
                    case VALUE_NUMBER: {
                        String[] stringArray;
                        Object object;
                        Long l = jsonParser.getLong();
                        if (bl) {
                            object = new LongField(string2, l.longValue(), Field.Store.YES);
                            stringArray = new NumericDocValuesField(string2, l.longValue());
                            document.add((IndexableField)stringArray);
                            document.add((IndexableField)object);
                            break;
                        }
                        if (string2.startsWith("_req_")) break;
                        object = new LongField(string2, l.longValue(), Field.Store.YES);
                        document.add((IndexableField)object);
                        break;
                    }
                    case VALUE_FALSE: {
                        System.out.println("Got false for key:" + string2);
                        break;
                    }
                    case VALUE_TRUE: {
                        System.out.println("Got true for key:" + string2);
                        break;
                    }
                    case VALUE_NULL: {
                        System.out.println("Got null for key:" + string2);
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("I caught: " + exception + " for string " + string);
        }
        jsonParser.close();
        try {
            this.writer.addDocument((Iterable)this.config.build((TaxonomyWriter)this.taxoWriter, document));
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

