/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.receiver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;

public class IndexerTaskMap
implements Callable<Boolean> {
    private String sr;
    private String filepath;
    private IndexWriter writer;
    private int fid;
    private File inputfile;
    private Map<String, Field> facetFields_file;
    private Map<String, Field> facetFields_doc;
    private Map<String, Field> fields_file;
    private Map<String, Field> fields_doc;
    private Document doc;
    private List<Document> docsToIndex;
    private long default_time;
    private SimpleDateFormat rdft;
    private List<Pattern> plist;
    private List<String> dlist;
    private SimpleDateFormat ft;
    private Calendar cal;
    private FacetsConfig config;
    private DirectoryTaxonomyWriter taxoWriter;

    public IndexerTaskMap(String string, String string2, File file, IndexWriter indexWriter, List<Pattern> list, List<String> list2, int n, Map<String, Field> map, Map<String, Field> map2, Map<String, Field> map3, Map<String, Field> map4, FacetsConfig facetsConfig, DirectoryTaxonomyWriter directoryTaxonomyWriter) {
        this.sr = string2;
        this.filepath = string;
        this.writer = indexWriter;
        this.fid = n;
        this.doc = new Document();
        this.inputfile = new File(this.filepath);
        this.default_time = this.inputfile.lastModified();
        this.docsToIndex = new ArrayList<Document>(35);
        this.rdft = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        this.plist = list;
        this.dlist = list2;
        this.ft = new SimpleDateFormat();
        this.cal = Calendar.getInstance();
        this.facetFields_file = map;
        this.facetFields_doc = map2;
        this.fields_file = map3;
        this.fields_doc = map4;
        this.config = facetsConfig;
        this.taxoWriter = directoryTaxonomyWriter;
    }

    @Override
    public Boolean call() {
        BufferedReader bufferedReader = null;
        int n = 1;
        try {
            long l;
            bufferedReader = new BufferedReader(new FileReader(this.inputfile));
            String string = this.inputfile.getName();
            String string2 = null;
            boolean bl = false;
            long l2 = 0L;
            String string3 = this.rdft.format(new Date(this.default_time));
            long l3 = l = Long.parseLong(string3);
            this.addAllFieldsToDoc(this.doc);
            LongField longField = new LongField("Time", 0L, Field.Store.YES);
            NumericDocValuesField numericDocValuesField = new NumericDocValuesField("Time", 0L);
            while ((string2 = bufferedReader.readLine()) != null) {
                Document document;
                l2 = this.get_time(string2, l3);
                if (l2 == l && n <= 30) {
                    document = this.createNewDocuments(string2, string, n, l2);
                    this.docsToIndex.add(document);
                } else if (!bl) {
                    document = this.createNewDocuments(string2, string, n, l2);
                    this.docsToIndex.add(document);
                    this.indexSavedDocs(l2, numericDocValuesField, longField);
                    bl = true;
                    this.docsToIndex = null;
                } else if (bl) {
                    this.update_all_doc_fields(string2, string, n, l2);
                    this.writer.addDocument((Iterable)this.config.build((TaxonomyWriter)this.taxoWriter, this.doc));
                }
                ++n;
                l3 = l2;
            }
            if (!bl) {
                System.out.println("No pattern found in file: " + this.filepath);
                this.indexSavedDocs(l2, numericDocValuesField, longField);
            }
            System.out.println("Indexed File:" + this.fid + "with:" + n + " records");
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private void printarray() {
        int n = this.docsToIndex.size();
        for (int i = 0; i < n; ++i) {
            Document document = this.docsToIndex.get(i);
        }
    }

    private void indexSavedDocs(long l, NumericDocValuesField numericDocValuesField, LongField longField) {
        numericDocValuesField.setLongValue(l);
        longField.setLongValue(l);
        for (Document document : this.docsToIndex) {
            document.add((IndexableField)numericDocValuesField);
            document.add((IndexableField)longField);
            try {
                this.writer.addDocument((Iterable)this.config.build((TaxonomyWriter)this.taxoWriter, document));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void update_all_doc_fields(String string, String string2, int n, long l) {
        string2 = string2.replace('.', '_');
        String string3 = string2 + "_" + Integer.toString(n);
        this.facetFields_doc.get("Time").setLongValue(l);
        this.fields_doc.get("Time").setLongValue(l);
        this.fields_doc.get("Linenumber").setLongValue((long)n);
        this.fields_doc.get("Contents").setStringValue(string);
        this.fields_doc.get("ID").setStringValue(string3);
    }

    private Document createNewDocuments(String string, String string2, int n, long l) {
        Field field2;
        Document document = new Document();
        for (Field field2 : this.facetFields_file.values()) {
            document.add((IndexableField)field2);
        }
        for (Field field2 : this.fields_file.values()) {
            document.add((IndexableField)field2);
        }
        string2 = string2.replace('.', '_');
        String string3 = string2 + "_" + Integer.toString(n);
        field2 = new StringField("ID", string3, Field.Store.YES);
        LongField longField = new LongField("Linenumber", (long)n, Field.Store.YES);
        TextField textField = new TextField("Contents", string, Field.Store.YES);
        document.add((IndexableField)field2);
        document.add((IndexableField)longField);
        document.add((IndexableField)textField);
        return document;
    }

    private void addAllFieldsToDoc(Document document) {
        for (Field field : this.facetFields_file.values()) {
            document.add((IndexableField)field);
        }
        for (Field field : this.facetFields_doc.values()) {
            document.add((IndexableField)field);
        }
        for (Field field : this.fields_file.values()) {
            document.add((IndexableField)field);
        }
        for (Field field : this.fields_doc.values()) {
            document.add((IndexableField)field);
        }
    }

    private long get_time(String string, long l) {
        int n = this.plist.size();
        Matcher matcher = null;
        Date date = null;
        String string2 = null;
        long l2 = l;
        for (int i = 0; i < n; ++i) {
            Pattern pattern = this.plist.get(i);
            matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            this.ft.applyPattern(this.dlist.get(i));
            try {
                date = this.ft.parse(matcher.group(1));
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            this.cal.setTime(date);
            string2 = this.rdft.format(date);
            l2 = Long.parseLong(string2);
            break;
        }
        return l2;
    }
}

