/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.receiver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import oracle.rat.tfa.receiver.JsonIndexer;

public class IndexerTaskDup23
implements Callable<Boolean> {
    private String filepath;
    private String hostname;
    private String database;
    private String instance;
    private String filetype;
    private List<Pattern> plist;
    private List<String> dlist;
    private JsonIndexer jindexer;
    private SimpleDateFormat rdft;
    private SimpleDateFormat ft;
    private List<JsonObject> docsToIndex;
    private String[] linesToIndex;
    private Calendar cal;
    private int fid;
    private File infile;
    private String filename;

    public IndexerTaskDup23(String string, String string2, String string3, String string4, String string5, List<Pattern> list, List<String> list2, int n, JsonIndexer jsonIndexer) {
        this.filepath = string;
        this.database = string3;
        this.hostname = string2;
        this.instance = string4;
        this.filetype = string5;
        this.infile = new File(string);
        this.filename = this.infile.getName();
        this.plist = list;
        this.dlist = list2;
        this.jindexer = jsonIndexer;
        this.rdft = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        this.docsToIndex = new ArrayList<JsonObject>(35);
        this.linesToIndex = new String[35];
        this.ft = new SimpleDateFormat();
        this.cal = Calendar.getInstance();
        this.fid = n;
    }

    @Override
    public Boolean call() {
        BufferedReader bufferedReader = null;
        int n = 1;
        try {
            int n2;
            long l;
            bufferedReader = new BufferedReader(new FileReader(this.filepath));
            String string = null;
            boolean bl = false;
            long l2 = 0L;
            String string2 = this.rdft.format(new Date(this.infile.lastModified()));
            long l3 = l = Long.parseLong(string2);
            while ((string = bufferedReader.readLine()) != null) {
                l2 = this.get_time(string, l3);
                if (l2 == l && n <= 30) {
                    this.linesToIndex[n] = string;
                } else if (!bl) {
                    this.linesToIndex[n] = string;
                    for (n2 = 1; n2 <= n; ++n2) {
                        this.makeAndIndexJson(n2, this.linesToIndex[n2], l2);
                    }
                    bl = true;
                    this.linesToIndex = null;
                } else if (bl) {
                    this.makeAndIndexJson(n, string, l2);
                }
                ++n;
                l3 = l2;
            }
            if (!bl) {
                System.out.println("no pattern and less than 30 lines");
                for (n2 = 1; n2 <= n; ++n2) {
                    this.makeAndIndexJson(n2, this.linesToIndex[n2], l2);
                }
            }
            System.out.println("Indexed File:" + this.fid + "with:" + n + " records");
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private void makeAndIndexJson(int n, String string, long l) {
        String string2 = this.getJson(n, string, l);
        this.jindexer.index_json(string2);
    }

    private String getJson(int n, String string, long l) {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("Linenumber", n);
        jsonObjectBuilder.add("Hostname_f", this.hostname);
        jsonObjectBuilder.add("Database_f", this.database);
        jsonObjectBuilder.add("Instance_f", this.instance);
        jsonObjectBuilder.add("Filepath", this.filepath);
        jsonObjectBuilder.add("Filetype_f", this.filetype);
        jsonObjectBuilder.add("Filename", this.filename);
        jsonObjectBuilder.add("Fid", this.fid);
        jsonObjectBuilder.add("Time_f", l);
        jsonObjectBuilder.add("Contents", string);
        String string2 = this.filename.replace('.', '_') + "_" + Integer.toString(n);
        jsonObjectBuilder.add("ID", string2);
        JsonObject jsonObject = jsonObjectBuilder.build();
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);
        jsonWriter.writeObject(jsonObject);
        jsonWriter.close();
        return stringWriter.toString();
    }

    private long get_time(String string, long l) {
        int n = this.plist.size();
        Matcher matcher = null;
        Date date = null;
        String string2 = null;
        long l2 = l;
        for (int i = 0; i < n; ++i) {
            Pattern pattern = this.plist.get(i);
            matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            this.ft.applyPattern(this.dlist.get(i));
            try {
                date = this.ft.parse(matcher.group(1));
            }
            catch (ParseException parseException) {
                System.out.println(this.dlist.get(i) + i);
                parseException.printStackTrace();
            }
            this.cal.setTime(date);
            string2 = this.rdft.format(date);
            l2 = Long.parseLong(string2);
            break;
        }
        return l2;
    }
}

