/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.receiver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import javax.json.stream.JsonParser;
import oracle.rat.tfa.receiver.CaseInsensitiveWhitespaceAnalyzer;
import oracle.rat.tfa.receiver.JsonIndexer;
import oracle.rat.tfa.receiver.MetadataIndexer;
import oracle.rat.tfa.receiver.MetadataSearcher;
import oracle.rat.tfa.receiver.SearchJsonReceiver;
import oracle.rat.tfa.receiver.TFARRecordInfo;
import oracle.rat.tfa.util.ConfigManager;
import oracle.rat.tfa.util.Output;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class IndexerReceiverApache
implements Runnable {
    private SimpleDateFormat rdft;
    private SimpleDateFormat ft;
    private List<Pattern> pList;
    private List<String> dList;
    private int count = 0;
    private boolean finished = false;
    private Calendar cal;
    private SimpleDateFormat format;
    private Date curr;
    private Date prev;
    private Pattern tp;
    private Matcher match;
    private Document doc;
    private IndexWriter writer;
    private File indexPath;
    private Map<String, Field> facetFields_msg;
    private Map<String, Field> facetFields_doc;
    private Map<String, Field> fields_msg;
    private Map<String, Field> fields_doc;
    private FacetsConfig config;
    private MetadataSearcher msearcher;
    private MetadataIndexer mindexer;
    private Map<String, ArrayList<Document>> docsmap = null;
    private JsonIndexer jsonindexer;
    private DirectoryTaxonomyWriter taxoWriter;
    private HashMap<String, String> event_types;
    private Set<String> components;
    private Map<String, Integer> hosts;
    private Map<String, String> files;
    private SearchJsonReceiver datasearcher;
    private String dindex;
    ArrayList<Document> patlist;
    HashMap<String, ArrayList<Document>> patmap;
    private String tfar_record_file = null;
    private int seq_no;
    public final String FDC = "DATACENTER";
    public boolean started = false;
    private String tfar_record_dir = null;
    private String tfa_home = null;

    public IndexerReceiverApache(String string, MetadataSearcher metadataSearcher, String string2) {
        String string3 = ConfigManager.getFromRConfigPropertiesFile("r.i_seq_no");
        this.seq_no = Integer.parseInt(string3);
        Output.printTrace("got i_seq_no:" + string3, 3);
        this.tfa_home = string;
        this.tfar_record_dir = string + File.separator + "internal";
        this.tfar_record_file = this.tfar_record_dir + File.separator + "tfarrecordmeta_" + Integer.toString(this.seq_no) + ".info";
        this.pList = new ArrayList<Pattern>();
        this.dList = new ArrayList<String>();
        this.cal = Calendar.getInstance();
        this.format = new SimpleDateFormat();
        this.ft = new SimpleDateFormat();
        this.match = null;
        this.prev = new Date();
        this.curr = new Date();
        this.hosts = new HashMap<String, Integer>();
        String string4 = string + File.separator + "internal" + File.separator + "receiverhash.txt";
        File file = new File(string4);
        if (file.exists()) {
            Output.printTrace("file read_hash_from_file", 3);
            this.files = this.read_hash_from_file();
            Output.printTrace("hash:" + this.files, 3);
        } else {
            this.files = new HashMap<String, String>();
        }
        this.components = new HashSet<String>();
        this.patlist = new ArrayList();
        this.patmap = new HashMap();
        this.indexPath = new File(string2);
        this.rdft = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        this.config = new FacetsConfig();
        this.config.setIndexFieldName("_mpath", "facet_path");
        this.config.setIndexFieldName("_mdash", "facet_dpath");
        this.config.setIndexFieldName("_mcpath", "facet_cpath");
        this.config.setIndexFieldName("_mepath", "facet_epath");
        this.config.setIndexFieldName("_mhhost", "facet_host");
        this.config.setIndexFieldName("_mhftype", "facet_ftype");
        this.config.setIndexFieldName("_mfname", "Filename_p");
        this.config.setIndexFieldName("_mcluster", "facet_cluster");
        this.config.setHierarchical("_mpath", true);
        this.config.setHierarchical("_mdash", true);
        this.config.setHierarchical("_mcpath", true);
        this.config.setHierarchical("_mepath", true);
        this.config.setHierarchical("_mhhost", true);
        this.config.setHierarchical("_mhftype", true);
        this.config.setHierarchical("_mcluster", true);
        this.setStart(string2);
        this.dindex = string2;
        this.doc = new Document();
        this.msearcher = metadataSearcher;
        this.mindexer = null;
        this.docsmap = new HashMap<String, ArrayList<Document>>();
        this.datasearcher = this.datasearcher;
        this.event_types = new HashMap();
        this.event_types.put("1", "Error");
        this.event_types.put("2", "Warn");
        this.event_types.put("3", "Info");
        this.event_types.put("100", "Change");
        this.event_types.put("101", "Error");
        IndexerReceiverApache.initialize_patterns(this.pList, this.dList);
    }

    private void setStart(String string) {
        try {
            FSDirectory fSDirectory = FSDirectory.open((File)this.indexPath);
            String string2 = this.indexPath.toString();
            string2 = string2 + "_t";
            File file = new File(string2);
            FSDirectory fSDirectory2 = FSDirectory.open((File)file);
            CaseInsensitiveWhitespaceAnalyzer caseInsensitiveWhitespaceAnalyzer = new CaseInsensitiveWhitespaceAnalyzer(Version.LUCENE_47);
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(Version.LUCENE_47, (Analyzer)caseInsensitiveWhitespaceAnalyzer);
            indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            indexWriterConfig.setRAMBufferSizeMB(16.0);
            indexWriterConfig.setMaxThreadStates(4);
            indexWriterConfig.setUseCompoundFile(true);
            if (fSDirectory.fileExists("write.lock")) {
                fSDirectory.clearLock("write.lock");
            }
            this.writer = new IndexWriter((Directory)fSDirectory, indexWriterConfig);
            this.taxoWriter = new DirectoryTaxonomyWriter((Directory)fSDirectory2);
            this.writer.commit();
            this.taxoWriter.commit();
            this.datasearcher = new SearchJsonReceiver(string);
            this.jsonindexer = new JsonIndexer(this.writer, this.taxoWriter, this.config);
        }
        catch (IOException iOException) {
            System.out.println(Thread.currentThread().getId() + "Indexer::Failed to created Indexer");
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.started = true;
        String string = null;
        String string2 = "NODE";
        String string3 = "FILENAME";
        String string4 = "0";
        String string5 = "0";
        String string6 = "0";
        String string7 = "0";
        Object var8_8 = null;
        Object var9_9 = null;
        boolean bl = false;
        Object object = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        String string15 = null;
        String string16 = null;
        String string17 = null;
        String string18 = null;
        String string19 = null;
        long l = 0L;
        int n = 0;
        String string20 = null;
        String string21 = null;
        try {
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(this.tfar_record_file));
            String string22 = ConfigManager.getFromRConfigPropertiesFile("r.i_line_num");
            Output.printTrace("got i_line_s:" + string22, 3);
            int n2 = Integer.parseInt(string22);
            for (int i = 0; i < n2; ++i) {
                lineNumberReader.readLine();
            }
            while (!this.finished) {
                int n3;
                Object object2;
                String[] stringArray;
                Object object3;
                string20 = lineNumberReader.readLine();
                if (string20 == null) {
                    Output.printTrace("waiting 4 more", 4);
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("interuppt");
                    }
                    continue;
                }
                if (++n == TFARRecordInfo.maxlines) {
                    ++this.seq_no;
                    lineNumberReader.close();
                    this.tfar_record_file = this.tfar_record_dir + File.separator + "tfarrecordmeta_" + Integer.toString(this.seq_no) + ".info";
                    Output.printTrace("Indexer:File change:" + this.tfar_record_file, 3);
                    lineNumberReader = new LineNumberReader(new FileReader(this.tfar_record_file));
                    n = 0;
                }
                String string23 = null;
                Output.printTrace("Indexer:" + string20, 3);
                LinkedHashMap<String, String> linkedHashMap = this.fix_record_meta(string20);
                for (Map.Entry<String, String> entry : linkedHashMap.entrySet()) {
                    string23 = entry.getKey();
                    if (string23.equals("FILENAME")) {
                        string3 = (String)entry.getValue();
                        string3 = string3.trim();
                        string19 = string2 + ":" + string3;
                        if (string3.contains("tfainfo")) {
                            object = "tfa_info";
                            string12 = "TFA";
                        } else if (string3.contains("tfajson_lite")) {
                            object = "tfajson";
                            string12 = "TFA";
                        } else if (string3.contains("tfajson")) {
                            object = "tfajson";
                            string12 = "TFA";
                        } else if (string3.contains("tfar_metrics")) {
                            object = "_METRICS";
                            string12 = "_METRICS";
                        } else if (((String)object).equals("null")) {
                            object = "Unclassified";
                            string12 = "Unclassified";
                        }
                        if (this.files.get(string19) == null || !string17.equals("Unclassified")) {
                            object3 = new Date();
                            this.cal.setTime((Date)object3);
                            stringArray = this.rdft.format((Date)object3);
                            if (this.files.get(string19) == null && string17.equals("Unclassified") && !((String)object).equals("Unclassified") && !((String)object).equals("_METRICS")) {
                                this.files.put(string19, (String)stringArray);
                            }
                            String string24 = this.getMetaJson("File", string3, string2, (String)object, string12, string13, string14, string15, string16, string8, string9, string10, string11, string17, string18);
                            this.jsonindexer.index_json(string24);
                            this.taxoWriter.commit();
                            this.writer.commit();
                            continue;
                        }
                        object3 = this.get_query_file(string3);
                        this.jsonindexer.deleteIndex((Query)object3);
                        stringArray = this.getMetaJson("File", string3, string2, (String)object, string12, string13, string14, string15, string16, string8, string9, string10, string11, string17, string18);
                        this.jsonindexer.index_json((String)stringArray);
                        this.taxoWriter.commit();
                        this.writer.commit();
                        continue;
                    }
                    if (string23.equals("NODENAME")) {
                        if (l != 0L) {
                            this.indexFileMeta(string2, string3, string4, string5, string6, string7, l, string18);
                        }
                        l = 0L;
                        string2 = (String)entry.getValue();
                        string2 = string2.trim();
                        object3 = string2.split(",");
                        string2 = object3[0];
                        string18 = "unknown";
                        if (((String[])object3).length >= 2) {
                            string18 = object3[1];
                        }
                        if (this.hosts.get(string2) == null) {
                            this.hosts.put(string2, 1);
                            stringArray = this.getMetaJson("Host", string2, string2, "NA", "NA", string13, string14, string15, string16, "NA", "NA", "NA", "NA", "NA", string18);
                            this.jsonindexer.index_json((String)stringArray);
                            this.taxoWriter.commit();
                            this.writer.commit();
                        }
                        object = null;
                        string12 = null;
                        string13 = "Unclassified";
                        string14 = "Unclassified";
                        string15 = "Unclassified";
                        string16 = "DATACENTER";
                        string17 = "Unclassified";
                        continue;
                    }
                    if (string23.equals("CURRENTOFFSET")) {
                        string4 = (String)entry.getValue();
                        continue;
                    }
                    if (string23.equals("PREVOFFSET")) {
                        string5 = (String)entry.getValue();
                        continue;
                    }
                    if (string23.equals("CHUNKID")) {
                        string6 = (String)entry.getValue();
                        continue;
                    }
                    if (string23.equals("CHUNKSIZE")) {
                        string7 = (String)entry.getValue();
                        continue;
                    }
                    if (string23.equals("FIRSTTIME")) {
                        string8 = (String)entry.getValue();
                        continue;
                    }
                    if (string23.equals("LASTTIME")) {
                        string9 = (String)entry.getValue();
                        continue;
                    }
                    if (string23.equals("LASTMODIFIED")) {
                        string10 = (String)entry.getValue();
                        continue;
                    }
                    if (string23.equals("FILESIZE")) {
                        string11 = (String)entry.getValue();
                        continue;
                    }
                    if (string23.equals("TFARFILE")) {
                        string21 = (String)entry.getValue();
                        continue;
                    }
                    if (!string23.equals("FILETYPE") || object != null && object != "NULL") continue;
                    object3 = (String)entry.getValue();
                    if (((String)object3).equals("") || ((String)object3).equals("NULL")) {
                        object = "null";
                        string12 = "Unclassified";
                        string13 = "Unclassified";
                        string14 = "Unclassified";
                        string15 = "Unclassified";
                        string16 = "DATACENTER";
                        string17 = "Unclassified";
                    } else if (((String)object3).indexOf("~") >= 0) {
                        int n4;
                        stringArray = ((String)object3).split("~");
                        int n5 = stringArray.length;
                        object = stringArray[0];
                        if (((String)object).isEmpty() || ((String)object).equalsIgnoreCase("null")) {
                            object = "Unclassified";
                        }
                        if (n5 >= 2) {
                            string12 = stringArray[1];
                            if (string12.isEmpty() || string12.equalsIgnoreCase("null")) {
                                string12 = "Unclassified";
                            }
                        } else {
                            string12 = "Unclassified";
                        }
                        if (n5 >= 3) {
                            string13 = stringArray[2];
                            if (string13.isEmpty() || string13.equalsIgnoreCase("null")) {
                                string13 = "Unclassified";
                            }
                        } else {
                            string13 = "Unclassified";
                        }
                        if (n5 >= 4) {
                            string14 = stringArray[3];
                            if (string14.isEmpty() || string14.equalsIgnoreCase("null")) {
                                string14 = "Unclassified";
                            }
                        } else {
                            string14 = "Unclassified";
                        }
                        if (n5 >= 5) {
                            string15 = stringArray[4];
                            if (string15.isEmpty() || string15.equalsIgnoreCase("null")) {
                                string15 = "Unclassified";
                            }
                        } else {
                            string15 = "Unclassified";
                        }
                        if ((n4 = IndexerReceiverApache.countOccurrences((String)object3, '~')) >= 5) {
                            string17 = stringArray[5];
                            if (string17.isEmpty() || string17.equalsIgnoreCase("null")) {
                                string17 = "Unclassified";
                            }
                        } else {
                            string17 = "Unclassified";
                        }
                    } else {
                        object = object3;
                        string12 = "Unclassified";
                        string13 = "Unclassified";
                        string14 = "Unclassified";
                        string15 = "Unclassified";
                        string16 = "DATACENTER";
                        string17 = "Unclassified";
                    }
                    if (string15.equals("Unclassified")) {
                        string15 = string2;
                    }
                    if (string16.equals("Unclassified")) {
                        string16 = "DATACENTER";
                    }
                    this.components.add(string12);
                }
                if (((String)object).equals("cinfo")) {
                    Map.Entry<String, String> entry;
                    entry = new BufferedReader(new FileReader(string21));
                    try {
                        object3 = new StringBuilder();
                        stringArray = ((BufferedReader)((Object)entry)).readLine();
                        while (stringArray != null) {
                            ((StringBuilder)object3).append((String)stringArray);
                            ((StringBuilder)object3).append(System.lineSeparator());
                            stringArray = ((BufferedReader)((Object)entry)).readLine();
                        }
                        object2 = ((StringBuilder)object3).toString();
                    }
                    finally {
                        ((BufferedReader)((Object)entry)).close();
                    }
                    object3 = this.getJson(string3, string2, (String)object2, (String)object, string4, string5, string6, string7, l, string12, string13, string14, string15, string16, string18);
                    this.jsonindexer.index_json((String)object3);
                    continue;
                }
                if (!string17.equals("Unclassified")) continue;
                object2 = new RandomAccessFile(string21, "r");
                long l2 = Long.parseLong(string4);
                int n6 = n3 = Integer.parseInt(string7);
                Output.printTrace("dataLength to read=" + n6, 3);
                Output.printTrace("data to read from file=" + string21, 3);
                ((RandomAccessFile)object2).seek(l2);
                byte[] byArray = new byte[n6];
                try {
                    ((RandomAccessFile)object2).readFully(byArray);
                    string = new String(byArray);
                }
                catch (Exception exception) {
                    Output.printTrace("IndexerReceiverApache:Failed to read data from file " + string21, 1);
                    continue;
                }
                try {
                    ((RandomAccessFile)object2).close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                String[] stringArray2 = string.split("\\r?\\n");
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string25;
                    String string26 = stringArray2[i];
                    if (object != null && ((String)object).equals("_METRICS") && string3.contains(".json")) {
                        string25 = this.getJsonIndexed(string3, string2, string26, (String)object, string12, string13, string14, string15, string16, string18);
                        this.jsonindexer.index_json(string25);
                        this.taxoWriter.commit();
                        this.writer.commit();
                        continue;
                    }
                    if (!string17.equals("Unclassified") || string3.contains("tfar_metrics")) continue;
                    string25 = this.getJson(string3, string2, string26, (String)object, string4, string5, string6, string7, ++l, string12, string13, string14, string15, string16, string18);
                    this.jsonindexer.index_json(string25);
                }
            }
            ConfigManager.set("r.i_seq_no", Integer.toString(this.seq_no), "INTEGER");
            ConfigManager.set("r.i_line_num", Integer.toString(n), "INTEGER");
            lineNumberReader.close();
        }
        catch (IOException iOException) {
            System.out.println("IndexerReceiverApache:" + Thread.currentThread().getId() + " Thread died");
            iOException.printStackTrace();
        }
    }

    public LinkedHashMap<String, String> fix_record_meta(String string) {
        String[] stringArray = string.split(";");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            linkedHashMap.put(stringArray[i].split("=")[0].trim(), stringArray[i].split("=")[1].trim());
        }
        return linkedHashMap;
    }

    public Query get_query_hostModel(String string) {
        BooleanQuery booleanQuery = new BooleanQuery();
        TermQuery termQuery = new TermQuery(new Term("_mtype", "hostmodel"));
        booleanQuery.add(new BooleanClause((Query)termQuery, BooleanClause.Occur.MUST));
        TermQuery termQuery2 = new TermQuery(new Term("_mhostname", string));
        booleanQuery.add(new BooleanClause((Query)termQuery2, BooleanClause.Occur.MUST));
        BooleanQuery booleanQuery2 = booleanQuery;
        return booleanQuery2;
    }

    public Query get_query_json(String string) {
        BooleanQuery booleanQuery = new BooleanQuery();
        TermQuery termQuery = new TermQuery(new Term("_mtype", "topology"));
        booleanQuery.add(new BooleanClause((Query)termQuery, BooleanClause.Occur.MUST));
        TermQuery termQuery2 = new TermQuery(new Term("Hostname", string));
        booleanQuery.add(new BooleanClause((Query)termQuery2, BooleanClause.Occur.MUST));
        BooleanQuery booleanQuery2 = booleanQuery;
        return booleanQuery2;
    }

    public Query get_query_file(String string) {
        BooleanQuery booleanQuery = new BooleanQuery();
        TermQuery termQuery = new TermQuery(new Term("_mtype", "File"));
        booleanQuery.add(new BooleanClause((Query)termQuery, BooleanClause.Occur.MUST));
        TermQuery termQuery2 = new TermQuery(new Term("_mname", string));
        booleanQuery.add(new BooleanClause((Query)termQuery2, BooleanClause.Occur.MUST));
        BooleanQuery booleanQuery2 = booleanQuery;
        return booleanQuery2;
    }

    public String getFileMetaJson(String string, String string2, String string3, String string4, String string5, String string6, Long l, String string7) {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("_mFnode", string.trim());
        jsonObjectBuilder.add("_mFfilename", string2.trim());
        jsonObjectBuilder.add("_mFcurrentOffset", Long.parseLong(string3.trim()));
        jsonObjectBuilder.add("_mFprevOffset", Long.parseLong(string4.trim()));
        jsonObjectBuilder.add("_mFchunkid", Long.parseLong(string5.trim()));
        jsonObjectBuilder.add("_mFchunkSize", Long.parseLong(string6.trim()));
        jsonObjectBuilder.add("_mFnumLines", l.longValue());
        jsonObjectBuilder.add("_mrnode", string7);
        JsonObject jsonObject = jsonObjectBuilder.build();
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);
        jsonWriter.writeObject(jsonObject);
        jsonWriter.close();
        return stringWriter.toString();
    }

    public void indexFileMeta(String string, String string2, String string3, String string4, String string5, String string6, Long l, String string7) throws IOException {
        String string8 = this.getFileMetaJson(string, string2, string3, string4, string5, string6, l, string7);
        this.jsonindexer.index_json(string8);
        this.taxoWriter.commit();
        this.writer.commit();
    }

    public String getFacetJson(String string) {
        Long l;
        Object object;
        JsonParser.Event event;
        StringReader stringReader = new StringReader(string);
        JsonParser jsonParser = Json.createParser((Reader)stringReader);
        String string2 = null;
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        try {
            while (jsonParser.hasNext()) {
                event = jsonParser.next();
                switch (event) {
                    case KEY_NAME: {
                        string2 = jsonParser.getString();
                        break;
                    }
                    case VALUE_STRING: {
                        object = jsonParser.getString();
                        jsonObjectBuilder.add(string2.trim() + "_f", (String)object);
                        break;
                    }
                    case VALUE_NUMBER: {
                        l = jsonParser.getLong();
                        jsonObjectBuilder.add(string2.trim() + "_f", l.longValue());
                        break;
                    }
                    case VALUE_FALSE: {
                        System.out.println("Got false for key:" + string2);
                        break;
                    }
                    case VALUE_TRUE: {
                        System.out.println("Got true for key:" + string2);
                        break;
                    }
                    case VALUE_NULL: {
                        System.out.println("Got null for key:" + string2);
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception while parsing string " + string);
        }
        jsonParser.close();
        event = jsonObjectBuilder.build();
        object = new StringWriter();
        l = Json.createWriter((Writer)object);
        l.writeObject((JsonObject)event);
        l.close();
        return ((StringWriter)object).toString();
    }

    public String getaddedcomponent_hostmodel(String string, String string2) {
        String string3 = string + ";" + string2 + "::" + "c_1:0,c_2:0,c_3:0,c_n:0";
        return string3;
    }

    public String getupdated_hostModel(String string, int n, String string2, String string3) {
        Object object;
        String[] stringArray = string2.split(";");
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("::");
            treeMap.put(stringArray2[0], stringArray2[1]);
        }
        String string4 = (String)treeMap.get(string);
        String[] stringArray3 = string4.split(",");
        int n2 = n - 1;
        String string5 = stringArray3[n - 1];
        String[] stringArray4 = string5.split(":");
        String string6 = stringArray4[1].equals("0") ? stringArray4[0] + ":" + string3 : stringArray4[0] + ":" + stringArray4[1] + "|" + string3;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray3.length; ++i) {
            if (i != n2) {
                stringBuilder.append(stringArray3[i]);
                if (i == stringArray3.length - 1) continue;
                stringBuilder.append(",");
                continue;
            }
            stringBuilder.append(string6 + ",");
        }
        String string7 = string + "::" + stringBuilder.toString();
        Iterator iterator = treeMap.entrySet().iterator();
        StringBuilder stringBuilder2 = new StringBuilder();
        while (iterator.hasNext()) {
            object = iterator.next();
            String string8 = (String)object.getKey();
            String string9 = (String)object.getValue();
            if (!string8.equals(string)) {
                stringBuilder2.append(string8 + "::" + string9 + ";");
                continue;
            }
            stringBuilder2.append(string7 + ";");
        }
        object = stringBuilder2.toString();
        object = ((String)object).substring(0, ((String)object).length() - 1);
        return object;
    }

    public JsonObject get_hostModel(String string) {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("q", "");
        jsonObjectBuilder.add("from", "20150101000000000");
        jsonObjectBuilder.add("to", "20160101000000000");
        jsonObjectBuilder.add("pagenum", "1");
        jsonObjectBuilder.add("paging", "100");
        jsonObjectBuilder.add("fq", "_mtype=hostmodel;_mhostname=" + string.trim());
        JsonObject jsonObject = jsonObjectBuilder.build();
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);
        jsonWriter.writeObject(jsonObject);
        jsonWriter.close();
        String string2 = stringWriter.toString();
        SearchJsonReceiver searchJsonReceiver = new SearchJsonReceiver(this.dindex);
        return searchJsonReceiver.get_result_injobj(string2);
    }

    public void index_hostModel(String string, Set<String> set, String string2) {
        String string3;
        String string4;
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("_mtype_f", "hostmodel");
        jsonObjectBuilder.add("_mhostname_f", string);
        jsonObjectBuilder.add("_mclustername_f", string2);
        Iterator<String> iterator = set.iterator();
        JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            string4 = iterator.next();
            string3 = "c_1:0,c_2:0,c_3:0,c_n:0";
            stringBuilder.append(string4);
            stringBuilder.append("::");
            stringBuilder.append(string3);
            stringBuilder.append(";");
        }
        string4 = stringBuilder.toString();
        string3 = string4.substring(0, string4.length() - 1);
        jsonObjectBuilder.add("Contents", string4.substring(0, string4.length() - 1));
        jsonObjectBuilder.add("_mdpath_f", string3);
        String string5 = this.rdft.format(new Date());
        long l = Long.parseLong(string5);
        jsonObjectBuilder.add("ITime_f", l);
        jsonObjectBuilder.add("Time_f", l);
        JsonObject jsonObject = jsonObjectBuilder.build();
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);
        jsonWriter.writeObject(jsonObject);
        jsonWriter.close();
        String string6 = stringWriter.toString();
        this.jsonindexer.index_json(string6);
        try {
            this.taxoWriter.commit();
            this.writer.commit();
        }
        catch (IOException iOException) {
            System.out.println(Thread.currentThread().getId() + "Indexer::Failed to created Indexer");
            iOException.printStackTrace();
        }
    }

    public void index_hostModel_content(String string, String string2, String string3) {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("_mtype_f", "hostmodel");
        jsonObjectBuilder.add("_mhostname_f", string);
        jsonObjectBuilder.add("_mclustername_f", string2);
        String string4 = "/hostModel/dc1/" + string2 + "/" + string + "/" + string3.trim();
        jsonObjectBuilder.add("Contents", string3.trim());
        jsonObjectBuilder.add("_mdpath_f", string4);
        String string5 = this.rdft.format(new Date());
        long l = Long.parseLong(string5);
        jsonObjectBuilder.add("ITime_f", l);
        jsonObjectBuilder.add("Time_f", l);
        JsonObject jsonObject = jsonObjectBuilder.build();
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);
        jsonWriter.writeObject(jsonObject);
        jsonWriter.close();
        String string6 = stringWriter.toString();
        this.jsonindexer.index_json(string6);
        try {
            this.taxoWriter.commit();
            this.writer.commit();
        }
        catch (IOException iOException) {
            System.out.println(Thread.currentThread().getId() + "Indexer::Failed to created Indexer");
            iOException.printStackTrace();
        }
    }

    public String getJsonIndexed(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws IOException {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("rnode_f", string10);
        jsonObjectBuilder.add("Contents", string3);
        jsonObjectBuilder.add("Hostname_f", string2);
        jsonObjectBuilder.add("Filename_f", string);
        jsonObjectBuilder.add("Filetype_f", string4);
        jsonObjectBuilder.add("Component_f", string5);
        jsonObjectBuilder.add("Instance_f", string6);
        jsonObjectBuilder.add("Database_f", string7);
        jsonObjectBuilder.add("Cluster_f", string8);
        jsonObjectBuilder.add("DC_f", string9);
        jsonObjectBuilder.add("_dtype_f", "data");
        String string11 = this.rdft.format(new Date());
        long l = Long.parseLong(string11);
        jsonObjectBuilder.add("Time_f", l);
        jsonObjectBuilder.add("ITime_f", l);
        JsonObject jsonObject = jsonObjectBuilder.build();
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);
        jsonWriter.writeObject(jsonObject);
        jsonWriter.close();
        String string12 = stringWriter.toString();
        String string13 = this.getFacetJson(string3);
        string12 = string12.substring(0, string12.length() - 1);
        string12 = string12 + "," + string13.substring(1, string13.length());
        return string12;
    }

    public String getJson(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, long l, String string9, String string10, String string11, String string12, String string13, String string14) throws IOException {
        String string15;
        Object object;
        int n;
        String string16 = string2 + ":" + string;
        if (this.patmap.containsKey(string4)) {
            this.patlist = this.patmap.get(string4);
        } else {
            this.patlist = this.msearcher.get_query_docs("Filetype", string4);
            Output.printTrace("IndexerReceiverApache::" + this.patlist.size() + ":" + string4, 3);
            this.patmap.put(string4, this.patlist);
        }
        int n2 = this.patlist.size();
        String string17 = string3;
        Matcher matcher = null;
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        boolean bl = false;
        String string18 = null;
        String[] stringArray = new String[]{"pattern_text", "date_pattern", "date_pos", "match", "Patid", "dtype", "name"};
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        for (n = 0; n < n2 && !bl; ++n) {
            try {
                String string19;
                String string20;
                String string21;
                object = this.patlist.get(n);
                String string22 = object.get("pattern_text");
                Pattern pattern = Pattern.compile(string22);
                matcher = pattern.matcher(string17);
                if (!matcher.find()) continue;
                bl = true;
                string15 = object.get("date_pattern");
                if (!string15.equals("NA")) {
                    this.format.applyPattern(string15.trim());
                    String string23 = object.get("date_pos");
                    int n3 = Integer.parseInt(string23.trim());
                    try {
                        this.prev = this.curr = this.format.parse(matcher.group(n3).trim());
                        this.cal.setTime(this.curr);
                        string18 = this.rdft.format(this.curr);
                        this.files.put(string16, string18);
                    }
                    catch (ParseException parseException) {
                        System.out.println("Parse error");
                        parseException.printStackTrace();
                    }
                } else {
                    string18 = this.files.get(string16);
                }
                long l2 = 0L;
                try {
                    l2 = Long.parseLong(string18);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Excpetion in parsing " + string18);
                    numberFormatException.printStackTrace();
                    l2 = Long.parseLong(this.rdft.format(new Date()));
                }
                String string24 = object.get("match");
                int n4 = Integer.parseInt(string24);
                if (n4 > 0) {
                    for (int i = 1; i <= n4; ++i) {
                        string21 = object.get("name" + Integer.toString(i));
                        string21 = string21 + "_f";
                        string20 = matcher.group(i);
                        jsonObjectBuilder.add(string21, string20);
                    }
                }
                if ((string19 = object.get("dtype")) != null || !string19.equals("NA")) {
                    jsonObjectBuilder.add("_mtype_f", string19);
                    jsonObjectBuilder.add("_mname_f", object.get("Patid"));
                    string21 = object.get("critical");
                    if (!string21.equals("NA") && !string21.equals("")) {
                        jsonObjectBuilder.add("Critical_f", string21);
                        jsonObjectBuilder.add("Eventtype_f", this.event_types.get(string21));
                    } else if (string19.equals("Events")) {
                        jsonObjectBuilder.add("Eventtype_f", this.event_types.get("3"));
                    }
                    if (string19.equals("Events")) {
                        jsonObjectBuilder.add("Eventname_f", object.get("Patid"));
                        string20 = "/" + string9 + "/" + object.get("Patid") + "%";
                        jsonObjectBuilder.add("_mepath_f", string20);
                    }
                }
                jsonObjectBuilder.add("Contents", string17);
                jsonObjectBuilder.add("Hostname_f", string2);
                jsonObjectBuilder.add("Filename_f", string);
                jsonObjectBuilder.add("Filetype_f", string4);
                jsonObjectBuilder.add("Component_f", string9);
                jsonObjectBuilder.add("Instance_f", string10);
                jsonObjectBuilder.add("Database_f", string11);
                jsonObjectBuilder.add("Cluster_f", string12);
                jsonObjectBuilder.add("DC_f", string13);
                jsonObjectBuilder.add("rnode_f", string14);
                jsonObjectBuilder.add("Time_f", l2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!bl) {
            jsonObjectBuilder = this.createUnmatchedJson(string, string2, string3, jsonObjectBuilder, string4, string9, string10, string11, string12, string13, string14);
        }
        if ((n = string.lastIndexOf(47)) > 0) {
            jsonObjectBuilder.add("SFilename_f", string.substring(n + 1));
        }
        jsonObjectBuilder.add("CurrentOffset_f", Long.parseLong(string5));
        jsonObjectBuilder.add("prevOffset_f", Long.parseLong(string6));
        jsonObjectBuilder.add("chunkid_f", Long.parseLong(string7));
        jsonObjectBuilder.add("chunkSize_f", Long.parseLong(string8));
        jsonObjectBuilder.add("LineNumber_f", l);
        object = this.rdft.format(new Date());
        long l3 = Long.parseLong((String)object);
        jsonObjectBuilder.add("ITime_f", l3);
        jsonObjectBuilder.add("_dtype_f", "data");
        string15 = jsonObjectBuilder.build();
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)stringWriter);
        jsonWriter.writeObject((JsonObject)string15);
        jsonWriter.close();
        return stringWriter.toString();
    }

    public String getMetaJson(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15) throws IOException {
        Object object;
        Object object2;
        String string16;
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("_mtype_f", string);
        jsonObjectBuilder.add("_mname_f", string2);
        jsonObjectBuilder.add("_mContents", string2);
        jsonObjectBuilder.add("Contents", string2);
        jsonObjectBuilder.add("_dtype_f", "meta");
        jsonObjectBuilder.add("_mhost_f", string3);
        jsonObjectBuilder.add("Hostname_f", string3);
        jsonObjectBuilder.add("_mHostname_f", string3);
        jsonObjectBuilder.add("Filename_f", string2);
        jsonObjectBuilder.add("_mFilename_f", string2);
        jsonObjectBuilder.add("Filetype_f", string4);
        jsonObjectBuilder.add("_mFiletype_f", string4);
        String string17 = null;
        String string18 = null;
        if (string.equals("File")) {
            jsonObjectBuilder.add("_mfname_f", string2);
            File file = new File(string2);
            String string19 = file.getParent();
            string16 = "Streamed";
            if (string19 == null) {
                jsonObjectBuilder.add("_mdirectory_f", string2);
            } else if (!string14.equals("Unclassified") && string.equals("File")) {
                int n = string19.indexOf(47);
                if (n >= 0) {
                    jsonObjectBuilder.add("_mdirectory_f", string19.substring(n));
                } else {
                    jsonObjectBuilder.add("_mdirectory_f", string19);
                }
                string16 = string14;
            } else {
                jsonObjectBuilder.add("_mdirectory_f", string19);
            }
            String string20 = string2.lastIndexOf("/") >= 0 ? string2.substring(string2.lastIndexOf("/") + 1) : string2;
            jsonObjectBuilder.add("_msfname_f", string20);
            jsonObjectBuilder.add("_mftype_f", string4);
            jsonObjectBuilder.add("_mfcomponent_f", string5);
            string2 = string2 + "%";
            string18 = string2.replaceAll("/", "~");
            if (string2.startsWith("/")) {
                jsonObjectBuilder.add("_mpath_f", "/" + string3 + string2 + string3 + ":" + string18);
            } else {
                jsonObjectBuilder.add("_mpath_f", "/" + string3 + "/" + string2 + string3 + ":" + string18);
            }
            String string21 = "/" + string5 + "/" + string4 + "/" + string20 + "%" + string3 + ":" + string18;
            object2 = "/" + string5 + "/" + string4 + "/" + string20 + "%" + string3 + ":" + string18;
            jsonObjectBuilder.add("_mhftype_f", (String)object2);
            jsonObjectBuilder.add("_mhhost_f", "/" + string3 + string21);
            if (string5.equals("OS") || string5.equals("ASM") || string5.equals("CRS") || string5.equals("RDBMS")) {
                jsonObjectBuilder.add("_mdash_f", "/" + string5 + "%");
            }
            jsonObjectBuilder.add("Component_f", string5);
            jsonObjectBuilder.add("_mComponent_f", string5);
            jsonObjectBuilder.add("Instance_f", string6);
            jsonObjectBuilder.add("_mInstance_f", string6);
            jsonObjectBuilder.add("Database_f", string7);
            jsonObjectBuilder.add("_mDatabase_f", string7);
            jsonObjectBuilder.add("Cluster_f", string8);
            jsonObjectBuilder.add("_mCluster_f", string8);
            jsonObjectBuilder.add("DC_f", string9);
            jsonObjectBuilder.add("_mDC_f", string9);
            jsonObjectBuilder.add("rnode_f", string15);
            object = string3 + ":" + string2.trim();
            string17 = this.files.get(object) != null ? this.files.get(object) : this.rdft.format(new Date());
        } else {
            string17 = this.rdft.format(new Date());
        }
        jsonObjectBuilder.add("first_timestamp", string10);
        jsonObjectBuilder.add("last_timestamp", string11);
        jsonObjectBuilder.add("last_modified", string12);
        jsonObjectBuilder.add("file_size", string13);
        jsonObjectBuilder.add("collection_f", string14);
        if (!string14.equals("Unclassified") && string.equals("File")) {
            jsonObjectBuilder.add("_mcpath_f", "/" + string3 + "/" + string2 + string3 + ":" + string18);
            jsonObjectBuilder.add("_mcollection_f", string14);
        }
        long l = 0L;
        try {
            l = Long.parseLong(string17);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Excpetion in parsing " + string17);
            numberFormatException.printStackTrace();
            l = Long.parseLong(this.rdft.format(new Date()));
        }
        jsonObjectBuilder.add("Time_f", l);
        string16 = this.rdft.format(new Date());
        long l2 = Long.parseLong(string16);
        jsonObjectBuilder.add("ITime_f", l);
        object2 = jsonObjectBuilder.build();
        object = new StringWriter();
        JsonWriter jsonWriter = Json.createWriter((Writer)object);
        jsonWriter.writeObject(object2);
        jsonWriter.close();
        return ((StringWriter)object).toString();
    }

    public JsonObjectBuilder createUnmatchedJson(String string, String string2, String string3, JsonObjectBuilder jsonObjectBuilder, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws IOException {
        boolean bl = false;
        String string11 = null;
        String string12 = null;
        String string13 = string2 + ":" + string;
        for (int i = 0; i < this.pList.size(); ++i) {
            this.tp = this.pList.get(i);
            this.match = this.tp.matcher(string3);
            if (!this.match.find()) continue;
            bl = true;
            this.ft.applyPattern(this.dList.get(i));
            try {
                this.curr = this.ft.parse(this.match.group(1));
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            this.prev = this.curr;
            this.cal.setTime(this.curr);
            string11 = this.rdft.format(this.curr);
            if (string11.startsWith("1970")) {
                int n = Calendar.getInstance().get(1);
                string11 = string11.replaceFirst("1970", Integer.toString(n));
            }
            this.files.put(string13, string11);
            string12 = this.match.group(0);
            break;
        }
        if (!bl) {
            this.curr = this.prev;
            this.cal.setTime(this.curr);
            string12 = string3;
            string11 = this.files.get(string13);
        }
        string12 = string3;
        long l = 0L;
        try {
            if (string11 == null || string11.isEmpty()) {
                string11 = this.rdft.format(new Date());
                this.files.put(string13, string11);
            }
            l = Long.parseLong(string11);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Excpetion in parsing " + string11);
            numberFormatException.printStackTrace();
            l = Long.parseLong(this.rdft.format(new Date()));
        }
        jsonObjectBuilder.add("Contents", string3);
        jsonObjectBuilder.add("Hostname_f", string2);
        jsonObjectBuilder.add("Filename_f", string);
        jsonObjectBuilder.add("Filetype_f", string4);
        jsonObjectBuilder.add("Time_f", l);
        jsonObjectBuilder.add("Component_f", string5);
        jsonObjectBuilder.add("Instance_f", string6);
        jsonObjectBuilder.add("Database_f", string7);
        jsonObjectBuilder.add("Cluster_f", string8);
        jsonObjectBuilder.add("DC_f", string9);
        jsonObjectBuilder.add("rnode_f", string10);
        return jsonObjectBuilder;
    }

    public void startup() {
        System.out.println("Indexer consumer::Starting\n");
        this.finished = false;
    }

    public void terminate() {
        try {
            System.out.println("Indexer consumer::stopping\n");
            this.taxoWriter.close();
            this.writer.close();
            this.write_hash_to_file(this.files);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.finished = true;
    }

    public void write_hash_to_file(Map<String, String> map) {
        String string = this.tfa_home + File.separator + "internal" + File.separator + "receiverhash.txt";
        File file = new File(string);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                System.out.println("FIle creation Failed");
                iOException.printStackTrace();
            }
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            for (Map.Entry<String, String> object2 : map.entrySet()) {
                Output.printTrace("write_hash_to_file:" + object2.getKey() + "+" + object2.getValue(), 3);
                properties.setProperty(object2.getKey(), object2.getValue());
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            properties.store(fileOutputStream, null);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Output.printTrace("IOException while updating rconfig file: " + iOException.getMessage(), 3);
        }
        catch (Exception exception) {
            Output.printTrace("Exception while updating rconfig file " + exception.getMessage(), 3);
        }
    }

    public Map<String, String> read_hash_from_file() {
        String string = this.tfa_home + File.separator + "internal" + File.separator + "receiverhash.txt";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            Set<String> set = properties.stringPropertyNames();
            for (String string2 : set) {
                String string3 = properties.getProperty(string2);
                Output.printTrace("read_hash_from_file:" + string2 + "+" + string3, 3);
                hashMap.put(string2, string3);
            }
        }
        catch (IOException iOException) {
            Output.printTrace("IOException while updating rconfig file: " + iOException.getMessage(), 3);
        }
        catch (Exception exception) {
            Output.printTrace("Exception while updating rconfig file " + exception.getMessage(), 3);
        }
        return hashMap;
    }

    public String getFileName(String string) {
        return string.substring(string.lastIndexOf("/") + 1);
    }

    private static void initialize_patterns(List<Pattern> list, List<String> list2) {
        list.add(Pattern.compile("^((\\w\\w\\w)(\\s+)(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d))((\\s+)|($))(.*)"));
        list2.add("MMM dd HH:mm:ss");
        list.add(Pattern.compile("^((\\w\\w\\w)\\s+(\\w\\w\\w)\\s+(\\d+)\\s+(\\d\\d):(\\d\\d):(\\d\\d)\\s+(\\d\\d\\d\\d))((\\s+)|($))(.*)"));
        list2.add("EEE MMM dd HH:mm:ss yyyy");
        list.add(Pattern.compile("((\\w\\w\\w)\\s+(\\w\\w\\w)\\s+(\\d+)\\s+(\\d\\d):(\\d\\d):(\\d\\d)\\s+(\\d\\d\\d\\d))(:)((\\s+)|($))(.*)"));
        list2.add("EEE MMM dd HH:mm:ss yyyy");
        list.add(Pattern.compile("^((\\w\\w\\w)\\s+(\\w\\w\\w)\\s+(\\d+)\\s+(\\d\\d):(\\d\\d):(\\d\\d)\\s+(\\w+)\\s+(\\d\\d\\d\\d))((\\s+)|($))(.*)"));
        list2.add("EEE MMM dd HH:mm:ss ZZZ yyyy");
        list.add(Pattern.compile("^zzz ...((\\w\\w\\w)\\s+(\\w\\w\\w)\\s+(\\d+)\\s+(\\d\\d):(\\d\\d):(\\d\\d)\\s+(\\w+)\\s+(\\d\\d\\d\\d))((\\s+)|($))(.*)"));
        list2.add("EEE MMM dd HH:mm:ss ZZZ yyyy");
        list.add(Pattern.compile("((\\d+)-(\\d+)-(\\d+) (\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d+))((\\s+)|($)|(:)|(\\d+))(.*)"));
        list2.add("yyyy-MM-dd HH:mm:ss.SSS");
        list.add(Pattern.compile("((\\d+)-(\\d+)-(\\d+)(\\w)(\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d\\d\\d))((\\s+)|($)|(\\d))(.*)"));
        list2.add("yyyy-MM-dd'T'HH:mm:ss.SSS");
        list.add(Pattern.compile("((\\d+)-(\\d+)-(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d))((\\s+)|($))(.*)"));
        list2.add("yyyy-MM-dd HH:mm:ss");
        list.add(Pattern.compile("^((\\d+)-(\\d+)-(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d)(\\,)(\\d+))((\\s+)|($))(.*)"));
        list2.add("yyyy-MM-dd HH:mm:ss,SSS");
        list.add(Pattern.compile("^((\\d+)-(\\w+)-(\\d\\d) (\\d\\d):(\\d\\d))((\\s+)|($))(.*)"));
        list2.add("yyyy-MMM-dd HH:mm");
        list.add(Pattern.compile("((\\d\\d)-(\\w\\w\\w)-(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d))(.*)"));
        list2.add("dd-MMM-yy HH:mm:ss");
        list.add(Pattern.compile("((\\w+)(\\s+)(\\d\\d)(\\,)(\\s+)(\\d\\d):(\\d\\d):(\\d\\d))(.*)"));
        list2.add("MMMM dd, yyyy HH:mm:ss");
        list.add(Pattern.compile("((\\d+)-(\\d+)-(\\d\\d)_(\\d\\d)-(\\d\\d)-(\\d\\d))(.*)"));
        list2.add("yyyy-MM-dd_HH-mm-ss");
        list.add(Pattern.compile("((\\d+)(/)(\\d+)(/)(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d))"));
        list2.add("MM/dd/yy HH:mm:ss");
    }

    public static int countOccurrences(String string, char c) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }
}

