/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.receiver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.json.JsonObject;
import oracle.rat.tfa.receiver.CaseInsensitiveWhitespaceAnalyzer;
import oracle.rat.tfa.receiver.IndexerTaskDup23;
import oracle.rat.tfa.receiver.JsonIndexer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class IndexerFiles3 {
    private static String sr = null;
    private static String fileList = null;
    private static File nodeDir = null;
    private static File taxodir = null;
    private static File schemaFile = null;
    private static Collection<Future<?>> futureList;
    private static Analyzer analyzer;
    private static IndexWriterConfig iwc;
    private static List<Pattern> pList;
    private static List<String> dList;
    private static final FacetsConfig config;
    private static BlockingQueue<JsonObject> queue;
    private static String schemaLoc;
    private static String indexLoc;
    private static String taxoloc;

    private static void initialize_patterns(List<Pattern> list, List<String> list2) {
        list.add(Pattern.compile("^((\\w\\w\\w)(\\s+)(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d))((\\s+)|($))(.*)"));
        list2.add("MMM dd HH:mm:ss");
        list.add(Pattern.compile("^((\\w\\w\\w)\\s+(\\w\\w\\w)\\s+(\\d+)\\s+(\\d\\d):(\\d\\d):(\\d\\d)\\s+(\\d\\d\\d\\d))((\\s+)|($))(.*)"));
        list2.add("EEE MMM dd HH:mm:ss yyyy");
        list.add(Pattern.compile("((\\w\\w\\w)\\s+(\\w\\w\\w)\\s+(\\d+)\\s+(\\d\\d):(\\d\\d):(\\d\\d)\\s+(\\d\\d\\d\\d))(:)((\\s+)|($))(.*)"));
        list2.add("EEE MMM dd HH:mm:ss yyyy");
        list.add(Pattern.compile("^((\\w\\w\\w)\\s+(\\w\\w\\w)\\s+(\\d+)\\s+(\\d\\d):(\\d\\d):(\\d\\d)\\s+(\\w+)\\s+(\\d\\d\\d\\d))((\\s+)|($))(.*)"));
        list2.add("EEE MMM dd HH:mm:ss ZZZ yyyy");
        list.add(Pattern.compile("^zzz ...((\\w\\w\\w)\\s+(\\w\\w\\w)\\s+(\\d+)\\s+(\\d\\d):(\\d\\d):(\\d\\d)\\s+(\\w+)\\s+(\\d\\d\\d\\d))((\\s+)|($))(.*)"));
        list2.add("EEE MMM dd HH:mm:ss ZZZ yyyy");
        list.add(Pattern.compile("((\\d+)-(\\d+)-(\\d+) (\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d+))((\\s+)|($)|(:)|(\\d+))(.*)"));
        list2.add("yyyy-MM-dd HH:mm:ss.SSS");
        list.add(Pattern.compile("((\\d+)-(\\d+)-(\\d+)(\\w)(\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d\\d\\d))((\\s+)|($)|(\\d))(.*)"));
        list2.add("yyyy-MM-dd'T'HH:mm:ss.SSS");
        list.add(Pattern.compile("((\\d+)-(\\d+)-(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d))((\\s+)|($))(.*)"));
        list2.add("yyyy-MM-dd HH:mm:ss");
        list.add(Pattern.compile("^((\\d+)-(\\d+)-(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d)(\\,)(\\d+))((\\s+)|($))(.*)"));
        list2.add("yyyy-MM-dd HH:mm:ss,SSS");
        list.add(Pattern.compile("^((\\d+)-(\\w+)-(\\d\\d) (\\d\\d):(\\d\\d))((\\s+)|($))(.*)"));
        list2.add("yyyy-MMM-dd HH:mm");
        list.add(Pattern.compile("((\\d\\d)-(\\w\\w\\w)-(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d))(.*)"));
        list2.add("dd-MMM-yy HH:mm:ss");
        list.add(Pattern.compile("((\\w+)(\\s+)(\\d\\d)(\\,)(\\s+)(\\d\\d):(\\d\\d):(\\d\\d))(.*)"));
        list2.add("MMMM dd, yyyy HH:mm:ss");
        list.add(Pattern.compile("((\\d+)-(\\d+)-(\\d\\d)_(\\d\\d)-(\\d\\d)-(\\d\\d))(.*)"));
        list2.add("yyyy-MM-dd_HH-mm-ss");
        list.add(Pattern.compile("((\\d+)(/)(\\d+)(/)(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d))"));
        list2.add("MM/dd/yy HH:mm:ss");
    }

    public static void main(String[] stringArray) throws IOException, InterruptedException {
        String string;
        int n = Integer.parseInt(stringArray[2]);
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        sr = stringArray[0];
        fileList = stringArray[1];
        indexLoc = stringArray[3];
        taxoloc = stringArray[5];
        schemaLoc = stringArray[4];
        nodeDir = new File(indexLoc);
        taxodir = new File(taxoloc);
        if (!nodeDir.exists()) {
            nodeDir.mkdirs();
            System.out.println("Indexer::Directory Created: " + nodeDir);
        } else {
            System.out.println("Indexer::Directory Already Exists:" + nodeDir);
        }
        if (!taxodir.exists()) {
            taxodir.mkdirs();
            System.out.println("Indexer_TAXO::Directory Created: " + taxodir);
        } else {
            System.out.println("Indexer_TAXO::Directory Already Exists:" + taxodir);
        }
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        iwc.setRAMBufferSizeMB(56.0);
        iwc.setMaxThreadStates(64);
        IndexerFiles3.initialize_patterns(pList, dList);
        FSDirectory fSDirectory = FSDirectory.open((File)nodeDir);
        FSDirectory fSDirectory2 = FSDirectory.open((File)taxodir);
        DirectoryTaxonomyWriter directoryTaxonomyWriter = new DirectoryTaxonomyWriter((Directory)fSDirectory2);
        IndexWriter indexWriter = new IndexWriter((Directory)fSDirectory, iwc);
        fileList.trim();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(fileList));
        String string2 = null;
        int n2 = 0;
        boolean bl = false;
        futureList = new ArrayList();
        FacetsConfig facetsConfig = new FacetsConfig();
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray2 = string.split(",");
            string2 = stringArray2[0];
            String string3 = stringArray2[1];
            String string4 = stringArray2[2];
            String string5 = stringArray2[3];
            String string6 = stringArray2[4];
            File file = new File(string2);
            String string7 = file.getName();
            String string8 = IndexerFiles3.getFileName(string2);
            JsonIndexer jsonIndexer = new JsonIndexer(indexWriter, directoryTaxonomyWriter, facetsConfig);
            Future<Boolean> future = executorService.submit(new IndexerTaskDup23(string2, string3, string4, string5, string6, pList, dList, ++n2, jsonIndexer));
        }
        bufferedReader.close();
        executorService.shutdown();
        try {
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        indexWriter.close();
        directoryTaxonomyWriter.close();
    }

    public static String getFileName(String string) {
        return string.substring(string.lastIndexOf("/") + 1);
    }

    static {
        analyzer = new CaseInsensitiveWhitespaceAnalyzer(Version.LUCENE_47);
        iwc = new IndexWriterConfig(Version.LUCENE_47, analyzer);
        pList = new ArrayList<Pattern>();
        dList = new ArrayList<String>();
        config = new FacetsConfig();
    }
}

