/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.receiver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import oracle.rat.tfa.receiver.CaseInsensitiveWhitespaceAnalyzer;
import oracle.rat.tfa.receiver.IndexerTaskMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class IndexerFiles {
    private static String sr = null;
    private static String fileList = null;
    private static File nodeDir = null;
    private static File taxodir = null;
    private static File schemaFile = null;
    private static Collection<Future<?>> futureList;
    private static Analyzer analyzer;
    private static IndexWriterConfig iwc;
    private static List<Pattern> pList;
    private static List<String> dList;
    private static final FacetsConfig config;
    private static BlockingQueue<JsonObject> queue;
    private static String schemaLoc;
    private static String indexLoc;
    private static String taxoloc;

    private static void initialize_patterns(List<Pattern> list, List<String> list2) {
        list.add(Pattern.compile("^((\\w\\w\\w)(\\s+)(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d))((\\s+)|($))(.*)"));
        list2.add("MMM dd HH:mm:ss");
        list.add(Pattern.compile("^((\\w\\w\\w)\\s+(\\w\\w\\w)\\s+(\\d+)\\s+(\\d\\d):(\\d\\d):(\\d\\d)\\s+(\\d\\d\\d\\d))((\\s+)|($))(.*)"));
        list2.add("EEE MMM dd HH:mm:ss yyyy");
        list.add(Pattern.compile("((\\w\\w\\w)\\s+(\\w\\w\\w)\\s+(\\d+)\\s+(\\d\\d):(\\d\\d):(\\d\\d)\\s+(\\d\\d\\d\\d))(:)((\\s+)|($))(.*)"));
        list2.add("EEE MMM dd HH:mm:ss yyyy");
        list.add(Pattern.compile("^((\\w\\w\\w)\\s+(\\w\\w\\w)\\s+(\\d+)\\s+(\\d\\d):(\\d\\d):(\\d\\d)\\s+(\\w+)\\s+(\\d\\d\\d\\d))((\\s+)|($))(.*)"));
        list2.add("EEE MMM dd HH:mm:ss ZZZ yyyy");
        list.add(Pattern.compile("^zzz ...((\\w\\w\\w)\\s+(\\w\\w\\w)\\s+(\\d+)\\s+(\\d\\d):(\\d\\d):(\\d\\d)\\s+(\\w+)\\s+(\\d\\d\\d\\d))((\\s+)|($))(.*)"));
        list2.add("EEE MMM dd HH:mm:ss ZZZ yyyy");
        list.add(Pattern.compile("((\\d+)-(\\d+)-(\\d+) (\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d+))((\\s+)|($)|(:)|(\\d+))(.*)"));
        list2.add("yyyy-MM-dd HH:mm:ss.SSS");
        list.add(Pattern.compile("((\\d+)-(\\d+)-(\\d+)(\\w)(\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d\\d\\d))((\\s+)|($)|(\\d))(.*)"));
        list2.add("yyyy-MM-dd'T'HH:mm:ss.SSS");
        list.add(Pattern.compile("((\\d+)-(\\d+)-(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d))((\\s+)|($))(.*)"));
        list2.add("yyyy-MM-dd HH:mm:ss");
        list.add(Pattern.compile("^((\\d+)-(\\d+)-(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d)(\\,)(\\d+))((\\s+)|($))(.*)"));
        list2.add("yyyy-MM-dd HH:mm:ss,SSS");
        list.add(Pattern.compile("^((\\d+)-(\\w+)-(\\d\\d) (\\d\\d):(\\d\\d))((\\s+)|($))(.*)"));
        list2.add("yyyy-MMM-dd HH:mm");
        list.add(Pattern.compile("((\\d\\d)-(\\w\\w\\w)-(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d))(.*)"));
        list2.add("dd-MMM-yy HH:mm:ss");
        list.add(Pattern.compile("((\\w+)(\\s+)(\\d\\d)(\\,)(\\s+)(\\d\\d):(\\d\\d):(\\d\\d))(.*)"));
        list2.add("MMMM dd, yyyy HH:mm:ss");
        list.add(Pattern.compile("((\\d+)-(\\d+)-(\\d\\d)_(\\d\\d)-(\\d\\d)-(\\d\\d))(.*)"));
        list2.add("yyyy-MM-dd_HH-mm-ss");
        list.add(Pattern.compile("((\\d+)(/)(\\d+)(/)(\\d\\d) (\\d\\d):(\\d\\d):(\\d\\d))"));
        list2.add("MM/dd/yy HH:mm:ss");
    }

    public static void main(String[] stringArray) throws IOException, InterruptedException {
        String string;
        int n = Integer.parseInt(stringArray[2]);
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        sr = stringArray[0];
        fileList = stringArray[1];
        indexLoc = stringArray[3];
        schemaLoc = stringArray[4];
        taxoloc = stringArray[5];
        try {
            IndexerFiles.writeJsonSchema(schemaLoc);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        nodeDir = new File(indexLoc);
        if (!nodeDir.exists()) {
            nodeDir.mkdirs();
            System.out.println("Indexer::Directory Created: " + nodeDir);
        } else {
            System.out.println("Indexer::Directory Already Exists:" + nodeDir);
        }
        taxodir = new File(taxoloc);
        if (!taxodir.exists()) {
            taxodir.mkdirs();
            System.out.println("Indexer_TAXO::Directory Created: " + taxodir);
        } else {
            System.out.println("Indexer_TAXO::Directory Already Exists:" + taxodir);
        }
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        iwc.setRAMBufferSizeMB(56.0);
        iwc.setUseCompoundFile(false);
        System.out.println("CaseInsensitiveWhitespaceAnalyzer");
        iwc.setMaxThreadStates(64);
        IndexerFiles.initialize_patterns(pList, dList);
        FSDirectory fSDirectory = FSDirectory.open((File)nodeDir);
        FSDirectory fSDirectory2 = FSDirectory.open((File)taxodir);
        IndexWriter indexWriter = new IndexWriter((Directory)fSDirectory, iwc);
        DirectoryTaxonomyWriter directoryTaxonomyWriter = new DirectoryTaxonomyWriter((Directory)fSDirectory2);
        fileList.trim();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(fileList));
        String string2 = null;
        int n2 = 0;
        boolean bl = false;
        futureList = new ArrayList();
        FacetsConfig facetsConfig = new FacetsConfig();
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray2 = string.split(",");
            string2 = stringArray2[0];
            String string3 = stringArray2[1];
            String string4 = stringArray2[2];
            String string5 = stringArray2[3];
            String string6 = stringArray2[4];
            ++n2;
            String string7 = IndexerFiles.getFileName(string2);
            HashMap<String, Field> hashMap = new HashMap<String, Field>(5);
            HashMap<String, Field> hashMap2 = new HashMap<String, Field>(1);
            HashMap<String, Field> hashMap3 = new HashMap<String, Field>(7);
            HashMap<String, Field> hashMap4 = new HashMap<String, Field>(4);
            IndexerFiles.initialize_fields(hashMap, hashMap2, hashMap3, hashMap4, string2, string3, string4, string5, string6, n2, string7);
            Future<Boolean> future = executorService.submit(new IndexerTaskMap(string2, sr, nodeDir, indexWriter, pList, dList, n2, hashMap, hashMap2, hashMap3, hashMap4, facetsConfig, directoryTaxonomyWriter));
        }
        bufferedReader.close();
        executorService.shutdown();
        try {
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        indexWriter.close();
        directoryTaxonomyWriter.close();
    }

    public static String getFileName(String string) {
        return string.substring(string.lastIndexOf("/") + 1);
    }

    private static void initialize_fields(Map<String, Field> map, Map<String, Field> map2, Map<String, Field> map3, Map<String, Field> map4, String string, String string2, String string3, String string4, String string5, int n, String string6) {
        String string7 = string;
        int n2 = string.lastIndexOf("files");
        string7 = string.substring(n2 + 6);
        map.put("Hostname", (Field)new FacetField("Hostname", new String[]{string2}));
        map.put("Database", (Field)new FacetField("Database", new String[]{string3}));
        map.put("Instance", (Field)new FacetField("Instance", new String[]{string4}));
        map.put("Filetype", (Field)new FacetField("Filetype", new String[]{string5}));
        map2.put("Time", (Field)new NumericDocValuesField("Time", 0L));
        map3.put("Hostname", (Field)new StringField("Hostname", string2, Field.Store.YES));
        map3.put("Database", (Field)new StringField("Database", string3, Field.Store.YES));
        map3.put("Instance", (Field)new StringField("Instance", string4, Field.Store.YES));
        map3.put("Filetype", (Field)new StringField("Filetype", string5, Field.Store.YES));
        map3.put("Fid", (Field)new StringField("Fid", Integer.toString(n), Field.Store.YES));
        map3.put("Filename", (Field)new StringField("Filename", string6, Field.Store.YES));
        map3.put("Filepath", (Field)new StringField("Filepath", string7, Field.Store.YES));
        map4.put("ID", (Field)new StringField("ID", "", Field.Store.YES));
        map4.put("Contents", (Field)new TextField("Contents", "", Field.Store.YES));
        map4.put("Linenumber", (Field)new LongField("Linenumber", 0L, Field.Store.YES));
        map4.put("Time", (Field)new LongField("Time", 0L, Field.Store.YES));
    }

    public static void writeJsonSchema(String string) throws IOException {
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        jsonObjectBuilder.add("ID", "TextField");
        jsonObjectBuilder.add("Path", "StringField");
        jsonObjectBuilder.add("Node", "StringField");
        jsonObjectBuilder.add("Ts", "LongField");
        jsonObjectBuilder.add("LN", "LongField");
        jsonObjectBuilder.add("Ts_f", "NumericDocValuesField");
        jsonObjectBuilder.add("Contents", "TextField");
        JsonObject jsonObject = jsonObjectBuilder.build();
        schemaFile = new File(string);
        if (schemaFile.exists()) {
            schemaFile.delete();
        }
        schemaFile.createNewFile();
        FileWriter fileWriter = new FileWriter(schemaFile);
        JsonWriter jsonWriter = Json.createWriter((Writer)fileWriter);
        jsonWriter.writeObject(jsonObject);
        jsonWriter.close();
        fileWriter.close();
    }

    static {
        analyzer = new CaseInsensitiveWhitespaceAnalyzer(Version.LUCENE_47);
        iwc = new IndexWriterConfig(Version.LUCENE_47, analyzer);
        pList = new ArrayList<Pattern>();
        dList = new ArrayList<String>();
        config = new FacetsConfig();
    }
}

