/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.receiver;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.util.Version;

public class CaseInsensitiveWhitespaceAnalyzer
extends Analyzer {
    private final Version matchVersion;

    public CaseInsensitiveWhitespaceAnalyzer(Version version) {
        this.matchVersion = version;
    }

    protected Analyzer.TokenStreamComponents createComponents(String string, Reader reader) {
        WhitespaceTokenizer whitespaceTokenizer = new WhitespaceTokenizer(this.matchVersion, reader);
        LowerCaseFilter lowerCaseFilter = new LowerCaseFilter(this.matchVersion, (TokenStream)whitespaceTokenizer);
        Analyzer.TokenStreamComponents tokenStreamComponents = new Analyzer.TokenStreamComponents((Tokenizer)whitespaceTokenizer, (TokenStream)lowerCaseFilter);
        return tokenStreamComponents;
    }
}

