/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.nls;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.rat.tfa.nls.Bundles;

public class ONLS {
    String language;
    String locale;
    String encoding;
    String country;
    Bundles bundles;
    Charset cset;
    Locale loc;

    public ONLS() throws IOException {
        this.locale = "en-US";
        this.language = "en";
        this.encoding = "UTF-8";
        this.country = "US";
        this.loc = new Locale(this.language);
        this.bundles = Bundles.getInstance();
        if (null == this.bundles) {
            throw new IOException("Bundles list is empty");
        }
        try {
            this.cset = Charset.forName(this.encoding);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw illegalCharsetNameException;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw unsupportedCharsetException;
        }
    }

    public ONLS(String string, String string2, String string3, String string4) {
        this.locale = string;
        this.language = string2;
        this.encoding = string3;
        this.country = string4;
        this.loc = new Locale(string2, string4);
        String string5 = "oracle.rat.tfa.i18n.I18nTfa_" + string2 + "_" + string4;
        try {
            this.bundles = Bundles.getInstance(string2, string4);
            this.bundles.addBundle(string, ResourceBundle.getBundle(string5, this.loc));
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (MissingResourceException missingResourceException) {
            throw missingResourceException;
        }
        try {
            this.cset = Charset.forName(string3);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw illegalCharsetNameException;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw unsupportedCharsetException;
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getCountry() {
        return this.country;
    }

    void print(String string, Object ... objectArray) throws IOException {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = this.bundles.getBundle(this.locale);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (MissingResourceException missingResourceException) {
            throw missingResourceException;
        }
        String string2 = resourceBundle.getString(string);
        Object[] objectArray2 = new Object[10];
        objectArray2[0] = string2;
        try {
            System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw indexOutOfBoundsException;
        }
        catch (ArrayStoreException arrayStoreException) {
            throw arrayStoreException;
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(this.loc);
        messageFormat.applyPattern(string2);
        String string3 = messageFormat.format(objectArray2);
        ByteBuffer byteBuffer = this.cset.encode(string3);
        String string4 = new String(byteBuffer.array(), this.encoding);
        System.out.print(string4);
    }

    void print(String string) throws IOException {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = this.bundles.getBundle(this.locale);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (MissingResourceException missingResourceException) {
            throw missingResourceException;
        }
        String string2 = resourceBundle.getString(string);
        MessageFormat messageFormat = null;
        messageFormat = new MessageFormat("");
        messageFormat.setLocale(this.loc);
        messageFormat.applyPattern(string2);
        ByteBuffer byteBuffer = this.cset.encode(string2);
        String string3 = new String(byteBuffer.array(), this.encoding);
        System.out.print(string3);
    }

    void write(Writer writer, String string, Object ... objectArray) throws IOException {
        PrintWriter printWriter = (PrintWriter)writer;
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = this.bundles.getBundle(this.locale);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (MissingResourceException missingResourceException) {
            throw missingResourceException;
        }
        String string2 = resourceBundle.getString(string);
        Object[] objectArray2 = new Object[10];
        objectArray2[0] = string2;
        try {
            System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw indexOutOfBoundsException;
        }
        catch (ArrayStoreException arrayStoreException) {
            throw arrayStoreException;
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(this.loc);
        messageFormat.applyPattern(string2);
        String string3 = messageFormat.format(objectArray2);
        ByteBuffer byteBuffer = this.cset.encode(string3);
        String string4 = new String(byteBuffer.array(), this.encoding);
        printWriter.println(string4);
    }

    void write(Writer writer, String string) throws IOException {
        PrintWriter printWriter = (PrintWriter)writer;
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = this.bundles.getBundle(this.locale);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (MissingResourceException missingResourceException) {
            throw missingResourceException;
        }
        String string2 = resourceBundle.getString(string);
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(this.loc);
        messageFormat.applyPattern(string2);
        ByteBuffer byteBuffer = this.cset.encode(string2);
        String string3 = new String(byteBuffer.array(), this.encoding);
        printWriter.write(string3);
    }

    public LinkedList listCharacterSets() {
        return new LinkedList();
    }

    public String formatDate(Date date, int n) {
        DateFormat dateFormat = DateFormat.getDateInstance(n, this.loc);
        return dateFormat.format(date);
    }

    public String formatDateTime(Date date, int n, int n2) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(n, n2, this.loc);
        return dateFormat.format(date);
    }

    String getMsg(String string, Object ... objectArray) throws IOException {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = this.bundles.getBundle(this.locale);
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (MissingResourceException missingResourceException) {
            throw missingResourceException;
        }
        String string2 = resourceBundle.getString(string);
        Object[] objectArray2 = new Object[10];
        objectArray2[0] = string2;
        try {
            System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw indexOutOfBoundsException;
        }
        catch (ArrayStoreException arrayStoreException) {
            throw arrayStoreException;
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(this.loc);
        messageFormat.applyPattern(string2);
        String string3 = messageFormat.format(objectArray2);
        ByteBuffer byteBuffer = this.cset.encode(string3);
        String string4 = new String(byteBuffer.array(), this.encoding);
        return string4;
    }
}

