/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.rat.tfa.db.DataAccessor.ZipEntityDA;
import oracle.rat.tfa.entity.Action;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.GenerateUUID;

@Entity(version=1)
public class ZipEntity {
    @PrimaryKey
    private String fileNameFull;
    private String fileNameShort;
    private String hostname;
    private Date startDate;
    private Date endDate;
    private Date dateCreated;
    private boolean isRemote = false;
    private boolean isCopiedToMaster = false;
    private String uuid;
    private List events;

    public ZipEntity(String string, String string2, String string3, Date date, Date date2) {
        this.fileNameFull = string;
        this.fileNameShort = string2;
        this.hostname = string3;
        this.startDate = date;
        this.endDate = date2;
        this.dateCreated = new Date();
        this.uuid = GenerateUUID.getUUID();
    }

    public ZipEntity() {
    }

    public String getFileNameFull() {
        return this.fileNameFull;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setIsRemote(boolean bl) {
        this.isRemote = bl;
    }

    public boolean isIsRemote() {
        return this.isRemote;
    }

    public void setIsCopiedToMaster(boolean bl) {
        this.isCopiedToMaster = bl;
    }

    public boolean isIsCopiedToMaster() {
        return this.isCopiedToMaster;
    }

    public static void printZips() {
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(ZipEntity.class);
        EntityCursor entityCursor = primaryIndex.entities();
        for (ZipEntity zipEntity : entityCursor) {
            System.out.println("######################################");
            System.out.println("Zip: " + zipEntity.fileNameFull);
            System.out.println("Zip: " + zipEntity.fileNameShort);
            System.out.println("Host: " + zipEntity.hostname);
            System.out.println("Start Date: " + zipEntity.startDate);
            System.out.println("End Date: " + zipEntity.endDate);
            System.out.println("isRemote: " + zipEntity.isRemote);
            System.out.println("isCopiedToMaster: " + zipEntity.isCopiedToMaster);
            System.out.println("UUID: " + zipEntity.getUuid());
            List list = zipEntity.getEvents();
            if (list == null) continue;
            for (int i = 0; i < list.size(); ++i) {
                Map map = (Map)list.get(i);
                System.out.println("str : " + map.get("str"));
                System.out.println("searchString : " + map.get("searchString"));
                System.out.println("fileName : " + map.get("fileName"));
                System.out.println("database : " + map.get("database"));
                System.out.println("instance : " + map.get("instance"));
                System.out.println("host : " + map.get("host"));
            }
        }
        entityCursor.close();
    }

    public static void printZips(PrintWriter printWriter) {
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(ZipEntity.class);
        EntityCursor entityCursor = primaryIndex.entities();
        for (ZipEntity zipEntity : entityCursor) {
            printWriter.println("######################################");
            printWriter.println("Zip: " + zipEntity.fileNameFull);
            printWriter.println("Zip: " + zipEntity.fileNameShort);
            printWriter.println("Hostname: " + zipEntity.hostname);
            printWriter.println("Start Date: " + zipEntity.startDate);
            printWriter.println("End Date: " + zipEntity.endDate);
            printWriter.println("isRemote: " + zipEntity.isRemote);
            printWriter.println("isCopiedToMaster: " + zipEntity.isCopiedToMaster);
            List list = zipEntity.getEvents();
            if (list == null) continue;
            for (int i = 0; i < list.size(); ++i) {
                Map map = (Map)list.get(i);
                printWriter.println("str : " + map.get("str"));
                printWriter.println("searchString : " + map.get("searchString"));
                printWriter.println("fileName : " + map.get("fileName"));
                printWriter.println("database : " + map.get("database"));
                printWriter.println("instance : " + map.get("instance"));
                printWriter.println("host : " + map.get("host"));
            }
        }
        entityCursor.close();
    }

    public static String printCollections(PrintWriter printWriter) {
        String string = "ALL COLLECTIONS PRINTED";
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(ZipEntity.class);
        EntityCursor entityCursor = primaryIndex.entities();
        int n = 0;
        for (ZipEntity zipEntity : entityCursor) {
            ++n;
            printWriter.println("\n############################################################################");
            printWriter.println("Zip file location : " + zipEntity.fileNameFull);
            printWriter.println("Zip file name : " + zipEntity.fileNameShort);
            printWriter.println("Hostname : " + zipEntity.hostname);
            printWriter.println("Start Date : " + zipEntity.startDate);
            printWriter.println("End Date : " + zipEntity.endDate);
            printWriter.println("isRemote : " + zipEntity.isRemote);
            printWriter.println("isCopiedToMaster : " + zipEntity.isCopiedToMaster);
            List list = zipEntity.getEvents();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Map map = (Map)list.get(i);
                    if (map.containsKey("requestClient") && map.containsKey("arguments")) {
                        printWriter.println("Request Client : " + map.get("requestClient"));
                        printWriter.println("Arguments : " + map.get("arguments"));
                        continue;
                    }
                    printWriter.println("**************************************");
                    printWriter.println("request client : " + map.get("requestClient"));
                    printWriter.println("event triggering collection : " + map.get("str"));
                    printWriter.println("file containing event : " + map.get("fileName"));
                    printWriter.println("timestamp at which event occurred : " + map.get("timestamp"));
                    printWriter.println("database : " + map.get("database"));
                    printWriter.println("instance : " + map.get("instance"));
                    printWriter.println("host : " + map.get("host"));
                }
            }
            printWriter.println("status : " + ZipEntity.getZipStatus(zipEntity.fileNameShort));
        }
        entityCursor.close();
        if (n == 0) {
            string = "NO COLLECTIONS TO PRINT";
        }
        return string;
    }

    public static String getZipStatus(String string) {
        String string2 = "";
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(Action.class);
        EntityCursor entityCursor = primaryIndex.entities();
        for (Action action : entityCursor) {
            String string3 = action.getActionName();
            if (!string3.equals("ziptracesfordates") && !string3.equals("startdiagcollection") || !action.getActionRequestArgs().contains(string.split("\\.")[1])) continue;
            string2 = action.getActionStatus();
        }
        entityCursor.close();
        return string2;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void changeUuid(String string) {
        this.uuid = string;
    }

    public static void clearAllZips() {
        Object object2;
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(ZipEntity.class);
        EntityCursor entityCursor = primaryIndex.entities();
        Vector<String> vector = new Vector<String>();
        for (Object object2 : entityCursor) {
            boolean bl = vector.add(((ZipEntity)object2).fileNameFull);
        }
        entityCursor.close();
        Iterator iterator = vector.iterator();
        object2 = new ZipEntityDA();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ((ZipEntityDA)object2).pIdx.delete((Object)string);
        }
    }

    public static ZipEntity getZipForUUID(String string) {
        ZipEntity zipEntity = null;
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(ZipEntity.class);
        EntityCursor entityCursor = primaryIndex.entities();
        for (ZipEntity zipEntity2 : entityCursor) {
            if (!zipEntity2.getUuid().equals(string)) continue;
            zipEntity = zipEntity2;
            break;
        }
        entityCursor.close();
        return zipEntity;
    }

    public String getFileNameShort() {
        return this.fileNameShort;
    }

    public void setEvents(List list) {
        this.events = list;
    }

    public List getEvents() {
        return this.events;
    }
}

