/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.rat.tfa.analysis.Globals.Global;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.receiver.RGlobal;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;

@Entity(version=3)
public class TFAReceiver {
    @PrimaryKey
    private String receivername;
    private String group;
    private String username;
    private String pass;
    private String tfahome;
    private String nullPass = "NONE";
    private int load = 0;
    private int port = -1;
    private String hostkey = null;
    private String sysinfo;
    private String type = "node";

    public TFAReceiver(String string, String string2, String string3, String string4) {
        this.receivername = string;
        this.username = string2;
        this.tfahome = string4;
        if (!string3.equalsIgnoreCase(this.nullPass)) {
            this.pass = string3;
        }
    }

    public TFAReceiver(String string, String string2, int n, int n2, String string3) {
        this.receivername = string;
        this.group = string2;
        this.load = n;
        this.port = n2;
        this.hostkey = string3;
    }

    public TFAReceiver(String string, String string2, int n, int n2, String string3, String string4) {
        this.receivername = string;
        this.group = string2;
        this.load = n;
        this.port = n2;
        this.hostkey = string3;
        this.type = string4;
    }

    public TFAReceiver(String string, String string2, int n, String string3) {
        this(string, string2, 0, n, string3);
    }

    public TFAReceiver(String string, String string2, String string3) {
        this(string, string2, 0, -1, string3);
    }

    public TFAReceiver(String string, int n, String string2) {
        this(string, null, 0, n, string2);
    }

    public TFAReceiver() {
    }

    public void setAttrI(String string, int n) {
        if (string.equals("load")) {
            this.load = n;
        } else if (string.equals("port")) {
            this.port = n;
        }
    }

    public String getSysinfo() {
        return this.hostkey;
    }

    public void setSysinfo(String string) {
        this.sysinfo = string;
    }

    public void setLoad(int n) {
        this.load = n;
    }

    public int getAttrI(String string) {
        int n = -1;
        if (string.equals("load")) {
            n = this.load;
        } else if (string.equals("port")) {
            n = this.port;
        }
        return n;
    }

    public void setAttr(String string, String string2) {
        if (string.equals("receivername")) {
            this.receivername = string2;
        } else if (string.equals("group")) {
            this.group = string2;
        } else if (string.equals("hostkey")) {
            this.hostkey = string2;
        } else if (string.equals("tfahome")) {
            this.tfahome = string2;
        } else if (string.equals("username")) {
            this.username = string2;
        } else if (string.equals("pass")) {
            this.pass = string2;
        } else if (string.equals("type")) {
            this.type = string2;
        }
    }

    public String getAttr(String string) {
        String string2 = null;
        if (string.equals("receivername")) {
            string2 = this.receivername;
        } else if (string.equals("group")) {
            string2 = this.group;
        } else if (string.equals("hostkey")) {
            string2 = this.hostkey;
        } else if (string.equals("tfahome")) {
            string2 = this.tfahome;
        } else if (string.equals("username")) {
            string2 = this.username;
        } else if (string.equals("pass")) {
            string2 = this.pass;
        } else if (string.equals("type")) {
            string2 = this.type;
        }
        return string2;
    }

    public static synchronized void printAll(PrintWriter printWriter, String string, boolean bl) throws DatabaseException {
        Transaction transaction = null;
        long l = 0L;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAReceiver.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                if (string.equals("receiver")) {
                    for (TFAReceiver tFAReceiver : entityCursor) {
                        String string2 = tFAReceiver.getAttr("group");
                        if (!bl || bl && string2 != null) {
                            printWriter.println("Collector Name : " + tFAReceiver.getAttr("receivername"));
                        }
                        ++l;
                    }
                } else {
                    for (TFAReceiver tFAReceiver : entityCursor) {
                        printWriter.println("Receiver Name : " + tFAReceiver.getAttr("receivername"));
                        ++l;
                    }
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static synchronized void printRObjects(PrintWriter printWriter, String string, String string2) throws DatabaseException {
        Transaction transaction = null;
        long l = 0L;
        String string3 = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAReceiver.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (TFAReceiver tFAReceiver : entityCursor) {
                    string3 = string2.equals("full") ? "Receiver Object : " + tFAReceiver.getAttr("receivername") + "~group=" + tFAReceiver.getAttr("group") + "~load=" + tFAReceiver.getAttrI("load") + "~port=" + tFAReceiver.getAttrI("port") + "~hostkey=" + tFAReceiver.getAttr("hostkey") + "~type=" + tFAReceiver.getAttr("type") : (string2.equals("showtype") ? "Receiver Object : " + tFAReceiver.getAttr("receivername") + "~group=" + tFAReceiver.getAttr("group") + "~load=" + tFAReceiver.getAttrI("load") + "~port=" + tFAReceiver.getAttrI("port") + "~type=" + tFAReceiver.getAttr("type") : "Receiver Object : " + tFAReceiver.getAttr("receivername") + "~group=" + tFAReceiver.getAttr("group") + "~load=" + tFAReceiver.getAttrI("load") + "~port=" + tFAReceiver.getAttrI("port"));
                    printWriter.println(string3);
                    ++l;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static synchronized List<String> getReceiversInTFA() throws DatabaseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Transaction transaction = null;
        long l = 0L;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAReceiver.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (TFAReceiver tFAReceiver : entityCursor) {
                    arrayList.add(tFAReceiver.getAttr("receivername").trim());
                    ++l;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
        return arrayList;
    }

    public static synchronized List<String> getGroups() throws DatabaseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Transaction transaction = null;
        String string = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAReceiver.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (TFAReceiver tFAReceiver : entityCursor) {
                    string = tFAReceiver.getAttr("group").trim();
                    if (string == null || arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
        return arrayList;
    }

    public static synchronized TFAReceiver getReceiverEntityByHost(String string) throws DatabaseException {
        TFAReceiver tFAReceiver = null;
        Transaction transaction = null;
        long l = 0L;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAReceiver.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            String string2 = null;
            try {
                for (TFAReceiver tFAReceiver2 : entityCursor) {
                    string2 = tFAReceiver2.getAttr("receivername").trim();
                    if (!string2.equals(string)) continue;
                    tFAReceiver = tFAReceiver2;
                    break;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
        return tFAReceiver;
    }

    public static synchronized void loadRObjectsData(String string) throws DatabaseException {
        String string2 = new Host().getHostname();
        String string3 = Properties.TFARunMode.toUpperCase();
        Transaction transaction = null;
        long l = 0L;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAReceiver.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (TFAReceiver tFAReceiver : entityCursor) {
                    if (string.equals("hostkey")) {
                        if (string3.equals("COLLECTOR")) {
                            RGlobal.collectorKeys.put(string2, tFAReceiver.getAttr("hostkey").trim());
                            continue;
                        }
                        RGlobal.collectorKeys.put(tFAReceiver.getAttr("receivername").trim(), tFAReceiver.getAttr("hostkey").trim());
                        continue;
                    }
                    if (!string.equals("port")) continue;
                    Map<String, Integer> map = Global.getPortMapping();
                    map.put(tFAReceiver.getAttr("receivername"), tFAReceiver.getAttrI("port"));
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }
}

