/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.util.Iterator;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;

@Entity(version=1)
public class TFAMetaData {
    @PrimaryKey
    private String id;
    private String masterReceiverNode;
    private int masterReceiverPort;

    public TFAMetaData(String string, String string2, int n) {
        this.id = string;
        this.masterReceiverNode = string2;
        this.masterReceiverPort = n;
    }

    public TFAMetaData() {
    }

    public String getMasterReceiverNode() {
        return this.masterReceiverNode;
    }

    public int getMasterReceiverPort() {
        return this.masterReceiverPort;
    }

    public void setMasterReceiverNode(String string) {
        this.masterReceiverNode = string;
    }

    public void setMasterReceiverPort(int n) {
        this.masterReceiverPort = n;
    }

    public String getRMasterInfo() {
        String string = this.masterReceiverNode;
        string = string + ":" + Integer.toString(this.masterReceiverPort);
        return string;
    }

    public static synchronized String getTFAMetaData() throws DatabaseException {
        Transaction transaction = null;
        long l = 0L;
        String string = "NONE";
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAMetaData.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                Iterator iterator = entityCursor.iterator();
                if (iterator.hasNext()) {
                    TFAMetaData tFAMetaData = (TFAMetaData)iterator.next();
                    string = tFAMetaData.getRMasterInfo();
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
        return string;
    }
}

