/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import oracle.rat.tfa.entity.TFAHostCopy;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;

@Entity(version=1)
public class TFAHost {
    @PrimaryKey
    private String hostname;
    private String username;
    private String pass;
    private String tfaHomeDir;
    private String nullPass = "NONE";

    public TFAHost(String string, String string2, String string3, String string4) {
        this.hostname = string;
        this.username = string2;
        this.tfaHomeDir = string4;
        if (!string3.equalsIgnoreCase(this.nullPass)) {
            this.pass = string3;
        }
    }

    public TFAHost() {
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.pass;
    }

    public String getTfaHomeDir() {
        return this.tfaHomeDir;
    }

    public TFAHostCopy getCopy() {
        return new TFAHostCopy(this.getHostname(), this.getUsername(), this.getPassword(), this.getTfaHomeDir());
    }

    public static synchronized void printAll(PrintWriter printWriter) throws DatabaseException {
        Transaction transaction = null;
        long l = 0L;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (TFAHost tFAHost : entityCursor) {
                    printWriter.println("Host Name : " + tFAHost.getHostname());
                    ++l;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static synchronized void printAllToMHandler(PrintWriter printWriter, String string, String string2) throws DatabaseException {
        Transaction transaction = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = string.substring(0, string.indexOf(":"));
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (TFAHost tFAHost : entityCursor) {
                    string5 = string;
                    string3 = tFAHost.getHostname();
                    if (null == string4) {
                        string4 = string3;
                    }
                    string5 = string5 + "~group=" + string4 + "~node=" + string3;
                    string5 = string6.equalsIgnoreCase(string3) ? string5 + "~hostkey=" + string2 : string5 + "~hostkey=" + string2;
                    printWriter.println(string5);
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static synchronized List<String> getHostsInTFA() throws DatabaseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Transaction transaction = null;
        long l = 0L;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(TFAHost.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (TFAHost tFAHost : entityCursor) {
                    arrayList.add(tFAHost.getHostname().trim());
                    ++l;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
        return arrayList;
    }
}

