/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.rat.tfa.db.DataAccessor.TFADirectoryDA;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.type.DirectoryMappingType;
import oracle.rat.tfa.util.Output;

@Entity(version=7)
public class TFADirectory
implements Comparable<TFADirectory> {
    @PrimaryKey
    private String directoryPath;
    @SecondaryKey(relate=Relationship.MANY_TO_MANY)
    private List<String> components = null;
    public String database;
    public String instance;
    public String cluster;
    public String srNumber;
    public List<String> hosts;
    public String permission = "public";
    public String owner = "root";
    public String collectionPolicy = "exclusions";
    private boolean collectAll = false;
    public Date lastInventoryTime;
    public Map<String, String> subcomponents = null;
    private List<String> invPatterns = null;

    public TFADirectory(String string, String string2, String string3, List<String> list, String string4, Map<String, String> map) {
        this.directoryPath = string;
        this.database = string2;
        this.instance = string3;
        this.components = list;
        this.cluster = new Host().getHostname().trim();
        this.srNumber = string4;
        this.hosts = new ArrayList<String>();
        this.subcomponents = map;
    }

    public TFADirectory() {
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getInstance() {
        return this.instance;
    }

    public DirectoryMappingType getDatabaseMapping() {
        DirectoryMappingType directoryMappingType = new DirectoryMappingType(this.directoryPath, this.database, this.instance, this.srNumber, this.permission);
        return directoryMappingType;
    }

    public void setSrNumber(String string) {
        this.srNumber = string;
    }

    public String getSrNumber() {
        return this.srNumber;
    }

    public void addSharedHost(String string) {
        this.hosts.add(string);
    }

    public List<String> getSharedHosts() {
        return this.hosts;
    }

    public void setPermission(String string) {
        this.permission = string;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setComponents(List<String> list) {
        this.components = list;
    }

    public List<String> getComponents() {
        return this.components;
    }

    public Map<String, String> getSubComponentByComponent(String string) {
        HashMap<String, String> hashMap = null;
        if (this.getSubComponents() != null && this.getSubComponents().size() > 0) {
            hashMap = new HashMap<String, String>();
            for (String string2 : this.getSubComponents().keySet()) {
                if (!string2.contains("|") || !string.equalsIgnoreCase(string2.split("\\|")[0])) continue;
                hashMap.put(string2.split("\\|")[1], this.getSubComponents().get(string2));
            }
        }
        return hashMap;
    }

    public Map<String, String> getSubComponents() {
        return this.subcomponents;
    }

    public void setCollectionPolicy(String string) {
        this.collectionPolicy = string;
    }

    public String getCollectionPolicy() {
        return this.collectionPolicy;
    }

    public void setCollectAll(boolean bl) {
        this.collectAll = bl;
    }

    public boolean isCollectAll() {
        return this.collectAll;
    }

    public void setLastInventoryTime() {
        this.lastInventoryTime = new Date();
    }

    public Date getLastInventoryTime() {
        return this.lastInventoryTime;
    }

    public void setSubcomponents(Map<String, String> map) {
        this.subcomponents = map;
    }

    public Map<String, String> getSubcomponents() {
        return this.subcomponents;
    }

    public void setInvPatterns(List<String> list) {
        this.invPatterns = list;
    }

    public List<String> getInvPatterns() {
        return this.invPatterns;
    }

    public synchronized void store() {
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            EntityStore entityStore = DbManager.getInstance().getEntityStore();
            TFADirectoryDA tFADirectoryDA = new TFADirectoryDA(entityStore);
            try {
                tFADirectoryDA.pIdx.put((Object)this);
                transaction.commit();
            }
            catch (LockConflictException lockConflictException) {
                Output.print("################# " + lockConflictException.getMessage() + " : caught Lock conflict");
                try {
                    if (transaction != null) {
                        transaction.abort();
                    }
                }
                catch (DatabaseException databaseException) {
                    Output.print("txn abort failed: " + databaseException.toString());
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print("Initial Transaction Try failed: " + databaseException.toString());
            databaseException.printStackTrace();
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object == null || object.getClass() != this.getClass()) {
            bl = false;
        } else {
            TFADirectory tFADirectory = (TFADirectory)object;
            if (this.getDirectoryPath().equals(tFADirectory.getDirectoryPath())) {
                bl = true;
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getDirectoryPath() == null ? 0 : this.getDirectoryPath().hashCode());
        return n;
    }

    @Override
    public int compareTo(TFADirectory tFADirectory) {
        String string = tFADirectory.getDirectoryPath();
        return this.getDirectoryPath().compareTo(string);
    }
}

