/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.util.Vector;
import oracle.rat.tfa.db.DataAccessor.ScanFileEntityDA;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;

@Entity(version=1)
public class ScanFileEntity {
    @PrimaryKey
    private String fileName;

    public ScanFileEntity() {
    }

    public ScanFileEntity(String string) {
        this.fileName = string;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean store(ScanFileEntityDA scanFileEntityDA) {
        boolean bl = false;
        Transaction transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
        try {
            bl = scanFileEntityDA.pIdx.putNoOverwrite(transaction, (Object)this);
            Output.printTrace("Alert Log to be scanned: " + this.getFileName() + " : " + bl, 3);
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.abort();
                transaction = null;
            }
            Output.print("ScanFileEntity: Caught Exception in storing ScanFileEntity.");
        }
        return bl;
    }

    public static void deleteScanEntities(Vector<String> vector) {
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            EntityStore entityStore = DbManager.getInstance().getEntityStore();
            PrimaryIndex primaryIndex = entityStore.getPrimaryIndex(String.class, ScanFileEntity.class);
            for (String string : vector) {
                try {
                    boolean bl = primaryIndex.delete((Object)string);
                    Output.printTrace("Deleted Alert Log to scan: " + string + " : " + bl, 3);
                }
                catch (Exception exception) {
                    Output.printTrace("Exception in deleteScanEntities : " + exception.getMessage(), 1);
                }
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.abort();
                transaction = null;
            }
            Output.printTrace("Exception in deleteScanEntities : " + exception.getMessage(), 1);
        }
    }
}

