/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.rat.tfa.db.DataAccessor.InventoryRunDA;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;

@Entity(version=1)
public class InventoryRun {
    @PrimaryKey
    private String hostname;
    private Date lastrunStart;
    private Date lastrunEnd;
    private String status;
    private String arguments;

    public InventoryRun() {
    }

    public InventoryRun(String string) {
        this.hostname = string;
        this.status = "NOTRUNNING";
        this.lastrunStart = new Date();
        this.arguments = "";
    }

    public InventoryRun(String string, String string2) {
        this.hostname = string;
        this.status = "NOTRUNNING";
        this.lastrunStart = new Date();
        this.arguments = string2;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setLastRun() {
        this.lastrunStart = new Date();
    }

    public Date getLastRun() {
        return this.lastrunStart;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String string) {
        this.arguments = string;
    }

    public boolean isRunning() {
        return this.status.equalsIgnoreCase("RUNNING");
    }

    public synchronized void store() {
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            InventoryRunDA inventoryRunDA = new InventoryRunDA();
            inventoryRunDA.pIdx.put((Object)this);
            try {
                transaction.commit();
            }
            catch (LockConflictException lockConflictException) {
                Output.print("################# " + lockConflictException.getMessage() + " : caught Lock conflict");
                try {
                    if (transaction != null) {
                        transaction.abort();
                    }
                }
                catch (DatabaseException databaseException) {
                    Output.print("InventoryRun : txn abort failed");
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print("InventoryRun : Initial Transaction Try failed");
        }
    }

    public void setLastrunEnd() {
        this.lastrunEnd = new Date();
    }

    public Date getLastrunEnd() {
        return this.lastrunEnd;
    }

    public void setStatus(String string) {
        this.status = string;
        if (string != null && string.equals("RUNNING")) {
            this.setLastRun();
            this.lastrunEnd = null;
        }
    }

    public void setStatusFailed(String string) {
        this.status = "FAILED-" + string;
        this.setLastrunEnd();
    }

    public void setStatusComplete() {
        this.status = "COMPLETE";
        this.setLastrunEnd();
    }

    public String getStatus() {
        return this.status;
    }

    public static synchronized String getInventoryStatus() throws DatabaseException {
        Transaction transaction = null;
        String string = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(String.class, InventoryRun.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (InventoryRun inventoryRun : entityCursor) {
                    string = inventoryRun.getStatus();
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print("InventoryRun :  DatabaseException in print inventory run statistics");
        }
        return string;
    }

    public static synchronized void print(PrintWriter printWriter) throws DatabaseException {
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(String.class, InventoryRun.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (InventoryRun inventoryRun : entityCursor) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm:ss");
                    String string = "";
                    String string2 = "";
                    if (inventoryRun.getLastRun() != null) {
                        string = simpleDateFormat.format(inventoryRun.getLastRun());
                    }
                    if (inventoryRun.getLastrunEnd() != null) {
                        string2 = simpleDateFormat.format(inventoryRun.getLastrunEnd());
                    }
                    printWriter.println(inventoryRun.getHostname() + "!" + string + "!" + string2 + "!" + inventoryRun.getStatus());
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print("InventoryRun :  DatabaseException in print inventory run statistics");
        }
    }
}

