/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import oracle.rat.tfa.db.DataAccessor.InstanceStartupDA;
import oracle.rat.tfa.db.DbPut;
import oracle.rat.tfa.db.OracleJdbc;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.entitykey.InstanceStartupKey;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SessionIdentifierGenerator;
import oracle.rat.tfa.xml.InstanceStartupXMLReader;

@Entity(version=1)
public class InstanceStartup {
    @PrimaryKey
    InstanceStartupKey key;
    String dummyStartup;
    String eventId;

    public InstanceStartup() {
    }

    public InstanceStartup(String string, Date date, String string2) {
        this.dummyStartup = string2;
        this.key = new InstanceStartupKey(string, date);
        SessionIdentifierGenerator sessionIdentifierGenerator = new SessionIdentifierGenerator();
        StringBuilder stringBuilder = new StringBuilder();
        Properties.getInstance();
        this.eventId = stringBuilder.append(Properties.getClusterName()).append(sessionIdentifierGenerator.nextSessionId()).toString();
    }

    public InstanceStartup(String string, Date date, String string2, String string3) {
        this.dummyStartup = string2;
        this.key = new InstanceStartupKey(string, date);
        this.eventId = string3;
    }

    public String getFileName() {
        return this.key.getFileName();
    }

    public String getDummyStartup() {
        return this.dummyStartup;
    }

    public InstanceStartupKey getKey() {
        return this.key;
    }

    public Date getStartupTime() {
        return this.key.getstartupTime();
    }

    public void store(DbPut dbPut) {
        InstanceStartupDA instanceStartupDA = new InstanceStartupDA();
        instanceStartupDA.pIdx.put((Object)this);
    }

    public synchronized void store() {
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            InstanceStartupDA instanceStartupDA = new InstanceStartupDA();
            instanceStartupDA.pIdx.put((Object)this);
            try {
                transaction.commit();
            }
            catch (LockConflictException lockConflictException) {
                Output.print("################# " + lockConflictException.getMessage() + " : caught Lock conflict");
                try {
                    if (transaction != null) {
                        transaction.abort();
                    }
                }
                catch (DatabaseException databaseException) {
                    Output.print("txn abort failed: " + databaseException.toString());
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print("Initial Transaction Try failed: " + databaseException.toString());
            databaseException.printStackTrace();
        }
    }

    public void print() {
        Output.print("++++++ Startup Start +++++");
        Output.print("Event Id     : " + this.eventId);
        Output.print("File Name    : " + this.getFileName());
        Output.print("Startup Time : " + this.getStartupTime().toString());
        Output.print("Dummy        : " + this.getDummyStartup());
        Output.print("++++++ Startup End +++++");
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("++++++ Startup Start +++++");
        printWriter.println("Event Id     : " + this.eventId);
        printWriter.println("File Name    : " + this.getFileName());
        printWriter.println("Startup Time : " + this.getStartupTime().toString());
        printWriter.println("Dummy        : " + this.getDummyStartup());
        printWriter.println("++++++ Startup End +++++");
    }

    public String dumpXml() {
        String string = "";
        string = string + "<startup>" + "\n";
        string = string + "<eventid>" + this.eventId + "</eventid>" + "\n";
        string = string + "<startuptime>" + this.getKey().getstartupTime() + "</startuptime>" + "\n";
        string = string + "<dummy>" + this.dummyStartup + "</dummy>" + "\n";
        string = string + "</startup>" + "\n";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpToOracle() throws DatabaseException {
        long l = 0L;
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(InstanceStartup.class);
        EntityCursor entityCursor = primaryIndex.entities();
        Connection connection = null;
        Statement statement = null;
        try {
            connection = OracleJdbc.getConnection();
            if (connection != null) {
                statement = connection.prepareStatement("begin tfa_v2.addDbStart(                     srFileId => ?,                      fileName => ?,                      hostname => ?,                     startupTime => ?,                      dummy => ?                     ); end;");
                for (InstanceStartup instanceStartup : entityCursor) {
                    Timestamp timestamp = null;
                    if (instanceStartup.getStartupTime() != null) {
                        timestamp = new Timestamp(instanceStartup.getStartupTime().getTime());
                    }
                    Properties.getInstance();
                    statement.setString(1, Properties.srFileId);
                    statement.setString(2, instanceStartup.getFileName());
                    statement.setNull(3, 12);
                    statement.setTimestamp(4, timestamp);
                    statement.setString(5, instanceStartup.getDummyStartup());
                    statement.execute();
                    ++l;
                }
                connection.commit();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            exception.printStackTrace();
        }
        finally {
            entityCursor.close();
            try {
                statement.close();
            }
            catch (Exception exception) {}
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    public static synchronized InstanceStartup getEvent(String string) throws DatabaseException {
        InstanceStartup instanceStartup = null;
        InstanceStartupDA instanceStartupDA = new InstanceStartupDA();
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(InstanceStartup.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (InstanceStartup instanceStartup2 : entityCursor) {
                    if (!instanceStartup2.eventId.equals(string)) continue;
                    instanceStartup = instanceStartup2;
                    break;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
        return instanceStartup;
    }

    public static synchronized void printEvents(PrintWriter printWriter, long l) throws DatabaseException {
        InstanceStartupDA instanceStartupDA = new InstanceStartupDA();
        Transaction transaction = null;
        long l2 = 0L;
        String string = new Host().getHostname().trim();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm");
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(InstanceStartup.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (InstanceStartup instanceStartup : entityCursor) {
                    long l3 = instanceStartup.getStartupTime().getTime();
                    long l4 = Calendar.getInstance().getTimeInMillis();
                    long l5 = (l4 - l3) / 1000L;
                    if (l5 > l) continue;
                    printWriter.println(instanceStartup.eventId + "!" + string + "!Instance Startup!" + simpleDateFormat.format(instanceStartup.getStartupTime()) + "!" + instanceStartup.getFileName());
                    ++l2;
                }
                printWriter.println("Total Startups found in database: " + l2);
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static synchronized void printXMLEvents(PrintWriter printWriter, long l, List<String> list) throws DatabaseException {
        String string = Properties.inventoryDir + File.separator;
        long l2 = 0L;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm");
        for (String string2 : list) {
            String string3 = string + string2 + "_InstanceStartup.xml";
            if (!new File(string3).exists()) continue;
            try {
                InstanceStartupXMLReader instanceStartupXMLReader = new InstanceStartupXMLReader(string3);
                for (InstanceStartup instanceStartup : instanceStartupXMLReader.getInstanceStartupEntities()) {
                    long l3 = instanceStartup.getStartupTime().getTime();
                    long l4 = Calendar.getInstance().getTimeInMillis();
                    long l5 = (l4 - l3) / 1000L;
                    if (l5 > l) continue;
                    printWriter.println(instanceStartup.eventId + "!" + string2 + "!Instance Startup!" + simpleDateFormat.format(instanceStartup.getStartupTime()) + "!" + instanceStartup.getFileName());
                    ++l2;
                }
                printWriter.println("Total Startups found in database: " + l2);
            }
            catch (DatabaseException databaseException) {
                Output.print(databaseException.toString());
            }
        }
    }

    public static synchronized void printAll(PrintWriter printWriter) throws DatabaseException {
        InstanceStartupDA instanceStartupDA = new InstanceStartupDA();
        Transaction transaction = null;
        long l = 0L;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(InstanceStartup.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (InstanceStartup instanceStartup : entityCursor) {
                    instanceStartup.print(printWriter);
                    ++l;
                }
                printWriter.println("Total Startups found in database: " + l);
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static boolean deleteAllStartups() {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(InstanceStartupKey.class, InstanceStartup.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (InstanceStartup instanceStartup : entityCursor) {
                    primaryIndex.delete((Object)instanceStartup.getKey());
                    bl = true;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("Exception in deleteAllStartups: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("Exception in deleteAllStartups: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }

    public static boolean deleteStartupEvent(String string) {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(InstanceStartupKey.class, InstanceStartup.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (InstanceStartup instanceStartup : entityCursor) {
                    if (!instanceStartup.getFileName().equalsIgnoreCase(string)) continue;
                    primaryIndex.delete((Object)instanceStartup.getKey());
                    bl = true;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("Exception in deleteStartupEvent: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("Exception in deleteStartupEvent: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }

    public static boolean deleteStartup(InstanceStartup instanceStartup) {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(InstanceStartupKey.class, InstanceStartup.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (InstanceStartup instanceStartup2 : entityCursor) {
                    if (!instanceStartup.getKey().equals(instanceStartup2.getKey())) continue;
                    primaryIndex.delete((Object)instanceStartup2.getKey());
                    bl = true;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("Exception in deleteStartup: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("Exception in deleteStartup: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }

    public static InstanceStartup getLastStartup(String string) {
        InstanceStartup instanceStartup = null;
        InstanceStartupDA instanceStartupDA = new InstanceStartupDA();
        Transaction transaction = null;
        Date date = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(InstanceStartup.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (InstanceStartup instanceStartup2 : entityCursor) {
                    if (!string.equals(instanceStartup2.getFileName())) continue;
                    if (date != null) {
                        if (date.after(instanceStartup2.getStartupTime())) continue;
                        date = instanceStartup2.getStartupTime();
                        instanceStartup = instanceStartup2;
                        continue;
                    }
                    date = instanceStartup2.getStartupTime();
                    instanceStartup = instanceStartup2;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.printTrace("InstanceStartup: Caught Exception in getLastStartup", 3);
        }
        return instanceStartup;
    }
}

