/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import oracle.rat.tfa.db.DataAccessor.InstanceShutdownDA;
import oracle.rat.tfa.db.OracleJdbc;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.entitykey.InstanceShutdownKey;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SessionIdentifierGenerator;
import oracle.rat.tfa.xml.InstanceShutdownXMLReader;

@Entity(version=1)
public class InstanceShutdown {
    @PrimaryKey
    InstanceShutdownKey key;
    Date startupTime;
    String type;
    String terminatingProcessName;
    Integer terminatingProcessID;
    String eventId;

    public InstanceShutdown() {
    }

    public InstanceShutdown(String string, Date date, Date date2, String string2, String string3, Integer n) {
        this.startupTime = date2;
        this.type = string2;
        this.key = new InstanceShutdownKey(string, date);
        this.terminatingProcessName = string3;
        this.terminatingProcessID = n;
        SessionIdentifierGenerator sessionIdentifierGenerator = new SessionIdentifierGenerator();
        StringBuilder stringBuilder = new StringBuilder();
        Properties.getInstance();
        this.eventId = stringBuilder.append(Properties.getClusterName()).append(sessionIdentifierGenerator.nextSessionId()).toString();
    }

    public InstanceShutdown(String string, Date date, Date date2, String string2, String string3, Integer n, String string4) {
        this.startupTime = date2;
        this.type = string2;
        this.key = new InstanceShutdownKey(string, date);
        this.terminatingProcessName = string3;
        this.terminatingProcessID = n;
        this.eventId = string4;
    }

    public String getFileName() {
        return this.key.getFileName();
    }

    public Date getStartupTime() {
        return this.startupTime;
    }

    public String getTerminatingProcessName() {
        return this.terminatingProcessName;
    }

    public Integer getTerminatingProcessID() {
        return this.terminatingProcessID;
    }

    public InstanceShutdownKey getKey() {
        return this.key;
    }

    public Date getShutdownTime() {
        return this.key.getShutdownTime();
    }

    public String getType() {
        return this.type;
    }

    public void setTerminatingProcessName(String string) {
        this.terminatingProcessName = string;
    }

    public void setTerminatingProcessID(Integer n) {
        this.terminatingProcessID = n;
    }

    public synchronized void store() {
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            InstanceShutdownDA instanceShutdownDA = new InstanceShutdownDA();
            instanceShutdownDA.pIdx.put((Object)this);
            try {
                transaction.commit();
            }
            catch (LockConflictException lockConflictException) {
                Output.print("################# " + lockConflictException.getMessage() + " : caught Lock conflict");
                try {
                    if (transaction != null) {
                        transaction.abort();
                    }
                }
                catch (DatabaseException databaseException) {
                    Output.print("txn abort failed: " + databaseException.toString());
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print("Initial Transaction Try failed: " + databaseException.toString());
            databaseException.printStackTrace();
        }
    }

    public void print() {
        Output.print("++++++ Shutdown Start +++++");
        Output.print("Event Id     : " + this.eventId);
        Output.print("File Name    : " + this.getFileName());
        Output.print("Startup Time : " + this.getStartupTime().toString());
        Output.print("Shutdown Time: " + this.getShutdownTime().toString());
        Output.print("Shutdown Type: " + this.getType());
        Output.print("Term process : " + this.getTerminatingProcessName());
        Output.print("Term pid     : " + this.getTerminatingProcessID());
        Output.print("++++++ Shutdown End +++++");
    }

    public String dumpStartXML() {
        String string = "";
        string = string + "<file name='" + this.key.getFileName() + "'>" + "\n";
        return string;
    }

    public String dumpEndXML() {
        String string = "";
        string = string + "</file>" + "\n";
        return string;
    }

    public String dumpXml() {
        String string = "";
        string = string + "<shutdown>" + "\n";
        string = string + "<eventid>" + this.eventId + "</eventid>" + "\n";
        string = string + "<startuptime>" + this.startupTime + "</startuptime>" + "\n";
        string = string + "<shutdowntime>" + this.getKey().getShutdownTime() + "</shutdowntime>" + "\n";
        string = string + "<type>" + this.type + "</type>" + "\n";
        string = string + "<processname>" + this.terminatingProcessName + "</processname>" + "\n";
        string = string + "<processid>" + this.terminatingProcessID + "</processid>" + "\n";
        string = string + "</shutdown>" + "\n";
        return string;
    }

    public String dumpSimileData(String string, String string2, String string3) {
        System.out.println("Inside dumpSimileData  " + string + string2 + string3);
        String string4 = "";
        String string5 = "";
        String string6 = "";
        string6 = this.type.equalsIgnoreCase("immediate") ? string2 : (this.type.equalsIgnoreCase("crash") ? string2 : (this.type.equals("abort") ? string2 : string2));
        string4 = string4 + "{\"start\":\"" + this.startupTime + "\", \"end\":\"" + this.getKey().getShutdownTime() + "\", \"durationEvent\":true, \"trackNum\":\"" + string + "\", \"title\":\"" + string6 + "\", \"caption\":\"" + string6 + "\"},";
        System.out.println("--->>> " + string4);
        return string4;
    }

    public String dumpSimileXml(String string, String string2, String string3) {
        System.out.println("Inside dumpSimileXml  " + string + string2 + string3);
        String string4 = "";
        String string5 = "";
        String string6 = "";
        string6 = this.type.equalsIgnoreCase("immediate") ? string2 : (this.type.equalsIgnoreCase("crash") ? string2 : (this.type.equals("abort") ? string2 : string2));
        string4 = string4 + "<event start=\"" + this.startupTime + "\" end=\"" + this.getKey().getShutdownTime() + "\" color=\"" + string3 + "\" durationEvent=\"true\" trackNum=\"" + string + "\" title=\"" + string6 + "\">" + string5 + "</event>\n";
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpToOracle() throws DatabaseException {
        long l = 0L;
        PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(InstanceShutdown.class);
        EntityCursor entityCursor = primaryIndex.entities();
        Connection connection = null;
        Statement statement = null;
        try {
            connection = OracleJdbc.getConnection();
            if (connection != null) {
                statement = connection.prepareStatement("begin tfa_v2.addDbShut(                     srFileId => ?,                      fileName => ?,                      hostname => ?,                     startupTime => ?,                      shutdownTime => ?,                      shutdownType => ?,                      process => ?,                      pid => ?                     ); end;");
                for (InstanceShutdown instanceShutdown : entityCursor) {
                    Timestamp timestamp = null;
                    if (instanceShutdown.getStartupTime() != null) {
                        timestamp = new Timestamp(instanceShutdown.getStartupTime().getTime());
                    }
                    Timestamp timestamp2 = null;
                    if (instanceShutdown.getShutdownTime() != null) {
                        timestamp = new Timestamp(instanceShutdown.getShutdownTime().getTime());
                    }
                    Properties.getInstance();
                    statement.setString(1, Properties.srFileId);
                    statement.setString(2, instanceShutdown.getFileName());
                    statement.setNull(3, 12);
                    statement.setTimestamp(4, timestamp);
                    statement.setTimestamp(5, timestamp2);
                    statement.setString(6, instanceShutdown.getType());
                    statement.setString(7, instanceShutdown.getTerminatingProcessName());
                    statement.setInt(8, instanceShutdown.getTerminatingProcessID());
                    statement.execute();
                    ++l;
                }
                connection.commit();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            exception.printStackTrace();
        }
        finally {
            entityCursor.close();
            try {
                statement.close();
            }
            catch (Exception exception) {}
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("++++++ Shutdown Start +++++");
        printWriter.println("Event Id       : " + this.eventId);
        printWriter.println("File Name      : " + this.getFileName());
        printWriter.println("Startup Time   : " + this.getStartupTime().toString());
        printWriter.println("Shutdown Time  : " + this.getShutdownTime().toString());
        printWriter.println("Type           : " + this.getType());
        printWriter.println("Process        : " + this.getTerminatingProcessName());
        printWriter.println("PID            : " + this.getTerminatingProcessID());
        printWriter.println("++++++ Shutdown End +++++");
    }

    public static synchronized InstanceShutdown getEvent(String string) throws DatabaseException {
        InstanceShutdown instanceShutdown = null;
        InstanceShutdownDA instanceShutdownDA = new InstanceShutdownDA();
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(InstanceShutdown.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (InstanceShutdown instanceShutdown2 : entityCursor) {
                    if (!instanceShutdown2.eventId.equals(string)) continue;
                    instanceShutdown = instanceShutdown2;
                    break;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
        return instanceShutdown;
    }

    public static synchronized void printEvents(PrintWriter printWriter, long l) throws DatabaseException {
        InstanceShutdownDA instanceShutdownDA = new InstanceShutdownDA();
        Transaction transaction = null;
        long l2 = 0L;
        String string = new Host().getHostname().trim();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm");
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(InstanceShutdown.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (InstanceShutdown instanceShutdown : entityCursor) {
                    long l3 = instanceShutdown.getShutdownTime().getTime();
                    long l4 = Calendar.getInstance().getTimeInMillis();
                    long l5 = (l4 - l3) / 1000L;
                    if (l5 > l) continue;
                    printWriter.println(instanceShutdown.eventId + "!" + string + "!Instance Shutdown!" + simpleDateFormat.format(instanceShutdown.getShutdownTime()) + "!" + instanceShutdown.getFileName() + "!" + instanceShutdown.getType());
                    ++l2;
                }
                printWriter.println("Total Shutdowns found in database: " + l2);
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static synchronized void printXMLEvents(PrintWriter printWriter, long l, List<String> list) throws DatabaseException {
        String string = Properties.inventoryDir + File.separator;
        long l2 = 0L;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm");
        for (String string2 : list) {
            String string3 = string + string2 + "_InstanceShutdown.xml";
            if (!new File(string3).exists()) continue;
            try {
                InstanceShutdownXMLReader instanceShutdownXMLReader = new InstanceShutdownXMLReader(string3);
                for (InstanceShutdown instanceShutdown : instanceShutdownXMLReader.getInstanceShutdownEntities()) {
                    long l3 = instanceShutdown.getShutdownTime().getTime();
                    long l4 = Calendar.getInstance().getTimeInMillis();
                    long l5 = (l4 - l3) / 1000L;
                    if (l5 > l) continue;
                    printWriter.println(instanceShutdown.eventId + "!" + string2 + "!Instance Shutdown!" + simpleDateFormat.format(instanceShutdown.getShutdownTime()) + "!" + instanceShutdown.getFileName() + "!" + instanceShutdown.getType());
                    ++l2;
                }
                printWriter.println("Total Shutdowns found in database: " + l2);
            }
            catch (DatabaseException databaseException) {
                Output.print(databaseException.toString());
            }
        }
    }

    public static synchronized void printAll(PrintWriter printWriter) throws DatabaseException {
        InstanceShutdownDA instanceShutdownDA = new InstanceShutdownDA();
        Transaction transaction = null;
        long l = 0L;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(InstanceShutdown.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (InstanceShutdown instanceShutdown : entityCursor) {
                    instanceShutdown.print(printWriter);
                    ++l;
                }
                printWriter.println("Total Shutdowns found in database: " + l);
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static boolean deleteAllShutdowns() {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(InstanceShutdownKey.class, InstanceShutdown.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (InstanceShutdown instanceShutdown : entityCursor) {
                    primaryIndex.delete((Object)instanceShutdown.getKey());
                    bl = true;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("Exception in deleteAllShutdowns: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("Exception in deleteAllShutdowns: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }

    public static boolean deleteShutdownEvent(String string) {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(InstanceShutdownKey.class, InstanceShutdown.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (InstanceShutdown instanceShutdown : entityCursor) {
                    if (!instanceShutdown.getFileName().equalsIgnoreCase(string)) continue;
                    primaryIndex.delete((Object)instanceShutdown.getKey());
                    bl = true;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("Exception in deleteShutdownEvent: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("Exception in deleteShutdownEvent: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }

    public static boolean deleteShutdown(InstanceShutdown instanceShutdown) {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(InstanceShutdownKey.class, InstanceShutdown.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (InstanceShutdown instanceShutdown2 : entityCursor) {
                    if (!instanceShutdown.getKey().equals(instanceShutdown2.getKey())) continue;
                    primaryIndex.delete((Object)instanceShutdown2.getKey());
                    bl = true;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("Exception in deleteShutdown: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("Exception in deleteShutdown: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }

    public static InstanceShutdown getLastShutdown(String string) {
        InstanceShutdown instanceShutdown = null;
        InstanceShutdownDA instanceShutdownDA = new InstanceShutdownDA();
        Transaction transaction = null;
        Date date = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(InstanceShutdown.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (InstanceShutdown instanceShutdown2 : entityCursor) {
                    if (!string.equals(instanceShutdown2.getFileName())) continue;
                    if (date != null) {
                        if (date.after(instanceShutdown2.getShutdownTime())) continue;
                        date = instanceShutdown2.getShutdownTime();
                        instanceShutdown = instanceShutdown2;
                        continue;
                    }
                    date = instanceShutdown2.getShutdownTime();
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.printTrace("InstanceShutdown: Caught Exception in getLastStartup", 3);
        }
        return instanceShutdown;
    }
}

