/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.persist.model.Persistent;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.rat.tfa.util.Output;

@Persistent
public class Host
implements Serializable {
    private static final long serialVersionUID = 58L;
    private String hostname;
    private String publicIp;
    private String privateIp;
    private String vIp;

    public Host() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            byte[] byArray = inetAddress.getAddress();
            this.publicIp = byArray.toString();
            this.hostname = inetAddress.getHostName().split("\\.")[0];
        }
        catch (UnknownHostException unknownHostException) {
            Output.print("Error in retrieving hostname: " + unknownHostException.getMessage());
        }
    }

    public String getHostname() {
        if (this.hostname != null) {
            return this.hostname.toLowerCase();
        }
        return null;
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    public String getPrivateIp() {
        return this.privateIp;
    }

    public String getVIp() {
        return this.vIp;
    }
}

