/*
 * Decompiled with CFR 0.152.
 */
package oracle.rat.tfa.entity;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import java.io.File;
import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import oracle.rat.tfa.db.DataAccessor.GenericDA;
import oracle.rat.tfa.db.DbGet;
import oracle.rat.tfa.db.DbPut;
import oracle.rat.tfa.db.OracleJdbc;
import oracle.rat.tfa.entity.Host;
import oracle.rat.tfa.entity.entitykey.GenericKey;
import oracle.rat.tfa.singletons.DbManager;
import oracle.rat.tfa.util.Output;
import oracle.rat.tfa.util.Properties;
import oracle.rat.tfa.util.SessionIdentifierGenerator;
import oracle.rat.tfa.xml.GenericEventXMLReader;

@Entity(version=1)
public class Generic {
    @PrimaryKey
    GenericKey key;
    ArrayList lines;
    Integer countofLines;
    Date eventLastTime;
    String eventId;

    public Generic() {
    }

    public Generic(String string, Date date, String string2, String string3, Integer n, Integer n2) {
        this.lines = new ArrayList();
        this.lines.add(string2);
        this.key = new GenericKey(string, date, string3, n2);
        this.countofLines = 1;
        this.eventLastTime = date;
        SessionIdentifierGenerator sessionIdentifierGenerator = new SessionIdentifierGenerator();
        StringBuilder stringBuilder = new StringBuilder();
        Properties.getInstance();
        this.eventId = stringBuilder.append(Properties.getClusterName()).append(sessionIdentifierGenerator.nextSessionId()).toString();
    }

    public Generic(String string, Date date, ArrayList<String> arrayList, String string2, Integer n, Integer n2, String string3) {
        this.lines = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.lines.add(arrayList.get(i));
        }
        this.key = new GenericKey(string, date, string2, n2);
        this.countofLines = n;
        this.eventLastTime = date;
        this.eventId = string3;
    }

    public String getEventTypeId() {
        return this.key.getEventTypeId();
    }

    public Date getEventTime() {
        return this.key.getEventTime();
    }

    public Integer getEventCount() {
        return this.key.getEventCount();
    }

    public Date getEventlastTime() {
        return this.eventLastTime;
    }

    public String getFileName() {
        return this.key.getFileName();
    }

    public Integer getNumberOfLines() {
        return this.countofLines;
    }

    public void setEventLastTime(Date date) {
        this.eventLastTime = date;
    }

    public void setEventCount(Integer n) {
        this.key.setEventCount(n);
    }

    public void addLine(String string) {
        this.lines.add(string);
        Generic generic = this;
        Integer n = generic.countofLines;
        Integer n2 = generic.countofLines = Integer.valueOf(generic.countofLines + 1);
    }

    public synchronized void store(DbPut dbPut) {
        Transaction transaction = null;
        Environment environment = dbPut.getEnvmnt();
        EntityStore entityStore = dbPut.getStore();
        try {
            transaction = environment.beginTransaction(null, null);
            GenericDA genericDA = new GenericDA();
            genericDA.pIdx.put((Object)this);
            try {
                transaction.commit();
            }
            catch (LockConflictException lockConflictException) {
                Output.print("################# " + lockConflictException.getMessage() + " : caught Lock conflict");
                try {
                    if (transaction != null) {
                        transaction.abort();
                    }
                }
                catch (DatabaseException databaseException) {
                    Output.print("txn abort failed: " + databaseException.toString());
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print("Initial Transaction Try failed: " + databaseException.toString());
            databaseException.printStackTrace();
        }
    }

    public void delete(DbPut dbPut) {
        Transaction transaction = null;
        Environment environment = dbPut.getEnvmnt();
        EntityStore entityStore = dbPut.getStore();
        try {
            transaction = environment.beginTransaction(null, null);
            GenericDA genericDA = new GenericDA();
            genericDA.pIdx.delete((Object)this.key);
            try {
                transaction.commit();
            }
            catch (LockConflictException lockConflictException) {
                Output.print("################# " + lockConflictException.getMessage() + " : caught Lock conflict");
                try {
                    if (transaction != null) {
                        transaction.abort();
                    }
                }
                catch (DatabaseException databaseException) {
                    Output.print("txn abort failed: " + databaseException.toString());
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print("Initial Transaction Try failed: " + databaseException.toString());
            databaseException.printStackTrace();
        }
    }

    public void print() {
        Output.print("++++++ Generic Event +++++");
        Output.print("Event Id        : " + this.eventId);
        Output.print("File Name       : " + this.getFileName());
        Output.print("Time            : " + this.getEventTime().toString());
        Output.print("Last Time       : " + this.getEventTime().toString());
        Output.print("Event Seq       : " + this.getEventCount().toString());
        Output.print("Event Type ID   : " + this.getEventTypeId().toString());
        for (int i = 0; i < this.lines.size(); ++i) {
            Output.print("Line            : " + this.lines.get(i));
        }
        Output.print("++++++ Generic  End +++++");
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("++++++ Generic Event +++++");
        printWriter.println("Event Id        : " + this.eventId);
        printWriter.println("File Name       : " + this.getFileName());
        printWriter.println("Time            : " + this.getEventTime().toString());
        printWriter.println("Last Time       : " + this.getEventTime().toString());
        printWriter.println("Event Seq       : " + this.getEventCount().toString());
        printWriter.println("Event Type ID   : " + this.getEventTypeId().toString());
        for (int i = 0; i < this.lines.size(); ++i) {
            printWriter.println("Line            : " + this.lines.get(i));
        }
        printWriter.println("++++++ Generic  End +++++");
    }

    public String dumpXml() {
        String string = "";
        string = string + "<genericevent>" + "\n";
        string = string + "<eventid>" + this.eventId + "</eventid>" + "\n";
        string = string + "<eventtypeid>" + this.getEventTypeId() + "</eventtypeid>" + "\n";
        string = string + "<filename>" + this.getFileName() + "</filename>" + "\n";
        string = string + "<eventtime>" + this.getEventTime().toString() + "</eventtime>" + "\n";
        string = string + "<eventlasttime>" + this.getEventlastTime().toString() + "</eventlasttime>" + "\n";
        string = string + "<eventseq>" + this.getEventCount().toString() + "</eventseq>" + "\n";
        string = string + "<lines>" + "\n";
        for (int i = 0; i < this.lines.size(); ++i) {
            string = string + "<line>" + this.lines.get(i) + "</line>" + "\n";
        }
        string = string + "</lines>" + "\n";
        string = string + "</genericevent>" + "\n";
        return string;
    }

    public static synchronized void deleteAllbyFile(String string, DbPut dbPut, DbGet dbGet) throws DatabaseException {
        Output output = new Output();
        EntityStore entityStore = dbPut.getStore();
        GenericDA genericDA = new GenericDA();
        Transaction transaction = null;
        Environment environment = dbPut.getEnvmnt();
        try {
            transaction = environment.beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = entityStore.getPrimaryIndex(GenericKey.class, Generic.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (Generic generic : entityCursor) {
                    Output.printTrace("Generic Fname : " + generic.getFileName(), 2);
                    Output.printTrace("Passed Fname : " + string, 2);
                    if (!generic.getFileName().equalsIgnoreCase(string)) continue;
                    Output.printTrace("Del Rec for : " + string, 3);
                    generic.delete(dbPut);
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumptoOracle() throws DatabaseException {
        long l = 0L;
        GenericDA genericDA = new GenericDA();
        PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(GenericKey.class, Generic.class);
        EntityCursor entityCursor = primaryIndex.entities();
        Connection connection = null;
        Statement statement = null;
        CallableStatement callableStatement = null;
        try {
            connection = OracleJdbc.getConnection();
            if (connection != null) {
                callableStatement = connection.prepareCall("{call tfa_v2.saveGenericEvent(                     srFileId => ?,                      fileName => ?,                      firstTimestamp => ?,                      lastTimestamp => ?,                      eventSeq => ?,                     eventTypeId => ?,                      eventStoreId => ?                      )}");
                statement = connection.prepareStatement("begin tfa_v2.addGenericEventLine(                     eventStoreId => ?,                      linetext => ?                      ); end;");
                Output.print("About to enter the cursor loop");
                for (Generic generic : entityCursor) {
                    Output.print("In the  loop");
                    String string = "";
                    String string2 = "";
                    try {
                        string = generic.getEventTime().toString();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        string2 = generic.getEventlastTime().toString();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Timestamp timestamp = null;
                    if (generic.getEventTime() != null) {
                        timestamp = new Timestamp(generic.getEventTime().getTime());
                    }
                    Timestamp timestamp2 = null;
                    if (generic.getEventlastTime() != null) {
                        timestamp2 = new Timestamp(generic.getEventlastTime().getTime());
                    }
                    Properties.getInstance();
                    callableStatement.setString(1, Properties.srFileId);
                    callableStatement.setString(2, generic.getFileName());
                    callableStatement.setTimestamp(3, timestamp);
                    callableStatement.setTimestamp(4, timestamp2);
                    callableStatement.setInt(5, (int)generic.getEventCount());
                    callableStatement.setString(6, generic.getEventTypeId());
                    callableStatement.registerOutParameter(7, 12);
                    callableStatement.execute();
                    String string3 = callableStatement.getString(7);
                    Output.print("Got eventStoreId : " + string3);
                    ++l;
                    for (int i = 0; i < generic.lines.size(); ++i) {
                        statement.setString(1, string3);
                        statement.setString(2, generic.lines.get(i).toString());
                        statement.execute();
                    }
                }
                connection.commit();
            }
            Output.print("Total found File in database: " + l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            entityCursor.close();
            try {
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static synchronized Generic getEvent(String string) throws DatabaseException {
        Generic generic = null;
        GenericDA genericDA = new GenericDA();
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(Generic.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (Generic generic2 : entityCursor) {
                    if (!generic2.eventId.equals(string)) continue;
                    generic = generic2;
                    break;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
        return generic;
    }

    public static synchronized void printEvents(PrintWriter printWriter, long l) throws DatabaseException {
        GenericDA genericDA = new GenericDA();
        Transaction transaction = null;
        long l2 = 0L;
        String string = new Host().getHostname().trim();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm");
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(Generic.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (Generic generic : entityCursor) {
                    long l3 = generic.getEventTime().getTime();
                    long l4 = Calendar.getInstance().getTimeInMillis();
                    long l5 = (l4 - l3) / 1000L;
                    if (l5 > l) continue;
                    printWriter.println(generic.eventId + "!" + string + "!Generic!" + simpleDateFormat.format(generic.getEventTime()) + "!" + generic.getFileName() + "!" + generic.lines.get(0));
                    ++l2;
                }
                printWriter.println("Total Generic Events found in database: " + l2);
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static synchronized void printXMLEvents(PrintWriter printWriter, long l, List<String> list) throws DatabaseException {
        String string = Properties.inventoryDir + File.separator;
        long l2 = 0L;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd HH:mm");
        for (String string2 : list) {
            String string3 = string + string2 + "__GenericEvent.xml";
            if (!new File(string3).exists()) continue;
            try {
                GenericEventXMLReader genericEventXMLReader = new GenericEventXMLReader(string3);
                for (Generic generic : genericEventXMLReader.getGenericEntities()) {
                    long l3 = generic.getEventTime().getTime();
                    long l4 = Calendar.getInstance().getTimeInMillis();
                    long l5 = (l4 - l3) / 1000L;
                    if (l5 > l) continue;
                    printWriter.println(generic.eventId + "!" + string2 + "!Generic!" + simpleDateFormat.format(generic.getEventTime()) + "!" + generic.getFileName() + "!" + generic.lines.get(0));
                    ++l2;
                }
                printWriter.println("Total Generic Events found in database: " + l2);
            }
            catch (DatabaseException databaseException) {
                Output.print(databaseException.toString());
            }
        }
    }

    public static synchronized void printAll(PrintWriter printWriter) throws DatabaseException {
        GenericDA genericDA = new GenericDA();
        Transaction transaction = null;
        long l = 0L;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getAllEntities(Generic.class);
            EntityCursor entityCursor = primaryIndex.entities();
            try {
                for (Generic generic : entityCursor) {
                    generic.print(printWriter);
                    ++l;
                }
                printWriter.println("Total Generic Events found in database: " + l);
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static synchronized void printAll(DbGet dbGet) throws DatabaseException {
        Output output = new Output();
        GenericDA genericDA = new GenericDA();
        Transaction transaction = null;
        Environment environment = dbGet.getEnvmnt();
        long l = 0L;
        try {
            transaction = environment.beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(GenericKey.class, Generic.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (Generic generic : entityCursor) {
                    Output.printTrace("FileName : " + generic.getFileName(), 2);
                    Output.printTrace("EventID  : " + generic.getEventTypeId(), 2);
                    Output.printTrace("EventCount : " + generic.getEventCount().toString(), 2);
                    for (int i = 0; i < generic.lines.size(); ++i) {
                        Output.printTrace("Line     : " + generic.lines.get(i), 2);
                    }
                    ++l;
                }
                Output.print("Total found File in database: " + l);
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (DatabaseException databaseException) {
            Output.print(databaseException.toString());
        }
    }

    public static boolean deleteAllGenerics() {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(GenericKey.class, Generic.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (Generic generic : entityCursor) {
                    primaryIndex.delete((Object)generic.key);
                    bl = true;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("Exception in deleteAllGenerics: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("Exception in deleteAllGenerics: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }

    public static boolean deleteGenericEvent(String string) {
        boolean bl = false;
        Transaction transaction = null;
        try {
            transaction = DbManager.getInstance().getEnvironment().beginTransaction(null, null);
            CursorConfig cursorConfig = new CursorConfig();
            cursorConfig.setReadUncommitted(true);
            PrimaryIndex primaryIndex = DbManager.getInstance().getEntityStore().getPrimaryIndex(GenericKey.class, Generic.class);
            EntityCursor entityCursor = primaryIndex.entities(transaction, cursorConfig);
            try {
                for (Generic generic : entityCursor) {
                    if (!generic.getFileName().equalsIgnoreCase(string)) continue;
                    primaryIndex.delete((Object)generic.key);
                    bl = true;
                }
                entityCursor.close();
                entityCursor = null;
                transaction.commit();
                transaction = null;
            }
            catch (Exception exception) {
                Output.print("Exception in deleteGenericEvent: " + exception.getMessage());
                exception.printStackTrace();
                if (entityCursor != null) {
                    entityCursor.close();
                }
                if (transaction != null) {
                    transaction.abort();
                    transaction = null;
                }
            }
        }
        catch (Exception exception) {
            Output.print("Exception in deleteGenericEvent: " + exception.getMessage());
            exception.printStackTrace();
        }
        return bl;
    }
}

